<?php

namespace MEC_Seat\Seat;

use MEC\Singleton;

/**
 * @since 1.0.0
 */
class SeatLayoutBuilder extends Singleton{

    /**
     * Enqueue Scripts
     *
     * @param int|string $event_id
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function enqueue( $event_id ){

        wp_enqueue_style('mec-lity-style');
        wp_enqueue_script('mec-lity-script');

        wp_enqueue_style( 'mec-seat-layout-backend' );
        wp_enqueue_script( 'mec-seat-layout-backend' );

        $event_tickets = array();
        if( is_numeric( $event_id ) ){

            $event_tickets  = get_post_meta( $event_id, 'mec_tickets', true );
            $event_tickets  = is_array( $event_tickets ) ? $event_tickets : array();
            foreach( $event_tickets as $ticket_id => $ticket){

                $t_price = (isset($event_tickets[$ticket_id]) and isset($event_tickets[$ticket_id]['price'])) ? (new \MEC_book())->get_ticket_price($event_tickets[$ticket_id], current_time('Y-m-d'), $event_id) : 0;
                $t_price = (is_numeric($t_price) ? \MEC\Base::get_main()->render_price($t_price, $event_id) : $t_price);

                $event_tickets[ $ticket_id ] = array(
                    'name' => $ticket['name'],
                    'price' => $t_price,
                );
            }

        }
        echo '<script>var mec_seat_event_tickets ='. json_encode( $event_tickets ) .';</script>';

        $data = array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'seatLayoutData' => self::get_seat_layout_data( $event_id ),
            'event_id' => $event_id,
        );
        echo '<script> var mec_seat_layout_backend ='. json_encode( $data ) .'</script>';
        echo '<style>.lity-content:after{-moz-box-shadow: none !important;-goog-ms-box-shadow: none !important;-webkit-box-shadow: none !important;box-shadow: none !important;}</style>';

		$css = '';
		$demo_colors = SeatLayoutBuilder::get_demo_settings_settings( $event_id );
		foreach( $demo_colors as $type => $color ){

			if( empty( $color) ){

				continue;
			}

			$css .= '#mec-seat-seats-settings-wrap{--mec-seat-color-' . $type .': '. $color .';}';
		}
		echo '<style>'. $css .'</style>';
    }

    /**
     * Update layout data by ajax
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function update_event_layout_data_by_ajax(){

        $event_id = isset( $_POST['event_id'] ) ? $_POST['event_id'] : false;
        $data = isset( $_POST['data'] ) && is_array( $_POST['data'] ) ? $_POST['data'] : array();
        $areas = isset( $_POST['areas'] ) && is_array( $_POST['areas'] ) ? $_POST['areas'] : array();
        $demo_settings = isset( $_POST['demo_settings'] ) && is_array( $_POST['demo_settings'] ) ? $_POST['demo_settings'] : array();

        $nonce = isset( $_POST['nonce'] ) ? $_POST['nonce'] : false;
        if( !$nonce || !wp_verify_nonce( $nonce, 'mec_seat_update_layout_nonce-'.$event_id ) ){

            wp_send_json_error(array(
                'message' => __( 'Security Error', MECSEATTEXTDOMAIN ),
            ));
        }

        self::update_event_layout_data( $event_id, $data, $areas );
        self::update_demo_settings_settings( $event_id, $demo_settings );

        wp_send_json_success( array(
            'message' => __( 'Success', MECSEATTEXTDOMAIN ),
        ));
    }

    /**
     * Export layout data by ajax
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function export_event_layout_data_by_ajax(){

        $event_id = isset( $_POST['event_id'] ) ? $_POST['event_id'] : 'global';

        $nonce = isset( $_POST['nonce'] ) ? $_POST['nonce'] : false;
        if( !$nonce || !wp_verify_nonce( $nonce, 'mec_seat_import_export_layout_nonce-'.$event_id ) ){

            wp_send_json_error(array(
                'message' => __( 'Security Error', MECSEATTEXTDOMAIN ),
            ));
        }

        if( is_numeric( $event_id ) ){

            $layout_data = get_post_meta( $event_id, 'mec_seat_layout_data', true );
            $areas_data = get_post_meta( $event_id, 'mec_seat_areas_data', true );
            $demo_settings = get_post_meta( $event_id, 'mec_demo_settings_settings', true );
        }else{

            $layout_data = \MEC\Settings\Settings::getInstance()->get_settings('seat_layout_data');
            $areas_data = \MEC\Settings\Settings::getInstance()->get_settings('seat_areas_data');
            $demo_settings = \MEC\Settings\Settings::getInstance()->get_settings('demo_settings');
        }

        $layout_data = wp_unslash( $layout_data );

        $layout_data = is_array( $layout_data ) ? $layout_data : json_decode( $layout_data );
        $areas_data = is_array( $areas_data ) ? $areas_data : array();
        $demo_settings = is_array( $demo_settings ) ? $demo_settings : array();
        unset( $areas_data['_fi_'] );
        unset( $areas_data['{{id}}'] );

        $d = array(
            'layout_data' => $layout_data,
            'areas_data' => $areas_data,
            'demo_settings' => $demo_settings
        );
        $data = array(
            'file_content' => json_encode( $d ),
            'filename' => 'mec-seat-layout-data-' . md5(time().mt_rand(100, 999)) .'.json',
        );

        wp_send_json_success( $data );
    }

    /**
     * Import layout data by ajax
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function import_event_layout_data_by_ajax(){

        $event_id = isset( $_POST['event_id'] ) ? $_POST['event_id'] : 'global';
        $import_data = isset( $_POST['import_data'] )  ? json_decode( wp_unslash( $_POST['import_data'] ), true ) : array();
        $import_data['layout_data'] = $import_data['layout_data'] ?? array();

        $nonce = isset( $_POST['nonce'] ) ? $_POST['nonce'] : false;
        if( !$nonce || !wp_verify_nonce( $nonce, 'mec_seat_import_export_layout_nonce-'.$event_id ) ){

            wp_send_json_error(array(
                'message' => __( 'Security Error', MECSEATTEXTDOMAIN ),
            ));
        }

        if( !isset( $import_data['layout_data'] ) || !isset( $import_data['areas_data'] ) ){

            wp_send_json_error(array(
                'message' => __( 'Import is not possible', MECSEATTEXTDOMAIN ),
            ));
        }


        $data = isset( $import_data['layout_data'] ) && is_array( $import_data['layout_data'] ) ? $import_data['layout_data'] : array();
        $areas = isset( $import_data['areas_data'] ) && is_array( $import_data['areas_data'] ) ? $import_data['areas_data'] : array();
        $demo_settings = isset( $import_data['demo_settings'] ) && is_array( $import_data['demo_settings'] ) ? $import_data['demo_settings'] : array();

        if( is_numeric( $event_id ) ){

            update_post_meta( $event_id, 'mec_seat_layout_data', $data );
            update_post_meta( $event_id, 'mec_seat_areas_data', $areas );
            update_post_meta( $event_id, 'mec_demo_settings_settings', $demo_settings );
            update_post_meta($event_id,'mec_seat_status','1');
            update_post_meta($event_id,'mec_seat_custom_seat_layout_status','0');
        }else{

            $options = \MEC\Settings\Settings::getInstance()->get_options();
            $options['settings']['seat_layout_data'] = $data;
            $options['settings']['seat_areas_data'] = $areas;
            $options['settings']['demo_settings'] = $demo_settings;

            update_option( 'mec_options', $options );
        }

        wp_send_json_success( array(
            'message' => __( 'Success', MECSEATTEXTDOMAIN ),
        ));
    }

    /**
     * Is global settings
     *
     * @since 1.0.0
     *
     * @return boolean
     */
    public function is_global_settings(){

        return isset( $_GET['page'] ) && 'MEC-settings' === $_GET['page'];
    }

    /**
     * Update layout and areas data
     *
     * @param int $event_id
     * @param string $layout_data json
     * @param array $areas_data
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function update_event_layout_data( $event_id, $layout_data, $areas_data ){

        unset( $areas_data['_fi_'] );
        unset( $areas_data['{{id}}'] );

        update_post_meta( $event_id, 'mec_seat_layout_data', $layout_data );
        update_post_meta( $event_id, 'mec_seat_areas_data', $areas_data );
    }

    /**
     * Return seat layout data
     *
     * @param int|string $event_id
     *
     * @since 1.0.0
     *
     * @return string
     */
    public static function get_seat_layout_data( $event_id ){

        $data = '';
        if( 'global' === $event_id ){

            $data = \MEC\Settings\Settings::getInstance()->get_settings('seat_layout_data');
        }else{

            $data = get_post_meta( $event_id, 'mec_seat_layout_data', true );
        }

        $data = !empty( $data ) ? $data : array();
        $data = wp_unslash( $data );

        return !empty( $data ) && !is_array( $data ) ? $data : json_encode( $data );
    }

    /**
     * Update seat demo settings
     *
     * @param int|string $event_id
     * @param array $data
     *
     * @since 1.0.0
     *
     * @return string
     */
    public static function update_demo_settings_settings( $event_id, $data ){

        if( is_numeric( $event_id ) ){

            update_post_meta( $event_id, 'mec_demo_settings_settings', $data );
        }else{

            $options = \MEC\Settings\Settings::getInstance()->get_options();
            $options['settings']['demo_settings'] = $data;

            update_option( 'mec_options', $options );
        }

        return is_array( $data ) ? $data : array();
    }

    /**
     * Return seat demo settings
     *
     * @param int|string $event_id
     *
     * @since 1.0.0
     *
     * @return array
     */
    public static function get_demo_settings_settings( $event_id ){

        $data = array();
        if( 'global' === $event_id ){

            $data = \MEC\Settings\Settings::getInstance()->get_settings('demo_settings');
        }else{

            $data = get_post_meta( $event_id, 'mec_demo_settings_settings', true );
        }

        return is_array( $data ) ? $data : array();
    }

    /**
     * Return seat areas data
     *
     * @param int|string $event_id
     *
     * @since 1.0.0
     *
     * @return array
     */
    public static function get_seat_areas_data( $event_id ){

        $data = array();
        if( 'global' === $event_id ){

            $data = \MEC\Settings\Settings::getInstance()->get_settings('seat_areas_data');
        }else{

            $data = get_post_meta( $event_id, 'mec_seat_areas_data', true );
        }

        $data = is_array( $data ) ? $data : array();
        unset( $data['_fi_'] );
        unset( $data['{{id}}'] );

        return $data;
    }

    /**
     * Display output
     *
     * @param int|string $event_id
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function output( $event_id, $is_fes_form = false ){

        if( !$event_id ){
            return;
        }

        $event_id = '-1' != $event_id ? $event_id : 'global';

        $this->enqueue( $event_id );

        $areas = self::get_seat_areas_data( $event_id );
        $layout_data = self::get_seat_layout_data( $event_id );
        $demo_settings = self::get_demo_settings_settings( $event_id );

        $areas['_fi_'] = array(
            'id' => '{{id}}',
            'number_of_seats' => '{{number_of_seats}}',
            'rows' => '{{rows}}',
            'title' => '{{title}}',
            'description' => '{{description}}',
            'ticket_ids' => '{{ticket_ids}}',
            'shape_type' => '{{shape_type}}',
            'number_of_seats_in_shape' => '{{number_of_seats_in_shape}}',
            'seat_booked' => '{{seat_booked}}',
            'seat_handicap_accessible' => '{{seat_handicap_accessible}}',
            'seat_selected_color' => '{{seat_selected_color}}',
            'seat_not_selected_color' => '{{seat_not_selected_color}}',
            'seat_description' => '{{seat_description}}',
        );

        if( $event_id ){

            $tickets = get_post_meta( $event_id, 'mec_tickets', true );
            $tickets = is_array( $tickets ) ? $tickets : array();
        }
        ?>
        <div class="mec-form-row">
            <button id="mec-seat-open-seats-settings"><?php esc_html_e( 'Seats Area Plan', MECSEATTEXTDOMAIN ); ?></button>
        </div>
        <div id="mec-seat-seats-settings-wrap" class="<?php echo $is_fes_form ? 'mec-fes-form' : '' ?>">
            <div class="mec-seat-topbar">
                <div class="mec-seat-topbar-left">
                    <div class="title"><?php esc_html_e( 'Seats Area Plan', MECSEATTEXTDOMAIN ); ?></div>
                    <div class="mec-seat-top-wrap">
                        <button id="mec-seat-set-general-settings" class="button" data-seatdefination=""><?php esc_html_e( 'Set General Settings', MECSEATTEXTDOMAIN ); ?></button>
                    </div>
                </div>
                <div class="mec-seat-close-lity">
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12">
                    <path id="close" d="M11.748.252a.86.86,0,0,1,0,1.217l-4.6,4.6,4.462,4.462a.86.86,0,0,1-1.217,1.217L5.93,7.286,1.608,11.609A.86.86,0,0,1,.391,10.392L4.713,6.069.252,1.608A.86.86,0,0,1,1.469.391L5.93,4.852l4.6-4.6A.86.86,0,0,1,11.748.252Z" fill="#939b9e"/>
                </svg>
                </div>
            </div>
            <div class="mec-seats-wrap">
                <div class="mec-seats-sidebar-wrap">
                    <div class="mec-seat-add-area-form mec-col-12">
                        <div class="mec-form-row mec-seat-add-area-form-fields">
                            <div class="mec-seat-area-rows-seats-wrap">
                                <div>
                                    <label for="mec-seat-area-rows"><?php esc_html_e( 'Rows', MECSEATTEXTDOMAIN ) ?></label>
                                    <input class="mec-col-12" type="number" id="mec-seat-area-rows" value="" placeholder="<?php esc_attr_e( 'Rows', MECSEATTEXTDOMAIN ); ?>" />
                                    <span class="mec-tooltip mec-seat-option-tooltip">
                                        <div class="box right">
                                            <div class="content"><p><?php _e('Enter the number of rows.', MECSEATTEXTDOMAIN); ?></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                                <div>
                                    <label for="mec-seat-area-number-of-seats"><?php esc_html_e( 'Seats', MECSEATTEXTDOMAIN ) ?></label>
                                    <input class="mec-col-12" type="number" id="mec-seat-area-number-of-seats" value="" placeholder="<?php esc_attr_e( 'Seats', MECSEATTEXTDOMAIN ); ?>" />
                                    <span class="mec-tooltip mec-seat-option-tooltip">
                                        <div class="box left">
                                            <div class="content"><p><?php _e('Enter the number of seats in each row.', MECSEATTEXTDOMAIN); ?></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="mec-col-12">
                                <input class="mec-col-12" type="text" id="mec-seat-area-title" value="" placeholder="<?php esc_attr_e( 'Area Title', MECSEATTEXTDOMAIN ); ?>" />
                            </div>
                            <div class="mec-col-12">
                                <textarea class="mec-col-12" id="mec-seat-area-description" data-key="description" placeholder="<?php esc_attr_e( 'Description', MECSEATTEXTDOMAIN ); ?>"></textarea>
                            </div>
                            <?php if( $event_id && 'global' !== $event_id ): ?>
                                <div class="mec-col-12">
                                    <div class="mec-col-12">
                                        <label><?php esc_html_e( 'Tickets', MECSEATTEXTDOMAIN ) ?></label>
                                        <span class="mec-tooltip mec-seat-option-tooltip">
                                            <div class="box left">
                                                <div class="content"><p><?php _e('Select the Ticket according to your desired seat. Tickets will be displayed after the event is updated.', MECSEATTEXTDOMAIN); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
                                    </div>
                                    <div class="mec-col-12 mec-seat-area-tickets-wrapper">
                                        <select id="mec-seat-area-tickets" data-key="ticket_ids" class="mec-seat-area-ticket mec-select2" multiple data-placeholder="<?php esc_attr_e( 'Select Allowed Tickets', MECSEATTEXTDOMAIN ); ?>" data-tags="true" data-placeholder="Select an option" data-allow-clear="true">
                                            <?php
                                                foreach( $tickets as $ticket_id => $ticket ){

                                                    $ticket_name = $ticket['name'] ?? '';

                                                    echo '<option value="'. esc_attr( $ticket_id ) .'">'. esc_html( $ticket_name ) .'</option>';
                                                }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="mec-col-12">
                                <select id="mec-seat-area-shape" data-key="shape_type" class="mec-seat-area-shape mec-col-12">
                                    <option value="square" selected="selected"><?php esc_html_e( 'Default', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="square-2"><?php esc_html_e( 'Square', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="table"><?php esc_html_e( 'Circle', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs"><?php esc_html_e( 'Chairs-1', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-2"><?php esc_html_e( 'Chairs-2', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-3"><?php esc_html_e( 'Chairs-3', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-4"><?php esc_html_e( 'Chairs-4', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-5"><?php esc_html_e( 'Chairs-5', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-6"><?php esc_html_e( 'Chairs-6', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="chairs-7"><?php esc_html_e( 'Chairs-7', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="kiosk"><?php esc_html_e( 'Kiosk', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="tent"><?php esc_html_e( 'Tent', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="parking"><?php esc_html_e( 'Parking', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="tickets-shape"><?php esc_html_e( 'Tickets', MECSEATTEXTDOMAIN ) ?></option>
                                    <option value="circle"><?php esc_html_e( 'Table', MECSEATTEXTDOMAIN ) ?></option>
                                </select>
                            </div>
                            <div class="mec-col-12 mec-seat-area-number-of-seats-in-shape-wrap">
                                <input class="mec-col-12" type="number" id="mec-seat-area-number-of-seats-in-shape" value="" placeholder="<?php esc_attr_e( 'Seats', MECSEATTEXTDOMAIN ); ?>" />
                            </div>
                            <div class="mec-area-seat-form-fields">
                                <div class="mec-seat-options">
                                    <div class="mec-form-row">
                                        <div class="mec-col-6">
                                            <label><?php esc_html_e( 'Book status', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-6">
                                            <label class="label-checkbox"><input type="checkbox" class="mec-area-seat-booked settings" data-key="seat_booked" value="1"><?php esc_html_e( 'Booked', MECSEATTEXTDOMAIN ) ?></label>
                                            <span class="mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Check if this seat is booked before.', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="mec-form-row">
                                        <div class="mec-col-6">
                                            <label><?php esc_html_e( 'Handicap accessible', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-6">
                                            <label class="label-checkbox"><input type="checkbox" class="mec-area-seat-handicap-accessible settings" data-key="seat_handicap_accessible" value="1"><?php esc_html_e( 'Yes', MECSEATTEXTDOMAIN ) ?></label>
                                            <span class="mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Check if this seat is handicap accessible.', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="mec-form-row column-flex">
                                        <div class="mec-col-12">
                                            <label><?php esc_html_e( 'Selected seat color', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-12">
                                            <input type="text" class="mec-area-seat-selected-color mec-color-picker" data-key="seat_selected_color" placeholder="<?php esc_attr_e('ex: #fff', MECSEATTEXTDOMAIN); ?>">
                                        </div>
                                    </div>
                                    <div class="mec-form-row column-flex">
                                        <div class="mec-col-12">
                                            <label><?php esc_html_e( 'Not selected seat color', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-12">
                                            <input type="text" class="mec-area-seat-not-selected-color mec-color-picker" data-key="seat_not_selected_color" placeholder="<?php esc_attr_e('ex: #fff', MECSEATTEXTDOMAIN); ?>">
                                        </div>
                                    </div>
                                    <div class="mec-form-row">
                                        <div class="mec-col-12">
                                            <textarea class="mec-area-seat-description mec-col-12" data-key="seat_description" placeholder="<?php esc_attr_e( 'Seat Description', MECSEATTEXTDOMAIN ); ?>"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mec-col-12">
                                <button class="mec-col-12 button" id="mec-seat-add-area">
                                    <i class="mec-sl-plus"></i>
                                    <?php esc_html_e( 'Add Area', MECSEATTEXTDOMAIN ); ?>
                                </button>
                            </div>
                        </div>

                        <div id="mec-area-item-popup" class="mec-area-item-popup <?php echo $is_fes_form ? 'mec-fes-form' : '' ?>">
                            <div class="mec-seat-topbar">
                                <div class="title"><?php esc_html_e( 'Area Settings', MECSEATTEXTDOMAIN ); ?></div>
                                <div class="mec-seat-close-lity">
                                <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 12 12">
                                    <path id="close" d="M11.748.252a.86.86,0,0,1,0,1.217l-4.6,4.6,4.462,4.462a.86.86,0,0,1-1.217,1.217L5.93,7.286,1.608,11.609A.86.86,0,0,1,.391,10.392L4.713,6.069.252,1.608A.86.86,0,0,1,1.469.391L5.93,4.852l4.6-4.6A.86.86,0,0,1,11.748.252Z" fill="#939b9e"/>
                                </svg>
                                </div>
                            </div>
                            <div class="mec-seat-area-form-fields">
                                <div class="mec-seat-area-rows-seats-wrap mec-form-row">
                                    <div>
                                        <label for="mec-seat-area-rows"><?php esc_html_e( 'Rows', MECSEATTEXTDOMAIN ) ?></label>
                                        <input id="mec-seat-area-rows-popup" class="mec-col-12" data-key="rows" type="text" min="1" value="" placeholder="<?php esc_attr_e( 'Rows', MECSEATTEXTDOMAIN ); ?>" />
                                        <span class="mec-tooltip mec-seat-option-tooltip">
                                            <div class="box right">
                                            <div class="content"><p><?php _e('Enter the number of rows.', MECSEATTEXTDOMAIN); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
                                    </div>
                                    <div>
                                        <label for="mec-seat-area-number-of-seats-popup"><?php esc_html_e( 'Seats', MECSEATTEXTDOMAIN ) ?></label>
                                        <input id="mec-seat-area-number-of-seats-popup" class="mec-col-12" data-key="number_of_seats" type="text" min="1" value="<?php echo esc_attr( $area['number_of_seats'] ?? '' ) ?>" placeholder="<?php esc_attr_e( 'Number of seats in each row', MECSEATTEXTDOMAIN ); ?>" />
                                        <span class="mec-tooltip mec-seat-option-tooltip">
                                            <div class="box left">
                                            <div class="content"><p><?php _e('Enter the number of seats in each row.', MECSEATTEXTDOMAIN); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="mec-col-12 mec-form-row">
                                    <input id="mec-seat-area-title-popup" class="mec-col-12" data-key="title" type="text" value="" placeholder="<?php esc_attr_e( 'Title', MECSEATTEXTDOMAIN ); ?>" />
                                </div>
                                <?php if( $event_id && 'global' !== $event_id ): ?>
                                    <div class="mec-col-12">
                                        <div class="mec-col-12">
                                            <label><?php esc_html_e( 'Tickets', MECSEATTEXTDOMAIN ) ?></label>
                                            <span class="mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Select the Ticket according to your desired seat. Tickets will be displayed after the event is updated.', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
                                        </div>
                                        <div class="mec-col-12 mec-form-row mec-seat-area-tickets-popup-wrapper">
                                            <select id="mec-seat-area-tickets-popup" class="mec-seat-area-ticket-popup mec-select2" data-key="ticket_ids" multiple data-placeholder="<?php esc_attr_e( 'Select Allowed Tickets', MECSEATTEXTDOMAIN ); ?>">
                                                <?php
                                                    foreach( $tickets as $ticket_id => $ticket ){

                                                        $ticket_name = $ticket['name'] ?? '';

                                                        echo '<option value="'. esc_attr( $ticket_id ) .'">'. esc_html( $ticket_name ) .'</option>';
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="mec-col-12 mec-form-row">
                                    <textarea id="mec-seat-area-description-popup" class="mec-col-12" data-key="description" placeholder="<?php esc_attr_e( 'Description', MECSEATTEXTDOMAIN ); ?>"></textarea>
                                </div>
                                <div class="mec-col-12 mec-form-row">
                                    <select id="mec-seat-area-shape-popup" data-key="shape_type" class="mec-seat-area-shape mec-col-12">
                                        <option value="square" selected><?php esc_html_e( 'Default', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="square-2"><?php esc_html_e( 'Square', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="table"><?php esc_html_e( 'Circle', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs"><?php esc_html_e( 'Chairs-1', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-2"><?php esc_html_e( 'Chairs-2', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-3"><?php esc_html_e( 'Chairs-3', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-4"><?php esc_html_e( 'Chairs-4', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-5"><?php esc_html_e( 'Chairs-5', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-6"><?php esc_html_e( 'Chairs-6', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="chairs-7"><?php esc_html_e( 'Chairs-7', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="kiosk"><?php esc_html_e( 'Kiosk', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="tent"><?php esc_html_e( 'Tent', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="parking"><?php esc_html_e( 'Parking', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="tickets-shape"><?php esc_html_e( 'Tickets', MECSEATTEXTDOMAIN ) ?></option>
                                        <option value="circle"><?php esc_html_e( 'Table', MECSEATTEXTDOMAIN ) ?></option>
                                    </select>
                                </div>
                                <div class="mec-col-12 mec-form-row mec-seat-area-number-of-seats-in-shape-wrap">
                                    <input class="mec-col-12" type="number" id="mec-seat-area-number-of-seats-in-shape-popup" data-key="number_of_seats_in_shape" value="" placeholder="<?php esc_attr_e( 'Seats', MECSEATTEXTDOMAIN ); ?>" />
                                </div>

                                <div class="mec-col-12 mec-form-row">
                                    <button class="mec-col-12 button" id="mec-seat-update-area"><?php esc_html_e( 'Save', MECSEATTEXTDOMAIN ); ?></button>
                                </div>
                            </div>
                        </div>

                        <div id="" class="mec-seat-areas">
                            <?php
                                $i = 0;
                                foreach( $areas as $k => $area ):
                                $id = $area['id'] ?? '';
                                $i++;
                                ?>
                                <div id="<?php echo '_fi_' === $k ? 'mec-seat-area-default' : ''; ?>" class="mec-form-row <?php echo '_fi_' === $k ? 'hidden' : ''; ?>" >
                                    <div id="mec-area-item-<?php echo esc_attr( $id ) ?>" class="mec-area-item" data-area_number="<?php echo esc_attr( $id ) ?>">
                                        <div class="mec-area-row-title mec-sl-cursor-move mec-move-row"><span class="mec-area-title"><?php echo isset( $area['title'] ) && !empty( ( $area['title'] ) ) ? $area['title'] : '#' . $i . ' ' . __('Area'); ?></span></div>
                                        <div class="actions">
                                            <span class="mec-edit-row mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Edit area settings', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="15.991" viewBox="0 0 16 15.991">
                                                    <path id="settings-icon" d="M1148.894-1851.7c-.833,0-1.238-.428-1.238-1.307v-.785a6.3,6.3,0,0,1-.841-.338l-.707.7a1.381,1.381,0,0,1-.891.474,1.24,1.24,0,0,1-.9-.428l-.9-.9a1.237,1.237,0,0,1-.43-.9,1.374,1.374,0,0,1,.475-.9l.633-.635a6.268,6.268,0,0,1-.466-1.085h-.851c-.835,0-1.236-.434-1.238-1.3v-1.146c0-.868.417-1.307,1.238-1.307h.853a6.354,6.354,0,0,1,.336-.839l-.622-.636a1.37,1.37,0,0,1-.479-.935,1.25,1.25,0,0,1,.432-.866l.9-.9a1.227,1.227,0,0,1,.9-.423,1.4,1.4,0,0,1,.895.474l.569.562a6.263,6.263,0,0,1,1.085-.466v-.783c0-.868.417-1.307,1.247-1.307h1.283a1.134,1.134,0,0,1,1.238,1.307v.8a6.24,6.24,0,0,1,1.085.466l.566-.564a1.4,1.4,0,0,1,.893-.472,1.225,1.225,0,0,1,.9.423l.9.9a1.245,1.245,0,0,1,.43.864,1.355,1.355,0,0,1-.479.935l-.625.624a6.259,6.259,0,0,1,.34.832h.851a1.146,1.146,0,0,1,1.247,1.307v1.162c0,.879-.4,1.307-1.237,1.307h-.851a6.141,6.141,0,0,1-.468,1.085h0l.656.656a1.356,1.356,0,0,1,.477.933,1.247,1.247,0,0,1-.428.866h0l-.9.9a1.125,1.125,0,0,1-1.8-.049l-.723-.723a6.269,6.269,0,0,1-.841.338v.783c0,.88-.4,1.307-1.238,1.307Zm1.275-1.094a1.018,1.018,0,0,0,.139,0,1.214,1.214,0,0,0,.015-.213v-1.193a.542.542,0,0,1,.117-.331.542.542,0,0,1,.3-.19,5.177,5.177,0,0,0,1.343-.542.543.543,0,0,1,.342-.068.542.542,0,0,1,.313.155l1,.989a1.2,1.2,0,0,0,.163.139,1.046,1.046,0,0,0,.1-.092l.9-.9a1,1,0,0,0,.092-.1,1.217,1.217,0,0,0-.141-.161h0l-.956-.956a.542.542,0,0,1-.156-.326.541.541,0,0,1,.084-.352,5.069,5.069,0,0,0,.669-1.551.542.542,0,0,1,.192-.3.541.541,0,0,1,.334-.116h1.265a.993.993,0,0,0,.137,0,1.209,1.209,0,0,0,.014-.215l.005-1.155a1.286,1.286,0,0,0-.014-.213,1.018,1.018,0,0,0-.139,0h-1.266a.544.544,0,0,1-.337-.122.543.543,0,0,1-.187-.306,5.147,5.147,0,0,0-.542-1.341.542.542,0,0,1-.068-.343.543.543,0,0,1,.155-.313l.9-.9a1.272,1.272,0,0,0,.141-.161.986.986,0,0,0-.09-.1l-.9-.9a.917.917,0,0,0-.1-.09,1.1,1.1,0,0,0-.163.139l-.866.868a.542.542,0,0,1-.324.155.542.542,0,0,1-.35-.082,5.164,5.164,0,0,0-1.553-.667.542.542,0,0,1-.3-.192.543.543,0,0,1-.115-.334v-1.193a1.313,1.313,0,0,0-.015-.213,1.018,1.018,0,0,0-.139,0h-1.283a.923.923,0,0,0-.137,0,1.125,1.125,0,0,0-.016.213v1.193a.542.542,0,0,1-.116.333.543.543,0,0,1-.3.191,5.181,5.181,0,0,0-1.553.669.542.542,0,0,1-.35.082.543.543,0,0,1-.324-.155l-.866-.843a1.119,1.119,0,0,0-.163-.141.92.92,0,0,0-.1.09l-.9.9a1.055,1.055,0,0,0-.092.1,1.3,1.3,0,0,0,.143.163l.9.9a.543.543,0,0,1,.154.31.541.541,0,0,1-.065.34,5.309,5.309,0,0,0-.542,1.345.541.541,0,0,1-.192.3.543.543,0,0,1-.334.115h-1.266a.921.921,0,0,0-.137,0,1.1,1.1,0,0,0-.016.213v1.153a1.21,1.21,0,0,0,.014.215,1.061,1.061,0,0,0,.139,0h1.266a.541.541,0,0,1,.335.115.542.542,0,0,1,.193.3,5.177,5.177,0,0,0,.667,1.553.543.543,0,0,1,.082.35.543.543,0,0,1-.155.324l-.927.936a1.209,1.209,0,0,0-.141.161.969.969,0,0,0,.094.1l.9.9a.981.981,0,0,0,.1.094,1.2,1.2,0,0,0,.161-.139l.973-.98a.542.542,0,0,1,.312-.155.543.543,0,0,1,.342.067,5.2,5.2,0,0,0,1.343.542.543.543,0,0,1,.3.192.543.543,0,0,1,.115.334V-1853a1.214,1.214,0,0,0,.015.213,1.059,1.059,0,0,0,.139,0h1.283Zm-3-4.54a3.34,3.34,0,0,1-.978-2.362,3.34,3.34,0,0,1,.978-2.362,3.34,3.34,0,0,1,2.362-.979h0a3.344,3.344,0,0,1,2.361.979,3.344,3.344,0,0,1,.979,2.361,3.34,3.34,0,0,1-.979,2.362,3.34,3.34,0,0,1-2.362.979A3.34,3.34,0,0,1,1147.164-1857.331Zm2.357-4.611a2.256,2.256,0,0,0-1.593.663,2.256,2.256,0,0,0-.658,1.595,2.256,2.256,0,0,0,.662,1.594,2.256,2.256,0,0,0,1.594.66v-.007a2.258,2.258,0,0,0,1.595-.661,2.258,2.258,0,0,0,.661-1.595,2.256,2.256,0,0,0-.665-1.592,2.256,2.256,0,0,0-1.591-.657Zm.647-4.653h0Z" transform="translate(-1141.531 1867.688)"/>
                                                </svg>
                                            </span>

                                            <span class="mec-remove-row mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Remove area.', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15.516" viewBox="0 0 11 15.516">
                                                    <path id="trash-icon" d="M10.935,2.016a1.99,1.99,0,0,0-3.866,0H3.5v1h11v-1H10.935ZM9,1.5a1.018,1.018,0,0,1,.875.516H8.142A.988.988,0,0,1,9,1.5ZM13,4h1V14.516a1.5,1.5,0,0,1-1.5,1.5h-7a1.5,1.5,0,0,1-1.5-1.5V4H5V14.516a.5.5,0,0,0,.5.5h7a.5.5,0,0,0,.5-.5V4ZM8,5v8H7V5Zm3,0v8H10V5Z" transform="translate(-3.5 -0.5)"/>
                                                </svg>
                                            </span>

                                        </div>

                                        <div id="mec-area-item-fields-<?php echo esc_attr( $id ) ?>" class="mec-seat-area-form-fields" data-item_id="<?php echo esc_attr( $id ) ?>">
                                            <div class="hidden">
                                                <input class="mec-area-row-id" data-key="id" type="hidden" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][id]" value="<?php echo esc_attr( $id ) ?>" />
                                                <input class="mec-area-row-ticket_ids" data-key="ticket_ids" type="hidden" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][ticket_ids]" value="<?php echo $area['ticket_ids'] ?? '' ?>" />
                                            </div>
                                            <div class="mec-seat-area-rows-seats-wrap">
                                                <div>
                                                    <label for="mec-seat-area-rows-<?php echo esc_attr( $id ) ?>"><?php esc_html_e( 'Rows', MECSEATTEXTDOMAIN ) ?></label>
                                                    <input id="mec-seat-area-rows-<?php echo esc_attr( $id ) ?>" class="mec-col-12" data-key="rows" type="text" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][rows]" min="1" value="<?php echo esc_attr( $area['rows'] ?? '' ) ?>" placeholder="<?php esc_attr_e( 'Rows', MECSEATTEXTDOMAIN ); ?>" />
                                                </div>
                                                <div>
                                                    <label for="mec-seat-area-number-of-seats-<?php echo esc_attr( $id ) ?>"><?php esc_html_e( 'Seats', MECSEATTEXTDOMAIN ) ?></label>
                                                    <input id="mec-seat-area-number-of-seats-<?php echo esc_attr( $id ) ?>" class="mec-col-12" data-key="number_of_seats" type="text" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][number_of_seats]" min="1" value="<?php echo esc_attr( $area['number_of_seats'] ?? '' ) ?>" placeholder="<?php esc_attr_e( 'Number of seats in each row', MECSEATTEXTDOMAIN ); ?>" />
                                                </div>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="title" type="text" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][title]" value="<?php echo esc_attr( $area['title'] ?? '' ) ?>" placeholder="<?php esc_attr_e( 'Title', MECSEATTEXTDOMAIN ); ?>" />
                                            </div>
                                            <div class="mec-col-12">
                                                <textarea class="mec-col-12" data-key="description" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][description]" placeholder="<?php esc_attr_e( 'Description', MECSEATTEXTDOMAIN ); ?>"><?php echo esc_html( $area['description'] ?? '' ) ?></textarea>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="shape_type" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][shape_type]" value="<?php echo esc_html( $area['shape_type'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="number_of_seats_in_shape" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][number_of_seats_in_shape]" value="<?php echo esc_html( $area['number_of_seats_in_shape'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="seat_booked" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][seat_booked]" value="<?php echo esc_html( $area['seat_booked'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="seat_handicap_accessible" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][seat_handicap_accessible]" value="<?php echo esc_html( $area['seat_handicap_accessible'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="seat_selected_color" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][seat_selected_color]" value="<?php echo esc_html( $area['seat_selected_color'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <input class="mec-col-12" data-key="seat_not_selected_color" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][seat_not_selected_color]" value="<?php echo esc_html( $area['seat_not_selected_color'] ?? '' ) ?>"/>
                                            </div>
                                            <div class="mec-col-12">
                                                <textarea class="mec-col-12" data-key="seat_description" name="mec[settings][seat_areas_data][<?php echo esc_attr( $id ) ?>][seat_description]" placeholder="<?php esc_attr_e( 'Description', MECSEATTEXTDOMAIN ); ?>"><?php echo esc_html( $area['seat_description'] ?? '' ) ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="mec-form-row mec-seat-save-seats-settings-wrapper">
                        <button id="mec-seat-save-seats-settings" class="button mec-col-12"><?php esc_html_e( 'Save', MECSEATTEXTDOMAIN ); ?></button>
                    </div>
                </div>

                <div class="mec-seats-content-wrap">
                    <div id="mec-seat-layouts-builder-wrap" class="mec-seat-layouts-builder-wrap">
                        <div class="mec-seat-layouts"></div>
                    </div>
                    <div class="mes-seats-footer">
                        <div class="mec-seat-demo">
                            <div id="mec-seat-popup-demo-data" class="mec-seat-popup mec-seat-popup-demo-data lity-hide <?php echo $is_fes_form ? 'mec-fes-form' : '' ?>">
                                <div class="mec-seat-topbar">
                                    <div class="title"><?php esc_html_e( 'Settings', MECSEATTEXTDOMAIN ); ?></div>
                                    <div class="mec-seat-close-lity">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 12 12">
                                        <path id="close" d="M11.748.252a.86.86,0,0,1,0,1.217l-4.6,4.6,4.462,4.462a.86.86,0,0,1-1.217,1.217L5.93,7.286,1.608,11.609A.86.86,0,0,1,.391,10.392L4.713,6.069.252,1.608A.86.86,0,0,1,1.469.391L5.93,4.852l4.6-4.6A.86.86,0,0,1,11.748.252Z" fill="#939b9e"/>
                                    </svg>
                                    </div>
                                </div>
                                <div class="mec-seat-form-fields">
                                    <input type="hidden" class="mec-seat-html-id" value="">
                                    <div class="mec-form-row column-flex">
                                        <div class="mec-col-12">
                                            <label><?php esc_html_e( 'Color', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-12">
                                            <input type="text" class="mec-seat-demo-color mec-color-picker" placeholder="<?php esc_attr_e('ex: #fff', MECSEATTEXTDOMAIN); ?>">
                                        </div>
                                    </div>

                                    <div class="mec-form-row">
                                        <button id="mec-seat-update-demo" class="mec-seat-update-demo mec-save-button button mec-col-12"><?php esc_html_e( 'Save', MECSEATTEXTDOMAIN ); ?></button>
                                    </div>
                                </div>
                            </div>
                            <ul>
                                <li class="mec-seat mec-seat-customized mec-seat-disabled"><span style=""></span></li><label data-target="disabled"><?php esc_html_e( 'Disabled', MECSEATTEXTDOMAIN ); ?></label>
                                <input type="hidden" class="mec-seat-demo-input" name="mec[settings][demo_settings][disabled]" value="<?php echo esc_attr( $demo_settings['disabled'] ?? '' ) ?>" />

                                <li class="mec-seat mec-seat-customized mec-seat-selected"><span style=""></span></li><label data-target="selected"><?php esc_html_e( 'Selected', MECSEATTEXTDOMAIN ); ?></label>
                                <input type="hidden" class="mec-seat-demo-input" name="mec[settings][demo_settings][selected]" value="<?php echo esc_attr( $demo_settings['selected'] ?? '' ) ?>" />

                                <li class="mec-seat mec-seat-customized mec-seat-available"><span style=""></span></li><label data-target="available"><?php esc_html_e( 'Available', MECSEATTEXTDOMAIN ); ?></label>
                                <input type="hidden" class="mec-seat-demo-input" name="mec[settings][demo_settings][available]" value="<?php echo esc_attr( $demo_settings['available'] ?? '' ) ?>" />

                                <li class="mec-seat mec-seat-customized mec-seat-booked"><span style=""></span></li><label data-target="booked"><?php esc_html_e( 'Reserved', MECSEATTEXTDOMAIN ); ?></label>
                                <input type="hidden" class="mec-seat-demo-input" name="mec[settings][demo_settings][booked]" value="<?php echo esc_attr( $demo_settings['booked'] ?? '' ) ?>" />

                            </ul>
                        </div>
                    </div>
                    <?php
                    if( $this->is_global_settings() ):
                            wp_nonce_field( 'mec_seat_update_layout_nonce-global', 'mec_seat_update_layout_nonce' );
                    elseif( $event_id ):
                        ?>
                        <div class="mec-seat-btn-wrap mec-form-row">
                            <?php wp_nonce_field( 'mec_seat_update_layout_nonce-'.$event_id, 'mec_seat_update_layout_nonce' ); ?>
                            <!-- <button class="mec-seat-update-layout button"><?php esc_html_e( 'Update', MECSEATTEXTDOMAIN) ?></button> -->
                        </div>
                    <?php endif; ?>
                    <textarea id="mec-seat-layout-data" name="mec[settings][seat_layout_data]" style="display:none;"><?php echo $layout_data; ?></textarea>
                    <div id="mec-seat-popup-backend-seat-data" class="mec-seat-popup-seat-data lity-hide <?php echo $is_fes_form ? 'mec-fes-form' : '' ?>">
                        <div class="mec-seat-topbar">
                            <div class="title"><?php esc_html_e( 'Seat Settings', MECSEATTEXTDOMAIN ); ?></div>
                            <div class="mec-seat-close-lity">
                            <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 12 12">
                                <path id="close" d="M11.748.252a.86.86,0,0,1,0,1.217l-4.6,4.6,4.462,4.462a.86.86,0,0,1-1.217,1.217L5.93,7.286,1.608,11.609A.86.86,0,0,1,.391,10.392L4.713,6.069.252,1.608A.86.86,0,0,1,1.469.391L5.93,4.852l4.6-4.6A.86.86,0,0,1,11.748.252Z" fill="#939b9e"/>
                            </svg>
                            </div>
                        </div>
                        <div class="mec-seat-form-fields">
                            <input type="hidden" class="mec-seat-html-id" value="">
                            <div class="mec-form-row">
                                <div class="mec-col-6">
                                    <label><?php esc_html_e( 'Display', MECSEATTEXTDOMAIN ) ?></label>
                                </div>
                                <div class="mec-col-6">
                                    <label class="label-checkbox"><input type="checkbox" class="mec-seat-status" value="1"><?php esc_html_e( 'Show', MECSEATTEXTDOMAIN ) ?></label>
                                    <span class="mec-tooltip mec-seat-option-tooltip">
                                        <div class="box left">
                                            <div class="content"><p><?php _e('Show/Hide seats in this position.', MECSEATTEXTDOMAIN); ?></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="mec-seat-options">
                                <div class="mec-form-row">
                                    <div class="mec-col-6">
                                        <label><?php esc_html_e( 'Custom Row ID', MECSEATTEXTDOMAIN ) ?></label>
                                    </div>
                                    <div class="mec-col-6">
                                        <input type="text" class="mec-seat-row-id mec-col-12" placeholder="<?php esc_attr_e( 'Row ID', MECSEATTEXTDOMAIN ); ?>" />
                                    </div>
                                </div>
                                <div class="mec-form-row">
                                    <div class="mec-col-6">
                                        <label><?php esc_html_e( 'Book status', MECSEATTEXTDOMAIN ) ?></label>
                                    </div>
                                    <div class="mec-col-6">
                                        <label class="label-checkbox"><input type="checkbox" class="mec-seat-booked settings" value="1"><?php esc_html_e( 'Booked', MECSEATTEXTDOMAIN ) ?></label>
                                        <span class="mec-tooltip mec-seat-option-tooltip">
                                            <div class="box left">
                                                <div class="content"><p><?php _e('Check if this seat is booked before.', MECSEATTEXTDOMAIN); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="mec-form-row">
                                    <div class="mec-col-6">
                                        <label><?php esc_html_e( 'Handicap accessible', MECSEATTEXTDOMAIN ) ?></label>
                                    </div>
                                    <div class="mec-col-6">
                                        <label class="label-checkbox"><input type="checkbox" class="mec-seat-handicap-accessible settings" value="1"><?php esc_html_e( 'Yes', MECSEATTEXTDOMAIN ) ?></label>
                                        <span class="mec-tooltip mec-seat-option-tooltip">
                                            <div class="box left">
                                                <div class="content"><p><?php _e('Check if this seat is handicap accessible.', MECSEATTEXTDOMAIN); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="mec-form-row column-flex">
                                    <div class="mec-col-12">
                                        <label><?php esc_html_e( 'Selected seat color', MECSEATTEXTDOMAIN ) ?></label>
                                    </div>
                                    <div class="mec-col-12">
                                        <input type="text" class="mec-seat-selected-color mec-color-picker" placeholder="<?php esc_attr_e('ex: #fff', MECSEATTEXTDOMAIN); ?>">
                                    </div>
                                </div>
                                <div class="mec-form-row column-flex">
                                    <div class="mec-col-12">
                                        <label><?php esc_html_e( 'Not selected seat color', MECSEATTEXTDOMAIN ) ?></label>
                                    </div>
                                    <div class="mec-col-12">
                                        <input type="text" class="mec-seat-not-selected-color mec-color-picker" placeholder="<?php esc_attr_e('ex: #fff', MECSEATTEXTDOMAIN); ?>">
                                    </div>
                                </div>
                                <div class="mec-form-row">
                                    <div class="mec-col-12">
                                        <textarea class="mec-area-seat-description mec-col-12" placeholder="<?php esc_attr_e( 'Description', MECSEATTEXTDOMAIN ); ?>"></textarea>
                                    </div>
                                </div>
                                <?php if( $event_id && 'global' !== $event_id ): ?>
                                    <div class="mec-form-row">
                                        <div class="mec-col-6">
                                            <label><?php esc_html_e( 'Tickets', MECSEATTEXTDOMAIN ) ?></label>
                                        </div>
                                        <div class="mec-col-6 mec-seat-ticket-wrapper">
                                            <select class="mec-seat-ticket mec-select2" multiple data-placeholder="<?php esc_attr_e( 'Select Allowed Tickets', MECSEATTEXTDOMAIN ); ?>">
                                                <?php
                                                    foreach( $tickets as $ticket_id => $ticket ){

                                                        $ticket_name = $ticket['name'] ?? '';

                                                        echo '<option value="'. esc_attr( $ticket_id ) .'">'. esc_html( $ticket_name ) .'</option>';
                                                    }
                                                ?>
                                            </select>
                                            <span class="mec-tooltip mec-seat-option-tooltip">
                                                <div class="box left">
                                                    <div class="content"><p><?php _e('Select the Ticket according to your desired seat. Tickets will be displayed after the event is updated.', MECSEATTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="mec-form-row">
                                <button id="mec-seat-update-seat" class="mec-seat-update-seat button mec-col-12"><?php esc_html_e( 'Save', MECSEATTEXTDOMAIN ); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Display import export html form
     *
     * @param int|string $event_id
     * @param bool $is_fes_form
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function import_export_html( $event_id, $is_fes_form = false ){

        if( -1 === $event_id && $is_fes_form ){

            return;
        }

        if( is_numeric( $event_id ) && 'auto-draft' === get_post_status( $event_id ) ){

            return;
        }

        ?>
            <div id="mec-seat-import-form">
                <h4 class="title"><?php esc_html_e( 'Import', MECSEATTEXTDOMAIN ); ?></h4>
                <?php if( $this->is_global_settings() ): ?>
                    <?php wp_nonce_field( 'mec_seat_import_export_layout_nonce-global', 'mec_seat_import_export_layout_nonce' ); ?>
                <?php elseif( $event_id ): ?>
                    <?php wp_nonce_field( 'mec_seat_import_export_layout_nonce-'.$event_id, 'mec_seat_import_export_layout_nonce' ); ?>
                <?php endif; ?>
                <div class="mec-form-row">
                    <textarea class="mec-col-12" id="mec-seat-import-data"></textarea>
                </div>
                <div class="mec-form-row">
                    <div class="mec-seat-btn-wrap mec-form-row">
                        <button class="mec-seat-import-layout button"><?php esc_html_e( 'Import', MECSEATTEXTDOMAIN) ?></button>
                    </div>
                </div>
            </div>
            <div id="mec-seat-export-form">
                <h4 class="title"><?php esc_html_e( 'Export', MECSEATTEXTDOMAIN ); ?></h4>
                <div class="mec-form-row">
                    <div class="mec-seat-btn-wrap mec-form-row">
                        <button class="mec-seat-export-layout button"><?php esc_html_e( 'Export', MECSEATTEXTDOMAIN) ?></button>
                    </div>
                </div>
            </div>
        <?php
    }
}
