<?php

namespace MEC_Seat\Seat;

use MEC\Singleton;

class Seats extends Singleton{

    public $tbl;

    public function __construct(){

        global $wpdb;
        $this->tbl = $wpdb->prefix.'mec_seats';
    }

    private function get_where( $conditions = array()){

        $where = "1";

        if( !is_array($conditions) || empty($conditions) ){

            return $where;
        }

        global $wpdb;
        foreach($conditions as $k => $v){

            switch($k){

                case 'book_id':
                case 'event_id':
                case 'seat_number':
                case 'occurrence':
                    if($v){

                        if( is_array( $v ) && !isset( $v['compare'] ) ){

                            $v = is_array($v) ? "'" . implode("','",$v) . "'" : $v;
                            $where .= " AND `{$k}` IN (".$v.")";
                        }elseif( is_array( $v ) && isset( $v['compare'] ) ){

                            $compare = isset( $v['compare'] ) ? $v['compare'] : 'IN';
                            $v = isset( $v['value'] ) ? $v['value'] : false;
                            if( !$v ){

                                break;
                            }

                            $v = is_array($v) ? "'" . implode("','",$v) . "'" : $v;
                            $where .= " AND `{$k}` {$compare} (".$v.")";
                        } else {

                            $where .= $wpdb->prepare(
                                " AND `{$k}` = '%s'",
                                $v
                            );
                        }
                    }
                break;
            }
        }

        return $where;
    }

    public function get_rows( $conditions, $fields = '*' ){

        global $wpdb;
        $where = $this->get_where( $conditions );

        $fields = is_array($fields) && !empty($fields) ? "`" . implode( '`,`', $fields ) . "`" : $fields;
        $fields = !empty($fields) ? $fields : '*';

        $sql = "SELECT {$fields} FROM {$this->tbl} WHERE {$where}";

        return $wpdb->get_results($sql,ARRAY_A);
    }

    public function _get_seats( $conditions = array(), $return_by_post_and_seat_number_data = false ){

        $rows = $this->get_rows( $conditions);

        $seats = [];
        if(!empty($rows) && is_array($rows)){

            foreach( $rows as $row ){

                $id = $row['id'];
                $data = maybe_unserialize($row['data']);

                $seat = [
                    'id' => $id,
                    'book_id' => $row['book_id'],
                    'event_id' => $row['event_id'],
                    'occurrence' => $row['occurrence'],
                    'seat_number' => $row['seat_number'],
                    'data' => is_array($data) ? $data : [],
                ];

                $seats[$id] = $seat;
            }
        }

        return $seats;
    }

    private function _insert( $seat_data ){

        global $wpdb;
        $seat = [
            'book_id' => (int)$seat_data['book_id'],
            'event_id' => (int)$seat_data['event_id'],
            'occurrence' => (int)$seat_data['occurrence'],
            'seat_number' => (int)$seat_data['seat_number'],
            'data' => $seat_data['data'],
        ];

        $v_type = ['%d','%d','%d','%d','%s'];

        return $wpdb->insert($this->tbl, $seat, $v_type );
    }

    private function _update( $seat_data, $where ){

        if(empty($where)){

            return false;
        }

        global $wpdb;

        $seat = [
            'book_id' => '',
            'event_id' => '',
            'occurrence' => '',
            'seat_number' => '',
            'data' => '',
        ];

        $v_type = ['%d','%d','%d','%d','%s'];

        foreach($seat as $k => $v){

            switch($k){

                case 'book_id':
                case 'event_id':
                case 'occurrence':
                case 'seat_number':
                case 'data':

                    if(isset($seat_data[$k])){

                        $seat[$k] = $seat_data[$k];
                    }else{

                        unset($seat[$k]);
                    }
                break;
            }
        }

        return $wpdb->update($this->tbl, $seat, $where, $v_type );
    }

    private function _delete( $conditions ){

        global $wpdb;
        return $wpdb->delete($this->tbl,$conditions);
    }

    private function _add_or_update( $seat ){

        $book_id = isset($seat['book_id']) ? (int)$seat['book_id'] : 0;
        $event_id = isset($seat['event_id']) ? (int)$seat['event_id'] : 0;
        $occurrence = isset($seat['occurrence']) ? (int)$seat['occurrence'] : 0;
        $seat_number = isset($seat['seat_number']) ? (int)$seat['seat_number'] : 0;

        if( !$book_id || !$event_id || !$occurrence || !$seat_number ){

            return false;
        }

        $seat['data'] = isset($seat['data']) ? serialize($seat['data']) : '';
        $existed = $this->is_existed( $book_id, $event_id, $occurrence, $seat_number );

        if( !$existed ){

            $r = $this->_insert($seat);
        }elseif( $existed ){

            $where['id'] = $existed;
            $r = $this->_update($seat, $where);
        }

        return $r;
    }

    public function get_seats( $event_id, $occurrence = null, $book_id = null, $seat_number = null, $return_cached = true ){

        $cached = $return_cached ? $this->get_cache( $event_id, $book_id, $occurrence ) : false;
        if( $cached ){

            return $cached;
        }

        $conditions = [
            'event_id' => $event_id,
            'occurrence' => $occurrence,
            'book_id' => $book_id,
            'seat_number' => $seat_number,
        ];

        $seats = $this->_get_seats( $conditions );
        $this->update_cache( $event_id, $book_id, $occurrence, $seats );

        return $seats;
    }

    public function is_existed( $book_id, $event_id, $occurrence, $seat_number ){

        $conditions = [
            'book_id' => $book_id,
            'event_id' => $event_id,
            'occurrence' => $occurrence,
            'seat_number' => $seat_number,
        ];

        $r = $this->_get_seats($conditions);

        if(count($r)){

            return key($r);
        }

        return false;
    }

    public function add_or_update( $book_id, $event_id, $occurrence, $seats ){

        $success = null;
        if( !$book_id || !$event_id || !$occurrence || !is_array($seats) ){

            return false;
        }

        $success = !is_null($success) ? $success : true;
        foreach( $seats as $seat ){

            $seat_number = isset($seat['seat_number']) ? $seat['seat_number'] : 0;
            $data = isset($seat['data']) && is_array( isset($seat['data']) ) ? $seat['data'] : [];
            $data = empty($data) && isset($seat['data']) ? (array)$seat['data'] : $data;
            unset($data['data']);

            $seat['book_id'] = $book_id;
            $seat['event_id'] = $event_id;
            $seat['occurrence'] = $occurrence;
            $seat['seat_number'] = $seat_number;
            $seat['data'] = $data;

            $s = $this->_add_or_update( $seat );
            $success = $success && $s;
        }

        $this->clear_cache( $event_id, $book_id, $occurrence );

        return $success;
    }

    public function update_seats( $book_id, $event_id, $occurrence, $seats ){

        if( !$book_id || !$event_id || !$occurrence || !is_array($seats) ){

            return false;
        }

        $saved_seats = $this->get_seats( $event_id, $occurrence, $book_id, null, false );

        $saved_seats_numbers = array_column($saved_seats,'seat_number','id');
        $seats_numbers = array_column($seats,'seat_number');

        foreach( $saved_seats_numbers as $id => $saved_seat_number ){

            if( false === array_search( $saved_seat_number, $seats_numbers ) ){

                $conditions = [
                    'id' => $id,
                ];
                $this->_delete($conditions);
            }
        }

        return $this->add_or_update( $book_id, $event_id, $occurrence, $seats );
    }

    public function delete( $book_id, $event_id = null, $occurrence = null, $seat_number = null ){

        $conditions['book_id'] = $book_id;

        if( !is_null($event_id) ){

            $conditions['event_id'] = $event_id;
        }

        if( !is_null($occurrence) ){

            $conditions['occurrence'] = $occurrence;
        }

        if( !is_null($seat_number) ){

            $conditions['seat_number'] = $seat_number;
        }

        $this->_delete( $conditions );

        $this->clear_cache( $event_id, $book_id, $occurrence );
    }

    public function update_cache( $event_id, $book_id, $occurrence, $seats ){

        $cache_key = 'mec-seats-'.$event_id.'-'.$book_id.'-'.$occurrence;
        set_transient( $cache_key, $seats, 3600 );
    }

    public function get_cache( $event_id, $book_id, $occurrence ){

        $cache_key = 'mec-seats-'.$event_id.'-'.$book_id.'-'.$occurrence;
        return get_transient( $cache_key );
    }

    public function clear_cache( $event_id, $book_id, $occurrence ){

        $cache_key = 'mec-seats-'.$event_id.'-'.$book_id.'-'.$occurrence;
        delete_transient( $cache_key );
        $cache_key = 'mec-seats-'.$event_id.'-'.'-'.$occurrence;
        delete_transient( $cache_key );
        $cache_key = 'mec-seats-'.$event_id.'-'.$book_id.'-';
        delete_transient( $cache_key );
        $cache_key = 'mec-seats-'.$event_id.'-'.'-';
        delete_transient( $cache_key );
    }
}