<?php

namespace MEC_Seat\Seat;

/**
 * @since 1.0.0
 */
class SeatsTable{

    public static $tbl = 'mec_seats';
    public static $version = '1.0.0';

    public static function create_table(){

        if ( !function_exists( 'dbDelta' ) ) {

			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		}

        global $wpdb;
        $seats_table_name = $wpdb->prefix . self::$tbl;
        $db_option_key = 'mec_table_version_'.$seats_table_name;

        $tables = $wpdb->get_results("SHOW TABLES");
        $tables_group = "Tables_in_".DB_NAME;
        $tables = array_column($tables,$tables_group);
        $table_exists = array_search($seats_table_name,$tables);

        if(false === $table_exists){

            $charset = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE IF NOT EXISTS `{$seats_table_name}` (
                `id` bigint(20) NOT NULL AUTO_INCREMENT,
                `event_id` bigint(20) NOT NULL,
                `book_id` bigint(20) NOT NULL,
                `occurrence` bigint(20) NOT NULL,
                `seat_number` bigint(20) NOT NULL,
                `data` text NULL,
                PRIMARY KEY (`id`)
            ){$charset}";

            dbDelta( $sql );

            update_option( $db_option_key, static::$version );
        }
    }
}