<?php

namespace MEC_Seat\Settings;


use MEC\Singleton;
use MEC_Seat\Base;

/**
 * @since 1.0.0
 */
class SettingsPage extends Singleton {

	/**
	 * @since 1.0.0
	 *
	 * @var \MEC_Main
	 */
	public $main;

	/**
	 * @since 1.0.0
	 *
	 * @var array
	 */
	public $settings;

	/**
	 * Init
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function init() {

		add_filter( 'mec_is_custom_settings', [ $this, 'is_seat_settings' ], 10, 2 );
		add_action( 'mec_settings_sidebar', [ $this, 'sidebar' ] );
	}

	/**
	 * Is seat settings
	 *
	 * @param bool $true
	 * @param string $tab
	 *
	 * @since 1.0.0
	 *
	 * @return boolean
	 */
	public function is_seat_settings( $true, $tab ) {

		if ( $true ) {
			return $true;
		}

		$tab = strtolower( $tab );

		switch ( $tab ) {
			case 'mec-seat':
				$this->display();
				$true = true;
		}

		return $true;
	}

	/**
	 * Display Settings Page
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display() {

		$this->main = Base::get_main();
		include __DIR__ . '/template-settings-page.php';
	}

	/**
	 * Display Settings menu Sidebar
	 *
	 * @since 1.0.0
	 *
	 * @param $active_menu
	 */
	public function sidebar( $active_menu ) {

		$submenus = array(
			__( 'Seat', MECSEATTEXTDOMAIN )              => 'seat_option',
		);

		if(mec_seat_is_enabled()){

			$submenus = array_merge_recursive(
				$submenus,
				array(
					__('Shortcodes', MECSEATTEXTDOMAIN)    => 'seat_shortcodes',
					__('Import / Export', MECSEATTEXTDOMAIN)    => 'seat_import_export',
				)
			);
		}

		$this->main = Base::get_main();
		$submenus   = apply_filters( 'mec-settings-item-seat', $submenus, $active_menu );

		?>
		<!-- Seat -->
		<li class="wns-be-group-menu-li mec-settings-menu seat-setting-item <?php echo $active_menu === 'seat' ? 'active' : ''; ?>">
			<a href="<?php echo $this->main->add_qs_var( 'tab', 'mec-seat' ); ?>" id="" class="wns-be-group-tab-link-a">
			<svg xmlns="http://www.w3.org/2000/svg" width="14.6" height="14.6" viewBox="0 0 14.6 14.6">
				<path id="Path_42" data-name="Path 42" d="M139.823,62.083h-1.431V59.748A3.813,3.813,0,0,0,134.528,56h-3.059a3.813,3.813,0,0,0-3.864,3.752v2.335h-1.431a.175.175,0,0,0-.175.175V69.82a.175.175,0,0,0,.175.175h1.934a.175.175,0,0,0,.175-.175V67.444h9.432V69.82a.175.175,0,0,0,.175.175h1.934A.175.175,0,0,0,140,69.82V62.258a.175.175,0,0,0-.175-.175ZM138,67.094H128a.487.487,0,0,1-.486-.486V65.533a.487.487,0,0,1,.486-.487h10a.487.487,0,0,1,.486.487v1.075a.487.487,0,0,1-.487.486Zm-10.043-7.346a3.463,3.463,0,0,1,3.514-3.4h3.059a3.463,3.463,0,0,1,3.514,3.4v2.335h-.153a.175.175,0,0,0-.175.175V64.7h-9.432V62.258a.175.175,0,0,0-.175-.175h-.153Zm-1.606,9.9V62.433h1.584V64.7a.835.835,0,0,0-.77.83v1.075a.835.835,0,0,0,.77.83v2.208Zm13.3,0h-1.584V67.437a.835.835,0,0,0,.77-.83V65.533a.835.835,0,0,0-.77-.83v-2.27h1.584Z" transform="translate(-125.698 -55.696)" stroke-width="0.6"/>
			</svg>
				<span class="wns-be-group-menu-title"><?php _e( 'Seat', MECSEATTEXTDOMAIN ); ?></span>
			</a>
			<ul class="<?php echo $active_menu === 'seat' ? 'subsection' : 'mec-settings-submenu'; ?>">

				<?php foreach ( $submenus as $menu_name => $menu_link ) {
					if ( in_array( $menu_link, array_values( $submenus ), true ) ) {
						?>
						<li>
							<a
									<?php if ( $active_menu === 'seat' ): ?>
										data-id="<?php echo $menu_link; ?>" <?php echo $menu_link !== 'seat_option' ? 'data-group_id="seat"' : ''; ?> class="wns-be-group-tab-link-a WnTabLinks"
									<?php else: ?>
										href="<?php echo $this->main->add_qs_var( 'tab', 'mec-seat' ) . '#' . $menu_link; ?>"
									<?php endif; ?>
							>
								<span class="pr-be-group-menu-title"><?php echo $menu_name; ?></span>
							</a>
						</li>
						<?php

					}
				} ?>
			</ul>
		</li>
		<?php
	}
}