<?php
/** no direct access **/

use MEC\Settings\Settings;
use MEC_Seat\Seat\SeatLayoutBuilder;

defined( 'MECEXEC' ) or die();

/** @var \MEC_Seat\Settings\SettingsPage $this */

$settings = Settings::getInstance()->get_settings();

$active_menu = $_GET['tab'] ?? 'options';

$seat_status = isset( $settings['seat_status'] ) && '1' == $settings['seat_status'] ? true : '';
$seat_skip_status = isset( $settings['seat_skip_status'] ) && '1' == $settings['seat_skip_status'] ? true : false;

$seat_pending_time = (int) ( $settings['seat_pending_time'] ?? 0 );
$display_seat_id   = $settings['display_seat_id'] ?? 'row_number';
?>
<div class="wns-be-container wns-be-container-sticky">
	<div id="wns-be-infobar">
		<div class="mec-search-settings-wrap">
			<i class="mec-sl-magnifier"></i>
			<input id="mec-search-settings" type="text" placeholder="<?php esc_html_e( 'Search...', MECSEATTEXTDOMAIN ); ?>">
		</div>
		<a id="" class="dpr-btn dpr-save-btn"><?php _e( 'Save Changes', MECSEATTEXTDOMAIN ); ?></a>
	</div>

	<div class="wns-be-sidebar">
		<?php $this->main->get_sidebar_menu( 'seat' ); ?>
	</div>

	<div class="wns-be-main">
		<div id="wns-be-notification"></div>
		<div id="wns-be-content">
			<div class="wns-be-group-tab">
				<div class="mec-container">
				<?php if( isset($settings['booking_status']) && '1' == $settings['booking_status'] ): ?>
					<form id="mec_seat_form">
						<div id="seat_option" class="mec-options-fields <?php echo ($active_menu == 'options' ? 'active' : 'mec-util-hidden'); ?>">
							<h4 class="mec-form-subtitle"><?php _e( 'Seat', MECSEATTEXTDOMAIN ); ?></h4>
							<div class="mec-form-row">
								<label>
									<input type="hidden" name="mec[settings][seat_status]" value="0"/>
									<input onchange="jQuery('#mec_seat_container_toggle').toggle();" value="1" type="checkbox" name="mec[settings][seat_status]" <?php if ( $seat_status ) {
										echo 'checked="checked"';
									} ?> /> <?php _e( 'Enable Seat module', MECSEATTEXTDOMAIN ); ?>
									<p><?php esc_attr_e("Enable the module and reload the page for additional settings to become available", MECSEATTEXTDOMAIN); ?></p>
								</label>
							</div>
							<div id="mec_seat_container_toggle" class="<?php if ( !$seat_status ) {
								echo 'mec-util-hidden';
							} ?>">
								<?php if( mec_seat_is_enabled() ): ?>
									<div id="seats">
										<div class="mec-form-row">
											<label class="mec-col-4" for="mec_seat_seat_pending_time"><?php esc_html_e('Seat Pending Time', MECSEATTEXTDOMAIN); ?></label>
											<input class="mec-col-4" type="number" name="mec[settings][seat_pending_time]" id="mec_seat_pending_time" value="<?php echo esc_attr($seat_pending_time); ?>" placeholder="<?php esc_html_e('Duration', MECSEATTEXTDOMAIN); ?>"/>
											<span class="mec-tooltip">
												<div class="box top">
													<h5 class="title"><?php esc_html_e('Enable Seat skip', MECSEATTEXTDOMAIN ); ?></h5>
													<div class="content"><p><?php esc_attr_e("Set a duration in seconds for the seat to be reserved during the booking process. (Zero disables the feature)", MECSEATTEXTDOMAIN ); ?></p></div>
												</div>
												<i title="" class="dashicons-before dashicons-editor-help"></i>
											</span>
										</div>

										<div class="mec-form-row">
											<label class="mec-col-4" for="mec_seat_display_seat_id"><?php esc_html_e('Seat ID', MECSEATTEXTDOMAIN); ?></label>
											<select class="mec-col-4" type="number" name="mec[settings][display_seat_id]" id="mec_display_seat_id">
												<option value="seat_number" <?php selected( $display_seat_id, 'seat_number' ); ?>><?php esc_html_e( 'Seat Number', MECSEATTEXTDOMAIN ); ?></option>
												<option value="row_number" <?php selected( $display_seat_id, 'row_number' ); ?>><?php esc_html_e( 'Row ID and Row Number', MECSEATTEXTDOMAIN ); ?></option>
											</select>
										</div>

										<h5 class="title"><?php esc_html_e( 'Seats Options', MECSEATTEXTDOMAIN ); ?></h5>
										<div class="mec-form-row">
											<label>
												<input type="hidden" name="mec[settings][seat_skip_status]" value="0"/>
												<input value="1" type="checkbox" name="mec[settings][seat_skip_status]" <?php if ( $seat_skip_status ) {
													echo 'checked="checked"';
												} ?> /> <?php esc_html_e( 'Enable Seat skip', MECSEATTEXTDOMAIN ); ?>
											</label>
											<span class="mec-tooltip">
												<div class="box right">
													<h5 class="title"><?php esc_html_e('Enable Seat skip', MECSEATTEXTDOMAIN ); ?></h5>
													<div class="content"><p><?php esc_attr_e("Using this option, users can register their booking without selecting a seat.", MECSEATTEXTDOMAIN ); ?></p></div>
												</div>
												<i title="" class="dashicons-before dashicons-editor-help"></i>
											</span>
										</div>
										<?php SeatLayoutBuilder::getInstance()->output( 'global' ); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>

						<?php if ( $seat_status ): ?>
							<div id="seat_shortcodes" class="mec-options-fields <?php echo ($active_menu == 'seat_shortcodes' ? 'active' : 'mec-util-hidden'); ?>">
								<h4 class="mec-form-subtitle"><?php _e('Shortcode Guideline', MECSEATTEXTDOMAIN); ?></h4>
								<div class="mec-form-row">
									<strong><?php _e('Event Seats Plan',MECSEATTEXTDOMAIN); ?></strong>
									<div class="mec-box-option">
										<p class="description">[mec-seats event_id="{EventID}" start_occurrence="{DateTime}" limit="{Number}"]</p>
									</div>
								</div>
							</div>
							<div id="seat_import_export" class="mec-options-fields <?php echo ($active_menu == 'seat_import_export' ? 'active' : 'mec-util-hidden'); ?>">
								<?php SeatLayoutBuilder::getInstance()->import_export_html( 'global' ); ?>
							</div>
						<?php endif; ?>

						<div class="mec-options-fields">
							<?php wp_nonce_field( 'mec_options_form' ); ?>
							<button style="display: none;" id="mec_seat_form_button" class="button button-primary mec-button-primary" type="submit"><?php _e( 'Save Changes', MECSEATTEXTDOMAIN ); ?></button>
						</div>
					</form>
					<?php else: ?>
						<div class="mec-error"><?php esc_html_e( 'Booking module must be active.', MECSEATTEXTDOMAIN ) ?>  <a href="https://webnus.net/dox/modern-events-calendar/booking/" target="_blank"> <?php esc_html_e( 'How to set booking module', MECSEATTEXTDOMAIN ) ?></a></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>

	<div id="wns-be-footer">
		<a id="" class="dpr-btn dpr-save-btn"><?php _e( 'Save Changes', MECSEATTEXTDOMAIN ); ?></a>
	</div>

</div>
<script>
	jQuery(document).ready(function () {
		jQuery(".dpr-save-btn").on('click', function (event) {
			event.preventDefault();
			jQuery("#mec_seat_form_button").trigger('click');
		});
	});

	jQuery('#mec_gateways_form_container .mec-required').on('change', function () {
		var val = jQuery(this).val();
		if (val) {
			// Remove Focus Style
			jQuery(this).removeClass('mec-mandatory');
		}
	});

	jQuery("#mec_seat_form").on('submit', function (event) {
		event.preventDefault();

		window.onbeforeunload = null;

		var validated = true;
		var first_field;

		jQuery('#mec_gateways_form_container').find('.mec-required').each(function () {
			// Remove Focus Style
			jQuery(this).removeClass('mec-mandatory');

			var val = jQuery(this).val();
			if (jQuery(this).is(':visible') && !val) {
				// Add Focus Style
				jQuery(this).addClass('mec-mandatory');

				validated = false;
				if (!first_field) first_field = this;
			}
		});

		if (!validated && first_field) {
			jQuery(first_field).focus();
			jQuery('html, body').animate(
					{
						scrollTop: (jQuery(first_field).offset().top - 200)
					}, 500);

			return false;
		}

		// Add loading Class to the button
		jQuery(".dpr-save-btn").addClass('loading').text("<?php echo esc_js( esc_attr__( 'Saved', MECSEATTEXTDOMAIN ) ); ?>");
		jQuery('<div class="wns-saved-settings"><?php echo esc_js( esc_attr__( 'Settings Saved!', MECSEATTEXTDOMAIN ) ); ?></div>').insertBefore('#wns-be-content');

		if (jQuery(".mec-purchase-verify").text() != '<?php echo esc_js( esc_attr__( 'Verified', MECSEATTEXTDOMAIN ) ); ?>') {
			jQuery(".mec-purchase-verify").text("<?php echo esc_js( esc_attr__( 'Checking ...', MECSEATTEXTDOMAIN ) ); ?>");
		}

		var settings = jQuery("#mec_seat_form").serialize();
		jQuery.ajax(
				{
					type: "POST",
					url: ajaxurl,
					data: "action=mec_save_settings&" + settings,
					beforeSend: function () {
						jQuery('.wns-be-main').append('<div class="mec-loarder-wrap mec-settings-loader"><div class="mec-loarder"><div></div><div></div><div></div></div></div>');
					},
					success: function (data) {
						// Remove the loading Class to the button
						setTimeout(function () {
							jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js( esc_attr__( 'Save Changes', MECSEATTEXTDOMAIN ) ); ?>");
							jQuery('.wns-saved-settings').remove();
							jQuery('.mec-loarder-wrap').remove();
							if (jQuery(".mec-purchase-verify").text() != '<?php echo esc_js( esc_attr__( 'Verified', MECSEATTEXTDOMAIN ) ); ?>') {
								jQuery(".mec-purchase-verify").text("<?php echo esc_js( esc_attr__( 'Please Refresh Page', MECSEATTEXTDOMAIN ) ); ?>");
							}
						}, 1000);
					},
					error: function (jqXHR, textStatus, errorThrown) {
						// Remove the loading Class to the button
						setTimeout(function () {
							jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js( esc_attr__( 'Save Changes', MECSEATTEXTDOMAIN ) ); ?>");
							jQuery('.wns-saved-settings').remove();
							jQuery('.mec-loarder-wrap').remove();
						}, 1000);
					}
				});
	});

	jQuery(document).ready(function($){

		if($('li.active .subsection li.active').length == 0 ){

			$('li.active .subsection li:first-child a').trigger('click');
		}else{

			$('li.active .subsection li.active a').trigger('click');
		}
	});
</script>