<?php

namespace MEC_Webex_Integration\Core\addEventToWebex;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class addEventToWebex
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Webex_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @return  object
     * @since   1.0.0
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_ajax_mec_events_to_webex', array($This, 'mec_events_to_webex'));
        add_action('wp_ajax_mec_webex_export_events', array($This, 'mec_webex_export_events'));
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {

    }

    public function mec_events_to_webex()
    {

        $exclude_expired = isset($_POST['exclude_expired']) && 'yes' === $_POST['exclude_expired'] ? true : false;

        $events = get_posts(array(
            'post_type' => 'mec-events',
            'numberposts' => -1,
            'post_status' => 'publish',
            'meta_query' => array(
                // meta query takes an array of arrays, watch out for this!
                'relation' => 'AND',
                array(
                    'key' => 'mec_webex_event',
                    'value' => array('webinar', 'meeting'),
                    'compare' => 'IN'
                ),
                array(
                    'key' => 'mec_event_import_from_webex',
                    'compare' => 'NOT EXISTS'
                )
            )
        ));

        $message = '<ul>';
        foreach ($events as $event) {
            $event_id = $event->ID;
            $event_detail = (new \MEC\Events\Event($event_id))->get_detail();
            $is_expired = \MEC\Base::get_main()->is_expired($event_detail);
            if ($exclude_expired && $is_expired) {
                continue;
            }
            $expired = $is_expired ? '-<b style="color: red">Expired</b>' : '';

            $message .= '<li><input type="checkbox" name="mec-events-to-webex[]"  id="webex-events-to-webex-' . $event->ID . '" name="webex-events-to-webex-' . $event->ID . '" value="' . $event->ID . '" checked="checked" /><label style="margin-left:10px;" for="webex-events-to-webex-' . $event->ID . '">' . $event->post_title . ' <strong>(' . get_post_meta($event->ID, 'mec_webex_event', true) . ')</strong></label>' . $expired . '</li>';
        }

        $message .= '</ul><input id="mec_webex_checkall" type="button" value="Deselect All"><div id="mec_webex_export_events" onclick="mec_webex_do_export_events(this)" class="button mec-webex-export-events button-primary mec-button-primary" type="submit">' . esc_html__('Export To Webex', 'mec-wi') . '</div><p id="mec-webex-importing-desc"></p>
        <script>
        function mec_webex_do_export_events(e) {
            jQuery("#mec_webex_export_events").attr("disabled", true).addClass("loading").text("' . esc_attr__('Exporting ...', "mec-wi") . '");
            var events = jQuery("#mec_webex_request_get_wm_result").serialize();
            jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_export_events&"+events,
                dataType: "json",
                success: function(data)
                {
                    // Remove the loading Class to the button
                    jQuery("#mec_webex_export_events").removeAttr("disabled").removeClass("loading").text("' . esc_attr__('Export To Webex', "mec-wi") . '");
                    console.log(data)
                    if ( data.success == "1") {
                        jQuery("#mec-webex-importing-desc").html(data.message);
                    } 
                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                    // Remove the loading Class to the button
                    console.log("error!")
                }
            });
        }
        </script>';

        echo json_encode(array('success' => 1, 'message' => $message));
        exit;

    }

    public function mec_webex_export_events()
    {
        $mec_webex_events = $_POST['mec-events-to-webex'] ?? array();
        $access_token = esc_html(get_option('mec_webex_access_token'));

        $main = new \MEC_main();
        $base = \MEC::getInstance('app.libraries.render');

        // MEC Render Library
        $render = $base->getRender();

        // Timezone Options
        $timezone = $main->get_timezone();
        $gmt_offset = $main->get_gmt_offset();

        $result = array();
        $i = 0;
        foreach ($mec_webex_events as $mec_webex_event) {

            $mec_event_id = $mec_webex_event;
            $event = $render->data($mec_event_id);
            $password = (!empty(get_post_meta($mec_event_id, 'mec_webex_password', true))) ? get_post_meta($mec_event_id, 'mec_webex_password', true) : '';
            $siteUrl = (!empty(get_post_meta($mec_event_id, 'mec_webex_link_url', true))) ? get_post_meta($mec_event_id, 'mec_webex_link_url', true) : '';
            $dates = $render->dates($mec_event_id, $event);
            $date = $dates[0] ?? array();
            $event_type = get_post_meta($mec_event_id, 'mec_webex_event', true);

            $recurrence = '';
            $week_day_mapping = array('1' => 'MO', '2' => 'TU', '3' => 'WE', '4' => 'TH', '5' => 'FR', '6' => 'SA', '7' => 'SU');

            $repeat_type = $event->meta['mec_repeat_type'];
            $mec_repeat_end = $event->meta['mec_repeat_end'];
            $mec_repeat_end_at_occurrences = $event->meta['mec_repeat_end_at_occurrences'];
            $mec_repeat_end_at_date = $event->meta['mec_repeat_end_at_date'];

            if ($repeat_type == 'daily') {
                $recurrence = "FREQ=DAILY;INTERVAL=" . $event->mec->rinterval;
            } elseif ($repeat_type == 'weekly') {
                $ex = date('D', $date['start']['timestamp']);
                $byday_mapping = array('MON' => 'MO', 'TUE' => 'TU', 'WED' => 'WE', 'THU' => 'TH', 'FRI' => 'FR', 'SAT' => 'SA', 'SUN' => 'SU');
                $recurrence = "FREQ=WEEKLY;BYDAY=". $byday_mapping[strtoupper($ex)].";INTERVAL=".($event->mec->rinterval / 7);
            } elseif ($repeat_type == 'monthly') {
                $recurrence = "FREQ=MONTHLY;INTERVAL=".$event->mec->rinterval.";BYMONTHDAY=".date('d', $date['start']['timestamp']);
            } elseif ($repeat_type == 'yearly') {
                $recurrence = "FREQ=YEARLY;BYMONTH=".date('m', $date['start']['timestamp']).";BYMONTHDAY=".date('d', $date['start']['timestamp']);
            } elseif ($repeat_type == 'weekday') {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach ($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday] . ',';
                $recurrence = "FREQ=WEEKLY;BYDAY=" . trim($byday, ', ');
            } elseif ($repeat_type == 'weekend') {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach ($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday] . ',';
                $recurrence = "FREQ=WEEKLY;BYDAY=" . trim($byday, ', ');
            } elseif ($repeat_type == 'certain_weekdays') {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach ($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday] . ',';
                $recurrence = "FREQ=WEEKLY;BYDAY=" . trim($byday, ', ');
            } elseif ($repeat_type == 'advanced') {
                $advanced_days = is_array($event->meta['mec_advanced_days']) ? $event->meta['mec_advanced_days'] : array();
                $first_rule = $advanced_days[0] ?? NULL;
                $ex = explode('.', $first_rule);
                $byday_mapping = array('MON' => 'MO', 'TUE' => 'TU', 'WED' => 'WE', 'THU' => 'TH', 'FRI' => 'FR', 'SAT' => 'SA', 'SUN' => 'SU');
                $recurrence = "FREQ=WEEKLY;BYDAY=" . $byday_mapping[strtoupper($ex[0])];
            }

            if($mec_repeat_end=='occurrences'){
                $recurrence.=";COUNT=".($mec_repeat_end_at_occurrences+1);
            } else if($mec_repeat_end=='date'){
                $recurrence.=";UNTIL=".str_replace('-','',$mec_repeat_end_at_date);
            }

            $start = date('Y-m-d\TH:i:s', $date['start']['timestamp']) . $gmt_offset;

            $end = date('Y-m-d\TH:i:s', $date['end']['timestamp']) . $gmt_offset;


            $event_data = array
            (
                "title" => $event->title,
                "agenda" => strip_tags(strip_shortcodes($event->content)),
                "password" => $password,
                "start" => $start,
                "end" => $end,
                "timezone" => $timezone,
                "recurrence" => $recurrence,
                "scheduledType" => $event_type,
                "siteUrl" => $siteUrl,
                "sendEmail" => true
            );


            $response = wp_remote_post('https://webexapis.com/v1/meetings', array(
                    'method' => 'POST',
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $access_token,
                        'Content-Type' => 'application/json',
                    ),
                    'body' => json_encode($event_data, JSON_FORCE_OBJECT),
                    'cookies' => array(),
                    'timeout' => '120',
                )
            );
            $body = json_decode(
                wp_remote_retrieve_body($response)
            );
            if (isset($body->id)) {
                $result[$i][$event->title] = $body->id;
                
                update_post_meta($mec_event_id, 'mec_webex_link_url', $body->webLink);
                update_post_meta($mec_event_id, 'mec_webex_join_url', $body->webLink);
            } else {
                $result[$i][$event->title] = 'Error!';
            }

            $i++;
        }

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $myDateTime = new \DateTime("now", $gmtTimezone);
        $nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));

        $expire_time_flag = ($nowTime > (int)get_option('mec_webex_token_expire_in')) ? 1 : 0;
        $message = ($expire_time_flag == 1) ? esc_html__('Access Token is expired. Please click on "Generate Access Token" and import again.', 'mec-wi') : esc_html__('All items are exported.', 'mec-wi');

        echo json_encode(array('success' => 1, 'message' => $message, 'result' => $result, 'response' => $response));
        die();
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public
    function init()
    {
        if (!class_exists('\MEC_Webex_Integration\Autoloader')) {
            return;
        }
    }
} //MecWebex
