<?php

namespace MEC_Webex_Integration\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Webex_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECWIDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    {
        add_action('admin_init', function () {
            \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\checkLicense\WebexIntegrationAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_Webex_Integration\Autoloader')) {
            return;
        }

        \MEC_Webex_Integration\Autoloader::addClasses(
            [
                'MEC_Webex_Integration\\Core\\base\\WebexBase' => self::$dir . '/base/base.php',
                'MEC_Webex_Integration\\Core\\singleOptions\\SingleOptions' => self::$dir . '/singleOptions/singleOptions.php',
                'MEC_Webex_Integration\\Core\\importMeetings\\ImportMeetings' => self::$dir . '/importMeetings/importMeetings.php',
                'MEC_Webex_Integration\\Core\\importWebinars\\ImportWebinars' => self::$dir . '/importWebinars/importWebinars.php',
                'MEC_Webex_Integration\\Core\\addEventToWebex\\addEventToWebex' => self::$dir . '/addEventToWebex/addEventToWebex.php',
                'MEC_Webex_Integration\\Core\\checkLicense\\WebexIntegrationAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\base\WebexBase');
        \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\singleOptions\SingleOptions');
        \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\importMeetings\ImportMeetings');
        \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\importWebinars\ImportWebinars');
        \MEC_Webex_Integration\Autoloader::load('MEC_Webex_Integration\Core\addEventToWebex\addEventToWebex');
    }
} //Loader

Loader::instance();
