<?php

namespace MEC_Webex_Integration\Core\base;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class WebexBase
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Webex_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @return  object
     * @since   1.0.0
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('admin_menu', array($This, 'menus'), 20);
        add_action('wp_ajax_mec_webex_authorization_form', array($This, 'mec_webex_authorization_form'));
        add_action('wp_ajax_mec_webex_generate_access_token', array($This, 'mec_webex_generate_access_token'));
        add_action('wp_ajax_mec_webex_reset_token', array($This, 'mec_webex_reset_token'));
        add_action('admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue' ));
    }
    public static function admin_enqueue() {
        wp_register_style( 'mec-webex-backend', MECWIDASSETS.'/backend.css', array(), MECWIVERSION );
    }
    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {

    }

    public function menus()
    {
        add_submenu_page('mec-intro', __('MEC Webex Integration', 'mec'), __('Webex Integration', 'mec'), 'manage_options', 'MEC-webex', array($this, 'render_page'));
    }

    public function render_page()
    {
        ob_start();
        include(plugin_dir_path(__FILE__) . 'webex-page.php');
        echo $output = ob_get_clean();
    }

    public function mec_webex_authorization_form()
    {
        $wi = $_POST['wi'] ?? array();

        $client_id = $wi['client_id'] ?? NULL;
        $client_secret = $wi['client_secret'] ?? NULL;
        $authorization_code = $wi['authorization_code'] ?? NULL;

        update_option('mec_webex_client_id', $client_id);
        update_option('mec_webex_client_secret', $client_secret);
        update_option('mec_webex_authorization_code', $authorization_code);

        echo json_encode(array('success' => 1, 'message' => 'All settings saved.'));
        exit;

    }

    public function mec_webex_generate_access_token()
    {

        $client_id = get_option('mec_webex_client_id');
        $client_secret = get_option('mec_webex_client_secret');
        $authorization_code = get_option('mec_webex_authorization_code');
        $refresh_access_token = get_option('mec_webex_refresh_access_token');

        if (!isset($client_id) || empty($client_id)) {
            echo json_encode(array('success' => 0, 'message' => 'Please fill Client ID field.'));
            exit;
        }
        if (!isset($client_secret) || empty($client_secret)) {
            echo json_encode(array('success' => 0, 'message' => 'Please fill Client Secret field.'));
            exit;
        }
        if (!isset($authorization_code) || empty($authorization_code)) {
            echo json_encode(array('success' => 0, 'message' => 'Please click on "Authenticate" button first.'));
            exit;
        }

        $redirect_url = get_admin_url('', 'admin.php?page=MEC-webex');

        $url = 'https://webexapis.com/v1/access_token';
        $body = array();
        if (isset($refresh_access_token) && !empty($refresh_access_token)) {
            $body = array(
                'grant_type' => 'refresh_token',
                'client_id' => $client_id,
                'client_secret' => $client_secret,
                'refresh_token' => $refresh_access_token,
            );
        } else {
            $body = array(
                'grant_type' => 'authorization_code',
                'client_id' => $client_id,
                'client_secret' => $client_secret,
                'code' => $authorization_code,
                'redirect_uri' => $redirect_url,
            );
        }

        $response = wp_remote_post($url, array(
                'method' => 'POST',
                'headers' => array(
                    'Content-Type' => 'application/x-www-form-urlencoded'
                ),
                'body' => $body,
                'cookies' => array(),
                'timeout' => '120',
                'redirection' => '10',
                'user-agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36',
            )
        );

        $body = json_decode(wp_remote_retrieve_body($response));

        $message = '';
        if (isset($body->access_token) && !empty($body->access_token)) {
            update_option('mec_webex_access_token', $body->access_token);
        }
        if (isset($body->refresh_token) && !empty($body->refresh_token)) {
            update_option('mec_webex_refresh_access_token', $body->refresh_token);
        }
        if (isset($body->expires_in) && !empty($body->expires_in)) {
            $tz = wp_timezone_string();
            $timestamp = time();
            $datetime_format = get_option('date_format') . ' ' . get_option('time_format');
            $datetime_format = !empty($datetime_format) ? $datetime_format : 'Y-m-d H:i';
            // $date = date($datetime_format);
            $dt = new \DateTime('now', new \DateTimeZone($tz)); //first argument "must" be a string
            $dt->modify('+' . $body->expires_in . ' second');
            $message = esc_html__('Access Token is generated and will expire at', 'mec-wi') . ' ' . $dt->format($datetime_format);
            update_option('mec_webex_token_expire_in', strtotime($dt->format($datetime_format)));
        }

        if (isset($body->error)) {

            echo json_encode(array('success' => 0, 'message' => $body->error));
        } else {

            echo json_encode(array('success' => 1, 'message' => $message));
        }
        exit;

    }

    public function mec_webex_reset_token()
    {

        $delete_access_token = delete_option('mec_webex_access_token');
        $delete_refresh_access_token = delete_option('mec_webex_refresh_access_token');

        if (empty(get_option('mec_webex_access_token')) || empty(get_option('mec_webex_refresh_access_token'))) {
            $message_url = 'Your OAuth data has been deleted from the database. You need to click on "Authenticate" button again.';
            echo json_encode(array('success' => 1, 'message' => $message_url));
            exit;
        } else {
            echo json_encode(array('success' => 1, 'message' => 'We couldn\'t delete any data in the database.'));
        }

    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Webex_Integration\Autoloader')) {
            return;
        }
    }
} //MecWebex
