<?php
wp_enqueue_script('jquery-ui-datepicker');
wp_enqueue_style('mec-webex-backend');

(isset($_GET['code']) && !empty($_GET['code'])) ? update_option('mec_webex_authorization_code', $_GET['code']) : NULL;

$tz = wp_timezone_string();
$gmtTimezone = new \DateTimeZone($tz);
$myDateTime = new \DateTime("now", $gmtTimezone);
$nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));

$client_id = get_option('mec_webex_client_id');
$client_secret = get_option('mec_webex_client_secret');
$authorization_code = get_option('mec_webex_authorization_code');
$token_availablity = get_option('mec_webex_access_token');
$expire_time_flag = ($nowTime > (int)get_option('mec_webex_token_expire_in')) ? 1 : 0;
$expire_time = ((($nowTime > (int)get_option('mec_webex_token_expire_in')) && !empty(get_option('mec_webex_token_expire_in'))) ? esc_html__('Your Access Token is expired. Please click on "Generate Access Token"') : !empty(get_option('mec_webex_token_expire_in'))) ? esc_html__('Access Token is generated and will expire at', 'mec-wi') . ' ' . date(get_option('date_format') . ' ' . get_option('time_format'), get_option('mec_webex_token_expire_in')) : '';

if (isset($expire_time) && !empty($expire_time)) {
    $expire_time_class = ($expire_time_flag == 1) ? 'mec-error' : 'mec-success';
} else {
    $expire_time_class = NULL;
}

$redirect_url = get_admin_url('', 'admin.php?page=MEC-webex');
?>
<div id="mec-webex-wrap" class="about-webex-wrap mec-addons">
    <div class="mec-webex-header">
        <h1 class="mec-addons-title"> <?php echo __('Webex Integration', 'mec-wi'); ?> </h1>
        <span class="w-theme-version"><?php echo __('Version ', 'mec-wi'); ?><?php echo MECWIVERSION; ?></span>
    </div>
    <div class="welcome-content w-clearfix extra">
        <form id="mec_webex_request_authorization_form" action="<?php echo $redirect_url; ?>"
                method="POST">
            <div class="mec-col-12">
                <h4 class="mec-form-subtitle"><?php esc_html_e('Request User Authorization', 'mec-wi'); ?></h4>
                <p style="margin-left:0"
                    class="description"><?php esc_html_e('Please set this URL for Callback URL in Webex OAuth App.', 'mec-wi'); ?>
                    <code><?php echo $redirect_url; ?></code></p>
                <div class="mec-form-row">
                    <label class="mec-col-3"
                            for="mec_webex_client_id"><?php esc_html_e('Client ID', 'mec-wi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_webex_client_id"
                                name="wi[client_id]" value="<?php echo esc_html($client_id); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-3"
                            for="mec_webex_client_secret"><?php esc_html_e('Client Secret', 'mec-wi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_webex_client_secret"
                                name="wi[client_secret]"
                                value="<?php echo esc_html($client_secret); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-3"
                            for="mec_webex_authorization_code"><?php esc_html_e('Authorization Code', 'mec-wi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_webex_authorization_code"
                                name="wi[authorization_code]"
                                value="<?php echo (isset($_GET['code']) && !empty($_GET['code'])) ? esc_html($_GET['code']) : esc_html($authorization_code); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <button id="mec_webex_request_authorization_button"
                            class="button authorization-button button-primary mec-button-primary"
                            type="submit"><?php _e('Authenticate', 'mec-wi'); ?></button>
                    <?php if ((isset($_GET['code']) && !empty($_GET['code'])) || (isset($authorization_code) && !empty($authorization_code))) : ?>
                        <button id="mec_webex_request_generate_access_token"
                                class="button generate-access-token button-primary mec-button-primary"
                                type="submit"><?php _e('Generate Access Token', 'mec-wi'); ?></button>
                        <?php
                        $resetbutton = ($expire_time_class == 'mec-success') ? '' : 'disable';
                        $resetbutton = (isset($token_availablity) && !empty($token_availablity)) ? '' : 'disable';
                        ?>
                        <button id="mec_webex_request_reset_data"
                                class="button reset-token button-primary mec-button-primary <?php echo $resetbutton; ?>"
                                type="submit"><?php _e('Reset', 'mec-wi'); ?></button>
                    <?php endif; ?>
                </div>
                <?php $token_availablity_class = isset($token_availablity) && !empty($token_availablity) ? '' : 'disable'; ?>
                <p id="mec_webex_request_authorization_message"
                    class="<?php echo $expire_time_class . ' ' . $token_availablity_class; ?>"><?php echo $expire_time; ?></p>
                <p id="mec_reset_data_now"
                    class="reset-message disable"><?php _e('Your Webex data have been reset on database.', 'mec-wi'); ?></p>
            </div>
        </form>

        <div class="mec-webex-select-wm <?php echo ($expire_time_flag == 1) ? 'mec-util-hidden' : NULL; ?>">
            <div class="mec-col-12">
                <div class="mec-container">
                    <h4 class="mec-form-subtitle">
                        <?php esc_html_e('Select Webinar/Meetings to import/Export', 'mec-wi'); ?>
                    </h4>
                    <form id="mec_webex_request_get_wm" action="<?php echo $redirect_url; ?>" method="GET">
                        <div class="mec-form-row">
                            <input type="checkbox" id="mec-exclude-expired" name="mec-exclude-expired" value="1"/>
                            <?php esc_html_e('Exclude Expired Events', 'mec-wi') ?>
                        </div>
                        <div id="mec_meta_box_date_form">
                            <div class="mec-form-row">
                                <div class="mec-col-4">
                                    <div class="mec-title" style="margin-bottom: 5px">
                                        <span class="mec-dashicons dashicons dashicons-calendar-alt"></span>
                                        <label for="webex_from_date"><?php esc_html_e('From', 'mec-wi'); ?></label>
                                    </div>
                                    <input type="text" name="webex_from_date" id="webex_from_date"
                                           value="<?php echo date('Y-m-d') ?>"
                                           placeholder="<?php esc_html_e('From', 'mec-wi'); ?>" autocomplete="off"/>
                                </div>
                                <div class="mec-col-4">
                                    <div class="mec-title" style="margin-bottom: 5px">
                                        <span class="mec-dashicons dashicons dashicons-calendar-alt"></span>
                                        <label for="webex_to_date"><?php esc_html_e('To', 'mec-wi'); ?></label>
                                    </div>
                                    <input type="text" name="webex_to_date" id="webex_to_date"
                                           value="<?php echo date('Y-m-d') ?>"
                                           placeholder="<?php esc_html_e('To', 'mec-wi'); ?>" autocomplete="off"/>
                                </div>
                                <div class="mec-col-4">
                                    <div class="mec-title" style="margin-bottom: 5px">
                                        <label for="webex_limit"><?php esc_html_e('Limit', 'mec-wi'); ?></label>
                                    </div>
                                    <input type="number" name="webex_limit" id="webex_limit" value="10"
                                           placeholder="<?php esc_html_e('Limit', 'mec-wi'); ?>" autocomplete="off"/>
                                </div>
                            </div>
                        </div>
                        <button id="mec_webex_get_meetings" style="margin: 0 15px 0 0;"
                                class="button mec-webex-get-meetings button-primary mec-button-primary"
                                type="submit"><?php esc_html_e('Get Meetings', 'mec-wi'); ?></button>
                        <button id="mec_webex_get_webinars" style="margin: 0 15px 0 0;"
                                class="button mec-webex-get-webinars button-primary mec-button-primary"
                                type="submit"><?php esc_html_e('Get Webinars', 'mec-wi'); ?></button>
                        <button id="mec_events_to_webex" style="margin: 0 15px 0 0;"
                                class="button mec-events-to-webex button-primary mec-button-primary"
                                type="submit"><?php esc_html_e('Export Events to Webex', 'mec-wi'); ?></button>
                    </form>

                    <form id="mec_webex_request_get_wm_result" action="<?php echo $redirect_url; ?>" method="GET">
                        <div id="mec_webex_request_get_wm_result_wrap"></div>
                        <div id="mec_webex_imported_message"></div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
    #wpwrap .mec-button-primary.loading:before {
        display: none;
    }

    .reset-token,
    .generate-access-token {
        margin-left: 15px !important;
    }

    #wpwrap .mec-button-primary.green-done {
        background: #12bb2e;
        background: linear-gradient(95deg, #6ee882 0, #1ed63d 50%, #12bb2e 100%);
    }

    #mec_webex_request_authorization_message.disable,
    #wpwrap .mec-button-primary.reset-token.disable,
    .reset-message.disable {
        display: none;
    }

    /* Webex Event Import Select All & Deselect All */
    #mec_webex_checkall {
        background: #fff;
        border: 1px solid #282828;
        border-radius: 60px;
        padding: 6px 32px 8px;
        margin: 30px 0 0;
        cursor: pointer;
        display: block;
        transition: all 0.3s ease;
        -webkit-transition: all 0.3s ease;
        -moz-transition: all 0.3s ease;
        -ms-transition: all 0.3s ease;
        -o-transition: all 0.3s ease;
    }

    #mec_webex_checkall:focus {
        box-shadow: inset;
        outline: none;
    }

    #mec_webex_checkall:hover {
        background: #282828;
        color: #fff;
    }
</style>

<script type="text/javascript">
    let datepicker_format = 'yy-mm-dd';
    jQuery(document).ready(function ($) {
        jQuery('#webex_from_date').datepicker(
            {
                changeYear: true,
                changeMonth: true,
                dateFormat: datepicker_format,
                gotoCurrent: true,
                yearRange: 'c-3:c+5',
            });

        jQuery('#webex_to_date').datepicker(
            {
                changeYear: true,
                changeMonth: true,
                dateFormat: datepicker_format,
                gotoCurrent: true,
                yearRange: 'c-3:c+5',
            });
        $(document).on("click", "#mec_webex_checkall", function () {
            if ($(this).val() == "Check All") {
                $("#mec_webex_request_get_wm_result_wrap input").prop("checked", true);
                $(this).val("Uncheck All");
            } else {
                $("#mec_webex_request_get_wm_result_wrap input").prop("checked", false);
                $(this).val("Check All");
            }
        });
    });

    jQuery("#mec_webex_request_authorization_form").find('.authorization-button').on('click', function (e) {
        e.preventDefault();

        // Message
        var $message = jQuery('#mec_webex_request_authorization_message');

        // Hide the Message
        $message.hide();
        $message.removeClass('mec-error');
        $message.removeClass('mec-success');

        $client_id = jQuery('#mec_webex_client_id').val();
        $client_secret = jQuery('#mec_webex_client_secret').val();
        $scope = 'spark%3Akms%20meeting%3Aschedules_read%20meeting%3Aschedules_write';

        if ($client_id == "") {
            $message.show().addClass('mec-error').html("<?php esc_html_e('Please fill Client ID field!', 'mec-wi'); ?>");
            return;
        }

        if ($client_secret == "") {
            $message.show().addClass('mec-error').html("<?php esc_html_e('Please fill Client Secret field!', 'mec-wi'); ?>");
            return;
        }

        jQuery(".authorization-button").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-wi'); ?>");

        var options = jQuery("#mec_webex_request_authorization_form").serialize();
        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_authorization_form&" + options,
                dataType: "json",
                success: function (data) {
                    // Remove the loading Class to the button
                    jQuery(".authorization-button").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Authenticate', 'mec-wi'); ?>");

                    if (data.success == '1') window.location.replace("https://webexapis.com/v1/authorize?response_type=code&client_id=" + $client_id + "&scope=" + $scope + "&redirect_uri=<?php echo $redirect_url; ?>");
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('error!')
                }
            });

    });

    jQuery("#mec_webex_request_authorization_form").find('.generate-access-token').on('click', function (e) {
        e.preventDefault();

        var $message = jQuery('#mec_webex_request_authorization_message');

        // Hide the Message
        $message.hide();
        $message.removeClass('mec-error');
        $message.removeClass('mec-success');

        jQuery(".generate-access-token").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-wi'); ?>");
        jQuery(".mec-webex-select-wm").addClass('mec-util-hidden');

        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_generate_access_token",
                dataType: "json",
                success: function (data) {
                    // Remove the loading Class to the button
                    jQuery(".generate-access-token").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Generate Access Token', 'mec-wi'); ?>");

                    if (data.success == '1') {
                        $message.show().addClass('mec-success').html(data.message);
                        jQuery(".mec-webex-select-wm").removeClass('mec-util-hidden');
                    } else if (data.success == '0') {
                        $message.show().addClass('mec-error').html(data.message);
                    }
                    jQuery("#mec_webex_request_reset_data").removeClass('disable');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('error!')
                }
            });

    });

    // RESET Button:
    jQuery("#mec_webex_request_authorization_form").find('.reset-token').on('click', function (e) {
        e.preventDefault();

        var $message = jQuery('#mec_reset_data_now');

        // Hide the Message
        $message.hide();
        $message.removeClass('disable');

        jQuery(".reset-token").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Processing ...', 'mec-wi'); ?>");
        jQuery(".mec-webex-select-wm").addClass('mec-util-hidden');

        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_reset_token",
                dataType: "json",
                success: function (data) {
                    console.log('Everything Done.')
                    // Remove the loading Class to the button
                    jQuery(".reset-token").removeAttr("disabled").removeClass('loading').addClass('green-done').text("<?php esc_attr_e('Done.', 'mec-wi'); ?>");

                    if (data.success == '1') {
                        $message.show().addClass('mec-success').html(data.message);
                        jQuery(".mec-webex-select-wm").removeClass('mec-util-hidden');
                    } else if (data.success == '0') {
                        $message.show().addClass('mec-error').html(data.message);
                    }

                    jQuery("#mec_webex_request_authorization_message, #mec_webex_request_generate_access_token").hide(900);

                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('Oh, Error!')
                }
            });

    });

    // Get Meetings
    jQuery("#mec_webex_request_get_wm").find('#mec_webex_get_meetings').on('click', function (e) {
        e.preventDefault();

        var $message = jQuery('#mec_webex_imported_message');
        var $result = jQuery('#mec_webex_request_get_wm_result_wrap');

        // Hide the Message
        $message.hide();
        $message.removeClass('mec-error');
        $message.removeClass('mec-success');

        jQuery("#mec_webex_get_meetings").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-wi'); ?>");

        var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no';
        var from_date = jQuery('#webex_from_date').val();
        var to_date = jQuery('#webex_to_date').val();
        var limit = jQuery('#webex_limit').val();

        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_get_meetings&exclude_expired=" + exclude_expired + "&from_date=" + from_date + "&to_date=" + to_date + "&limit=" + limit,
                dataType: "json",
                success: function (data) {
                    // Remove the loading Class to the button
                    jQuery("#mec_webex_get_meetings").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Meetings', 'mec-wi'); ?>");

                    if (data.success == '1') {
                        $result.html(data.message);
                    } else if (data.success == '0') {
                        $message.show().addClass('mec-error').html(data.message);
                    }

                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('error!');
                    $message.show().addClass('mec-error').html('error!');
                    jQuery("#mec_webex_get_meetings").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Meetings', 'mec-wi'); ?>");
                }
            });

    });

    //Get Webinars
    jQuery("#mec_webex_request_get_wm").find('#mec_webex_get_webinars').on('click', function (e) {
        e.preventDefault();

        var $message = jQuery('#mec_webex_imported_message');
        var $result = jQuery('#mec_webex_request_get_wm_result_wrap');

        // Hide the Message
        $message.hide();
        $message.removeClass('mec-error');
        $message.removeClass('mec-success');

        jQuery("#mec_webex_get_webinars").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-wi'); ?>");

        var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no';
        var from_date = jQuery('#webex_from_date').val();
        var to_date = jQuery('#webex_to_date').val();
        var limit = jQuery('#webex_limit').val();

        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_webex_get_webinars&exclude_expired=" + exclude_expired + "&from_date=" + from_date + "&to_date=" + to_date + "&limit=" + limit,
                dataType: "json",
                success: function (data) {
                    // Remove the loading Class to the button
                    jQuery("#mec_webex_get_webinars").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Webinars', 'mec-wi'); ?>");

                    if (data.success == '1') {
                        $result.html(data.message);
                    } else if (data.success == '0') {
                        $message.show().addClass('mec-error').html(data.message);
                    }

                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('error!');
                    $message.show().addClass('mec-error').html('error!');
                    jQuery("#mec_webex_get_webinars").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Webinars', 'mec-wi'); ?>");
                }
            });

    });

    // Export Events
    jQuery("#mec_webex_request_get_wm").find('#mec_events_to_webex').on('click', function (e) {
        e.preventDefault();

        var $message = jQuery('#mec_webex_imported_message');
        var $result = jQuery('#mec_webex_request_get_wm_result_wrap');

        // Hide the Message
        $message.hide();
        $message.removeClass('mec-error');
        $message.removeClass('mec-success');

        var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no';
        jQuery("#mec_events_to_webex").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-wi'); ?>");

        jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_events_to_webex&exclude_expired=" + exclude_expired,
                dataType: "json",
                success: function (data) {
                    // Remove the loading Class to the button
                    jQuery("#mec_events_to_webex").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Export Events to Webex', 'mec-wi'); ?>");

                    if (data.success == '1') {
                        $result.html(data.message);
                    } else if (data.success == '0') {
                        $message.show().addClass('mec-error').html(data.message);
                    }

                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // Remove the loading Class to the button
                    console.log('error!')
                }
            });

    });

</script>