<?php

namespace MEC_Webex_Integration\Core\importMeetings;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class ImportMeetings
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Webex_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @return  object
     * @since   1.0.0
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_ajax_mec_webex_get_meetings', array($This, 'mec_webex_get_meetings'));
        add_action('wp_ajax_mec_webex_import_meetings', array($This, 'mec_webex_import_meetings'));
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {

    }

    public function mec_webex_get_meetings()
    {

        $exclude_expired = isset($_POST['exclude_expired']) && 'yes' === $_POST['exclude_expired'] ? "&state=active&meetingType=meetingSeries" : '';
        $from_date = $_POST['from_date'] ?? '';
        $to_date = $_POST['to_date'] ?? '';
        $limit = $_POST['limit'] ?? 10;
        $access_token = esc_html(get_option('mec_webex_access_token'));

        $url = 'https://webexapis.com/v1/meetings?scheduledType=meeting&from=' . $from_date . '&to=' . $to_date . '&max=' . $limit . $exclude_expired.'&timezone='.get_option('timezone_string');
        $response = wp_remote_post($url, array(
                'method' => 'GET',
                'headers' => array(
                    'Authorization' => 'Bearer ' . $access_token,
                ),
                'body' => array(),
                'cookies' => array(),
                'timeout' => '120',
                'redirection' => '10',
            )
        );

        if (is_wp_error($response)) {

            $error_message = $response->get_error_message();
            $message = "Something went wrong: $error_message";
            echo json_encode(array('success' => 0, 'message' => $message));

        } else {

            $body = json_decode(
                wp_remote_retrieve_body($response)
            );

            $message = '';
            if ($body->items != null) {
                $message .= '<ul>';
                $tz = wp_timezone_string();
                $gmtTimezone = new \DateTimeZone($tz);

                foreach ($body->items as $meeting) {
                    $date_startt = new \DateTime($meeting->start, $gmtTimezone);
                    $date_startt->setTimezone(new \DateTimeZone($tz));
                    $start_datee = $date_startt->format('F j, Y g:i A');
                    $expired = '';
                    if ($meeting->state == "expired") {
                        $expired = '-<b style="color: red">Expired</b>';
                    }
                    $message .= '<li><input type="checkbox" name="mec-webex-meetings[]"  id="webex-meeting-' . $meeting->id . '" name="webex-meeting-' . $meeting->id . '" value="' . $meeting->id . '" checked="checked" /><label style="margin-left:10px;" for="webex-meeting-' . $meeting->id . '">' . $meeting->title . ' (Start Time: ' . $start_datee . ')' . '-' . $expired . '</label></li>';
                }

                $message .= '</ul><input id="mec_webex_checkall" type="button" value="Deselect All"><div id="mec_webex_import_meetings" onclick="mec_webex_do_import_meetings(this)" class="button mec-webex-import-meetings button-primary mec-button-primary" type="submit">' . esc_html__('Import meetings', 'mec-wi') . '</div><p id="mec-webex-importing-desc"></p>
            <script>
            function mec_webex_do_import_meetings(e) {
                jQuery("#mec_webex_import_meetings").attr("disabled", true).addClass("loading").text("' . esc_attr__('Importing ...', "mec-wi") . '");
                var mettings = jQuery("#mec_webex_request_get_wm_result").serialize();
                jQuery.ajax(
                {
                    type: "POST",
                    url: ajaxurl,
                    data: "action=mec_webex_import_meetings&"+mettings,
                    dataType: "json",
                    success: function(data)
                    {
                        // Remove the loading Class to the button
                        jQuery("#mec_webex_import_meetings").removeAttr("disabled").removeClass("loading").text("' . esc_attr__('Import meetings', "mec-wi") . '");

                        if ( data.success == "1") {
                            jQuery("#mec-webex-importing-desc").html(data.message);
                            console.log(data.message)
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown)
                    {
                        // Remove the loading Class to the button
                        console.log("error!")
                    }
                });
            }
            </script>';
            } else {
                $message .= '<p>Not Meeting Found!</p>';
            }
        }

        echo json_encode(array('success' => 1, 'message' => $message));
        exit;
    }


    /**
     * @throws \Exception
     */
    public static function get_datetimes($start_datetime, $end_datetime)
    {

        if (!$start_datetime) $start_datetime = 'now';
        if (!$end_datetime) $end_datetime = 'now';

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $date_start = new \DateTime($start_datetime, $gmtTimezone);
        $date_end = new \DateTime($end_datetime, $gmtTimezone);
        $date_s = $date_start->format('Y-m-d');
        $date_e = $date_end->format('Y-m-d');


        $datetimes = array(
            'start' => array(
                'hour' => 8,
                'minutes' => '00',
                'ampm' => 'AM',
                'datetime' => $date_s . ' 08:00 AM',
                'date' => $date_s,
            ),
            'end' => array(
                'hour' => 8,
                'minutes' => '00',
                'ampm' => 'PM',
                'datetime' => $date_e . ' 08:00 PM',
                'date' => $date_e,
            ),
        );

        if (!$start_datetime) {

            return $datetimes;
        }

        if (!empty($date_start)) {

            $start_date = $date_s;

            $datetimes['start']['hour'] = $date_start->format('g');
            $datetimes['start']['minutes'] = $date_start->format('i');
            $datetimes['start']['ampm'] = $date_start->format('A');
            $datetimes['start']['datetime'] = "{$start_date} {$datetimes['start']['hour']}:{$datetimes['start']['minutes']} {$datetimes['start']['ampm']}";
            $datetimes['start']['date'] = $start_date;
        }


        if (!empty($date_end)) {

            $end_date = $date_e;

            $datetimes['end']['hour'] = $date_end->format('g');
            $datetimes['end']['minutes'] = $date_end->format('i');
            $datetimes['end']['ampm'] = $date_end->format('A');
            $datetimes['end']['datetime'] = "{$end_date} {$datetimes['end']['hour']}:{$datetimes['end']['minutes']} {$datetimes['end']['ampm']}";
            $datetimes['end']['date'] = $end_date;
        }

        return $datetimes;
    }

    public function mec_webex_import_meetings()
    {
        $mec_webex_meetings = isset($_POST['mec-webex-meetings']) ? $_POST['mec-webex-meetings'] : array();
        $access_token = esc_html(get_option('mec_webex_access_token'));

        $main = new \MEC_main();

        foreach ($mec_webex_meetings as $meeting_id) {

            $url='https://webexapis.com/v1/meetings/' . $meeting_id;
            $timezone=get_option('timezone_string');

            $response = wp_remote_post($url, array(
                    'method' => 'GET',
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $access_token,
                        'timezone'=>$timezone
                    ),
                    'body' => array(),
                    'cookies' => array()
                )
            );

            $body = json_decode(
                wp_remote_retrieve_body($response)
            );


            $message[] = $body;

            $title = $body->title;
            $description = $body->agenda;
            $webex_meeting_uid = $body->hostUserId;
            $webex_meeting_id = $meeting_id;

            $start_datetime = isset($body->start) ? $body->start : false;
            $end_datetime = isset($body->end) ? $body->end : false;

            $tz = wp_timezone_string();
            $gmtTimezone = new \DateTimeZone($tz);

            $datetimes = self::get_datetimes($start_datetime, $end_datetime);


            $start_date = $datetimes['start']['date'];
            $start_hour = $datetimes['start']['hour'];
            $start_minutes = $datetimes['start']['minutes'];
            $start_ampm = $datetimes['start']['ampm'];

            $end_date = $datetimes['end']['date'];
            $end_hour = $datetimes['end']['hour'];
            $end_minutes = $datetimes['end']['minutes'];
            $end_ampm = $datetimes['end']['ampm'];

            $allday = 0;
            $mec_repeat_end = 'never';


            if (isset ($body->recurrence) and !empty($body->recurrence)) {
                $repeat_status = 1;
                $repeat_type = '';
                $interval = null;
                $year = null;
                $month = null;
                $adv_day = null;
                $adv_week = null;
                $day = null;
                $week = null;
                $weekday = null;
                $weekdays = null;
                $g_week_days = null;
                $advanced_days = null;
                $end_at_occurrences = null;
                $finish = $end_date;
                $arr_recurrence = explode(';', $body->recurrence);

                foreach ($arr_recurrence as $recurr) {
                    if (str_contains($recurr, 'FREQ')) {
                        $repeat_type = strtolower(explode('=', $recurr)[1]);
                    }
                    if (str_contains($recurr, 'INTERVAL')) {
                        $interval = explode('=', $recurr)[1];
                    }
                    if (str_contains($recurr, 'UNTIL')) {
                        $until = explode('=', $recurr)[1];
                        $finish = substr($until, 0, 4) . "-" . substr($until, 4, 2) . "-" . substr($until, 6, 2);
                        $mec_repeat_end = 'date';
                    }
                    if (str_contains($recurr, 'BYDAY')) {
                        $g_week_days = explode(',', explode('=', $recurr)[1]);
                    }
                    if (str_contains($recurr, 'BYSETPOS')) {
                        $adv_week = explode('=', $recurr)[1];
                    }
                    if (str_contains($recurr, 'COUNT')) {
                        $end_at_occurrences=explode('=', $recurr)[1];
                        $end_at_occurrences=intval($end_at_occurrences)-1;
                        $mec_repeat_end = 'occurrences';
                    }

                    /*  if (str_contains($recurr, 'BYMONTHDAY')) {
                        }
                       if (str_contains($recurr, 'WKST')) {
                        }
                       if (str_contains($recurr, 'BYMONTH')) {
                        }*/

                }

                switch ($repeat_type) {
                    case 'daily':
                        break;
                    case 'weekly':
                        $interval = $interval != null ? $interval * 7 : 7;
                        if ($g_week_days != null && count($g_week_days) > 1) {

                            $week_day_mapping = array('MO' => 1, 'TU' => 2, 'WE' => 3, 'TH' => 4, 'FR' => 5, 'SA' => 6, 'SU' => 7);

                            $weekdays = '';
                            foreach ($g_week_days as $g_week_day) $weekdays .= $week_day_mapping[$g_week_day] . ',';

                            $weekdays = ',' . trim($weekdays, ', ') . ',';
                            $interval = null;

                            $repeat_type = 'certain_weekdays';
                        }
                        break;
                    case 'monthly':
                        if ($adv_week != null) {

                            $repeat_type = 'advanced';

                            if ($adv_week < 0) $adv_week = 'l';

                            $adv_day = $g_week_days[0];
                            $mec_adv_day = 'Sat';
                            if ($adv_day == 'SU') $mec_adv_day = 'Sun';
                            elseif ($adv_day == 'MO') $mec_adv_day = 'Mon';
                            elseif ($adv_day == 'TU') $mec_adv_day = 'Tue';
                            elseif ($adv_day == 'WE') $mec_adv_day = 'Wed';
                            elseif ($adv_day == 'TH') $mec_adv_day = 'Thu';
                            elseif ($adv_day == 'FR') $mec_adv_day = 'Fri';

                            $advanced_days = array($mec_adv_day . '.' . $adv_week);
                        } else {
                            $repeat_type = 'monthly';

                            $year = '*';
                            $month = '*';

                            $s = $start_date;
                            $e = $end_date;

                            $_days = array();
                            while (strtotime($s) <= strtotime($e)) {
                                $_days[] = date('d', strtotime($s));
                                $s = date('Y-m-d', strtotime('+1 Day', strtotime($s)));
                            }

                            $day = ',' . implode(',', array_unique($_days)) . ',';

                            $week = '*';
                            $weekday = '*';
                        }
                        break;
                    case 'yearly':
                        $year = '*';

                        $s = $start_date;
                        $e = $end_date;

                        $_months = array();
                        $_days = array();
                        while (strtotime($s) <= strtotime($e)) {
                            $_months[] = date('m', strtotime($s));
                            $_days[] = date('d', strtotime($s));

                            $s = date('Y-m-d', strtotime('+1 Day', strtotime($s)));
                        }

                        $month = ',' . implode(',', array_unique($_months)) . ',';
                        $day = ',' . implode(',', array_unique($_days)) . ',';

                        $week = '*';
                        $weekday = '*';
                        break;
                }


            } else {
                $repeat_status = 0;
                $g_recurrence_rule = '';
                $repeat_type = '';
                $interval = null;
                $finish = $end_date;
                $year = null;
                $month = null;
                $day = null;
                $week = null;
                $weekday = null;
                $weekdays = null;
                $advanced_days = null;
                $end_at_occurrences = null;
            }


            $args = array
            (
                'title' => $title,
                'content' => $description,
                'location_id' => '',
                'organizer_id' => '',
                'date' => array
                (
                    'start' => array(
                        'date' => $start_date,
                        'hour' => $start_hour,
                        'minutes' => $start_minutes,
                        'ampm' => $start_ampm,
                    ),
                    'end' => array(
                        'date' => $end_date,
                        'hour' => $end_hour,
                        'minutes' => $end_minutes,
                        'ampm' => $end_ampm,
                    ),
                    'repeat' => array(),
                    'allday' => $allday,
                    'comment' => '',
                    'hide_time' => 0,
                    'hide_end_time' => 0,
                ),
                'start' => $start_date,
                'start_time_hour' => $start_hour,
                'start_time_minutes' => $start_minutes,
                'start_time_ampm' => $start_ampm,
                'end' => $end_date,
                'end_time_hour' => $end_hour,
                'end_time_minutes' => $end_minutes,
                'end_time_ampm' => $end_ampm,
                'repeat_status' => $repeat_status,
                'repeat_type' => $repeat_type,
                'interval' => $interval,
                'finish' => $finish,
                'year' => $year,
                'month' => $month,
                'day' => $day,
                'week' => $week,
                'weekday' => $weekday,
                'weekdays' => $weekdays,
                'meta' => array
                (
                    'mec_source' => 'webex-meetings',
                    'mec_webex_meeting_uid' => $webex_meeting_uid,
                    'mec_webex_meeting_id' => $webex_meeting_id,
                    'mec_advanced_days' => $advanced_days,
                    'mec_repeat' => array
                    (
                        'status' => $repeat_status,
                        'type' => $repeat_type,
                        'interval' => $interval,
                        'end' => 'date',
                        'end_at_date' => $mec_repeat_end == 'date' ? $finish : null,
                        'end_at_occurrences' => null,
                    ),
                    'mec_comment' => $body->timezone,
                    'mec_repeat_end' => $mec_repeat_end,
                    'mec_repeat_end_at_occurrences' => $end_at_occurrences,
                    'mec_repeat_end_at_date' => $mec_repeat_end == 'date' ? $finish : null,
                )
            );

            $db = \MEC::getInstance('app.libraries.db');
            $post_id = $db->select("SELECT `post_id` FROM `#__postmeta` WHERE `meta_value`='$webex_meeting_id' AND `meta_key`='mec_webex_meeting_id'", 'loadResult');

            if (!post_exists($title, $description, '', $main->get_main_post_type())) $args['meta']['mec_imported_from_webex_meeting'] = 1;

            $post_id = $main->save_event($args, NULL);

            update_post_meta($post_id, 'more_info', $body->webLink);
            update_post_meta($post_id, 'more_info_title', esc_html__('Register', 'mec-wi'));
            update_post_meta($post_id, 'mec_webex_event', 'meeting');
            update_post_meta($post_id, 'mec_webex_link_url', $body->webLink);
            update_post_meta($post_id, 'mec_webex_link_title', esc_html__('Register', 'mec-wi'));
            update_post_meta($post_id, 'mec_webex_password', $body->password);
            update_post_meta($post_id, 'mec_webex_join_url', $body->webLink);
            update_post_meta($post_id, 'mec_webex_join_title', esc_html__('Join it!', 'mec-wi'));
            update_post_meta($post_id, 'mec_event_import_from_webex', '1');

        }

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $myDateTime = new \DateTime("now", $gmtTimezone);
        $nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));

        $expire_time_flag = ($nowTime > (int)get_option('mec_webex_token_expire_in')) ? 1 : 0;
        $message = ($expire_time_flag == 1) ? esc_html__('Access Token is expired. Please click on "Generate Access Token" and import again.', 'mec-wi') : esc_html__('All items are imported.', 'mec-wi');

        echo json_encode(array('success' => 1, 'message' => $message));

        exit;
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zoom_Integration\Autoloader')) {
            return;
        }
    }
} //MecWebex
