<?php

namespace MEC_Webex_Integration\Core\singleOptions;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

use MEC\Books\EventBook;

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class SingleOptions
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Webex_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_enqueue_scripts', [$This, 'assets']);
        add_action('mec_webex_event_form', [$This, 'meta_box_webex']);
        add_filter('mec-single-event-meta-title', [$This, 'add_options'] , 100 , 2);
        add_action('mec_metabox_details', [$This, 'meta_box_webex'], 60);
        add_action('save_post', [$This, 'save_event']);
        add_action('mec_single_webex_badge', [$This, 'display_badge_in_single'] , 100 ,1);
        add_action('mec_single_after_content', [$This, 'display_in_single_page']);
        add_action('mec_shortcode_virtual_badge', [$This, 'display_badge_in_shortcode'] , 100, 1);
        add_filter('mec_monthly_virtual_badge', [$This, 'display_badge_in_monthly'] , 100 , 2);
        add_filter('MEC_extra_info_gateways', [$This, 'display_password_in_booking'] , 100 , 3);
        add_action('mec_extra_field_notifications', [$This, 'display_notification_field']);
        add_action('save_fes_meta_action',[$This, 'save_fes_form'], 100, 2);

        add_filter('mec_profile_event_detail', [__CLASS__, 'add_event_detail_to_dashboard'], 10,3);
        add_filter('mec_profile_event_detail_header', [__CLASS__, 'add_header_event_detail_to_dashboard'], 10,3);
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp(){

    }

    public function add_options( $tabs, $activated )
    {
        $webexTab =  array(
            __('Webex Information', 'mec-wi') => 'mec-webex',
        );
        $tabs = array_merge($tabs, $webexTab);
        return $tabs;
    }

    public function meta_box_webex($post)
    {
        $mec_webex_event = get_post_meta($post->ID, 'mec_webex_event', true);
        $mec_webex_badge_shortcode = get_post_meta($post->ID, 'mec_webex_badge_shortcode', true);
        $mec_webex_badge_single = get_post_meta($post->ID, 'mec_webex_badge_single', true);

        $webex_join_url = get_post_meta($post->ID, 'mec_webex_join_url', true);
        $webex_join_title = get_post_meta($post->ID, 'mec_webex_join_title', true);
        $webex_join_target = get_post_meta($post->ID, 'mec_webex_join_target', true);
        $mec_webex_display_join_in_booking = get_post_meta($post->ID, 'mec_webex_display_join_in_booking', true);

        $webex_link_url = get_post_meta($post->ID, 'mec_webex_link_url', true);
        $webex_link_title = get_post_meta($post->ID, 'mec_webex_link_title', true);
        $webex_link_target = get_post_meta($post->ID, 'mec_webex_link_target', true);
        $mec_webex_display_link_in_booking = get_post_meta($post->ID, 'mec_webex_display_link_in_booking', true);

        $webex_embed = get_post_meta($post->ID, 'mec_webex_embed', true);

        $webex_hide_info_before_start = get_post_meta($post->ID, 'mec_webex_hide_info_before_start', true);
        $webex_show_info_time = get_post_meta($post->ID, 'mec_webex_show_info_time', true);
        $webex_show_info_hm = get_post_meta($post->ID, 'mec_webex_show_info_hm', true);

        $mec_webex_hide_info = get_post_meta($post->ID, 'mec_webex_hide_info', true);

        $mec_webex_password = get_post_meta($post->ID, 'mec_webex_password', true);
        $mec_webex_display_password_in_booking = get_post_meta($post->ID, 'mec_webex_display_password_in_booking', true);

        ?>
        <div class="mec-meta-box-fields mec-event-tab-content" id="mec-webex">
            <h4><?php echo __('Webex Event', 'mec-wi'); ?></h4>
            <div class="mec-form-row">
                <input
                    <?php
                    if ((isset($mec_webex_event) and $mec_webex_event == 'none') || !isset($mec_webex_event) || empty($mec_webex_event)) {
                        echo 'checked="checked"';
                    }
                    ?>
                        type="radio" name="mec[mec_webex_event]" id="mec_webex_event_none" value="none"/><label
                        for="mec_webex_event_none"><?php _e('None', 'mec-wi'); ?></label>
                    <input
                    <?php
                    if (isset($mec_webex_event) and $mec_webex_event == 'webinar') {
                        echo 'checked="checked"';
                    }
                    ?>
                        type="radio" name="mec[mec_webex_event]" id="mec_webex_event_webinar" value="webinar"/><label
                        for="mec_webex_event_webinar"><?php _e('Webinar', 'mec-wi'); ?></label>
                    <input
                    <?php
                    if (isset($mec_webex_event) and $mec_webex_event == 'meeting') {
                        echo 'checked="checked"';
                    }
                    ?>
                        type="radio" name="mec[mec_webex_event]" id="mec_webex_event_meeting" value="meeting"/><label
                        for="mec_webex_event_meeting"><?php _e('Meeting', 'mec-wi'); ?></label>
            </div>
            <div class="mec-webex-event-wrap" style="<?php echo ((isset($mec_webex_event) and $mec_webex_event == 'none') || !isset($mec_webex_event) || empty($mec_webex_event)) ? 'display: none': 'display: block'; ?>">
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_webex_badge_shortcode) and $mec_webex_badge_shortcode == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_webex_badge_shortcode]" id="mec_webex_badge_shortcode" value="1"/><label
                            for="mec_webex_badge_shortcode"><?php _e('Display webex badge in shortcode', 'mec-wi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_webex_badge_single) and $mec_webex_badge_single == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_webex_badge_single]" id="mec_webex_badge_single" value="1"/><label
                            for="mec_webex_badge_single"><?php _e('Display webex badge in Single Event Page', 'mec-wi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_webex_link_url"><?php esc_html_e('Registeration Link' , 'mec-wi'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_webex_link_url]" id="mec_webex_link_url" readonly value="<?php echo esc_attr($webex_link_url); ?>" placeholder="eg. https://example.webex.com">
                    <input class="mec-col-2" type="text" name="mec[mec_webex_link_title]" id="mec_webex_link_title" value="<?php echo esc_attr($webex_link_title); ?>" placeholder="Title">
                    <select class="mec-col-2" name="mec[mec_webex_link_target]" id="mec_webex_link_target">
                        <option value="_self" <?php echo($webex_link_target == '_self' ? 'selected="selected"' : ''); ?>><?php _e('Current Window', 'mec-wi'); ?></option>
                        <option value="_blank" <?php echo($webex_link_target == '_blank' ? 'selected="selected"' : ''); ?>><?php _e('New Window', 'mec-wi'); ?></option>
                    </select>
                    <label class="mec-col-3" for="mec_webex_display_link_in_booking"><input
                        <?php
                        if (isset($mec_webex_display_link_in_booking) and $mec_webex_display_link_in_booking == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_webex_display_link_in_booking]" id="mec_webex_display_link_in_booking" value="1"/><?php esc_html_e('Display when booking is completed' , 'mec-wi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_webex_password"><?php esc_html_e('Password' , 'mec-wi'); ?></label>
                    <input class="mec-col-6" type="text" name="mec[mec_webex_password]" id="mec_webex_password" value="<?php echo esc_attr($mec_webex_password); ?>"/>
                    <label class="mec-col-5" for="mec_webex_display_password_in_booking"><input
                        <?php
                        if (isset($mec_webex_display_password_in_booking) and $mec_webex_display_password_in_booking == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_webex_display_password_in_booking]" id="mec_webex_display_password_in_booking" value="1"/><?php esc_html_e('Display when booking is completed' , 'mec-wi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_webex_embed"><?php esc_html_e('Embed' , 'mec-wi'); ?></label>
                    <textarea class="mec-col-11" type="text" name="mec[mec_webex_embed]" id="mec_webex_embed" ><?php echo esc_attr($webex_embed); ?></textarea>
                </div>
                <div class="mec-form-row">

                    <label class="mec-col-3" for="mec_webex_hide_info_before_start"><input
                        <?php
                        if (isset($webex_hide_info_before_start) and $webex_hide_info_before_start == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_webex_hide_info_before_start]" id="mec_webex_hide_info_before_start" value="1"/><?php esc_html_e('Display the above information until' , 'mec-wi'); ?></label>
                    <input class="mec-col-1" type="number" name="mec[mec_webex_show_info_time]" value="<?php echo((isset($webex_show_info_time) and trim($webex_show_info_time)) ? esc_attr($webex_show_info_time) : '0'); ?>" placeholder="<?php _e('e.g. 0', 'mec'); ?>">
                    <select class="mec-col-1" name="mec[mec_webex_show_info_hm]" id="mec_webex_show_info_hm">
                        <option value="day" <?php echo($webex_show_info_hm == 'day' ? 'selected="selected"' : ''); ?>><?php _e('Day', 'mec-wi'); ?></option>
                        <option value="hour" <?php echo($webex_show_info_hm == 'hour' ? 'selected="selected"' : ''); ?>><?php _e('Hour', 'mec-wi'); ?></option>
                        <option value="minute" <?php echo($webex_show_info_hm == 'minute' ? 'selected="selected"' : ''); ?>><?php _e('Minute', 'mec-wi'); ?></option>
                    </select>
                    <label class="mec-col-2" for="mec_webex_show_info_time"><?php esc_html_e('before event starts.' , 'mec-wi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_webex_hide_info) and $mec_webex_hide_info == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_webex_hide_info]" id="mec_webex_hide_info" value="1"/><label
                            for="mec_webex_hide_info"><?php _e('Hide the above information when event is live', 'mec-wi'); ?></label>
                </div>
            </div>
        </div>
        <script>
        jQuery(document).ready(function()
        {
            jQuery('input[name="mec[mec_webex_event]"]').on('change', function()
            {

                if ( jQuery(this).val() != 'none') {
                    jQuery('.mec-webex-event-wrap').show();
                } else {
                    jQuery('.mec-webex-event-wrap').hide();
                }

            });
        });
        </script>
        <?php
    }

    public function save_event($post_id)
    {
        // Check if our nonce is set.
        if(!isset($_POST['mec_event_nonce'])) return false;

        // Verify that the nonce is valid.
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_event_nonce']), 'mec_event_data')) return false;

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return false;

        // Get Modern Events Calendar Data
        $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();

        $mec_webex_event = (isset($_mec['mec_webex_event']) and !empty($_mec['mec_webex_event'])) ? $_mec['mec_webex_event'] : 'none';
        update_post_meta($post_id, 'mec_webex_event', $mec_webex_event);

        $mec_webex_badge_shortcode = (isset($_mec['mec_webex_badge_shortcode']) and !empty($_mec['mec_webex_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_badge_shortcode', $mec_webex_badge_shortcode);

        $mec_webex_badge_single = (isset($_mec['mec_webex_badge_single']) and !empty($_mec['mec_webex_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_badge_single', $mec_webex_badge_single);

        $mec_webex_join_url = (isset($_mec['mec_webex_join_url']) and !empty($_mec['mec_webex_join_url'])) ? $_mec['mec_webex_join_url'] : '';
        update_post_meta($post_id, 'mec_webex_join_url', $mec_webex_join_url);

        $mec_webex_join_title = (isset($_mec['mec_webex_join_title']) and !empty($_mec['mec_webex_join_title'])) ? $_mec['mec_webex_join_title'] : '';
        update_post_meta($post_id, 'mec_webex_join_title', $mec_webex_join_title);

        $mec_webex_join_target = (isset($_mec['mec_webex_join_target']) and !empty($_mec['mec_webex_join_target'])) ? $_mec['mec_webex_join_target'] : '';
        update_post_meta($post_id, 'mec_webex_join_target', $mec_webex_join_target);

        $mec_webex_link_url = (isset($_mec['mec_webex_link_url']) and !empty($_mec['mec_webex_link_url'])) ? $_mec['mec_webex_link_url'] : '';
        update_post_meta($post_id, 'mec_webex_link_url', $mec_webex_link_url);

        $mec_webex_link_title = (isset($_mec['mec_webex_link_title']) and !empty($_mec['mec_webex_link_title'])) ? $_mec['mec_webex_link_title'] : '';
        update_post_meta($post_id, 'mec_webex_link_title', $mec_webex_link_title);

        $mec_webex_link_target = (isset($_mec['mec_webex_link_target']) and !empty($_mec['mec_webex_link_target'])) ? $_mec['mec_webex_link_target'] : '';
        update_post_meta($post_id, 'mec_webex_link_target', $mec_webex_link_target);

        $mec_webex_embed = (isset($_mec['mec_webex_embed']) and !empty($_mec['mec_webex_embed'])) ? $_mec['mec_webex_embed'] : '';
        update_post_meta($post_id, 'mec_webex_embed', $mec_webex_embed);

        $mec_webex_show_info_time = (isset($_mec['mec_webex_show_info_time']) and !empty($_mec['mec_webex_show_info_time'])) ? $_mec['mec_webex_show_info_time'] : '';
        update_post_meta($post_id, 'mec_webex_show_info_time', $mec_webex_show_info_time);

        $mec_webex_show_info_hm = (isset($_mec['mec_webex_show_info_hm']) and !empty($_mec['mec_webex_show_info_hm'])) ? $_mec['mec_webex_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_webex_show_info_hm', $mec_webex_show_info_hm);

        $mec_webex_hide_info = (isset($_mec['mec_webex_hide_info']) and !empty($_mec['mec_webex_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_hide_info', $mec_webex_hide_info);

        $mec_webex_hide_info_before_start = (isset($_mec['mec_webex_hide_info_before_start']) and !empty($_mec['mec_webex_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_hide_info_before_start', $mec_webex_hide_info_before_start);

        $mec_webex_password = (isset($_mec['mec_webex_password']) and !empty($_mec['mec_webex_password'])) ? $_mec['mec_webex_password'] : '';
        update_post_meta($post_id, 'mec_webex_password', $mec_webex_password);

        $mec_webex_display_password_in_booking = (isset($_mec['mec_webex_display_password_in_booking']) and !empty($_mec['mec_webex_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_password_in_booking', $mec_webex_display_password_in_booking);

        $mec_webex_display_join_in_booking = (isset($_mec['mec_webex_display_join_in_booking']) and !empty($_mec['mec_webex_display_join_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_join_in_booking', $mec_webex_display_join_in_booking);

        $mec_webex_display_link_in_booking = (isset($_mec['mec_webex_display_link_in_booking']) and !empty($_mec['mec_webex_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_link_in_booking', $mec_webex_display_link_in_booking);

        return true;
    }

    public function save_fes_form($post_id, $mec) {

        // $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();

        $mec_webex_event = (isset($mec['mec_webex_event']) and !empty($mec['mec_webex_event'])) ? $mec['mec_webex_event'] : 'none';
        update_post_meta($post_id, 'mec_webex_event', $mec_webex_event);

        $mec_webex_badge_shortcode = (isset($mec['mec_webex_badge_shortcode']) and !empty($mec['mec_webex_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_badge_shortcode', $mec_webex_badge_shortcode);

        $mec_webex_badge_single = (isset($mec['mec_webex_badge_single']) and !empty($mec['mec_webex_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_badge_single', $mec_webex_badge_single);

        $mec_webex_join_url = (isset($mec['mec_webex_join_url']) and !empty($mec['mec_webex_join_url'])) ? $mec['mec_webex_join_url'] : '';
        update_post_meta($post_id, 'mec_webex_join_url', $mec_webex_join_url);

        $mec_webex_join_title = (isset($mec['mec_webex_join_title']) and !empty($mec['mec_webex_join_title'])) ? $mec['mec_webex_join_title'] : '';
        update_post_meta($post_id, 'mec_webex_join_title', $mec_webex_join_title);

        $mec_webex_join_target = (isset($mec['mec_webex_join_target']) and !empty($mec['mec_webex_join_target'])) ? $mec['mec_webex_join_target'] : '';
        update_post_meta($post_id, 'mec_webex_join_target', $mec_webex_join_target);

        $mec_webex_link_url = (isset($mec['mec_webex_link_url']) and !empty($mec['mec_webex_link_url'])) ? $mec['mec_webex_link_url'] : '';
        update_post_meta($post_id, 'mec_webex_link_url', $mec_webex_link_url);

        $mec_webex_link_title = (isset($mec['mec_webex_link_title']) and !empty($mec['mec_webex_link_title'])) ? $mec['mec_webex_link_title'] : '';
        update_post_meta($post_id, 'mec_webex_link_title', $mec_webex_link_title);

        $mec_webex_link_target = (isset($mec['mec_webex_link_target']) and !empty($mec['mec_webex_link_target'])) ? $mec['mec_webex_link_target'] : '';
        update_post_meta($post_id, 'mec_webex_link_target', $mec_webex_link_target);

        $mec_webex_embed = (isset($mec['mec_webex_embed']) and !empty($mec['mec_webex_embed'])) ? $mec['mec_webex_embed'] : '';
        update_post_meta($post_id, 'mec_webex_embed', $mec_webex_embed);

        $mec_webex_show_info_time = (isset($mec['mec_webex_show_info_time']) and !empty($mec['mec_webex_show_info_time'])) ? $mec['mec_webex_show_info_time'] : '';
        update_post_meta($post_id, 'mec_webex_show_info_time', $mec_webex_show_info_time);

        $mec_webex_show_info_hm = (isset($mec['mec_webex_show_info_hm']) and !empty($mec['mec_webex_show_info_hm'])) ? $mec['mec_webex_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_webex_show_info_hm', $mec_webex_show_info_hm);

        $mec_webex_hide_info = (isset($mec['mec_webex_hide_info']) and !empty($mec['mec_webex_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_hide_info', $mec_webex_hide_info);

        $mec_webex_hide_info_before_start = (isset($mec['mec_webex_hide_info_before_start']) and !empty($mec['mec_webex_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_hide_info_before_start', $mec_webex_hide_info_before_start);

        $mec_webex_password = (isset($mec['mec_webex_password']) and !empty($mec['mec_webex_password'])) ? $mec['mec_webex_password'] : '';
        update_post_meta($post_id, 'mec_webex_password', $mec_webex_password);

        $mec_webex_display_password_in_booking = (isset($mec['mec_webex_display_password_in_booking']) and !empty($mec['mec_webex_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_password_in_booking', $mec_webex_display_password_in_booking);

        $mec_webex_display_join_in_booking = (isset($mec['mec_webex_display_join_in_booking']) and !empty($mec['mec_webex_display_join_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_join_in_booking', $mec_webex_display_join_in_booking);

        $mec_webex_display_link_in_booking = (isset($mec['mec_webex_display_link_in_booking']) and !empty($mec['mec_webex_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_webex_display_link_in_booking', $mec_webex_display_link_in_booking);

        return true;

    }

    public function display_badge_in_single( $event_id )
    {

        $main = new \MEC_main();
        $eventx = $event_id->ID;
        $event_data = $event_id->ID;
        $timestamp = $event_id->time['start_timestamp'];
        $timestamp = $main->get_start_time_of_multiple_days($event_data, $timestamp);

        $ex = explode(':', $timestamp);
        $timestamp = (int) $ex[0];

        $year = date('Y', $timestamp);
        $month = date('m', $timestamp);
        $day = date('d', $timestamp);
        $hour = date('H', $timestamp);
        $minutes = date('i', $timestamp);
        $event_date = date('Y-m-d h:i a', $timestamp);

        $webex_hide_info_before_start = get_post_meta($eventx, 'mec_webex_hide_info_before_start', true);
        $webex_show_info_time = get_post_meta($eventx, 'mec_webex_show_info_time', true);
        $webex_show_info_hm = get_post_meta($eventx, 'mec_webex_show_info_hm', true);

        $mec_webex_hide_info = get_post_meta($eventx, 'mec_webex_hide_info', true);

        $get_meta = get_post_meta($eventx, 'mec_webex_badge_single', true);
        $mec_webex_webinar = get_post_meta($eventx, 'mec_webex_event', true) == 'webinar' ? esc_html__('Webex Webinar' , 'mec-wi') : NULL;
        $mec_webex_meeting = get_post_meta($eventx, 'mec_webex_event', true) == 'meeting' ? esc_html__('Webex Meeting' , 'mec-wi') : NULL;

        $content = '<div class="mec-single-webex-badge"><i class="mec-sl-camrecorder"></i><h3>'.$mec_webex_webinar.$mec_webex_meeting.'</h3></div>';

        if ($get_meta == 1) {
            if ( $webex_hide_info_before_start and $webex_show_info_time > 0  and $main->check_date_time_validation('Y-m-d h:i a', strtolower($event_date)) and strtotime("-{$webex_show_info_time}{$webex_show_info_hm}", strtotime($event_date)) > current_time('timestamp', 0) and !$mec_webex_hide_info ) {
                echo $content;
            } elseif (!$mec_webex_hide_info and !$webex_hide_info_before_start) {
                echo $content;
            }
        }

    }

    public function display_badge_in_shortcode( $event_id )
    {
        $get_meta = get_post_meta($event_id, 'mec_webex_badge_shortcode', true);
        $mec_webex_webinar = get_post_meta($event_id, 'mec_webex_event', true) == 'webinar' ? esc_html__('Webex Webinar' , 'mec-wi') : NULL;
        $mec_webex_meeting = get_post_meta($event_id, 'mec_webex_event', true) == 'meeting' ? esc_html__('Webex Meeting' , 'mec-wi') : NULL;

        if ($get_meta) {
        ?>
            <span class="mec-shortcode-webex-badge">
                <i class="mec-sl-camrecorder"></i><span><?php echo $mec_webex_webinar.$mec_webex_meeting; ?></span>
            </span>
        <?php
        }
    }

    public function display_badge_in_monthly($events_str,$event_id)
    {

        $get_meta = get_post_meta($event_id, 'mec_webex_badge_shortcode', true);
        $mec_webex_webinar = get_post_meta($event_id, 'mec_webex_event', true) == 'webinar' ? esc_html__('Webex Webinar' , 'mec-wi') : NULL;
        $mec_webex_meeting = get_post_meta($event_id, 'mec_webex_event', true) == 'meeting' ? esc_html__('Webex Meeting' , 'mec-wi') : NULL;

        $new_events_str = '';
        if ($get_meta) {
            $new_events_str =
            '
            <span class="mec-shortcode-webex-badge">
                <i class="mec-sl-camrecorder"></i><span>'.$mec_webex_webinar.$mec_webex_meeting.'</span>
            </span>
            ';
            $events_str = $new_events_str;
        }

        return $events_str;
    }

    public function assets()
    {
        wp_enqueue_style('mec-webex-style', MECWIDASSETS . 'mec-webex.css' );
    }

    public function display_in_single_page($event)
    {
        $main = new \MEC_main();
        $event_id = isset( $event->data->ID ) ? $event->data->ID : $event->ID;
        $timestamp = $event->data->time['start_timestamp'];
        $timestamp = $main->get_start_time_of_multiple_days($event_id, $timestamp);

        $ex = explode(':', $timestamp);
        $timestamp = (int) $ex[0];

        $year = date('Y', $timestamp);
        $month = date('m', $timestamp);
        $day = date('d', $timestamp);
        $hour = date('H', $timestamp);
        $minutes = date('i', $timestamp);

        $user_books = EventBook::getInstance()->get_user_books( $event_id );
        $user_has_book = ( is_array( $user_books ) && count( $user_books ) ) ? true : false;

        // Ticket Selling Stop
        $event_date = date('Y-m-d h:i a', $timestamp);

        $webex_join_url = get_post_meta($event_id, 'mec_webex_join_url', true);
        $webex_join_title = get_post_meta($event_id, 'mec_webex_join_title', true);
        $webex_join_target = get_post_meta($event_id, 'mec_webex_join_target', true);
        $mec_webex_display_join_in_booking = get_post_meta($event_id, 'mec_webex_display_join_in_booking', true);

        $webex_join = ($webex_join_title and ( $user_has_book || $mec_webex_display_join_in_booking != '1' ) )  ? '<a class="mec-event-webex-join" href="'.$webex_join_url.'" target="'.$webex_join_target.'">'.$webex_join_title.'</a>' : '' ;

        $webex_link_url = get_post_meta($event_id, 'mec_webex_link_url', true);
        $webex_link_title = get_post_meta($event_id, 'mec_webex_link_title', true);
        $webex_link_target = get_post_meta($event_id, 'mec_webex_link_target', true);
        $mec_webex_display_link_in_booking = get_post_meta($event_id, 'mec_webex_display_link_in_booking', true);

        $webex_link = ($webex_link_title and ( $user_has_book || $mec_webex_display_link_in_booking != '1' ) )  ? '<a class="mec-event-webex-link" href="'.$webex_link_url.'" target="'.$webex_link_target.'">'.$webex_link_title.'</a>' : '' ;

        $webex_embed = get_post_meta($event_id, 'mec_webex_embed', true) ? '<div class="mec-event-webex-embed">'.get_post_meta($event_id, 'mec_webex_embed', true).'</div>' : '';

        $webex_hide_info_before_start = get_post_meta($event_id, 'mec_webex_hide_info_before_start', true);
        $webex_show_info_time = get_post_meta($event_id, 'mec_webex_show_info_time', true);
        $webex_show_info_hm = get_post_meta($event_id, 'mec_webex_show_info_hm', true);

        $mec_webex_hide_info = get_post_meta($event_id, 'mec_webex_hide_info', true);

        $webex_display_password_in_booking = get_post_meta($event_id, 'mec_webex_display_password_in_booking', true);
        $webex_password = (get_post_meta($event_id, 'mec_webex_password', true) and ( $user_has_book || $webex_display_password_in_booking != '1' ) ) ? '<div class="mec-webex-password"><strong>'.esc_html__('Password:' ,'mec-wi') . '</strong> <span>' .get_post_meta($event_id, 'mec_webex_password', true) . '</span></div>' : '';

        $content ="";
        if ( !empty($webex_embed) || !empty($webex_join) || !empty($webex_link) || !empty($webex_password)):
        $content =
        '<div class="mec-event-data-fields mec-frontbox">'.
            $webex_embed.
            $webex_join.
            $webex_link.
            $webex_password.
        '</div>';
        endif;

        if ( $webex_hide_info_before_start and $webex_show_info_time > 0  and $main->check_date_time_validation('Y-m-d h:i a', strtolower($event_date)) and strtotime("-{$webex_show_info_time}{$webex_show_info_hm}", strtotime($event_date)) > current_time('timestamp', 0) and !$mec_webex_hide_info) {
            echo $content;
        } elseif ( $mec_webex_hide_info and !$main->is_ongoing($event)) {
            echo $content;
        } elseif (!$mec_webex_hide_info and !$webex_hide_info_before_start) {
           echo $content;
        }elseif($user_has_book){
            // echo $content;
        }
    }

    public function display_password_in_booking($content, $event_id,$book_id)
    {
        $webex_join_url = get_post_meta($event_id, 'mec_webex_join_url', true);
        $webex_join_title = get_post_meta($event_id, 'mec_webex_join_title', true);
        $webex_join_target = get_post_meta($event_id, 'mec_webex_join_target', true);
        $mec_webex_display_join_in_booking = get_post_meta($event_id, 'mec_webex_display_join_in_booking', true);

        $webex_join = ($webex_join_title and $mec_webex_display_join_in_booking == '1')  ? '<div class="mec-event-webex-join-wrap"><strong>'.esc_html('Webex Join:' ,'mec-wi').'</strong> <a class="mec-webex-join-in-booking" href="'.$webex_join_url.'" target="'.$webex_join_target.'">'.$webex_join_title.'</a></div>' : '' ;

        $webex_link_url = get_post_meta($event_id, 'mec_webex_link_url', true);
        $webex_link_title = get_post_meta($event_id, 'mec_webex_link_title', true);
        $webex_link_target = get_post_meta($event_id, 'mec_webex_link_target', true);
        $mec_webex_display_link_in_booking = get_post_meta($event_id, 'mec_webex_display_link_in_booking', true);

        $webex_link = ($webex_link_title and $mec_webex_display_link_in_booking == '1')  ? '<div class="mec-event-webex-link-wrap"><strong>'.esc_html('Webex Link:' ,'mec-wi').'</strong> <a class="mec-webex-link-in-booking" href="'.$webex_link_url.'" target="'.$webex_link_target.'">'.$webex_link_title.'</a></div>' : '' ;

        $webex_display_password_in_booking = get_post_meta($event_id, 'mec_webex_display_password_in_booking', true);
        $webex_password = (get_post_meta($event_id, 'mec_webex_password', true) and $webex_display_password_in_booking == '1') ? '<div class="mec-webex-password-in-booking"><strong>'.esc_html__('Webex Event Password:' ,'mec-wi') . '</strong> <span>' .get_post_meta($event_id, 'mec_webex_password', true) . '</span></div>' : '';
        $mec_confirmed = get_post_meta($book_id, 'mec_confirmed', true);

        if ( !$mec_confirmed ) return;
        $content .= $webex_join . $webex_link . $webex_password;

        return $content;
    }

    public function display_notification_field() {
        ?>
        <li><span>%%webex_join%%</span>: <?php _e('Webex Join', 'mec-wi'); ?></li>
        <li><span>%%webex_link%%</span>: <?php _e('Webex link', 'mec-wi'); ?></li>
        <li><span>%%webex_password%%</span>: <?php _e('Webex password', 'mec-wi'); ?></li>
        <li><span>%%webex_embed%%</span>: <?php _e('Webex embed', 'mec-wi'); ?></li>
        <?php
    }

    public static function add_header_event_detail_to_dashboard() {

        echo '<td>'.__( 'Webex', 'mec-wi').'</td>';
    }

    public static function add_event_detail_to_dashboard( $event_id, $book_id, $event ) {

        if( !$event_id || !$book_id ){

            return;
        }

        $timestamp = get_post_meta( $book_id, 'mec_attention_time_start', true );

        $webex_join_url = get_post_meta($event_id, 'mec_webex_join_url', true);
        $webex_join_title = get_post_meta($event_id, 'mec_webex_join_title', true);
        $webex_join_target = get_post_meta($event_id, 'mec_webex_join_target', true);

        $webex_join = ($webex_join_title)  ? '<a class="mec-event-webex-join" href="'.$webex_join_url.'" target="'.$webex_join_target.'">'.$webex_join_title.'</a>' : '' ;

        $webex_link_url = get_post_meta($event_id, 'mec_webex_link_url', true);
        $webex_link_title = get_post_meta($event_id, 'mec_webex_link_title', true);
        $webex_link_target = get_post_meta($event_id, 'mec_webex_link_target', true);

        $webex_link = ($webex_link_title)  ? '<a class="mec-event-webex-link" href="'.$webex_link_url.'" target="'.$webex_link_target.'">'.$webex_link_title.'</a>' : '' ;

        $webex_embed = get_post_meta($event_id, 'mec_webex_embed', true) ? '<div class="mec-event-webex-embed">'.get_post_meta($event_id, 'mec_webex_embed', true).'</div>' : '';

        $webex_hide_info_before_start = get_post_meta($event_id, 'mec_webex_hide_info_before_start', true);
        $webex_show_info_time = get_post_meta($event_id, 'mec_webex_show_info_time', true);
        $webex_show_info_hm = get_post_meta($event_id, 'mec_webex_show_info_hm', true);

        $mec_webex_hide_info = get_post_meta($event_id, 'mec_webex_hide_info', true);

        $webex_password = (get_post_meta($event_id, 'mec_webex_password', true) ) ? '<div class="mec-webex-password"><strong>'.esc_html__('Password:' ,'mec-wi') . '</strong> <span>' .get_post_meta($event_id, 'mec_webex_password', true) . '</span></div>' : '';

        $html ="";
        if ( !empty($webex_embed) || !empty($webex_join) || !empty($webex_link) || !empty($webex_password)){
            $html = '
                <div class="mec-event-data-fields mec-frontbox">
                    '.$webex_embed.'
                    '.$webex_join.'
                    '.$webex_link.'
                    '.$webex_password.'
                </div>
            ';
        }
        ?>
        <td>
            <?php if( !empty( $html ) ): ?>
                <a class="mec-booking-webex-access-info-link mec-booking-number-of-attendees"  href="#mec_profile_booking_webex_info_<?php echo $book_id; ?>">
                    <?php echo __('<i class="mec-sl-eye"></i>', 'mec-virtual'); ?>
                </a>
                <div id="mec_profile_booking_webex_info_<?php echo $book_id; ?>" class="mec-booking-webex-access-info-content mec-booking-attendees lity-hide">
                    <?php echo $html; ?>
                </div>
            <?php else: ?>
                -
            <?php endif; ?>
        </td>
        <?php
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Webex_Integration\Autoloader')) {
            return;
        }
    }
} //MecWebex
