<?php
/**
*	Plugin Name: MEC Webex Integration
*	Plugin URI: http://webnus.net/modern-events-calendar/
*	Description: Webex Integration
*	Version: 1.2.0
*	Text Domain: mec-wi
*	Domain Path: /languages
*	Author URI: http://webnus.net
**/
namespace MEC_Webex_Integration;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Webex_Integration
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_Webex_Integration_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECWIVERSION' , '1.2.0');
		define('MECWIDIR' , plugin_dir_path(__FILE__));
		define('MECWIURL' , plugin_dir_url(__FILE__));
		define('MECWIDASSETS' , MECWIURL . '/assets/' );
		define('MECWINAME' , 'Webex Integration');
		define('MECWISLUG' , 'mec-webex-integration');
		define('MECWIOPTIONS' , 'mec_webex_integration_options');
		define('MECWITEXTDOMAIN' , 'mec-wi');
		define('MECWIMAINFILEPATH' ,__FILE__);
		define('MECWIABSPATH', dirname(__FILE__));

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
		add_action( 'plugins_loaded', [$This,'addon_load_text_domain'] );
	}

	/**
	 * Load plugin textdomain.
	 */
	public function addon_load_text_domain() {
		load_plugin_textdomain( 'mec-wi', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECWIDIR . DS . 'core' . DS . 'autoloader.php';
	}

} //Base

Base::instance();
