<?php
namespace MECAdvancedReport\App\Libraries;

use MECAdvancedReport\App\Libraries\Bookings;
use MECAdvancedReport\Core\Patterns\SingletonPattern;

// Don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * API.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class API extends SingletonPattern
{
    /**
     * Constructor
     *
     * @since   1.0.0
     */
    public function __construct()
    {
        add_action('rest_api_init', [$this, 'registerResetRout']);
    }

    /**
     * Register Reset Rout
     *
     * @since   1.0.0
     */
    public function registerResetRout()
    {
        register_rest_route('mec', 'attendees', array(
            'methods'  => 'GET',
            'callback' => [$this, 'getAttendees']
        ));
    }

    /**
     * Get Attendees
     *
     * @since   1.0.0
     */
    public function getAttendees($request)
    {
        $allParams = $request->get_params();
        $params = $this->validateParams($allParams);
        $allAttendees = Bookings::instance()->getAttendees();
        $attendees = [];
        foreach ($allAttendees as $attendee) {
            if (isset($params['all'])) {
                $attendees = $allAttendees;
                break;
            }
            if (isset($params['event'])) {
                if (!$params['event']) {
                    continue;
                } elseif (!$this->containsString($attendee['event']['name'], $params['event'])) {
                    continue;
                }
            }
            if (isset($params['orderTime'])) {
                if (!$params['orderTime']) {
                    continue;
                } elseif (!$this->containsString($attendee['orderTime'], $params['orderTime'])) {
                    continue;
                }
            }
            if (isset($params['category'])) {
                if (!$params['category']) {
                    continue;
                } else {
                    $categoryFlag = false;
                    $categoryParamArr = explode(',', $params['category']);
                    foreach ($categoryParamArr as $categoryParam) {
                        foreach ($attendee['categories'] as $attendeeCategory) {
                            if ($this->containsString($attendeeCategory, $categoryParam)) {
                                $categoryFlag = true;
                                break 2;
                            }
                        }
                    }
                    if (!$categoryFlag) {
                        continue;
                    }
                }
            }
            if (isset($params['location'])) {
                if (!$params['location']) {
                    continue;
                } else {
                    $locationFlag = false;
                    $locationParamArr = explode(',', $params['location']);
                    foreach ($locationParamArr as $locationParam) {
                        foreach ($attendee['locations'] as $attendeeLocation) {
                            if ($this->containsString($attendeeLocation, $locationParam)) {
                                $locationFlag = true;
                                break 2;
                            }
                        }
                    }
                    if (!$locationFlag) {
                        continue;
                    }
                }
            }
            if (isset($params['organizer'])) {
                if (!$params['organizer']) {
                    continue;
                } else {
                    $organizerFlag = false;
                    $organizerParamArr = explode(',', $params['organizer']);
                    foreach ($organizerParamArr as $organizerParam) {
                        foreach ($attendee['organizers'] as $attendeeOrganizer) {
                            if ($this->containsString($attendeeOrganizer, $organizerParam)) {
                                $organizerFlag = true;
                                break 2;
                            }
                        }
                    }
                    if (!$organizerFlag) {
                        continue;
                    }
                }
            }
            if (isset($params['status'])) {
                if (!$params['status']) {
                    continue;
                } else {
                    if (isset($params['status']['confirm'])) {
                        if (!$params['status']['confirm']) {
                            continue;
                        } elseif (!$this->containsString($attendee['status']['confirmed']['text'], $params['status']['confirm'])) {
                            continue;
                        }
                    }
                    if (isset($params['status']['verify'])) {
                        if (!$params['status']['verify']) {
                            continue;
                        } elseif (!$this->containsString($attendee['status']['verified']['text'], $params['status']['verify'])) {
                            continue;
                        }
                    }
                }
            }
            unset($attendee['booking']['link']);
            array_push($attendees, $attendee);
        }
        if (empty($params)) {
            return new \WP_Error('emptyParams', 'There is no params in this query', array('status' => 404));
        }
        $response = new \WP_REST_Response($attendees);
        $response->set_status(200);
        return $response;
    }

    /**
     * Params Validation
     *
     * @since   1.0.0
     */
    
    private function validateParams($allParams)
    {
        $validParams = array_flip(['all', 'event', 'orderTime', 'category', 'location', 'organizer', 'status']);
        $params = array_intersect_key($allParams, $validParams);
        if (isset($params['status']) && $params['status']) {
            $statusKeys = array_flip(array_keys($params['status']));
            $statusValidKeys = array_flip(['confirm', 'verify']);
            if (!array_intersect_key($statusKeys, $statusValidKeys)) {
                unset($params['status']);
            } else {
                $params['status'] = array_intersect_key($params['status'], $statusValidKeys);
            }
        }
        return $params;
    }

    /**
     * The string has contained the desired string
     *
     * @since   1.0.0
     */
    private function containsString($string, $desiredString)
    {
        return strpos(trim(strtolower($string)), trim(strtolower($desiredString))) !== false;
    }
}
