<?php
namespace MECAdvancedReport\App\Libraries;

use MECAdvancedReport\Plugin;
use MECAdvancedReport\App\Libraries\Charts;
use MECAdvancedReport\App\Libraries\Bookings;
use MECAdvancedReport\Core\Patterns\SingletonPattern;

// Don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Ajax.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class Ajax extends SingletonPattern
{
    /**
     * Constructor
     *
     * @since   1.0.0
     */
    public function __construct()
    {
        add_action('wp_ajax_mecARSAttendees', [$this, 'attendees']);
        add_action('wp_ajax_mecARSExport', [$this, 'export']);
    }

    public function prepare_bookings_query( $bookingsQuery ){

        $order_by = isset($_REQUEST['orderby']) ? $_REQUEST['orderby'] : '';
        $order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';

        switch( $order_by ){
            case 'bookingID':
                $bookingsQuery['meta_key'] = '';
                $bookingsQuery['orderby'] = 'ID';
                $bookingsQuery['order'] = $order;
                break;
            case 'invoiceID':

                $bookingsQuery['meta_key'] = 'mec_transaction_id';
                $bookingsQuery['orderby'] = 'meta_value';
                $bookingsQuery['order'] = $order;
                break;
            case 'assignedTo':

                $bookingsQuery['meta_key'] = 'sort_php';
                $bookingsQuery['orderby'] = 'php_assigned_to';
                $bookingsQuery['order'] = $order;

                break;
            case 'orderTime':

                $bookingsQuery['meta_key'] = 'mec_booking_time';
                $bookingsQuery['orderby'] = 'meta_value';
                $bookingsQuery['order'] = $order;
                break;
            case 'price':

                $bookingsQuery['meta_key'] = 'sort_php';
                $bookingsQuery['orderby'] = 'php_price';
                $bookingsQuery['order'] = $order;

                break;
            case 'event':

                $bookingsQuery['meta_key'] = 'sort_php';
                $bookingsQuery['orderby'] = 'php_event_title';
                $bookingsQuery['order'] = $order;

                break;
            case 'bookDate':

                $bookingsQuery['meta_key'] = '';
                $bookingsQuery['orderby'] = 'post_date';
                $bookingsQuery['order'] = $order;

                break;
        }

        return $bookingsQuery;
    }

    /**
     * Attendees
     *
     * @since   1.0.0
     */
    public function attendees()
    {
        if (wp_verify_nonce($_REQUEST['nonce'], 'mecARS')) {
            $data = [];
            $eventIDs = isset($_REQUEST['bookingsQuery']['eventIDs']) ? $_REQUEST['bookingsQuery']['eventIDs'] : [];
            $bookingTime = isset($_REQUEST['bookingsQuery']['bookingTime']) ? $_REQUEST['bookingsQuery']['bookingTime'] : [];
            $categoryIDs = isset($_REQUEST['eventsQuery']['categoryIDs']) ? $_REQUEST['eventsQuery']['categoryIDs'] : [];
            $locationIDs = isset($_REQUEST['eventsQuery']['locationIDs']) ? $_REQUEST['eventsQuery']['locationIDs'] : [];
            $organizerIDs = isset($_REQUEST['eventsQuery']['organizerIDs']) ? $_REQUEST['eventsQuery']['organizerIDs'] : [];
            $attendeesType = isset($_REQUEST['attendeesQuery']['type']) ? $_REQUEST['attendeesQuery']['type'] : 'all';
            $attendeesChunkNum = isset($_REQUEST['attendeesQuery']['chunkNum']) ? $_REQUEST['attendeesQuery']['chunkNum'] : 0;
            $attendeesOrder = isset($_REQUEST['attendeesQuery']['order']) && $_REQUEST['attendeesQuery']['order'] ? $_REQUEST['attendeesQuery']['order'] : 0;
            $lineChartsCategoryIDs = isset($_REQUEST['lineChartsQuery']['categoryIDs']) ? $_REQUEST['lineChartsQuery']['categoryIDs'] : [];
            $lineChartsLocationIDs = isset($_REQUEST['lineChartsQuery']['locationIDs']) ? $_REQUEST['lineChartsQuery']['locationIDs'] : [];
            $lineChartsOrganizerIDs = isset($_REQUEST['lineChartsQuery']['organizerIDs']) ? $_REQUEST['lineChartsQuery']['organizerIDs'] : [];
            $lineChartsCategoriesRunning = isset($_REQUEST['lineChartsQuery']['categoriesRunning']) && $_REQUEST['lineChartsQuery']['categoriesRunning'] == 'true' ? $_REQUEST['lineChartsQuery']['categoriesRunning'] : false;
            $lineChartsLocationsRunning = isset($_REQUEST['lineChartsQuery']['locationsRunning']) && $_REQUEST['lineChartsQuery']['locationsRunning'] == 'true' ? $_REQUEST['lineChartsQuery']['locationsRunning'] : false;
            $lineChartsOrganizersRunning = isset($_REQUEST['lineChartsQuery']['organizersRunning']) && $_REQUEST['lineChartsQuery']['organizersRunning'] == 'true' ? $_REQUEST['lineChartsQuery']['organizersRunning'] : false;
            $lineChartsAllRunning = isset($_REQUEST['lineChartsQuery']['allRunning']) && $_REQUEST['lineChartsQuery']['allRunning'] == 'true' ? $_REQUEST['lineChartsQuery']['allRunning'] : false;
            $eventsSelectorRunning = isset($_REQUEST['eventsSelectorRunning']) && $_REQUEST['eventsSelectorRunning'] == 'true' ? true : false;
            $bookingsQuery = [];
            $eventsQuery = [];
            $postsTerms = [];

            $bookingsQuery = $this->prepare_bookings_query( $bookingsQuery );

            // Event Query
            if ($eventIDs) {
                $bookingsQuery['eventIDs']['relation'] = 'OR';
                foreach ($eventIDs as $eventID) {
                    if ($eventsSelectorRunning) {
                        $postTerms = wp_get_post_terms($eventID, ['mec_category', 'mec_location', 'mec_organizer'], ['fields' => 'all']);
                        if (!$postsTerms) {
                            $postsTerms = $postTerms;
                        } else {
                            if ($postTerms) {
                                $postsTermsIDs = array_map(function ($postsTerm) {
                                    return $postsTerm->term_id;
                                }, $postsTerms);
                                foreach ($postTerms as $postTerm) {
                                    if (!in_array($postTerm->term_id, $postsTermsIDs)) {
                                        array_push($postsTerms, $postTerm);
                                    }
                                }
                            }
                        }
                    }
                }

                $bookingsQuery['eventIDs']['p'] = [
                    'key' => 'mec_event_id',
                    'value' => $eventIDs,
                    'compare' => 'IN',
                ];
            } else {
                $bookingsQuery['eventIDs'] = [];
            }
            // Time Query
            if ($bookingTime) {
                $bookingsQuery['bookingTime'] = [
                    'key' => 'mec_booking_time',
                    'value' => [date('Y-m-d', strtotime($bookingTime[0])), date('Y-m-d', strtotime($bookingTime[1]))],
                    'type' => 'DATE',
                    'compare' => 'BETWEEN',
                ];
            } else {
                $bookingsQuery['bookingTime'] = [];
            }
            // Category Query
            $eventsQuery['categoryIDs'] = !empty($categoryIDs) ? (array)$categoryIDs : (array)$lineChartsCategoryIDs;
            // Location Query
            $eventsQuery['locationIDs'] = !empty($locationIDs) ? (array)$locationIDs : (array)$lineChartsLocationIDs;
            // Organizer Query
            $eventsQuery['organizerIDs'] = !empty($organizerIDs) ? (array)$organizerIDs : (array)$lineChartsOrganizerIDs;
            // Get Data
            $attendees = Bookings::instance()->getAttendees($attendeesType, $bookingsQuery, $eventsQuery);
            if ($lineChartsLocationsRunning) {
                $data['charts']['lineCharts']['locations'] = Charts::instance()->getLineChartData('locations', $attendees, $lineChartsLocationIDs);
            } elseif ($lineChartsOrganizersRunning) {
                $data['charts']['lineCharts']['organizers'] = Charts::instance()->getLineChartData('organizers', $attendees, $lineChartsOrganizerIDs);
            } elseif ($lineChartsCategoriesRunning) {
                $data['charts']['lineCharts']['categories'] = Charts::instance()->getLineChartData('categories', $attendees, $lineChartsCategoryIDs);
            }

            if ($lineChartsAllRunning) {
                $data['charts']['lineCharts']['locations'] = Charts::instance()->getLineChartData('locations', $attendees, $lineChartsLocationIDs);
                $data['charts']['lineCharts']['organizers'] = Charts::instance()->getLineChartData('organizers', $attendees, $lineChartsOrganizerIDs);
                $data['charts']['lineCharts']['categories'] = Charts::instance()->getLineChartData('categories', $attendees, $lineChartsCategoryIDs);
                $data['charts']['doughnutChart'] = Charts::instance()->getDoughnutChartData($attendees);
            }

            if(
                ( !empty($eventsQuery['categoryIDs']) || !empty($eventsQuery['locationIDs']) || !empty($eventsQuery['organizerIDs']) )
                &&
                (!isset($bookingsQuery['eventIDs']['p']['value']) || empty($bookingsQuery['eventIDs']['p']['value']))
                ){

                $bookingsQuery['eventIDs']['p'] = [
                    'key' => 'mec_event_id',
                    'value' => Bookings::instance()->get_event_ids($eventsQuery),
                    'compare' => 'IN',
                ];
            }
            $data['statistics'] = Bookings::instance()->getBookingsStatistics($bookingsQuery);

            $attendeesChunk = $attendees ? array_chunk($attendees, 15) : [];
            $attendeesChunkKeys = array_filter(array_keys($attendeesChunk), function ($key) use ($attendeesChunkNum) {
                return $key > $attendeesChunkNum;
            });
            $data['maxChunkNum'] = count($attendeesChunkKeys);
            ob_start();
            $attendeesFirstChunk = $attendeesChunk ? $attendeesChunk[$attendeesChunkNum] : [];
            Bookings::instance()->renderAttendeesList($attendeesFirstChunk, $attendeesOrder);
            $data['html'] = ob_get_clean();
            $data['pagination'] = '<div class="pagination">'.Bookings::instance()->pagination.'</div>';
            $data['attendeesOrder'] = count($attendeesFirstChunk);

            if(isset($data['charts']['lineCharts']) && is_array($data['charts']['lineCharts'])){

                if ($bookingTime) {

                    $start_date = date_i18n('d F', strtotime($bookingTime[0]));
                    $end_date   = date_i18n('d F', strtotime($bookingTime[1]));
                }
                /**
                 * $type example locations
                 * $groups array of sales,attendees,labels
                 */
                foreach($data['charts']['lineCharts'] as $type => $groups){

                    if ($bookingTime) {

                        if(false == array_search($start_date,$groups[$type]['labels']??array())){

                            $add_start = true;
                            array_unshift($data['charts']['lineCharts'][$type]['labels'],$start_date);
                            array_unshift($data['charts']['lineCharts'][$type]['sales'],0);
                            array_unshift($data['charts']['lineCharts'][$type]['attendees'],0);
                        }

                        if(false == array_search($end_date,$groups[$type]['labels']??array())){

                            $add_end = true;
                            array_push($data['charts']['lineCharts'][$type]['labels'],$end_date);
                            array_push($data['charts']['lineCharts'][$type]['sales'],0);
                            array_push($data['charts']['lineCharts'][$type]['attendees'],0);
                        }
                    }
                }
            }

            if ($postsTerms) {
                $groupedTerms = [];
                foreach ($postsTerms as $term) {
                    $groupedTerms[$term->taxonomy][] = ['id' => $term->term_id, 'text' => $term->name];
                }
                $data['terms'] = $groupedTerms;
            }
            // Paste Data
            echo wp_json_encode($data);
        }
        wp_die();
    }

    /**
     * Export
     *
     * @since   1.0.0
     */
    public function export()
    {
        if (wp_verify_nonce($_REQUEST['nonce'], 'mecARS')) {
            $data = [];
            $eventIDs = isset($_GET['bookingsQuery']['eventIDs']) ? $_GET['bookingsQuery']['eventIDs'] : [];
            $bookingTime = isset($_GET['bookingsQuery']['bookingTime']) ? $_GET['bookingsQuery']['bookingTime'] : [];
            $categoryIDs = isset($_GET['eventsQuery']['categoryIDs']) ? $_GET['eventsQuery']['categoryIDs'] : [];
            $locationIDs = isset($_GET['eventsQuery']['locationIDs']) ? $_GET['eventsQuery']['locationIDs'] : [];
            $organizerIDs = isset($_GET['eventsQuery']['organizerIDs']) ? $_GET['eventsQuery']['organizerIDs'] : [];
            $attendeesType = isset($_GET['attendeesQuery']['type']) ? $_GET['attendeesQuery']['type'] : 'all';
            $attendeesChunkNum = isset($_GET['attendeesQuery']['chunkNum']) ? $_GET['attendeesQuery']['chunkNum'] : 0;
            $selectedAttendees = isset($_GET['selectedAttendees']) ? $_GET['selectedAttendees'] : [];
            $eventsSelectorRunning = isset($_GET['eventsSelectorRunning']) && $_GET['eventsSelectorRunning'] == 'true' ? true : false;
            $exportType = isset($_GET['exportType']) ? $_GET['exportType'] : 'json';
            $bookingsQuery = [];
            $eventsQuery = [];
            $postsTerms = [];

            $bookingsQuery = $this->prepare_bookings_query( $bookingsQuery );

            // Event Query
            if ($eventIDs) {
                $bookingsQuery['eventIDs']['relation'] = 'OR';
                foreach ($eventIDs as $eventID) {
                    $bookingsQuery['eventIDs'][] = [
                        'key' => 'mec_event_id',
                        'value' => $eventID,
                        'compare' => '=',
                    ];
                    if ($eventsSelectorRunning) {
                        $postTerms = wp_get_post_terms($eventID, ['mec_category', 'mec_location', 'mec_organizer'], ['fields' => 'all']);
                        if (!$postsTerms) {
                            $postsTerms = $postTerms;
                        } else {
                            if ($postTerms) {
                                $postsTermsIDs = array_map(function ($postsTerm) {
                                    return $postsTerm->term_id;
                                }, $postsTerms);
                                foreach ($postTerms as $postTerm) {
                                    if (!in_array($postTerm->term_id, $postsTermsIDs)) {
                                        array_push($postsTerms, $postTerm);
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                $bookingsQuery['eventIDs'] = [];
            }
            // Time Query
            if ($bookingTime) {
                $bookingsQuery['bookingTime'] = [
                    'key' => 'mec_booking_time',
                    'value' => [date('Y-m-d', strtotime($bookingTime[0])), date('Y-m-d', strtotime($bookingTime[1]))],
                    'type' => 'DATE',
                    'compare' => 'BETWEEN',
                ];
            } else {
                $bookingsQuery['bookingTime'] = [];
            }
            // Category Query
            $eventsQuery['categoryIDs'] = $categoryIDs;
            // Location Query
            $eventsQuery['locationIDs'] = $locationIDs;
            // Organizer Query
            $eventsQuery['organizerIDs'] = $organizerIDs;
            // Get Data

            $attendees = Bookings::instance()->getAttendees($attendeesType, $bookingsQuery, $eventsQuery);
            if ($selectedAttendees) {

                foreach ($selectedAttendees as $selectedAttendee) {
                    $currentAttendee = $attendees[$selectedAttendee];
                    unset($currentAttendee['categories']);
                    unset($currentAttendee['locations']);
                    unset($currentAttendee['organizers']);
                    unset($currentAttendee['gateway']);
                    $currentAttendee['booking'] = $currentAttendee['booking']['id'];
                    $currentAttendee['invoice'] = $currentAttendee['invoice']['id'];
                    $currentAttendee['price'] = \MEC\Base::get_main()->render_price( round($currentAttendee['price'], 2) );
                    $currentAttendee['event'] = $currentAttendee['event']['name'];
                    $currentAttendee['confirmation'] = $currentAttendee['status']['confirmed']['text'];
                    $currentAttendee['verification'] = $currentAttendee['status']['verified']['text'];
                    $currentAttendee['ticketVariation'] = $currentAttendee['ticketVariation'];
                    unset($currentAttendee['status']);
                    array_push($data, $currentAttendee);
                }
            } else if($attendeesType == 'allAttendees' || $attendeesType == 'all') {

                foreach ($attendees as $Attendee) {
                    $currentAttendee = $Attendee;
                    unset($currentAttendee['categories']);
                    unset($currentAttendee['locations']);
                    unset($currentAttendee['organizers']);
                    unset($currentAttendee['gateway']);
                    $currentAttendee['booking'] = $currentAttendee['booking']['id'];
                    $currentAttendee['invoice'] = $currentAttendee['invoice']['id'];
                    $currentAttendee['price'] = \MEC\Base::get_main()->render_price( round($currentAttendee['price'], 2) );
                    $currentAttendee['event'] = $currentAttendee['event']['name'];
                    $currentAttendee['confirmation'] = $currentAttendee['status']['confirmed']['text'];
                    $currentAttendee['verification'] = $currentAttendee['status']['verified']['text'];
                    $currentAttendee['ticketVariation'] = $currentAttendee['ticketVariation'];
                    unset($currentAttendee['status']);
                    array_push($data, $currentAttendee);
                }
            }

            // Generate File
            $fileName = 'mec-advanced-reports-' . time();
            if ($exportType == 'json') {
                $data = wp_json_encode($data, JSON_UNESCAPED_UNICODE);
                header('Content-Description: File Transfer');
                header('Pragma: public');
                header('Cache-Control: must-revalidate');
                header('Expires: 0');
                header('Content-type: application/txt');
                header('Content-Disposition: attachment; filename="' . $fileName . '.json"');
                header('Content-Transfer-Encoding: binary');
                echo wp_unslash($data);
            } elseif ($exportType == 'csv') {
                header('Content-Description: File Transfer');
                header('Pragma: public');
                header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                header('Expires: 0');
                header('Content-type: text/csv');
                header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
                $fh = @fopen('php://output', 'w');
                fwrite($fh, chr(0xEF) . chr(0xBB) . chr(0xBF));
                $header = true;
                foreach ($data as $dataItem) {
                    if ($header) {
                        fputcsv($fh, array_keys($dataItem));
                        $header = false;
                    }
                    fputcsv($fh, array_values($dataItem));
                }
                fclose($fh);
            } elseif ($exportType == 'xml') {
                $xml = new \DOMDocument('1.0', 'utf-8');
                $rootNode = $xml->appendChild($xml->createElement("items"));
                foreach ($data as $dataItem) {
                    if (!empty($dataItem)) {
                        $itemNode = $rootNode->appendChild($xml->createElement('item'));
                        foreach ($dataItem as $k => $v) {
                            $itemNode->appendChild($xml->createElement($k, $v));
                        }
                    }
                }
                $xml->formatOutput = true;
                $xml->save($fileName);
                header('Content-Description: File Transfer');
                header('Content-Type: application/xml');
                header('Content-Disposition: attachment; filename="' . $fileName . '.xml"');
                header('Content-Transfer-Encoding: binary');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                ob_clean();
                flush();
                readfile($fileName);
                exec('rm ' . $fileName);
            }
        }
        wp_die();
    }
}
