<?php
namespace MECAdvancedReport\App\Libraries;

use MECAdvancedReport\Core\Patterns\SingletonPattern;

// Don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Events.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class Events extends SingletonPattern
{
    /**
     * Events Property
     *
     * @since   1.0.0
     */
    public $events;

    /**
     * Terms Property
     *
     * @since   1.0.0
     */
    public $terms;

    /**
     * Constructor
     *
     * @since   1.0.0
     */
    public function __construct()
    {
    }

    /**
     * Get Events
     *
     * @since   1.0.0
     */
    public function getEvents($numberPosts = -1)
    {

        if( !empty( $this->events ) ){

            return $this->events;
        }

        $postType = apply_filters('mec_post_type_name', 'mec-events');
        return $this->events = get_posts([
            'post_type' => $postType,
            'numberposts' => $numberPosts,
            'suppress_filters' => false,
            'orderby' => 'date',
            'order' => 'DESC',
            'post_status' => 'publish',
        ]);
    }

    /**
     * Get Terms
     *
     * @since   1.0.0
     */
    public function getTerms()
    {

        if( !empty( $this->terms ) ){

            return $this->terms;
        }

        $this->terms['categories'] = get_terms([
            'taxonomy' => 'mec_category',
            'hide_empty' => false,
        ]);
        $this->terms['locations'] = get_terms([
            'taxonomy' => 'mec_location',
            'hide_empty' => false,
        ]);
        $this->terms['organizers'] = get_terms([
            'taxonomy' => 'mec_organizer',
            'hide_empty' => false,
        ]);

        return $this->terms;
    }

    /**
     * Render Events Dropdown
     *
     * @since   1.0.0
     */
    public function renderEventsDropdown()
    {
        $this->getEvents();
        ?>
        <select class="mec-ars-form-control" name="mec-ars-events-selector" autocomplete="off" multiple data-placeholder="<?php esc_html_e('Select Event Name', 'mec-ars'); ?>">
            <?php if ($this->events) { ?>
                <?php foreach ($this->events as $event) { ?>
                    <option value="<?php echo esc_attr($event->ID); ?>"><?php echo esc_html($event->post_title); ?></option>
                <?php } ?>
            <?php } ?>
        </select>
        <?php
    }

    /**
     * Render Events Categories Dropdown
     *
     * @since   1.0.0
     */
    public function renderCategoriesDropdown()
    {

        $this->getTerms();
        ?>
        <select class="mec-ars-form-control" name="mec-ars-categories-selector" autocomplete="off" multiple data-placeholder="<?php esc_html_e('Select Categories', 'mec-ars'); ?>">
            <?php if ($this->terms['categories']) { ?>
                <?php foreach ($this->terms['categories'] as $category) { ?>
                    <option value="<?php echo esc_attr($category->term_id); ?>"><?php echo esc_html($category->name); ?></option>
                <?php } ?>
            <?php } ?>
        </select>
        <?php
    }

    /**
     * Render Events Locations Dropdown
     *
     * @since   1.0.0
     */
    public function renderLocationsDropdown()
    {
        $this->getTerms();
        ?>
        <select class="mec-ars-form-control" name="mec-ars-locations-selector" autocomplete="off" multiple data-placeholder="<?php esc_html_e('Select Locations', 'mec-ars'); ?>">
            <?php if ($this->terms['locations']) { ?>
                <?php foreach ($this->terms['locations'] as $location) { ?>
                    <option value="<?php echo esc_attr($location->term_id); ?>"><?php echo esc_html($location->name); ?></option>
                <?php } ?>
            <?php } ?>
        </select>
        <?php
    }

    /**
     * Render Events Organizers Dropdown
     *
     * @since   1.0.0
     */
    public function renderOrganizersDropdown()
    {
        $this->getTerms();
        ?>
        <select class="mec-ars-form-control" name="mec-ars-organizers-selector" autocomplete="off" multiple data-placeholder="<?php esc_html_e('Select Organizers', 'mec-ars'); ?>">
            <?php if ($this->terms['organizers']) { ?>
                <?php foreach ($this->terms['organizers'] as $organizer) { ?>
                    <option value="<?php echo esc_attr($organizer->term_id); ?>"><?php echo esc_html($organizer->name); ?></option>
                <?php } ?>
            <?php } ?>
        </select>
        <?php
    }
}
