<?php
namespace MECAdvancedReport\App\Pages;

use MECAdvancedReport\Core\Patterns\SingletonPattern;
use MECAdvancedReport\App\Libraries\Events;
use MECAdvancedReport\App\Libraries\Charts;
use MECAdvancedReport\App\Libraries\Bookings;

// Don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Index.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class Index extends SingletonPattern
{
    /**
     * Constructor
     *
     * @since   1.0.0
     */
    public function __construct()
    {
        add_action('admin_menu', [$this, 'createPage'], 99999);
    }

    /**
     * Create Page
     *
     * @since   1.0.0
     */
    public function createPage()
    {
        global $submenu;
        add_submenu_page(
            'mec-intro',
            esc_html__('Advanced Reports', 'mec-ars'),
            esc_html__('Advanced Reports', 'mec-ars'),
            'edit_posts',
            'mec-advanced-report',
            [$this, 'pageContent']
        );
        // Rename MEC Report
        if (isset($submenu['mec-intro'])) {
            foreach ($submenu['mec-intro'] as $key => $mecMenus) {
                if ($mecMenus[2] == 'MEC-report') {
                    $submenu['mec-intro'][$key][0] = esc_html__('Promote', 'mec-ars');
                }
            }
        }
    }

    /**
     * Page Content
     *
     * @since   1.0.0
     */
    public function pageContent()
    {
        ?>
        <div class="mec-ars-wrap" id="mec-ars-wrap">
            <!-- Preloader -->
            <div class="mec-ars-make-wrap-empty mec-ars-active"></div>
            <div class="mec-ars-flex mec-ars-justify-content-center mec-ars-preloader" id="mec-ars-wrap-preloader">
                <div class="sk-pulse"></div>
            </div>
            <script>
                document.getElementById('mec-ars-wrap-preloader').classList.add('mec-ars-active');
            </script>
            <div class="mec-ars-header-name-version">
                <h1 class="ars-name"><?php echo __('Advanced Reports', 'mec-ars'); ?></h1>
                <span class="w-theme-version"><?php echo __('Version ', 'mec-ars'); ?><?php echo MECARSVERSION; ?></span>
            </div>
            <!-- Header -->
            <header class="mec-ars-header mec-ars-active" id="mec-ars-header">
                <div class="mec-ars-flex mec-ars-justify-content-between mec-form-row">
                    <div class="mec-ars-flex-item">
                        <?php Events::instance()->renderEventsDropdown(); ?>
                    </div>
                    <div class="mec-ars-flex-item">
                        <input class="mec-ars-form-control" type="text" name="mec-ars-daterange" placeholder="<?php esc_attr_e('Pick a Date Range', 'mec-ars'); ?>" data-opens="left" autocomplete="off">
                    </div>
                </div>
            </header>
            <!-- Sections -->
            <div class="mec-ars-sections mec-ars-active" id="mec-ars-sections">
                <section class="mec-ars-section" id="mec-ars-section-statistics">
                    <?php $bookingsStatistics = Bookings::instance()->getBookingsStatistics(); ?>
                    <div class="mec-ars-flex">
                        <div class="mec-ars-flex-item">
                            <?php Bookings::instance()->renderAllAttendeesNumber(isset($bookingsStatistics['allAttendees']) ? $bookingsStatistics['allAttendees'] : 0); ?>
                        </div>
                        <div class="mec-ars-flex-item">
                            <?php Bookings::instance()->renderAllBookingsNumber(isset($bookingsStatistics['all']) ? $bookingsStatistics['all'] : 0); ?>
                        </div>
                        <div class="mec-ars-flex-item">
                            <?php Bookings::instance()->renderConfirmedBookingsNumber(isset($bookingsStatistics['confirmed']) ? $bookingsStatistics['confirmed'] : 0); ?>
                        </div>
                        <div class="mec-ars-flex-item">
                            <?php Bookings::instance()->renderVerifiedBookingsNumber(isset($bookingsStatistics['verified']) ? $bookingsStatistics['verified'] : 0); ?>
                        </div>
                        <div class="mec-ars-flex-item">
                            <?php Bookings::instance()->renderTotalIncome(isset($bookingsStatistics['income']) ? $bookingsStatistics['income'] : 0); ?>
                        </div>
                    </div>
                </section>
                <!-- Charts -->
                <section class="mec-ars-section" id="mec-ars-section-charts">
                    <div class="mec-ars-flex">
                        <div class="mec-ars-flex-item" id="mec-ars-line-charts">
                            <?php Charts::instance()->renderLineCharts(); ?>
                        </div>
                        <div class="mec-ars-flex-item" id="mec-ars-doughnut-chart">
                            <?php Charts::instance()->renderDoughnutChart(); ?>
                        </div>
                    </div>
                </section>
                <!-- Attendees -->
                <section class="mec-ars-section" id="mec-ars-section-attendees">
                    <div class="mec-ars-attendees-all">
                        <div class="mec-ars-title">
                            <h2><?php esc_html_e('All Attendees', 'mec-ars'); ?></h2>
                        </div>
                        <?php Bookings::instance()->renderAttendees('all', false); ?>
                    </div>
                </section>
            </div>
            <!-- Modals -->
            <div class="mec-ars-modals" id="mec-ars-modals">
                <span id="mec-ars-close-modals"><?php esc_html_e('Back', 'mec-ars'); ?></span>
                <div class="mec-ars-modal-item mec-ars-attendees-all">
                    <div class="mec-ars-title">
                        <h2><?php esc_html_e('All Bookings', 'mec-ars'); ?></h2>
                    </div>
                    <?php Bookings::instance()->renderAttendees('all'); ?>
                </div>
                <div class="mec-ars-modal-item mec-ars-attendees-confirmed">
                    <div class="mec-ars-title">
                        <h2><?php esc_html_e('Confirmed Bookings', 'mec-ars'); ?></h2>
                    </div>
                    <?php Bookings::instance()->renderAttendees('confirmed'); ?>
                </div>
                <div class="mec-ars-modal-item mec-ars-attendees-verified">
                    <div class="mec-ars-title">
                        <h2><?php esc_html_e('Verified Bookings', 'mec-ars'); ?></h2>
                    </div>
                    <?php Bookings::instance()->renderAttendees('verified'); ?>
                </div>
            </div>
                <div class="pagination">
                    <?php
                        echo Bookings::instance()->pagination;
                    ?>
                </div>
        </div> <!-- .mec-ars-wrap -->
        <?php
    }
}
