const UICtrl = (function ($) {
    const UISelectors = {
        window: $(window),
        wrap: $('#mec-ars-wrap'),
        modals: $('#mec-ars-modals'),
        lineCharts: {},
        doughnutCharts: {},
    };

    return {
        index: function () {
            UICtrl.select2();
            UICtrl.daterange();
            UICtrl.lineChart('mec-ars-locations-chart-canvas', 'locations');
            UICtrl.lineChart('mec-ars-organizers-chart-canvas', 'organizers');
            UICtrl.lineChart('mec-ars-categories-chart-canvas', 'categories');
            UICtrl.doughnutChart('mec-ars-gateways-chart-canvas', 'gateways', 'mec-ars-gateways-chart-legends');
        },
        select2: function () {
            UISelectors.wrap.find('select').select2({
                placeholder: $(this).data('placeholder'),
            });
        },
        daterange: function () {
            UISelectors.wrap.find('input[name="mec-ars-daterange"]').each(function () {
                const opens = $(this).data('opens') ? $(this).data('opens') : 'right';
                $(this).daterangepicker({
                    parentEl: '#mec-ars-wrap',
                    autoApply: true,
                    opens: opens,
                    autoUpdateInput: false,
                    locale: {
                        format: 'MMMM DD, YYYY'
                    },
                });
            });
        },
        lineChart: function (chartID, chartName) {
            const config = {
                type: 'line',
                data: {
                    labels: mecARS.lineCharts.data.labels,
                    datasets: [{
                        label: mecARS.lineCharts.attendeesLabel,
                        fill: false,
                        lineTension: 0.1,
                        yAxisID: 'attendees',
                        backgroundColor: '#FFBE0C',
                        borderColor: '#FFBE0C',
                        pointBorderWidth: 2,
                        pointBackgroundColor: '#fff',
                        pointHoverBackgroundColor: '#FFBE0C',
                        data: mecARS.lineCharts.data.attendees,
                    }, {
                        label: mecARS.lineCharts.salesLabel,
                        fill: false,
                        lineTension: 0.1,
                        yAxisID: 'sales',
                        backgroundColor: '#00ACF8',
                        borderColor: '#00ACF8',
                        pointBorderWidth: 2,
                        pointBackgroundColor: '#fff',
                        pointHoverBackgroundColor: '#00ACF8',
                        data: mecARS.lineCharts.data.sales,
                    }]
                },
                options: {
                    responsive: true,
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 20,
                        }
                    },
                    title: {
                        display: false,
                    },
                    tooltips: {
                        intersect: false,
                        callbacks: {
                            label: function (tooltipItem, data) {
                                const dataset = data.datasets[tooltipItem.datasetIndex];
                                if (dataset.yAxisID == 'sales') {
                                    const currentValue = dataset.data[tooltipItem.index];
                                    const price = currentValue.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
                                    return `${mecARS.lineCharts.salesCurrencySing ? mecARS.lineCharts.salesCurrencySing + price : '$' + price}`;
                                } else {
                                    return dataset.data[tooltipItem.index];
                                }
                            }
                        }
                    },
                    hover: {
                        mode: 'nearest',
                        intersect: true
                    },
                    scales: {
                        xAxes: [{
                            display: true,
                            ticks: {
                                maxTicksLimit: 11,
                                padding: 10,
                            },
                            gridLines: {
                                display: true,
                            },
                        }],
                        yAxes: [{
                            id: 'attendees',
                            type: 'linear',
                            position: 'right',
                            ticks: {
                                min: 0,
                                fontColor: '#FFBE0C',
                            },
                            gridLines: {
                                display: false,
                            },
                        }, {
                            id: 'sales',
                            type: 'linear',
                            position: 'right',
                            ticks: {
                                min: 0,
                                fontColor: '#00ACF8',
                                callback: function (value, index, values) {
                                    return mecARS.lineCharts.salesCurrencySing ? mecARS.lineCharts.salesCurrencySing + value : '$' + value;
                                }
                            },
                            gridLines: {
                                display: true,
                            },
                        }]
                    }
                }
            };
            const chart = document.getElementById(chartID).getContext('2d');
            UISelectors.lineCharts[chartName] = new Chart(chart, config);
            UISelectors.lineCharts[chartName].resize();
        },
        doughnutChart: function (chartID, chartName, legendsContainer) {
            const config = {
                type: 'doughnut',
                data: {
                    labels: mecARS.doughnutChart.labels,
                    datasets: [{
                        data: mecARS.doughnutChart.sales,
                        backgroundColor: [
                            '#00ACF8',
                            '#FFBE0C',
                            '#1CE1AC',
                            '#8a43eb',
                            '#FF017E',
                            '#ff9800',
                        ],
                    }],
                },
                options: {
                    responsive: true,
                    elements: {
                        arc: {
                            borderWidth: 0.5
                        }
                    },
                    cutoutPercentage: 80,
                    aspectRatio: 1,
                    legend: {
                        position: 'bottom',
                        labels: {
                            boxWidth: 9,
                            usePointStyle: true,
                            padding: 18,
                            filter: function (item, chart) {
                                return !item.text.includes('mecArsEmptyLabel');
                            }
                        }
                    },
                    legendCallback: function (chart) {
                        let legendHTML = '';
                        const dataset = chart.data.datasets[0];
                        const total = dataset.data.reduce((total, value) => total + value, 0);

                        for (let i = 0; i < dataset.data.length; i++) {
                            const currentValue = dataset.data[i];
                            const label = chart.data.labels[i];
                            if (label == 'mecArsEmptyLabel') {
                                continue;
                            }
                            const percentage = ((currentValue / total) * 100).toFixed(1) + '%';
                            const price = currentValue.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
                            legendHTML += `
                            <li class="mec-ars-flex">
                                <div class="mec-ars-flex-item">
                                    <span class="mec-ars-current-value">${mecARS.lineCharts.salesCurrencySing ? mecARS.lineCharts.salesCurrencySing + price : '$' + price}</span>
                                    <span class="mec-ars-label">${label}</span>
                                </div>
                                <div class="mec-ars-flex-item mec-ars-flex mec-ars-justify-content-between">
                                    <span class="mec-ars-percentage-number">${percentage}</span>
                                    <span class="mec-ars-percentage">
                                        <span class="mec-ars-progressbar" style="background-color: ${dataset.backgroundColor[i]}; width: ${percentage};"></span>
                                    </span>
                                </div>
                            </li>`;
                        }
                        return legendHTML;
                    },
                    title: {
                        display: false,
                    },
                    animation: {
                        animateScale: true,
                        animateRotate: true,
                    },
                    tooltips: {
                        callbacks: {
                            label: function (tooltipItem, data) {
                                const dataset = data.datasets[tooltipItem.datasetIndex];
                                const currentValue = dataset.data[tooltipItem.index];
                                const price = currentValue.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
                                return `${mecARS.lineCharts.salesCurrencySing ? mecARS.lineCharts.salesCurrencySing + price : '$' + price}`;
                            }
                        }
                    }
                }
            };
            const chart = document.getElementById(chartID).getContext('2d');
            UISelectors.doughnutCharts[chartName] = new Chart(chart, config);
            UISelectors.doughnutCharts[chartName].resize();
            if (mecARS.doughnutChart.labels[0] == 'mecArsEmptyLabel') {
                UISelectors.doughnutCharts[chartName].data.datasets[0].backgroundColor.unshift('#e3e3e3');
                UISelectors.doughnutCharts[chartName].options.tooltips.enabled = false;
                UISelectors.doughnutCharts[chartName].update();
            }
            document.getElementById(legendsContainer).innerHTML = UISelectors.doughnutCharts[chartName].generateLegend();
        },
        preloaderToggle: function (parent = UISelectors.wrap) {
            parent.children('.mec-ars-preloader').toggleClass('mec-ars-active');
        },
        wrapPreloaderToggle: function () {
            UISelectors.wrap.children('.mec-ars-preloader').toggleClass('mec-ars-active');
        },
        loadMorePreloaderToggle: function (parent = UISelectors.wrap) {
            const preloaderHTML = `
            <div class="mec-ars-flex mec-ars-justify-content-center mec-ars-load-more-preloader">
                <div class="mec-ars-flex-item">
                    <div class="sk-pulse mec-ars-load-more-preloader-spin"></div>
                </div>
            </div>`;
            parent.toggleClass('mec-ars-load-more-preloader-active');
            if (parent.hasClass('mec-ars-load-more-preloader-active')) {
                parent.append(preloaderHTML);
            } else {
                parent.find('.mec-ars-load-more-preloader').remove();
            }
        },
        getUISelectors: function () {
            return UISelectors;
        },
    };
})(jQuery);

const EventCtrl = (function ($) {
    const UISelectors = UICtrl.getUISelectors();
    const eventData = {
        mainAttendeesQuery: {
            bookings: {},
            events: {},
            attendees: {
                type: 'all',
                chunkNum: 0,
                maxChunkNum: mecARS.attendeesQueryInit.allMaxChunkNumZero ? 0 : undefined,
                order: 15,
            },
        },
        allAttendeesQuery: {
            bookings: {},
            events: {},
            attendees: {
                type: 'all',
                chunkNum: 0,
                maxChunkNum: mecARS.attendeesQueryInit.allMaxChunkNumZero ? 0 : undefined,
                order: 15,
            },
        },
        allAttendeesQueryW: {
            bookings: {},
            events: {},
            attendees: {
                type: 'allAttendees',
                chunkNum: 0,
                maxChunkNum: mecARS.attendeesQueryInit.allMaxChunkNumZero ? 0 : undefined,
                order: 15,
            },
        },
        confirmedAttendeesQuery: {
            bookings: {},
            events: {},
            attendees: {
                type: 'confirmed',
                chunkNum: 0,
                maxChunkNum: mecARS.attendeesQueryInit.confirmedMaxChunkNumZero ? 0 : undefined,
                order: 15,
            },
        },
        verifiedAttendeesQuery: {
            bookings: {},
            events: {},
            attendees: {
                type: 'verified',
                chunkNum: 0,
                maxChunkNum: mecARS.attendeesQueryInit.verifiedMaxChunkNumZero ? 0 : undefined,
                order: 15,
            },
        },
        lineChartsQuery: {},
        eventsSelectorRunning: false,
        scrollController: {
            headerAttendees: false,
            allAttendees: false,
            confirmedAttendees: false,
            verifiedAttendees: false,
        },
    };

    return {
        index: function () {
            // Window Load
            UISelectors.window.on('load', EventCtrl.windowLoad);
            // Tabs
            UISelectors.wrap.find('.mec-ars-tabs-nav').find('li a').on('click', EventCtrl.tabs);
            // Modals
            UISelectors.wrap.find('.mec-ars-statistics-item').not('.mec-ars-all-attendees-number').on('click', EventCtrl.openModal);
            UISelectors.wrap.find('#mec-ars-close-modals').on('click', EventCtrl.closeModal);
            // Common
            UISelectors.wrap.find('input[name="mec-ars-daterange"]').on('apply.daterangepicker', EventCtrl.daterange);
            // Main Attendees
            UISelectors.wrap.children('header').find('select[name="mec-ars-events-selector"]').on('change', EventCtrl.headerEventsSelector);
            UISelectors.wrap.children('.pagination').find('.page-numbers').on('click', EventCtrl.paginationClick);

            UISelectors.wrap.children('header').find('input[name="mec-ars-daterange"]').on('apply.daterangepicker', EventCtrl.headerDaterange);
            // Line Charts
            UISelectors.wrap.find('#mec-ars-line-charts').find('select[name="mec-ars-categories-selector"]').on('change', EventCtrl.lineChartsCategoriesSelector);
            UISelectors.wrap.find('#mec-ars-line-charts').find('select[name="mec-ars-locations-selector"]').on('change', EventCtrl.lineChartsLocationsSelector);
            UISelectors.wrap.find('#mec-ars-line-charts').find('select[name="mec-ars-organizers-selector"]').on('change', EventCtrl.lineChartsOrganizersSelector);
            // All Attendees
            UISelectors.modals.find('.mec-ars-attendees-all').find('.mec-ars-attendees-filter').find('select[name="mec-ars-events-selector"]').on('change', EventCtrl.allAttendeesEventsSelector);
            UISelectors.modals.find('.mec-ars-attendees-all').find('.mec-ars-attendees-filter').find('input[name="mec-ars-daterange"]').on('apply.daterangepicker', EventCtrl.allAttendeesDaterange);
            UISelectors.modals.find('.mec-ars-attendees-all').find('.mec-ars-attendees-filter').find('select[name="mec-ars-categories-selector"]').on('change', EventCtrl.allAttendeesCategoriesSelector);
            UISelectors.modals.find('.mec-ars-attendees-all').find('.mec-ars-attendees-filter').find('select[name="mec-ars-locations-selector"]').on('change', EventCtrl.allAttendeesLocationsSelector);
            UISelectors.modals.find('.mec-ars-attendees-all').find('.mec-ars-attendees-filter').find('select[name="mec-ars-organizers-selector"]').on('change', EventCtrl.allAttendeesOrganizersSelector);
            // Confirmed Attendees
            UISelectors.modals.find('.mec-ars-attendees-confirmed').find('.mec-ars-attendees-filter').find('select[name="mec-ars-events-selector"]').on('change', EventCtrl.confirmedAttendeesEventsSelector);
            UISelectors.modals.find('.mec-ars-attendees-confirmed').find('.mec-ars-attendees-filter').find('input[name="mec-ars-daterange"]').on('apply.daterangepicker', EventCtrl.confirmedAttendeesDaterange);
            UISelectors.modals.find('.mec-ars-attendees-confirmed').find('.mec-ars-attendees-filter').find('select[name="mec-ars-categories-selector"]').on('change', EventCtrl.confirmedAttendeesCategoriesSelector);
            UISelectors.modals.find('.mec-ars-attendees-confirmed').find('.mec-ars-attendees-filter').find('select[name="mec-ars-locations-selector"]').on('change', EventCtrl.confirmedAttendeesLocationsSelector);
            UISelectors.modals.find('.mec-ars-attendees-confirmed').find('.mec-ars-attendees-filter').find('select[name="mec-ars-organizers-selector"]').on('change', EventCtrl.confirmedAttendeesOrganizersSelector);
            // Verified Attendees
            UISelectors.modals.find('.mec-ars-attendees-verified').find('.mec-ars-attendees-filter').find('select[name="mec-ars-events-selector"]').on('change', EventCtrl.verifiedAttendeesEventsSelector);
            UISelectors.modals.find('.mec-ars-attendees-verified').find('.mec-ars-attendees-filter').find('input[name="mec-ars-daterange"]').on('apply.daterangepicker', EventCtrl.verifiedAttendeesDaterange);
            UISelectors.modals.find('.mec-ars-attendees-verified').find('.mec-ars-attendees-filter').find('select[name="mec-ars-categories-selector"]').on('change', EventCtrl.verifiedAttendeesCategoriesSelector);
            UISelectors.modals.find('.mec-ars-attendees-verified').find('.mec-ars-attendees-filter').find('select[name="mec-ars-locations-selector"]').on('change', EventCtrl.verifiedAttendeesLocationsSelector);
            UISelectors.modals.find('.mec-ars-attendees-verified').find('.mec-ars-attendees-filter').find('select[name="mec-ars-organizers-selector"]').on('change', EventCtrl.verifiedAttendeesOrganizersSelector);

            UISelectors.window.on('scroll', EventCtrl.loadMore);
            // Sort Column
            UISelectors.wrap.on('click', '.mec-ars-sort-column i', EventCtrl.attendeesSortColumn);
            // Export
            UISelectors.wrap.on('change', '.mec-ars-checkbox-all', EventCtrl.attendeesCheckbox);
            UISelectors.wrap.find('.mec-ars-attendees-export').find('span').on('click', EventCtrl.export);
        },
        windowLoad: function () {
            UISelectors.wrap.children('.mec-ars-make-wrap-empty').remove();
            UICtrl.wrapPreloaderToggle();
        },
        tabs: function (e) {
            e.preventDefault();
            const navItemLink = $(this);
            const contentID = navItemLink.attr('href');
            UISelectors.wrap.find('.mec-ars-tabs-nav').find('li').removeClass('mec-ars-active');
            navItemLink.parent('li').addClass('mec-ars-active');
            navItemLink.closest('.mec-ars-tabs-nav').siblings('.mec-ars-tabs-content').children('div').removeClass('mec-ars-active').end().children(contentID).addClass('mec-ars-active');
        },
        openModal: function () {
            const statisticsItem = $(this);
            UISelectors.wrap.find('#mec-ars-header').removeClass('mec-ars-active').end().find('#mec-ars-sections').removeClass('mec-ars-active').end().find('#mec-ars-modals').addClass('mec-ars-active');
            UISelectors.wrap.find('.mec-ars-section').hide().end().find('.mec-ars-modal-item').hide();
            if (statisticsItem.hasClass('mec-ars-all-bookings-number')) {
                var dateRange = UISelectors.wrap.find('header').find('[name="mec-ars-daterange"]').val();
                var events = UISelectors.wrap.find('header').find('[name="mec-ars-events-selector"]').val();

                UISelectors.wrap.find('.mec-ars-modal-item.mec-ars-attendees-all').find('[name="mec-ars-daterange"]').val(dateRange);
                UISelectors.wrap.find('.mec-ars-modal-item.mec-ars-attendees-all').find('[name="mec-ars-events-selector"]').val(events);

                UISelectors.wrap.find('.mec-ars-modal-item.mec-ars-attendees-all').show();
            } else if (statisticsItem.hasClass('mec-ars-confirmed-bookings-number') || statisticsItem.hasClass('mec-ars-total-income')) {
                UISelectors.wrap.find('.mec-ars-modal-item.mec-ars-attendees-confirmed').show();
            } else if (statisticsItem.hasClass('mec-ars-verified-bookings-number')) {
                UISelectors.wrap.find('.mec-ars-modal-item.mec-ars-attendees-verified').show();
            }
            UICtrl.select2();
        },
        closeModal: function () {
            UISelectors.wrap.find('#mec-ars-header').addClass('mec-ars-active').end().find('#mec-ars-sections').addClass('mec-ars-active').end().find('#mec-ars-modals').removeClass('mec-ars-active');
            UISelectors.wrap.find('.mec-ars-section').show().end().find('.mec-ars-modal-item').hide();
            EventCtrl.paginationClick();
        },
        daterange: function (e, picker) {
            picker.element.val(picker.startDate.format(picker.locale.format) + ' - ' + picker.endDate.format(picker.locale.format));
        },
        headerEventsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.mainAttendeesQuery.bookings.eventIDs = $(this).val();
            eventData.mainAttendeesQuery.attendees.chunkNum = 0;
            eventData.mainAttendeesQuery.attendees.order = 0;
            eventData.lineChartsQuery.locationIDs = [];
            eventData.lineChartsQuery.organizerIDs = [];
            eventData.lineChartsQuery.categoryIDs = [];
            eventData.lineChartsQuery.allRunning = true;
            eventData.eventsSelectorRunning = true;
            eventData.paged = 1;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);
        },
        paginationClick: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.mainAttendeesQuery.bookings.eventIDs = $('#mec-ars-wrap [name="mec-ars-events-selector"]').val();
            eventData.mainAttendeesQuery.attendees.chunkNum = 0;
            eventData.mainAttendeesQuery.attendees.order = 0;
            eventData.lineChartsQuery.locationIDs = [];
            eventData.lineChartsQuery.organizerIDs = [];
            eventData.lineChartsQuery.categoryIDs = [];
            eventData.lineChartsQuery.allRunning = true;
            eventData.eventsSelectorRunning = true;
            eventData.paged = $(this).is('a') ? parseInt($(this).html()) : 1;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);

            return false;
        },
        headerDaterange: function (e, picker) {
            UICtrl.wrapPreloaderToggle();
            eventData.mainAttendeesQuery.bookings.bookingTime = [
                picker.startDate.format('Y-M-D'),
                picker.endDate.format('Y-M-D')
            ];
            eventData.mainAttendeesQuery.attendees.chunkNum = 0;
            eventData.mainAttendeesQuery.attendees.order = 0;
            eventData.lineChartsQuery.allRunning = true;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);
        },
        lineChartsCategoriesSelector: function () {
            UICtrl.preloaderToggle(UISelectors.wrap.find('#mec-ars-line-charts').find('.mec-ars-tabs-content'));
            eventData.lineChartsQuery.categoryIDs = $(this).val();
            eventData.lineChartsQuery.categoriesRunning = true;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);
        },
        lineChartsLocationsSelector: function () {
            UICtrl.preloaderToggle(UISelectors.wrap.find('#mec-ars-line-charts').find('.mec-ars-tabs-content'));
            eventData.lineChartsQuery.locationIDs = $(this).val();
            eventData.lineChartsQuery.locationsRunning = true;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);
        },
        lineChartsOrganizersSelector: function () {
            UICtrl.preloaderToggle(UISelectors.wrap.find('#mec-ars-line-charts').find('.mec-ars-tabs-content'));
            eventData.lineChartsQuery.organizerIDs = $(this).val();
            eventData.lineChartsQuery.organizersRunning = true;
            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-sections'), eventData.lineChartsQuery);
        },
        allAttendeesEventsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.allAttendeesQuery.bookings.eventIDs = $(this).val();
            eventData.allAttendeesQuery.events.locationIDs = [];
            eventData.allAttendeesQuery.events.organizerIDs = [];
            eventData.allAttendeesQuery.events.categoryIDs = [];
            eventData.allAttendeesQuery.attendees.chunkNum = 0;
            eventData.allAttendeesQuery.attendees.order = 0;
            eventData.eventsSelectorRunning = true;
            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
        },
        allAttendeesDaterange: function (e, picker) {
            UICtrl.wrapPreloaderToggle();
            eventData.allAttendeesQuery.bookings.bookingTime = [
                picker.startDate.format('Y-M-D'),
                picker.endDate.format('Y-M-D')
            ];
            eventData.allAttendeesQuery.attendees.chunkNum = 0;
            eventData.allAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
        },
        allAttendeesCategoriesSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.allAttendeesQuery.events.categoryIDs = $(this).val();
            eventData.allAttendeesQuery.attendees.chunkNum = 0;
            eventData.allAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
        },
        allAttendeesLocationsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.allAttendeesQuery.events.locationIDs = $(this).val();
            eventData.allAttendeesQuery.attendees.chunkNum = 0;
            eventData.allAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
        },
        allAttendeesOrganizersSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.allAttendeesQuery.events.organizerIDs = $(this).val();
            eventData.allAttendeesQuery.attendees.chunkNum = 0;
            eventData.allAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
        },
        confirmedAttendeesEventsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.confirmedAttendeesQuery.bookings.eventIDs = $(this).val();
            eventData.confirmedAttendeesQuery.events.locationIDs = [];
            eventData.confirmedAttendeesQuery.events.organizerIDs = [];
            eventData.confirmedAttendeesQuery.events.categoryIDs = [];
            eventData.confirmedAttendeesQuery.attendees.chunkNum = 0;
            eventData.confirmedAttendeesQuery.attendees.order = 0;
            eventData.eventsSelectorRunning = true;
            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
        },
        confirmedAttendeesDaterange: function (e, picker) {
            UICtrl.wrapPreloaderToggle();
            eventData.confirmedAttendeesQuery.bookings.bookingTime = [
                picker.startDate.format('Y-M-D'),
                picker.endDate.format('Y-M-D')
            ];
            eventData.confirmedAttendeesQuery.attendees.chunkNum = 0;
            eventData.confirmedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
        },
        confirmedAttendeesCategoriesSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.confirmedAttendeesQuery.events.categoryIDs = $(this).val();
            eventData.confirmedAttendeesQuery.attendees.chunkNum = 0;
            eventData.confirmedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
        },
        confirmedAttendeesLocationsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.confirmedAttendeesQuery.events.locationIDs = $(this).val();
            eventData.confirmedAttendeesQuery.attendees.chunkNum = 0;
            eventData.confirmedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
        },
        confirmedAttendeesOrganizersSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.confirmedAttendeesQuery.events.organizerIDs = $(this).val();
            eventData.confirmedAttendeesQuery.attendees.chunkNum = 0;
            eventData.confirmedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
        },
        verifiedAttendeesEventsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.verifiedAttendeesQuery.bookings.eventIDs = $(this).val();
            eventData.verifiedAttendeesQuery.events.locationIDs = [];
            eventData.verifiedAttendeesQuery.events.organizerIDs = [];
            eventData.verifiedAttendeesQuery.events.categoryIDs = [];
            eventData.verifiedAttendeesQuery.attendees.chunkNum = 0;
            eventData.verifiedAttendeesQuery.attendees.order = 0;
            eventData.eventsSelectorRunning = true;
            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
        },
        verifiedAttendeesDaterange: function (e, picker) {
            UICtrl.wrapPreloaderToggle();
            eventData.verifiedAttendeesQuery.bookings.bookingTime = [
                picker.startDate.format(picker.locale.format),
                picker.endDate.format(picker.locale.format)
            ];
            eventData.verifiedAttendeesQuery.attendees.chunkNum = 0;
            eventData.verifiedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
        },
        verifiedAttendeesCategoriesSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.verifiedAttendeesQuery.events.categoryIDs = $(this).val();
            eventData.verifiedAttendeesQuery.attendees.chunkNum = 0;
            eventData.verifiedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
        },
        verifiedAttendeesLocationsSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.verifiedAttendeesQuery.events.locationIDs = $(this).val();
            eventData.verifiedAttendeesQuery.attendees.chunkNum = 0;
            eventData.verifiedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
        },
        verifiedAttendeesOrganizersSelector: function () {
            UICtrl.wrapPreloaderToggle();
            eventData.verifiedAttendeesQuery.events.organizerIDs = $(this).val();
            eventData.verifiedAttendeesQuery.attendees.chunkNum = 0;
            eventData.verifiedAttendeesQuery.attendees.order = 0;
            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
        },
        loadMore: function () {
            if (UISelectors.wrap.find('#mec-ars-sections').hasClass('mec-ars-active')) {
                if (typeof eventData.mainAttendeesQuery.attendees.maxChunkNum == 'undefined' || eventData.mainAttendeesQuery.attendees.maxChunkNum != '0') {
                    if ($(window).scrollTop() >= Math.ceil($('#mec-ars-section-attendees').find('.mec-ars-attendees-all').offset().top + $('#mec-ars-section-attendees').find('.mec-ars-attendees-all').outerHeight() - window.innerHeight)) {
                        if (eventData.scrollController.headerAttendees === false) {
                            UICtrl.loadMorePreloaderToggle(UISelectors.wrap.find('#mec-ars-section-attendees').find('.mec-ars-attendees-all'));
                            ++eventData.mainAttendeesQuery.attendees.chunkNum;
                            AjaxCtrl.attendees('mainAttendeesQuery', UISelectors.wrap.find('#mec-ars-section-attendees').find('.mec-ars-attendees-all'), eventData.lineChartsQuery);
                            eventData.scrollController.headerAttendees = true;
                        }
                    }
                }
            } else if (UISelectors.modals.find('.mec-ars-attendees-all').is(':visible')) {
                if (typeof eventData.allAttendeesQuery.attendees.maxChunkNum == 'undefined' || eventData.allAttendeesQuery.attendees.maxChunkNum != '0') {
                    if ($(window).scrollTop() >= Math.ceil($('.mec-ars-modal-item.mec-ars-attendees-all').offset().top + $('.mec-ars-modal-item.mec-ars-attendees-all').outerHeight() - window.innerHeight)) {
                        if (eventData.scrollController.allAttendees === false) {
                            UICtrl.loadMorePreloaderToggle(UISelectors.modals.find('.mec-ars-attendees-all'));
                            ++eventData.allAttendeesQuery.attendees.chunkNum;
                            AjaxCtrl.attendees('allAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-all'));
                            eventData.scrollController.allAttendees = true;
                        }
                    }
                }
            } else if (UISelectors.modals.find('.mec-ars-attendees-confirmed').is(':visible')) {
                if (typeof eventData.confirmedAttendeesQuery.attendees.maxChunkNum == 'undefined' || eventData.confirmedAttendeesQuery.attendees.maxChunkNum != '0') {
                    if ($(window).scrollTop() >= Math.ceil($('.mec-ars-modal-item.mec-ars-attendees-confirmed').offset().top + $('.mec-ars-modal-item.mec-ars-attendees-confirmed').outerHeight() - window.innerHeight)) {
                        if (eventData.scrollController.confirmedAttendees === false) {
                            UICtrl.loadMorePreloaderToggle(UISelectors.modals.find('.mec-ars-attendees-confirmed'));
                            ++eventData.confirmedAttendeesQuery.attendees.chunkNum;
                            AjaxCtrl.attendees('confirmedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-confirmed'));
                            eventData.scrollController.confirmedAttendees = true;
                        }
                    }
                }
            } else if (UISelectors.modals.find('.mec-ars-attendees-verified').is(':visible')) {
                if (typeof eventData.verifiedAttendeesQuery.attendees.maxChunkNum == 'undefined' || eventData.verifiedAttendeesQuery.attendees.maxChunkNum != '0') {
                    if ($(window).scrollTop() >= Math.ceil($('.mec-ars-modal-item.mec-ars-attendees-verified').offset().top + $('.mec-ars-modal-item.mec-ars-attendees-verified').outerHeight() - window.innerHeight)) {
                        if (eventData.scrollController.verifiedAttendees === false) {
                            UICtrl.loadMorePreloaderToggle(UISelectors.modals.find('.mec-ars-attendees-verified'));
                            ++eventData.verifiedAttendeesQuery.attendees.chunkNum;
                            AjaxCtrl.attendees('verifiedAttendeesQuery', UISelectors.modals.find('.mec-ars-attendees-verified'));
                            eventData.scrollController.verifiedAttendees = true;
                        }
                    }
                }
            }
        },
        attendeesSortColumn: function () {
            const currentSortItem = $(this);
            const sortUpRunning = currentSortItem.data('sort-up') !== undefined ? true : false;
            const attendees = currentSortItem.closest('.mec-ars-attendees-list').find('.mec-ars-attendee');
            const sortedAttendees = $(attendees.toArray().sort(function (attendeeA, attendeeB) {
                const attendeeASortContent = $(attendeeA).find('[data-sort="' + currentSortItem.parent().data('sort') + '"]').data('sort-content');
                const attendeeBSortContent = $(attendeeB).find('[data-sort="' + currentSortItem.parent().data('sort') + '"]').data('sort-content');
                if (sortUpRunning) {
                    if (attendeeASortContent > attendeeBSortContent) {
                        return 1;
                    }
                    if (attendeeBSortContent > attendeeASortContent) {
                        return -1;
                    }
                } else {
                    if (attendeeASortContent > attendeeBSortContent) {
                        return -1;
                    }
                    if (attendeeBSortContent > attendeeASortContent) {
                        return 1;
                    }
                }
                return 0;
            }));
            currentSortItem.closest('.mec-ars-attendees-list-header').find('i').removeClass('mec-ars-active');
            currentSortItem.addClass('mec-ars-active');
            sortedAttendees.each(function (index, element) {
                $(element).css('order', index);
            });
        },
        attendeesCheckbox: function () {
            const allCheckbox = $(this);
            const otherCheckboxes = allCheckbox.closest('.mec-ars-attendees-list').find('.mec-ars-checkbox:not(.mec-ars-checkbox-all)');
            if (allCheckbox.is(':checked')) {
                otherCheckboxes.prop('checked', true);
            } else {
                otherCheckboxes.prop('checked', false);
            }
        },
        export: function () {
            const currentExportItem = $(this);
            const checkedCheckboxes = currentExportItem.closest('.mec-ars-attendees').find('.mec-ars-checkbox:not(.mec-ars-checkbox-all):checked');
            const exportMessage = currentExportItem.closest('.mec-ars-attendees-export').find('.mec-ars-attendees-export-message');
            if(currentExportItem.parents('.mec-ars-attendees-export').hasClass('current-filter-attendees')){
                AjaxCtrl.export('mainAttendeesQuery', [], currentExportItem.data('export'));
            }else if (currentExportItem.parents('.mec-ars-attendees-export').hasClass('all-attendees')) {
                AjaxCtrl.export('allAttendeesQueryW', [], currentExportItem.data('export'));
            } else if (checkedCheckboxes.length > 0) {
                exportMessage.removeClass('mec-ars-active');
                let selectedAttendees = [];
                checkedCheckboxes.each(function (index, element) {
                    selectedAttendees.push($(this).val());
                });
                if (currentExportItem.closest('#mec-ars-section-attendees').length > 0) {
                    AjaxCtrl.export('mainAttendeesQuery', selectedAttendees, currentExportItem.data('export'));
                } else if (currentExportItem.closest('.mec-ars-modal-item.mec-ars-attendees-all').length > 0) {
                    AjaxCtrl.export('allAttendeesQuery', selectedAttendees, currentExportItem.data('export'));
                } else if (currentExportItem.closest('.mec-ars-modal-item.mec-ars-attendees-confirmed').length > 0) {
                    AjaxCtrl.export('confirmedAttendeesQuery', selectedAttendees, currentExportItem.data('export'));
                } else if (currentExportItem.closest('.mec-ars-modal-item.mec-ars-attendees-verified').length > 0) {
                    AjaxCtrl.export('verifiedAttendeesQuery', selectedAttendees, currentExportItem.data('export'));
                }
            } else {
                exportMessage.addClass('mec-ars-active');
            }
        },
        getEventData: function () {
            return eventData;
        },
    };
})(jQuery);

const AjaxCtrl = (function ($) {
    const UISelectors = UICtrl.getUISelectors();
    const eventData = EventCtrl.getEventData();

    return {
        export: function (queryType = 'mainAttendeesQuery', selectedAttendees = [], exportType = 'json') {
            const data = {
                action: 'mecARSExport',
                nonce: mecARS.nonce,
                bookingsQuery: eventData[queryType].bookings,
                eventsQuery: eventData[queryType].events,
                attendeesQuery: eventData[queryType].attendees,
                eventsSelectorRunning: eventData.eventsSelectorRunning,
                selectedAttendees: selectedAttendees,
                exportType: exportType,
            };
            window.open(`${mecARS.ajaxurl}?${$.param(data)}`, '_blank');
        },
        attendees: function (queryType = 'mainAttendeesQuery', parent = UISelectors.wrap, lineChartsQuery = {}) {
            $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'mecARSAttendees',
                    nonce: mecARS.nonce,
                    bookingsQuery: eventData[queryType].bookings,
                    eventsQuery: eventData[queryType].events,
                    attendeesQuery: eventData[queryType].attendees,
                    eventsSelectorRunning: eventData.eventsSelectorRunning,
                    lineChartsQuery: lineChartsQuery,
                    paged: eventData.paged,
                },
                dataType: 'json',
                success: function (response) {
                    if (UISelectors.wrap.children('.mec-ars-preloader').hasClass('mec-ars-active')) {
                        UICtrl.wrapPreloaderToggle();
                    }
                    if (UISelectors.wrap.find('#mec-ars-line-charts').find('.mec-ars-tabs-content').children('.mec-ars-preloader').hasClass('mec-ars-active')) {
                        UICtrl.preloaderToggle(UISelectors.wrap.find('#mec-ars-line-charts').find('.mec-ars-tabs-content'));
                    }
                    if (typeof response.html != 'undefined') {
                        if (eventData[queryType].attendees.chunkNum === 0) {
                            parent.find('.mec-ars-attendees-list').html($(response.html).html());
                        } else {
                            parent.find('.mec-ars-attendees-list').append($(response.html).find('.mec-ars-attendees-list-header').remove().end().html());
                            eventData.scrollController.headerAttendees = false;
                            eventData.scrollController.allAttendees = false;
                            eventData.scrollController.confirmedAttendees = false;
                            eventData.scrollController.verifiedAttendees = false;
                            if (parent.hasClass('mec-ars-load-more-preloader-active')) {
                                UICtrl.loadMorePreloaderToggle(parent);
                            }
                        }
                    }

                    if (typeof response.pagination != 'undefined') {
                        if (response.pagination.lengh === 0) {
                            $('#mec-ars-wrap').find('.pagination').html(' ');
                        } else {
                            $('#mec-ars-wrap').find('.pagination').html($(response.pagination).html());
                        }
                    }

                    if (typeof response.maxChunkNum != 'undefined') {
                        eventData[queryType].attendees.maxChunkNum = response.maxChunkNum;
                    }
                    if (typeof response.attendeesOrder != 'undefined') {
                        eventData[queryType].attendees.order += response.attendeesOrder;
                    }
                    if (typeof response.statistics != 'undefined') {
                        const statisticsSection = UISelectors.wrap.find('#mec-ars-section-statistics');
                        statisticsSection.find('.mec-ars-all-bookings-number').find('.mec-ars-number').text(typeof response.statistics.all != 'undefined' ? response.statistics.all : 0);
                        statisticsSection.find('.mec-ars-confirmed-bookings-number').find('.mec-ars-number').text(typeof response.statistics.confirmed != 'undefined' ? response.statistics.confirmed : 0);
                        statisticsSection.find('.mec-ars-verified-bookings-number').find('.mec-ars-number').text(typeof response.statistics.verified != 'undefined' ? response.statistics.verified : 0);
                        statisticsSection.find('.mec-ars-all-attendees-number').find('.mec-ars-number').text(typeof response.statistics.allAttendees != 'undefined' ? response.statistics.allAttendees : 0);
                        const income = typeof response.statistics.income != 'undefined' ? response.statistics.income.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') : '0.00';
                        statisticsSection.find('.mec-ars-total-income').find('.mec-ars-number').text(mecARS.lineCharts.salesCurrencySing ? mecARS.lineCharts.salesCurrencySing + income : '$' + income);
                    }
                    if (typeof response.charts != 'undefined') {
                        if (typeof response.charts.lineCharts != 'undefined') {
                            if (typeof response.charts.lineCharts.locations != 'undefined') {
                                UISelectors.lineCharts.locations.data.labels = response.charts.lineCharts.locations.labels;
                                UISelectors.lineCharts.locations.data.datasets[0].data = response.charts.lineCharts.locations.attendees;
                                UISelectors.lineCharts.locations.data.datasets[1].data = response.charts.lineCharts.locations.sales;
                                UISelectors.lineCharts.locations.update();
                            }
                            if (typeof response.charts.lineCharts.organizers != 'undefined') {
                                UISelectors.lineCharts.organizers.data.labels = response.charts.lineCharts.organizers.labels;
                                UISelectors.lineCharts.organizers.data.datasets[0].data = response.charts.lineCharts.organizers.attendees;
                                UISelectors.lineCharts.organizers.data.datasets[1].data = response.charts.lineCharts.organizers.sales;
                                UISelectors.lineCharts.organizers.update();
                            }
                            if (typeof response.charts.lineCharts.categories != 'undefined') {
                                UISelectors.lineCharts.categories.data.labels = response.charts.lineCharts.categories.labels;
                                UISelectors.lineCharts.categories.data.datasets[0].data = response.charts.lineCharts.categories.attendees;
                                UISelectors.lineCharts.categories.data.datasets[1].data = response.charts.lineCharts.categories.sales;
                                UISelectors.lineCharts.categories.update();

                            }
                            eventData.lineChartsQuery.categoriesRunning = false;
                            eventData.lineChartsQuery.locationsRunning = false;
                            eventData.lineChartsQuery.organizersRunning = false;
                        }
                        if (typeof response.charts.doughnutChart != 'undefined') {
                            UISelectors.doughnutCharts.gateways.data.labels = response.charts.doughnutChart.labels;
                            UISelectors.doughnutCharts.gateways.data.datasets[0].data = response.charts.doughnutChart.sales;
                            const backgroundColor = UISelectors.doughnutCharts.gateways.data.datasets[0].backgroundColor;
                            const backgroundColorIndex = backgroundColor.indexOf('#e3e3e3');
                            if (typeof response.charts.doughnutChart.empty != 'undefined') {
                                if (backgroundColorIndex === -1) {
                                    backgroundColor.unshift('#e3e3e3');
                                }
                                UISelectors.doughnutCharts.gateways.options.tooltips.enabled = false;
                            } else {
                                if (backgroundColorIndex === 0) {
                                    backgroundColor.splice(backgroundColorIndex, 1);
                                }
                                UISelectors.doughnutCharts.gateways.options.tooltips.enabled = true;
                            }
                            UISelectors.doughnutCharts.gateways.update();
                            document.getElementById('mec-ars-gateways-chart-legends').innerHTML = UISelectors.doughnutCharts.gateways.generateLegend();
                            eventData.lineChartsQuery.allRunning = false;
                        }
                    }
                    if (typeof response.terms != 'undefined') {
                        parent.find('select[name="mec-ars-locations-selector"]').empty().select2({
                            data: response.terms.mec_location,
                        });
                        parent.find('select[name="mec-ars-organizers-selector"]').empty().select2({
                            data: response.terms.mec_organizer,
                        });
                        parent.find('select[name="mec-ars-categories-selector"]').empty().select2({
                            data: response.terms.mec_category,
                        });
                        eventData.eventsSelectorRunning = false;
                    } else {
                        if (eventData.eventsSelectorRunning) {
                            parent.find('select[name="mec-ars-locations-selector"]').empty().select2({
                                data: mecARS.terms.mec_location,
                            });
                            parent.find('select[name="mec-ars-organizers-selector"]').empty().select2({
                                data: mecARS.terms.mec_organizer,
                            });
                            parent.find('select[name="mec-ars-categories-selector"]').empty().select2({
                                data: mecARS.terms.mec_category,
                            });
                            eventData.eventsSelectorRunning = false;
                        }
                    }

                    UISelectors.wrap.children('.pagination').find('.page-numbers').on('click', EventCtrl.paginationClick);
                }
            });
        },
    };
})(jQuery);

const App = (function (UICtrl, EventCtrl) {
    return {
        index: function () {
            UICtrl.index();
            EventCtrl.index();
        },
    };
})(UICtrl, EventCtrl);

App.index();