<?php
namespace MECAdvancedReport\Core;

use MECAdvancedReport\Core\Patterns\SingletonPattern;
use MECAdvancedReport\Core\Autoloader\Autoloader;

// Don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Loader.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class Loader extends SingletonPattern
{
    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    public function __construct()
    {
        $this->settingUp();
        $this->preload();
        $this->preloadInit();
        $this->setHooks();
        $this->registerAutoloadFiles();
        $this->loadAutoloadFiles();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public function settingUp()
    {
        self::$dir = MECARSDIR . 'core';
    }

    /**
     * Preload
     *
     * @since   1.0.0
     */
    public function preload()
    {
        include_once MECARSDIR . DS . 'core' . DS . 'Autoloader' . DS . 'Autoloader.php';
    }

    /**
     * Preload Init
     *
     * @since   1.0.0
     */
    public function preloadInit()
    {
        Autoloader::instance();
    }
    
    /**
     * Hooks
     *
     * @since   1.0.0
     */
    public function setHooks()
    {
        add_action('admin_init', function () {
            Autoloader::instance()->load('MECAdvancedReport\Core\checkLicense\AdvancedReportAddonUpdateActivation');
        });
    }

    /**
     * Register Autoload Files
     *
     * @since   1.0.0
     */
    public function registerAutoloadFiles()
    {
        if (!class_exists('\MECAdvancedReport\Core\Autoloader\Autoloader')) {
            return;
        }

        Autoloader::instance()->addClasses(
            [
                'MECAdvancedReport\\App\\Libraries\\Events' => self::$dir . '/../app/Libraries/Events.php',
                'MECAdvancedReport\\App\\Libraries\\Bookings' => self::$dir . '/../app/Libraries/Bookings.php',
                'MECAdvancedReport\\App\\Libraries\\Charts' => self::$dir . '/../app/Libraries/Charts.php',
                'MECAdvancedReport\\App\\Libraries\\Ajax' => self::$dir . '/../app/Libraries/Ajax.php',
                'MECAdvancedReport\\App\\Pages\\Index' => self::$dir . '/../app/Pages/Index.php',
                'MECAdvancedReport\\App\\Libraries\\API' => self::$dir . '/../app/Libraries/API.php',
                'MECAdvancedReport\\Core\\checkLicense\\AdvancedReportAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',
            ]
        );
    }

    /**
     * Load Inits
     *
     * @since   1.0.0
     */
    public function loadAutoloadFiles()
    {
        Autoloader::instance()->load('MECAdvancedReport\App\Libraries\Events');
        Autoloader::instance()->load('MECAdvancedReport\App\Libraries\Bookings');
        Autoloader::instance()->load('MECAdvancedReport\App\Libraries\Charts');
        Autoloader::instance()->load('MECAdvancedReport\App\Libraries\Ajax');
        Autoloader::instance()->load('MECAdvancedReport\App\Pages\Index');
        Autoloader::instance()->load('MECAdvancedReport\App\Libraries\API');
    }
}
