<?php
namespace MECAdvancedReport\Core\Autoloader;

use MECAdvancedReport\Core\Patterns\SingletonPattern;

// don't load directly.
if (! defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * Autoloader.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
class Autoloader extends SingletonPattern
{
    protected static $classes    = [];
    protected static $namespaces = [];

    public function __construct()
    {
        $this->register();
    }

    /**
     * Register spl autoload.
     *
     * @since   1.0.0
     */
    public function register()
    {
        spl_autoload_register([$this, 'load'], true, true);
    }

    public function addClass($class, $path)
    {
        static::$classes[ strtolower($class) ] = $path;
    }

    public function addClasses($classes)
    {
        foreach ($classes as $class => $path) {
            static::$classes[ strtolower($class) ] = $path;
        }
    }

    /**
     * Load
     *
     * @since   1.0.0
     */
    public function load($class)
    {
        // deal with funny is_callable('static::classname') side-effect
        if (strpos($class, 'static::') === 0) {
            // is called from within the class, so it's already loaded
            return true;
        }

        $class = ltrim($class, '\\');
        if (isset(static::$classes[ strtolower($class) ])) {
            $this->initClass($class, str_replace('/', DS, static::$classes[ strtolower($class) ]));
            return true;
        }

        return false;
    }

    /**
     * Init Class
     *
     * @since   1.0.0
     */
    protected function initClass($class, $file = null)
    {
        // include the file if needed
        if ($file && file_exists($file)) {
            include $file;
        }

        // if the loaded file contains a class...
        if (class_exists($class, false)) {
            // call the classes static init if needed
            if (method_exists($class, 'instance') && is_callable($class . '::instance')) {
                call_user_func($class . '::instance');
            }
        }
    }
}
