<?php
namespace MECAdvancedReport\Core\Patterns;

// don't load directly.
if (! defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * SingletonPattern.
 *
 * @author  Webnus Team
 * @package MECAdvancedReport
 * @since   1.0.0
 */
abstract class SingletonPattern
{
    /**
     * Constructor.
     *
     * @since   1.0.0
     */
    protected function __construct()
    {
    }

    /**
     * Clone.
     *
     * @since   1.0.0
     */
    private function __clone()
    {
    }

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     */
    final public static function instance()
    {
        static $instances = array();
        $called_class = get_called_class();

        if (! isset($instances[$called_class])) {
            $instances[$called_class] = new $called_class();
        }

        return $instances[$called_class];
    }
}