<?php

namespace MEC_Zoom_Integration\Zapier;

class Zapier {

	public static $text_domain = 'mec-zi';
	public static $instance;

	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function get_data( $data, $task, $set_settings_status, $zapier_class ){

        switch ( $task ) {
            case 'new_booking':

				$event_id = $data['booking_event_id'];
                if ( true !== $set_settings_status ) {

					$this->get_event_zoom_detail($event_id, $data);
                } else {

					$this->get_event_zoom_detail_for_set_setting($data);
                }

                break;
            case 'new_event':
            case 'modified_event':
            case 'canceled_event':

				$event_id = $data['event_id'];
				if ( true !== $set_settings_status ) {

					$this->get_event_zoom_detail($event_id,$data);
                } else {

					$this->get_event_zoom_detail_for_set_setting($data);
                }

				break;
            case 'all_events':
            case 'list_events':
            case 'event_occurrences':
            default:

            break;
        }

        return $data;
    }

	public function get_event_zoom_detail($event_id,&$data){


		$zoom_event_type = get_post_meta($event_id, 'mec_zoom_event', true);

		if(!$zoom_event_type || $zoom_event_type === 'none'){

			return $data;
		}

		$data['zoom_import_form_zoom'] = (bool)get_post_meta($event_id, 'mec_event_import_from_zoom', true );

		$data['zoom_event_type'] = $zoom_event_type;
		$data['zoom_event_type_text'] = 'meeting' === $zoom_event_type ? __('Meeting',self::$text_domain) : __('Webinar',self::$text_domain);

		$data['zoom_uid'] = get_post_meta($event_id, 'mec_zoom_'.$zoom_event_type.'_uid', true);
		$data['zoom_id'] = get_post_meta($event_id, 'mec_zoom_'.$zoom_event_type.'_id', true);

		$data['zoom_join_url'] = get_post_meta($event_id, 'mec_zoom_join_url', true);
		$data['zoom_join_title'] = get_post_meta($event_id, 'mec_zoom_join_title', true);

		$data['zoom_link_url'] = get_post_meta($event_id, 'mec_zoom_link_url', true);
		$data['zoom_link_title'] = get_post_meta($event_id, 'mec_zoom_link_title', true);

		$data['zoom_embed'] = get_post_meta($event_id, 'mec_zoom_embed', true) ? '<div class="mec-event-zoom-embed">'.get_post_meta($event_id, 'mec_zoom_embed', true).'</div>' : '';

		$data['zoom_password'] = get_post_meta($event_id, 'mec_zoom_password', true);

		return $data;
	}

	public function get_event_zoom_detail_for_set_setting(&$data){

		$data['zoom_import_form_zoom'] = true;

		$data['zoom_event_type'] = 'webinar';
		$data['zoom_event_type_text'] = __('Webinar',self::$text_domain);

		$data['zoom_uid'] = 123456;
		$data['zoom_id'] = 654321;

		$data['zoom_join_url'] = "http://webnus.net/";
		$data['zoom_join_title'] = __('Join','mec-zi');

		$data['zoom_link_url'] = "http://webnus.net/";
		$data['zoom_link_title'] = __('Register','mec-zi');
		$data['zoom_embed'] = '';

		$data['zoom_password'] = 'p123456';

		return $data;
	}
}
