<?php

namespace MEC_Zoom_Integration\Core\addEventToZoom;

use MEC_Zoom_Integration\Core\base\ZoomBase;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class AddEventToZoom
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zoom_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_ajax_mec_events_to_zoom', array($This, 'mec_events_to_zoom'));
        add_action('wp_ajax_mec_zoom_export_events', array($This, 'mec_zoom_export_events'));
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp(){

    }

    public function mec_events_to_zoom() {

        $exclude_expired = isset( $_POST['exclude_expired'] ) && 'yes' === $_POST['exclude_expired'] ? true : false;
        $events = get_posts(array(
            'post_type'=>'mec-events',
            'numberposts'=> -1,
            'post_status'=>'publish',
            'meta_query' => array(
                // meta query takes an array of arrays, watch out for this!
                'relation' => 'AND',
                array(
                    'key'     => 'mec_zoom_event',
                    'value'   => array('webinar', 'meeting'),
                    'compare' => 'IN'
                ),
                array(
                    'key'     => 'mec_event_import_from_zoom',
                    'compare' => 'NOT EXISTS'
                )
            )
        ));

        $message = '<ul>';
        foreach ($events  as $event) {

            $event_id = $event->ID;
            $event_detail = (new \MEC\Events\Event( $event_id ))->get_detail();
            $is_expired = \MEC\Base::get_main()->is_expired($event_detail);
            if( $exclude_expired && $is_expired ){
                continue;
            }

            $message .= '<li><input type="checkbox" name="mec-events-to-zoom[]"  id="zoom-events-to-zoom-'.$event->ID.'" name="zoom-events-to-zoom-'.$event->ID.'" value="'.$event->ID.'" checked="checked" /><label style="margin-left:10px;" for="zoom-events-to-zoom-'.$event->ID.'">'.$event->post_title.' <strong>('.get_post_meta($event->ID , 'mec_zoom_event' , true ).')</strong></label></li>';
        }
        $message .= '</ul><input id="mec_zoom_checkall" type="button" value="Deselect All"><div id="mec_zoom_export_events" onclick="mec_zoom_do_export_events(this)" class="button mec-zoom-export-events button-primary mec-button-primary" type="submit">'.esc_html__('Export To Zoom', 'mec-zi') .'</div><p id="mec-zoom-importing-desc"></p>
        <script>
        function mec_zoom_do_export_events(e) {
            jQuery("#mec_zoom_export_events").attr("disabled", true).addClass("loading").text("'.esc_attr__('Exporting ...', "mec-zi").'");
            var events = jQuery("#mec_zoom_request_get_wm_result").serialize();
            var tab_id = jQuery("#mec_zoom_tab_id").val();
            jQuery.ajax(
            {
                type: "POST",
                url: ajaxurl,
                data: "action=mec_zoom_export_events&tab="+tab_id+"&"+events,
                dataType: "json",
                success: function(data)
                {
                    // Remove the loading Class to the button
                    jQuery("#mec_zoom_export_events").removeAttr("disabled").removeClass("loading").text("'.esc_attr__('Export To Zoom', "mec-zi").'");
                    console.log(data)
                    if ( data.success == "1") {
                        jQuery("#mec-zoom-importing-desc").html(data.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                    // Remove the loading Class to the button
                    console.log("error!")
                }
            });
        }
        </script>';

        echo json_encode(array('success'=>1, 'message'=> $message));
        exit;

    }

    public function mec_zoom_export_events(){
        $mec_zoom_events = isset($_POST['mec-events-to-zoom']) ? $_POST['mec-events-to-zoom'] : array();
        $access_token = esc_html(ZoomBase::get_zoom_account_options('access_token'));

        $main = new \MEC_main();
        $base = \MEC::getInstance('app.libraries.render');

        // MEC Render Library
        $render = $base->getRender();

        // Timezone Options
        $timezone = $main->get_timezone();
        $gmt_offset = $main->get_gmt_offset();

        foreach ($mec_zoom_events as $mec_zoom_event) {
            $mec_event_id = $mec_zoom_event;
            $event = $render->data($mec_event_id);

            $password = ( !empty(get_post_meta($mec_event_id, 'mec_zoom_password', true)) ) ? get_post_meta($mec_event_id, 'mec_zoom_password', true) : '' ;

            $dates = $render->dates($mec_event_id, $event);
            $date = isset($dates[0]) ? $dates[0] : array();
            $event_type = get_post_meta($mec_event_id , 'mec_zoom_event' , true );

            $zoom_recurrence = array();
            $week_day_mapping = array('1'=>2, '2'=>3, '3'=>4, '4'=>5, '5'=>6, '6'=>7, '7'=>1);

            $repeat_type = $event->meta['mec_repeat_type'];

            if($repeat_type == 'daily')
            {
                $zoom_recurrence['type'] = 1;
                $zoom_recurrence['repeat_interval'] = (int) $event->mec->rinterval;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'weekly')
            {
                $zoom_recurrence['type'] = 2;
                $zoom_recurrence['repeat_interval'] = (int) ($event->mec->rinterval/7);
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'monthly')
            {
                $zoom_recurrence['type'] = 3;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'weekday')
            {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday].',';

                $zoom_recurrence['weekly_days'] = trim($byday, ', ');
                $zoom_recurrence['type'] = 2;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'weekend')
            {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday].',';

                $zoom_recurrence['weekly_days'] = trim($byday, ', ');
                $zoom_recurrence['type'] = 2;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'certain_weekdays')
            {
                $mec_weekdays = explode(',', trim($event->mec->weekdays, ','));
                foreach($mec_weekdays as $mec_weekday) $byday .= $week_day_mapping[$mec_weekday].',';

                $zoom_recurrence['weekly_days'] = trim($byday, ', ');
                $zoom_recurrence['type'] = 2;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }
            elseif($repeat_type == 'advanced')
            {
                $advanced_days = is_array($event->meta['mec_advanced_days']) ? $event->meta['mec_advanced_days'] : array();

                $first_rule = isset($advanced_days[0]) ? $advanced_days[0] : NULL;
                $ex = explode('.', $first_rule);

                $bysetpos = isset($ex[1]) ? $ex[1] : NULL;
                $byday_mapping = array('MON'=>2, 'TUE'=>3, 'WED'=>4, 'THU'=>5, 'FRI'=>6, 'SAT'=>7, 'SUN'=>1);
                $byday = $byday_mapping[strtoupper($ex[0])];

                $zoom_recurrence['type'] = 3;
                $zoom_recurrence['end_times']= ( $event->meta['mec_repeat']['end'] == 'occurrences' ) ? (int) $event->meta['mec_repeat']['end_at_occurrences'] : '';
                $zoom_recurrence['end_date_time']= ( $event->meta['mec_repeat']['end'] == 'date' ) ? date('Y-m-d\TH:i:s', strtotime($event->meta['mec_repeat']['end_at_date'])).$gmt_offset : '';
            }

            $start = array(
                'dateTime'=>date('Y-m-d\TH:i:s', $date['start']['timestamp']).$gmt_offset,
                'timeZone'=>$timezone,
            );

            $end = array(
                'dateTime'=>date('Y-m-d\TH:i:s', $date['end']['timestamp']).$gmt_offset,
                'timeZone'=>$timezone,
            );

            $allday = isset($event->meta['mec_allday']) ? $event->meta['mec_allday'] : 0;
            if($allday)
            {
                $start['dateTime'] = date('Y-m-d\T00:00:00', $date['start']['timestamp']).$gmt_offset;
                $end['dateTime'] = date('Y-m-d\T00:00:00', strtotime('+1 Day', strtotime($end['dateTime']))).$gmt_offset;
            }

            $diff = abs($date['end']['timestamp'] - $date['start']['timestamp']);
            $duration = floor($diff / (60));
            if (empty($zoom_recurrence)) {
                $event_data = array
                (
                    'topic'=> $event->title,
                    'agenda'=> strip_tags(strip_shortcodes($event->content)),
                    'start_time'=> $start['dateTime'],
                    'duration'=> $duration,
                    'password'=> $password,
                    'timezone'=> $timezone,
                    'type'=> (empty($zoom_recurrence)) ? 2 : 8,
                );
            } else {
                $event_data = array
                (
                    'topic'=> $event->title,
                    'agenda'=> strip_tags(strip_shortcodes($event->content)),
                    'start_time'=> $start['dateTime'],
                    'duration'=> $duration,
                    'recurrence'=> $zoom_recurrence,
                    'password'=> $password,
                    'timezone'=> $timezone,
                    'type'=> (empty($zoom_recurrence)) ? 2 : 8,
                );
            }

            if ( $event_type == 'meeting') {
                $response = wp_remote_post('https://api.zoom.us/v2/users/me/meetings', array(
                    'method'      => 'POST',
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $access_token,
                        'Content-Type' => 'application/json',
                    ),
                    'body'        => json_encode($event_data,JSON_FORCE_OBJECT),
                    'cookies'     => array()
                    )
                );
            } elseif ( $event_type == 'webinar') {
                $response = wp_remote_post('https://api.zoom.us/v2/users/me/webinars', array(
                    'method'      => 'POST',
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $access_token,
                        'Content-Type' => 'application/json',
                    ),
                    'body'        => json_encode($event_data,JSON_FORCE_OBJECT),
                    'cookies'     => array()
                    )
                );
            }

        }

        $body = wp_remote_retrieve_body( $response );

        if(isset($body->code) && 124 == $body->code){

            echo json_encode(array('success'=>0, 'message'=> $body->message));
            die();
        }

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $myDateTime = new \DateTime("now", $gmtTimezone);
        $nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));

        $expire_time_flag = ($nowTime > (int) ZoomBase::get_zoom_account_options('token_expire_in') ) ? 1 : 0 ;
        $message = ( $expire_time_flag == 1 ) ? esc_html__('Access Token is expired. Please click on "Generate Access Token" and import them again.','mec-zi') : esc_html__('All items are exported.' , 'mec-zi');

        echo json_encode(array('success'=>1, 'message'=>$message));
        die();
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zoom_Integration\Autoloader')) {
            return;
        }
    }
} //MecCTP
