<?php

namespace MEC_Zoom_Integration\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zoom_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECZIDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    {
        add_action('admin_init', function () {
            \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\checkLicense\ZoomIntegrationAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_Zoom_Integration\Autoloader')) {
            return;
        }

        \MEC_Zoom_Integration\Autoloader::addClasses(
            [
                'MEC_Zoom_Integration\\Core\\customizeTaxonomy\\MecCustomizeTaxonomy' => self::$dir . '/customizeTaxonomy/customize-taxonomy.php',
                'MEC_Zoom_Integration\\Core\\base\\ZoomBase' => self::$dir . '/base/base.php',
                'MEC_Zoom_Integration\\Core\\importWebinars\\ImportWebinars' => self::$dir . '/importWebinars/importWebinars.php',
                'MEC_Zoom_Integration\\Core\\importMeetings\\ImportMeetings' => self::$dir . '/importMeetings/importMeetings.php',
                'MEC_Zoom_Integration\\Core\\singleOptions\\SingleOptions' => self::$dir . '/singleOptions/singleOptions.php',
                'MEC_Zoom_Integration\\Core\\addEventToZoom\\AddEventToZoom' => self::$dir . '/addEventToZoom/addEventToZoom.php',
                'MEC_Zoom_Integration\\Core\\checkLicense\\ZoomIntegrationAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',

                'MEC_Zoom_Integration\\Zapier\\Zapier' => self::$dir . '/Zapier/Zapier.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\customizeTaxonomy\MecCustomizeTaxonomy');
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\base\ZoomBase');
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\importWebinars\ImportWebinars');
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\importMeetings\ImportMeetings');
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\singleOptions\SingleOptions');
        \MEC_Zoom_Integration\Autoloader::load('MEC_Zoom_Integration\Core\addEventToZoom\AddEventToZoom');
    }
} //Loader

Loader::instance();
