<?php

wp_enqueue_style( 'mec-zoom-integration-backend' );

use MEC_Zoom_Integration\Core\base\ZoomBase;

do_action( 'mec_zoom_before_load_page' );

(isset($_GET['code']) && !empty($_GET['code'])) ? update_option('mec_zoom_authorization_code' , $_GET['code']) : NULL;

$tz = wp_timezone_string();
$gmtTimezone = new \DateTimeZone($tz);
$myDateTime = new \DateTime("now", $gmtTimezone);
$nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));


$options = ZoomBase::get_zoom_account_options();

$client_id = $options['client_id'];
$client_secret = $options['client_secret'];
$authorization_code = $options['authorization_code'];
$token_availablity = $options['access_token'];
$expire_time_flag = ($nowTime > (int) $options['token_expire_in'] ) ? 1 : 0 ;
$expire_time = (( ($nowTime > (int) $options['token_expire_in'] ) && !empty($options['token_expire_in']) ) ? esc_html__('Your Access Token is expired. Please click on "Generate Access Token"') : !empty($options['token_expire_in'])) ? esc_html__('Access Token is generated and it will be expired at' , 'mec-zi') . ' ' . date(get_option('date_format') . ' ' . get_option('time_format') , $options['token_expire_in']) : '';

if ( isset($expire_time) && !empty($expire_time) ) {
    $expire_time_class = ( $expire_time_flag == 1 ) ? 'mec-error' : 'mec-success';
} else {
    $expire_time_class = NULL;
}

$redirect_url = apply_filters(
    'mec_zoom_redirect_url',
    get_admin_url('','admin.php?page=MEC-zoom')
);
?>
<div  id="mec-zoom-wrap"  class="about-zoom-wrap mec-addons">
    <div class="mec-zoom-header">
        <h1 class="mec-addons-title"> <?php echo __('Zoom Integration', 'mec-zi'); ?> </h1>
        <span class="w-theme-version"> <?php echo __('Version', 'mec-zi'); ?> <?php echo MECZIVERSION; ?></span>
    </div>
    <div class="welcome-content w-clearfix extra">
        <?php do_action( 'mec_zoom_start_integration_option' ) ?>
        <form id="mec_zoom_request_authorization_form" action="<?php echo $redirect_url; ?>" method="POST">
            <div class="mec-col-12">
                <?php do_action( 'mec_zoom_start_authorization_form' ); ?>
                <h4 class="mec-form-subtitle"><?php esc_html_e('Request User Authorization','mec-zi'); ?></h4>
                <p style="margin-left:0" class="description"><?php esc_html_e('Please set this URL for Callback URL in Zoom OAuth App.','mec-zi'); ?> <code><?php echo $redirect_url; ?></code></p>
                <div class="mec-form-row">
                    <label class="mec-col-3" for="mec_zoom_client_id"><?php esc_html_e('Client ID','mec-zi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_zoom_client_id" name="zi[client_id]" value="<?php echo esc_html($client_id); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-3" for="mec_zoom_client_secret"><?php esc_html_e('Client Secret','mec-zi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_zoom_client_secret" name="zi[client_secret]" value="<?php echo esc_html($client_secret); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-3" for="mec_zoom_authorization_code"><?php esc_html_e('Authorization Code','mec-zi'); ?></label>
                    <div class="mec-col-6">
                        <input style="width: 100%" type="text" id="mec_zoom_authorization_code" name="zi[authorization_code]" value="<?php echo (isset($_GET['code']) && !empty($_GET['code'])) ? esc_html($_GET['code']) : esc_html($authorization_code); ?>">
                    </div>
                </div>
                <div class="mec-form-row">
                    <button id="mec_zoom_request_authorization_button" class="button authorization-button button-primary mec-button-primary" type="submit"><?php _e('Authenticate', 'mec-zi'); ?></button>
                    <?php if ( (isset($_GET['code']) && !empty($_GET['code'])) || (isset($authorization_code) && !empty($authorization_code)) ) : ?>
                        <button id="mec_zoom_request_generate_access_token" class="button generate-access-token button-primary mec-button-primary" type="submit"><?php _e('Generate Access Token', 'mec-zi'); ?></button>
                        <?php
                            $resetbutton = ( $expire_time_class == 'mec-success' ) ? '' : 'disable';
                            $resetbutton = (isset($token_availablity) && !empty($token_availablity)) ? '' : 'disable';
                        ?>
                        <button id="mec_zoom_request_reset_data" class="button reset-token button-primary mec-button-primary <?php echo $resetbutton; ?>" type="submit"><?php _e('Reset', 'mec-zi'); ?></button>
                    <?php endif; ?>
                </div>
                <?php $token_availablity_class = isset($token_availablity) && !empty($token_availablity) ? '' : 'disable'; ?>
                <p id="mec_zoom_request_authorization_message" class="<?php echo $expire_time_class . ' ' . $token_availablity_class; ?>"><?php echo $expire_time; ?></p>
                <p id="mec_reset_data_now" class="reset-message disable"><?php _e('Your Zoom data has been reset on database.', 'mec-zi'); ?></p>
            </div>
        </form>

        <div class="mec-zoom-select-wm <?php echo ($expire_time_flag == 1 ) ? 'mec-util-hidden' : NULL; ?>">
            <div class="mec-col-12">
                <div class="mec-container">
                    <h4 class="mec-form-subtitle"><?php esc_html_e('Select Webinar/Meetings to import/Export' , 'mec-zi'); ?></h4>
                    <form  id="mec_zoom_request_get_wm" action="<?php echo $redirect_url; ?>" method="GET" >
                        <br/>
                        <div class="mec-form-row">
                            <input type="checkbox" id="mec-exclude-expired" name="mec-exclude-expired" value="1" />
                            <?php esc_html_e( 'Exclude Expired Events', 'mec-zi') ?>
                        </div>
                        <br/>
                        <button id="mec_zoom_get_webinars" style="margin: 0 15px 0 0;" class="button mec-zoom-get-webinars button-primary mec-button-primary" type="submit"><?php esc_html_e('Get Webinars', 'mec-zi'); ?></button>
                        <button id="mec_zoom_get_meetings" style="margin: 0 15px 0 0;" class="button mec-zoom-get-meetings button-primary mec-button-primary" type="submit"><?php esc_html_e('Get Meetings', 'mec-zi'); ?></button>
                        <button id="mec_events_to_zoom" style="margin: 0 15px 0 0;" class="button mec-events-to-zoom button-primary mec-button-primary" type="submit"><?php esc_html_e('Export Events to Zoom', 'mec-zi'); ?></button>
                    </form>

                    <form  id="mec_zoom_request_get_wm_result" action="<?php echo $redirect_url; ?>" method="GET" >
                        <div id="mec_zoom_request_get_wm_result_wrap"></div>
                        <div id="mec_zoom_imported_message"></div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
    .about-wrap h3 span.mec-zoom-step {
        border: 1px solid #000;
        border-radius: 50px;
        width: 30px;
        height: 29px;
        display: inline-block;
        padding-top: 1px;
        text-align: center;
        font-size: 17px;
        margin-right: 15px;
        vertical-align: middle;
    }
    #wpwrap .mec-button-primary.loading:before {
        display: none;
    }
    .reset-token,
    .generate-access-token {
        margin-left: 15px !important;
    }
    #wpwrap .mec-button-primary.green-done {
        background: #12bb2e;
        background: linear-gradient(95deg,#6ee882 0,#1ed63d 50%,#12bb2e 100%);
    }
    #mec_zoom_request_authorization_message.disable,
    #wpwrap .mec-button-primary.reset-token.disable,
    .reset-message.disable {
        display: none;
    }
    /* Zoom Event Import Select All & Deselect All */
    #mec_zoom_checkall {
        background: #fff;
        border: 1px solid #282828;
        border-radius: 60px;
        padding: 6px 32px 8px;
        margin: 30px 0 0;
        cursor: pointer;
        display: block;
        transition: all 0.3s ease;
        -webkit-transition: all 0.3s ease;
        -moz-transition: all 0.3s ease;
        -ms-transition: all 0.3s ease;
        -o-transition: all 0.3s ease;
    }

    #mec_zoom_checkall:focus {
        box-shadow: inset;
        outline: none;
    }

    #mec_zoom_checkall:hover {
        background: #282828;
        color: #fff;
    }
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    $(document).on("click", "#mec_zoom_checkall", function() {
        if ($(this).val() == "Check All") {
            $("#mec_zoom_request_get_wm_result_wrap input").prop("checked", true);
            $(this).val("Uncheck All");
        } else {
            $("#mec_zoom_request_get_wm_result_wrap input").prop("checked", false);
            $(this).val("Check All");
        }
    });
});
jQuery("#mec_zoom_request_authorization_form").find('.authorization-button').on('click', function(e)
{
    e.preventDefault();

    // Message
    var $message = jQuery('#mec_zoom_request_authorization_message');

    // Hide the Message
    $message.hide();
    $message.removeClass('mec-error');
    $message.removeClass('mec-success');

    $client_id = jQuery('#mec_zoom_client_id').val();
    $client_secret = jQuery('#mec_zoom_client_secret').val();

    if ( $client_id == "") {
        $message.show().addClass('mec-error').html("<?php esc_html_e('Please fill Client ID field!' , 'mec-zi'); ?>");
        return;
    }

    if ( $client_secret == "") {
        $message.show().addClass('mec-error').html("<?php esc_html_e('Please fill Client Secret field!' , 'mec-zi'); ?>");
        return;
    }

    jQuery(".authorization-button").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-zi'); ?>");

    var tab_id = jQuery('#mec_zoom_tab_id').val();
    var options = jQuery("#mec_zoom_request_authorization_form").serialize();
    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_zoom_authorization_form&tab="+tab_id+"&"+options,
        dataType: "json",
        success: function(data)
        {
            // Remove the loading Class to the button
            jQuery(".authorization-button").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Authenticate', 'mec-zi'); ?>");

            if ( data.success == '1') window.location.replace("https://zoom.us/oauth/authorize?response_type=code&client_id="+$client_id+"&redirect_uri=<?php echo urlencode($redirect_url); ?>");
        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('error!')
        }
    });

});

jQuery("#mec_zoom_request_authorization_form").find('.generate-access-token').on('click', function(e)
{
    e.preventDefault();

    var $message = jQuery('#mec_zoom_request_authorization_message');

    // Hide the Message
    $message.hide();
    $message.removeClass('mec-error');
    $message.removeClass('mec-success');

    jQuery(".generate-access-token").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-zi'); ?>");
    jQuery(".mec-zoom-select-wm").addClass('mec-util-hidden');

    var tab_id = jQuery('#mec_zoom_tab_id').val();

    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_zoom_generate_access_token&tab="+tab_id,
        dataType: "json",
        success: function(data)
        {
            // Remove the loading Class to the button
            jQuery(".generate-access-token").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Generate Access Token', 'mec-zi'); ?>");

            if ( data.success == '1'){
                $message.show().addClass('mec-success').html(data.message);
                jQuery(".mec-zoom-select-wm").removeClass('mec-util-hidden');
            }else if(data.success == '0'){
                $message.show().addClass('mec-error').html(data.message);
            }
            jQuery("#mec_zoom_request_reset_data").removeClass('disable');
        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('error!')
        }
    });

});

// RESET Button:
jQuery("#mec_zoom_request_authorization_form").find('.reset-token').on('click', function(e)
{
    e.preventDefault();

    var $message = jQuery('#mec_reset_data_now');

    // Hide the Message
    $message.hide();
    $message.removeClass('disable');

    jQuery(".reset-token").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Processing ...', 'mec-zi'); ?>");
    jQuery(".mec-zoom-select-wm").addClass('mec-util-hidden');

    var tab_id = jQuery('#mec_zoom_tab_id').val();

    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_zoom_reset_token&tab="+tab_id,
        dataType: "json",
        success: function(data)
        {
            console.log('Everything Done.')
            // Remove the loading Class to the button
            jQuery(".reset-token").removeAttr("disabled").removeClass('loading').addClass('green-done').text("<?php esc_attr_e('Done.', 'mec-zi'); ?>");

            if ( data.success == '1'){
                $message.show().addClass('mec-success').html(data.message);
                jQuery(".mec-zoom-select-wm").removeClass('mec-util-hidden');
            }else if(data.success == '0'){
                $message.show().addClass('mec-error').html(data.message);
            }

            jQuery("#mec_zoom_request_authorization_message, #mec_zoom_request_generate_access_token").hide(900);

        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('Oh, Error!')
        }
    });

});

//Get Webinars
jQuery("#mec_zoom_request_get_wm").find('#mec_zoom_get_webinars').on('click', function(e)
{
    e.preventDefault();

    var $message = jQuery('#mec_zoom_imported_message');
    var $result = jQuery('#mec_zoom_request_get_wm_result_wrap');

    // Hide the Message
    $message.hide();
    $message.removeClass('mec-error');
    $message.removeClass('mec-success');

    jQuery("#mec_zoom_get_webinars").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-zi'); ?>");

    var tab_id = jQuery('#mec_zoom_tab_id').val();
    var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no' ;
    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_zoom_get_webinars&exclude_expired=" + exclude_expired +"&tab="+tab_id,
        dataType: "json",
        success: function(data)
        {
            // Remove the loading Class to the button
            jQuery("#mec_zoom_get_webinars").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Webinars', 'mec-zi'); ?>");

            if ( data.success == '1'){
                $result.html(data.message);
            }else if(data.success == '0'){
                $message.show().addClass('mec-error').html(data.message);
            }

        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('error!')
        }
    });

});

// Get Meetings
jQuery("#mec_zoom_request_get_wm").find('#mec_zoom_get_meetings').on('click', function(e)
{
    e.preventDefault();

    var $message = jQuery('#mec_zoom_imported_message');
    var $result = jQuery('#mec_zoom_request_get_wm_result_wrap');

    // Hide the Message
    $message.hide();
    $message.removeClass('mec-error');
    $message.removeClass('mec-success');

    jQuery("#mec_zoom_get_meetings").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-zi'); ?>");

    var tab_id = jQuery('#mec_zoom_tab_id').val();
    var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no' ;

    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_zoom_get_meetings&exclude_expired=" + exclude_expired + "&tab="+tab_id,
        dataType: "json",
        success: function(data)
        {
            // Remove the loading Class to the button
            jQuery("#mec_zoom_get_meetings").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Get Meetings', 'mec-zi'); ?>");

            if ( data.success == '1'){
                $result.html(data.message);
            }else if(data.success == '0'){
                $message.show().addClass('mec-error').html(data.message);
            }

        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('error!')
        }
    });

});

// Export Events
jQuery("#mec_zoom_request_get_wm").find('#mec_events_to_zoom').on('click', function(e)
{
    e.preventDefault();

    var $message = jQuery('#mec_zoom_imported_message');
    var $result = jQuery('#mec_zoom_request_get_wm_result_wrap');

    // Hide the Message
    $message.hide();
    $message.removeClass('mec-error');
    $message.removeClass('mec-success');

    var tab_id = jQuery('#mec_zoom_tab_id').val();
    var exclude_expired = jQuery('#mec-exclude-expired').is(':checked') ? 'yes' : 'no';
    jQuery("#mec_events_to_zoom").attr("disabled", true).addClass('loading').text("<?php esc_attr_e('Checking ...', 'mec-zi'); ?>");

    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_events_to_zoom&exclude_expired=" + exclude_expired + "&tab="+tab_id,
        dataType: "json",
        success: function(data)
        {
            // Remove the loading Class to the button
            jQuery("#mec_events_to_zoom").removeAttr("disabled").removeClass('loading').text("<?php esc_attr_e('Export Events to Zoom', 'mec-zi'); ?>");

            if ( data.success == '1'){
                $result.html(data.message);
            }else if(data.success == '0'){
                $message.show().addClass('mec-error').html(data.message);
            }

        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            console.log('error!')
        }
    });

});
</script>