<?php

namespace MEC_Zoom_Integration\Core\importMeetings;

use MEC_Zoom_Integration\Core\base\ZoomBase;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class ImportMeetings
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zoom_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_ajax_mec_zoom_get_meetings', array($This, 'mec_zoom_get_meetings'));
        add_action('wp_ajax_mec_zoom_import_meetings', array($This, 'mec_zoom_import_meetings'));
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp(){

    }

    public function mec_zoom_get_meetings() {

        $exclude_expired = isset( $_POST['exclude_expired'] ) && 'yes' === $_POST['exclude_expired'] ? true : false;
        $access_token = esc_html(ZoomBase::get_zoom_account_options('access_token'));
        $response = wp_remote_post('https://api.zoom.us/v2/users/me/meetings?page_number=1&page_size=300', array(
            'method'      => 'GET',
            'headers' => array(
                'Authorization' => 'Bearer ' . $access_token,
            ),
            'body'        => array(),
            'cookies'     => array()
            )
        );
        if ( is_wp_error( $response ) ) {
            $error_message = $response->get_error_message();
            $message =  "Something went wrong: $error_message";
            echo json_encode(array('success'=>0, 'message'=> $message  ));
        } else {
            $body = json_decode(
                wp_remote_retrieve_body($response)
            );
            $message = '<ul>';
            $tz = wp_timezone_string();
            $gmtTimezone = new \DateTimeZone($tz);
            foreach ($body->meetings  as $meeting) {
                $date_startt = new \DateTime($meeting->start_time,$gmtTimezone);
                $date_startt->setTimezone(new \DateTimeZone($tz));

                $is_recurring = isset( $meeting->type ) && in_array( $meeting->type, array( 3, 8 ), false );
                if( !$is_recurring && $exclude_expired && current_time('timestamp') > $date_startt->getTimestamp() ){

                    continue;
                }

                $start_datee = $date_startt->format('F j, Y g:i A');
                $message .= '<li><input type="checkbox" name="mec-zoom-meetings[]"  id="zoom-meeting-'.$meeting->id.'" name="zoom-meeting-'.$meeting->id.'" value="'.$meeting->id.'" checked="checked" /><label style="margin-left:10px;" for="zoom-meeting-'.$meeting->id.'">'.$meeting->topic.' (Start Time: ' . $start_datee . ')</label></li>';
            }
            $message .= '</ul><input id="mec_zoom_checkall" type="button" value="Deselect All"><div id="mec_zoom_import_meetings" onclick="mec_zoom_do_import_meetings(this)" class="button mec-zoom-import-meetings button-primary mec-button-primary" type="submit">'.esc_html__('Import meetings', 'mec-zi') .'</div><p id="mec-zoom-importing-desc"></p>
            <script>
            function mec_zoom_do_import_meetings(e) {
                var tab_id = jQuery("#mec_zoom_tab_id").val();
                jQuery("#mec_zoom_import_meetings").attr("disabled", true).addClass("loading").text("'.esc_attr__('Importing ...', "mec-zi").'");
                var mettings = jQuery("#mec_zoom_request_get_wm_result").serialize();
                jQuery.ajax(
                {
                    type: "POST",
                    url: ajaxurl,
                    data: "action=mec_zoom_import_meetings&tab="+tab_id+"&"+mettings,
                    dataType: "json",
                    success: function(data)
                    {
                        // Remove the loading Class to the button
                        jQuery("#mec_zoom_import_meetings").removeAttr("disabled").removeClass("loading").text("'.esc_attr__('Import meetings', "mec-zi").'");

                        if ( data.success == "1") {
                            jQuery("#mec-zoom-importing-desc").html(data.message);
                            console.log(data.message)
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown)
                    {
                        // Remove the loading Class to the button
                        console.log("error!")
                    }
                });
            }
            </script>';

        }

        echo json_encode(array('success'=>1, 'message'=> $message));
        exit;
    }


    public function get_datetimes($start_datetime,$duration = null){

        if(!$start_datetime){

            $start_datetime = 'now';
        }

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $date_start = new \DateTime($start_datetime, $gmtTimezone);
        $date_start->setTimezone(new \DateTimeZone($tz));
        $date = $date_start->format('Y-m-d');

        $datetimes = array(
            'start' => array(
                'hour' => 8,
                'minutes' => '00',
                'ampm' => 'AM',
                'datetime' => $date.' 08:00 AM',
                'date' => $date,
            ),
            'end' => array(
                'hour' => 8,
                'minutes' => '00',
                'ampm' => 'PM',
                'datetime' => $date.' 08:00 PM',
                'date' => $date,
            ),
        );

        if(!$start_datetime){

            return $datetimes;
        }

        if(!empty($date_start)){

            $start_date = $date;

            $datetimes['start']['hour'] = $date_start->format('g');
            $datetimes['start']['minutes'] = $date_start->format('i');
            $datetimes['start']['ampm'] = $date_start->format('A');
            $datetimes['start']['datetime'] = "{$start_date} {$datetimes['start']['hour']}:{$datetimes['start']['minutes']} {$datetimes['start']['ampm']}";
            $datetimes['start']['date'] = $start_date;
        }


        if(!is_null($duration)){

            $date_end = new \DateTime($start_datetime , $gmtTimezone);
            $date_end->setTimezone(new \DateTimeZone($tz));
            $end_date = $date_end->format('Y-m-d');
            $date_end->modify('+'.$duration.' minute');

            if(!empty($date_end)){

                $datetimes['end']['hour'] = $date_end->format('g');
                $datetimes['end']['minutes'] = $date_end->format('i');
                $datetimes['end']['ampm'] = $date_end->format('A');
                $datetimes['end']['datetime'] = "{$end_date} {$datetimes['end']['hour']}:{$datetimes['end']['minutes']} {$datetimes['end']['ampm']}";
                $datetimes['end']['date'] = $end_date;
            }
        }

        return $datetimes;
    }

    public function mec_zoom_import_meetings(){
        $mec_zoom_meetings = isset($_POST['mec-zoom-meetings']) ? $_POST['mec-zoom-meetings'] : array();
        $access_token = esc_html(ZoomBase::get_zoom_account_options('access_token'));

        $main = new \MEC_main();
        foreach ($mec_zoom_meetings as $webniar_id) {
           $response = wp_remote_post('https://api.zoom.us/v2/meetings/'.$webniar_id, array(
                'method'      => 'GET',
                'headers' => array(
                    'Authorization' => 'Bearer ' . $access_token,
                ),
                'body'        => array(),
                'cookies'     => array()
                )
            );
            $body = json_decode(
                wp_remote_retrieve_body($response)
            );
            $message[] = $body;
            $title = $body->topic;
            $description = $body->agenda;
            $zoom_meeting_uid = $body->uuid;
            $zoom_meeting_id = $body->agenda;

            $start_datetime = isset($body->start_time) ? $body->start_time : false;
            $duration = isset($body->duration) ? $body->duration : null;
            if( !$start_datetime ){

                if( isset ($body->occurrences) and is_array($body->occurrences) ){

                    $start_datetime = current( $body->occurrences )->start_time;
                    $duration = current( $body->occurrences )->duration;
                }
            }

            $tz = wp_timezone_string();
            $gmtTimezone = new \DateTimeZone($tz);

            $datetimes = ImportMeetings::instance()->get_datetimes($start_datetime, $duration);
            $start_date = $datetimes['start']['date'];
            $start_hour = $datetimes['start']['hour'];
            $start_minutes = $datetimes['start']['minutes'];
            $start_ampm = $datetimes['start']['ampm'];

            $end_date = $datetimes['end']['date'];
            $end_hour = $datetimes['end']['hour'];
            $end_minutes = $datetimes['end']['minutes'];
            $end_ampm = $datetimes['end']['ampm'];

            $allday = 0;
            if ( isset ($body->occurrences) and !empty($body->occurrences)) {
                $repeat_status = 1;
                $repeat_type = '';
                $interval = NULL;
                $year = NULL;
                $month = NULL;
                $day = NULL;
                $week = NULL;
                $weekday = NULL;
                $weekdays = NULL;
                $weekdays = NULL;
                $advanced_days = NULL;

                $first_occurrence = current($body->occurrences);
                if(!empty($first_occurrence)){

                    $start_datetime = isset($first_occurrence->start_time) ? $first_occurrence->start_time : false;
                    $duration = isset($first_occurrence->duration) ? $first_occurrence->duration : null;

                    $datetimes = ImportMeetings::instance()->get_datetimes($start_datetime, $duration);
                    $start_date = $datetimes['start']['date'];
                    $start_hour = $datetimes['start']['hour'];
                    $start_minutes = $datetimes['start']['minutes'];
                    $start_ampm = $datetimes['start']['ampm'];

                    $end_date = $datetimes['end']['date'];
                    $end_hour = $datetimes['end']['hour'];
                    $end_minutes = $datetimes['end']['minutes'];
                    $end_ampm = $datetimes['end']['ampm'];
                }

                if ( isset($body->recurrence) and !empty($body->recurrence)) {
                    if ( $body->recurrence->type == 1){
                        $interval = $body->recurrence->repeat_interval;
                        $repeat_type = 'daily';
                    }

                    // Weekly
                    if ( $body->recurrence->type == 2){
                        $repeat_type = 'weekly';
                        $interval = isset($body->recurrence->repeat_interval) ? $body->recurrence->repeat_interval*7 : 7;
                    }

                    // Monthly with certain week of month
                    if ( $body->recurrence->type == 3 && isset($body->recurrence->monthly_week) && isset($body->recurrence->monthly_week_day)) {
                        $repeat_type = 'advanced';

                        $adv_week = $body->recurrence->monthly_week;
                        if($adv_week < 0) $adv_week = 'l';


                        $adv_day = $body->recurrence->monthly_week_day;
                        $mec_adv_day = 'Sat';
                        if($adv_day == '1') $mec_adv_day = 'Sun';
                        elseif($adv_day == '2') $mec_adv_day = 'Mon';
                        elseif($adv_day == '3') $mec_adv_day = 'Tue';
                        elseif($adv_day == '4') $mec_adv_day = 'Wed';
                        elseif($adv_day == '5') $mec_adv_day = 'Thu';
                        elseif($adv_day == '6') $mec_adv_day = 'Fri';

                        $advanced_days = array($mec_adv_day.'.'.$adv_week);

                    }  elseif ($body->recurrence->type == 3) {

                        $repeat_type = 'monthly';

                        $year = '*';
                        $month = '*';

                        $s = $start_date;
                        $e = $end_date;

                        $_days = array();
                        while(strtotime($s) <= strtotime($e))
                        {
                            $_days[] = date('d', strtotime($s));
                            $s = date('Y-m-d', strtotime('+1 Day', strtotime($s)));
                        }

                        $day = ','.implode(',', array_unique($_days)).',';

                        $week = '*';
                        $weekday = '*';

                    }


                    // Custom Week Days
                    if($body->recurrence->type == 2 and isset($body->recurrence->weekly_days) and count(explode(',', $body->recurrence->weekly_days)) > 1)
                    {
                        $g_week_days = explode(',', $body->recurrence->weekly_days);
                        $week_day_mapping = array(1=>7, 2=>1, 3=>2, 4=>3, 5=>4, 6=>5, 7=>6);

                        $weekdays = '';
                        foreach($g_week_days as $g_week_day) $weekdays .= $week_day_mapping[$g_week_day].',';

                        $weekdays = ','.trim($weekdays, ', ').',';
                        $interval = NULL;

                        $repeat_type = 'certain_weekdays';
                    }

                    $finish = (isset($body->recurrence->end_times) and is_int($body->recurrence->end_date_time)) ? end($body->occurrences)->start_time  : date('Y-m-d', strtotime($body->recurrence->end_date_time));
                    $finish = (!isset($body->recurrence->end_date_time) and is_int($body->recurrence->end_times)) ? end($body->occurrences)->start_time  : date('Y-m-d', strtotime($body->recurrence->end_date_time));

                }

            } else {

                $repeat_status = 0;
                $g_recurrence_rule = '';
                $repeat_type = '';
                $interval = NULL;
                $finish = $end_date;
                $year = NULL;
                $month = NULL;
                $day = NULL;
                $week = NULL;
                $weekday = NULL;
                $weekdays = NULL;
                $advanced_days = NULL;
            }

            $repeat_end = 'never';
            if( isset($body->recurrence->end_times) ){

                $repeat_end = 'occurrences';
            }elseif( isset($body->recurrence->end_date_time) ){

                $repeat_end = 'end_date_time';
            }

            $args = array
            (
                'title'=>$title,
                'content'=>$description,
                'location_id'=>'',
                'organizer_id'=>'',
                'date'=>array
                (
                    'start'=>array(
                        'date'=>$start_date,
                        'hour'=>$start_hour,
                        'minutes'=>$start_minutes,
                        'ampm'=>$start_ampm,
                    ),
                    'end'=>array(
                        'date'=>$end_date,
                        'hour'=>$end_hour,
                        'minutes'=>$end_minutes,
                        'ampm'=>$end_ampm,
                    ),
                    'repeat'=>array(),
                    'allday'=>$allday,
                    'comment'=>'',
                    'hide_time'=>0,
                    'hide_end_time'=>0,
                ),
                'start'=>$start_date,
                'start_time_hour'=>$start_hour,
                'start_time_minutes'=>$start_minutes,
                'start_time_ampm'=>$start_ampm,
                'end'=>$end_date,
                'end_time_hour'=>$end_hour,
                'end_time_minutes'=>$end_minutes,
                'end_time_ampm'=>$end_ampm,
                'repeat_status'=>$repeat_status,
                'repeat_type'=>$repeat_type,
                'interval'=>$interval,
                'finish'=>$finish,
                'year'=>$year,
                'month'=>$month,
                'day'=>$day,
                'week'=>$week,
                'weekday'=>$weekday,
                'weekdays'=>$weekdays,
                'meta'=>array
                (
                    'mec_source'=>'zoom-meetings',
                    'mec_zoom_meeting_uid'=>$zoom_meeting_uid,
                    'mec_zoom_meeting_id'=>$zoom_meeting_id,
                    'mec_advanced_days'=>$advanced_days,
                    'mec_repeat'=>array
                    (
                        'status' =>  (isset ($body->occurrences) and !empty($body->occurrences)) ? '1' : '0',
                        'type' => $repeat_type,
                        'interval' => $interval,
                        'end' => $repeat_end,
                        'end_at_date' => isset($body->recurrence->end_date_time) ?  (string) date('Y-m-d', strtotime($body->recurrence->end_date_time)) : NULL,
                        'end_at_occurrences' =>  isset($body->recurrence->end_times) ? (string) $body->recurrence->end_times : null,
                    ),
                    'mec_comment'=>$body->timezone,
                    'mec_repeat_end'=> $repeat_end,
                    'mec_repeat_end_at_occurrences'=> isset($body->recurrence->end_times) ? (string) $body->recurrence->end_times : null,
                    'mec_repeat_end_at_date'=> isset($body->recurrence->end_date_time) ?  (string) date('Y-m-d', strtotime($body->recurrence->end_date_time)) : NULL,
                )
            );

            $db = \MEC::getInstance('app.libraries.db');
            $post_id = $db->select("SELECT `post_id` FROM `#__postmeta` WHERE `meta_value`='$zoom_meeting_id' AND `meta_key`='mec_zoom_meeting_id'", 'loadResult');

            // Imported From Google
            if(!post_exists($title, $description, '', $main->get_main_post_type())) $args['meta']['mec_imported_from_zoom_meeting'] = 1;

            $post_id = $main->save_event($args, NULL);

            update_post_meta($post_id, 'more_info', $body->registration_url);
            update_post_meta($post_id, 'more_info_title', esc_html__('Register' , 'mec-zi'));
            update_post_meta($post_id, 'mec_zoom_event', 'meeting');
            update_post_meta($post_id, 'mec_zoom_link_url', $body->registration_url);
            update_post_meta($post_id, 'mec_zoom_link_title', esc_html__('Register' , 'mec-zi'));
            update_post_meta($post_id, 'mec_zoom_password', $body->password);
            update_post_meta($post_id, 'mec_zoom_join_url', $body->join_url);
            update_post_meta($post_id, 'mec_zoom_join_title', esc_html__('Join it!' , 'mec-zi'));
            update_post_meta($post_id, 'mec_event_import_from_zoom', '1');

            do_action( 'mec_zoom_added_meeting', $post_id );
        }

        $tz = wp_timezone_string();
        $gmtTimezone = new \DateTimeZone($tz);
        $myDateTime = new \DateTime("now", $gmtTimezone);
        $nowTime = strtotime($myDateTime->format(get_option('date_format') . ' ' . get_option('time_format')));

        $expire_time_flag = ($nowTime > (int) ZoomBase::get_zoom_account_options('token_expire_in') ) ? 1 : 0 ;
        $message = ( $expire_time_flag == 1 ) ? esc_html__('Access Token is expired. Please click on "Generate Access Token" and import them again.','mec-zi') : esc_html__('All items are imported.' , 'mec-zi');

        echo json_encode(array('success'=>1, 'message'=>$message));

        exit;
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zoom_Integration\Autoloader')) {
            return;
        }
    }
} //MecCTP
