<?php

namespace MEC_Zoom_Integration\Core\singleOptions;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

use MEC\Books\EventBook;

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class SingleOptions
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zoom_Integration
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_enqueue_scripts', [$This, 'assets']);
        add_action('mec_zoom_event_form', [$This, 'meta_box_zoom']);
        add_filter('mec-single-event-meta-title', [$This, 'add_options'], 99, 2);
        add_action('mec_metabox_details', [$This, 'meta_box_zoom'], 60);
        add_action('save_post', [$This, 'save_event']);
        add_action('mec_single_zoom_badge', [__CLASS__, 'display_badge_in_single'], 99, 1);
        add_action('mec_single_after_content', [__CLASS__, 'display_in_single_page']);
        add_action('mec_shortcode_virtual_badge', [$This, 'display_badge_in_shortcode'], 99, 1);
        add_filter('mec_monthly_virtual_badge', [$This, 'display_badge_in_monthly'], 99, 2);
        add_filter('MEC_extra_info_gateways', [$This, 'display_password_in_booking'], 99, 3);
        add_action('mec_extra_field_notifications', [$This, 'display_notification_field']);
        add_action('save_fes_meta_action', [$This, 'save_fes_form'], 99, 2);

        add_filter('mec_profile_event_detail', [__CLASS__, 'add_event_detail_to_dashboard'], 10, 3);
        add_filter('mec_profile_event_detail_header', [__CLASS__, 'add_header_event_detail_to_dashboard'], 10, 3);
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp() {}

    public function add_options($tabs, $activated)
    {
        $zoomTab =  array(
            __('Zoom Information', 'mec-zi') => 'mec-zoom',
        );
        $tabs = array_merge($tabs, $zoomTab);
        return $tabs;
    }

    public function meta_box_zoom($post)
    {
        $mec_zoom_event = get_post_meta($post->ID, 'mec_zoom_event', true);
        $mec_zoom_badge_shortcode = get_post_meta($post->ID, 'mec_zoom_badge_shortcode', true);
        $mec_display_booking_history = get_post_meta($post->ID, 'mec_display_booking_history', true);
        $mec_zoom_badge_single = get_post_meta($post->ID, 'mec_zoom_badge_single', true);

        $zoom_join_url = get_post_meta($post->ID, 'mec_zoom_join_url', true);
        $zoom_join_title = get_post_meta($post->ID, 'mec_zoom_join_title', true);
        $zoom_join_target = get_post_meta($post->ID, 'mec_zoom_join_target', true);
        $mec_zoom_display_join_in_booking = get_post_meta($post->ID, 'mec_zoom_display_join_in_booking', true);

        $zoom_link_url = get_post_meta($post->ID, 'mec_zoom_link_url', true);
        $zoom_link_title = get_post_meta($post->ID, 'mec_zoom_link_title', true);
        $zoom_link_target = get_post_meta($post->ID, 'mec_zoom_link_target', true);
        $mec_zoom_display_link_in_booking = get_post_meta($post->ID, 'mec_zoom_display_link_in_booking', true);

        $zoom_embed = get_post_meta($post->ID, 'mec_zoom_embed', true);
        $mec_zoom_display_embed_in_booking = get_post_meta($post->ID, 'mec_zoom_display_embed_in_booking', true);

        $zoom_hide_info_before_start = get_post_meta($post->ID, 'mec_zoom_hide_info_before_start', true);
        $zoom_show_info_time = get_post_meta($post->ID, 'mec_zoom_show_info_time', true);
        $zoom_show_info_hm = get_post_meta($post->ID, 'mec_zoom_show_info_hm', true);

        $mec_zoom_hide_info = get_post_meta($post->ID, 'mec_zoom_hide_info', true);

        $mec_zoom_password = get_post_meta($post->ID, 'mec_zoom_password', true);
        $mec_zoom_display_password_in_booking = get_post_meta($post->ID, 'mec_zoom_display_password_in_booking', true);
        $mec_zoom_meeting_id = get_post_meta($post->ID, 'mec_zoom_meeting_id', true);
        $mec_zoom_display_meeting_id_in_booking = get_post_meta($post->ID, 'mec_zoom_display_meeting_id_in_booking', true);

?>
        <div class="mec-meta-box-fields mec-event-tab-content" id="mec-zoom">
            <h4><?php echo __('zoom Event', 'mec-zi'); ?></h4>
            <div class="mec-form-row mec-zoom-event-type">
                <label for="mec_zoom_event_none">
                    <input
                        <?php
                        if ((isset($mec_zoom_event) and $mec_zoom_event == 'none') || !isset($mec_zoom_event) || empty($mec_zoom_event)) {
                            echo 'checked="checked"';
                        }
                        ?>
                        type="radio" name="mec[mec_zoom_event]" id="mec_zoom_event_none" value="none" />
                    <?php _e('None', 'mec-zi'); ?>
                </label>

                <label for="mec_zoom_event_webinar">
                    <input
                        <?php
                        if (isset($mec_zoom_event) and $mec_zoom_event == 'webinar') {
                            echo 'checked="checked"';
                        }
                        ?>
                        type="radio" name="mec[mec_zoom_event]" id="mec_zoom_event_webinar" value="webinar" />
                    <?php _e('Webinar', 'mec-zi'); ?>
                </label>

                <label for="mec_zoom_event_meeting">
                    <input
                        <?php
                        if (isset($mec_zoom_event) and $mec_zoom_event == 'meeting') {
                            echo 'checked="checked"';
                        }
                        ?>
                        type="radio" name="mec[mec_zoom_event]" id="mec_zoom_event_meeting" value="meeting" />
                    <?php _e('Meeting', 'mec-zi'); ?>
                </label>
            </div>
            <div class="mec-zoom-event-wrap" style="<?php echo ((isset($mec_zoom_event) and $mec_zoom_event == 'none') || !isset($mec_zoom_event) || empty($mec_zoom_event)) ? 'display: none' : 'display: block'; ?>">
                <div class="mec-form-row">
                    <label for="mec_zoom_badge_shortcode">
                        <input
                            <?php
                            if (isset($mec_zoom_badge_shortcode) and $mec_zoom_badge_shortcode == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_badge_shortcode]" id="mec_zoom_badge_shortcode" value="1" />
                        <?php _e('Display zoom badge in shortcode', 'mec-zi'); ?>
                    </label>
                </div>
                <div class="mec-form-row">
                    <label for="mec_zoom_badge_single">
                        <input
                            <?php
                            if (isset($mec_zoom_badge_single) and $mec_zoom_badge_single == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_badge_single]" id="mec_zoom_badge_single" value="1" />
                        <?php _e('Display zoom badge in single event', 'mec-zi'); ?>
                    </label>
                </div>
                <div class="mec-form-row">
                    <label for="mec_display_booking_history">
                        <input
                            <?php
                            if (isset($mec_display_booking_history) && $mec_display_booking_history == '1') {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_display_booking_history]" id="mec_display_booking_history" value="1" />
                        <?php _e('Display booking history in Single Event page', 'mec-zi'); ?>
                    </label>
                </div>

                <div class="mec-form-row">
                    <label class="mec-col-2" for="mec_zoom_join_url"><?php esc_html_e('Join URL', 'mec-zi'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_zoom_join_url]" id="mec_zoom_join_url" value="<?php echo esc_attr($zoom_join_url); ?>" placeholder="eg. https://youtube.com">
                    <input class="mec-col-3" type="text" name="mec[mec_zoom_join_title]" id="mec_zoom_join_title" value="<?php echo esc_attr($zoom_join_title); ?>" placeholder="Title">
                    <select class="mec-col-3" name="mec[mec_zoom_join_target]" id="mec_zoom_join_target">
                        <option value="_self" <?php echo ($zoom_join_target == '_self' ? 'selected="selected"' : ''); ?>><?php _e('Current Window', 'mec-zi'); ?></option>
                        <option value="_blank" <?php echo ($zoom_join_target == '_blank' ? 'selected="selected"' : ''); ?>><?php _e('New Window', 'mec-zi'); ?></option>
                    </select>
                    <label class="mec-col-12 label-checkbox" for="mec_zoom_display_join_in_booking">
                        <input
                            <?php
                            if (isset($mec_zoom_display_join_in_booking) and $mec_zoom_display_join_in_booking == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_display_join_in_booking]" id="mec_zoom_display_join_in_booking" value="1" />
                        <?php esc_html_e('Display when booking is complete', 'mec-zi'); ?>
                    </label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-2" for="mec_zoom_link_url"><?php esc_html_e('Register Link', 'mec-zi'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_zoom_link_url]" id="mec_zoom_link_url" value="<?php echo esc_attr($zoom_link_url); ?>" placeholder="eg. https://youtube.com">
                    <input class="mec-col-3" type="text" name="mec[mec_zoom_link_title]" id="mec_zoom_link_title" value="<?php echo esc_attr($zoom_link_title); ?>" placeholder="Title">
                    <select class="mec-col-3" name="mec[mec_zoom_link_target]" id="mec_zoom_link_target">
                        <option value="_self" <?php echo ($zoom_link_target == '_self' ? 'selected="selected"' : ''); ?>><?php _e('Current Window', 'mec-zi'); ?></option>
                        <option value="_blank" <?php echo ($zoom_link_target == '_blank' ? 'selected="selected"' : ''); ?>><?php _e('New Window', 'mec-zi'); ?></option>
                    </select>
                    <label class="mec-col-12 label-checkbox" for="mec_zoom_display_link_in_booking"><input
                            <?php
                            if (isset($mec_zoom_display_link_in_booking) and $mec_zoom_display_link_in_booking == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_display_link_in_booking]" id="mec_zoom_display_link_in_booking" value="1" /><?php esc_html_e('Display when booking is complete', 'mec-zi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-2" for="mec_zoom_password"><?php esc_html_e('Password', 'mec-zi'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_zoom_password]" id="mec_zoom_password" maxlength="10" value="<?php echo esc_attr($mec_zoom_password); ?>" />
                    <label class="mec-col-6 label-checkbox" for="mec_zoom_display_password_in_booking"><input
                            <?php
                            if (isset($mec_zoom_display_password_in_booking) and $mec_zoom_display_password_in_booking == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_display_password_in_booking]" id="mec_zoom_display_password_in_booking" value="1" /><?php esc_html_e('Display when booking is complete', 'mec-zi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-2" for="mec_zoom_meeting_id"><?php esc_html_e('Meeting ID', 'mec-zi'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_zoom_meeting_id]" id="mec_zoom_meeting_id" value="<?php echo esc_attr($mec_zoom_meeting_id); ?>" placeholder="Enter Meeting ID">
                    <label class="mec-col-6 label-checkbox" for="mec_zoom_display_meeting_id_in_booking">
                        <input
                            <?php
                            if (isset($mec_zoom_display_meeting_id_in_booking) and $mec_zoom_display_meeting_id_in_booking == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_display_meeting_id_in_booking]" id="mec_zoom_display_meeting_id_in_booking" value="1" />
                        <?php esc_html_e('Display when booking is complete', 'mec-zi'); ?>
                    </label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-2" for="mec_zoom_embed"><?php esc_html_e('Embed', 'mec-zi'); ?></label>
                    <textarea class="mec-col-4" type="text" name="mec[mec_zoom_embed]" id="mec_zoom_embed"><?php echo esc_attr($zoom_embed); ?></textarea>
                    <label class="mec-col-6 label-checkbox" for="mec_zoom_display_embed_in_booking"><input
                            <?php
                            if (isset($mec_zoom_display_embed_in_booking) and $mec_zoom_display_embed_in_booking == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_display_embed_in_booking]" id="mec_zoom_display_embed_in_booking" value="1" /><?php esc_html_e('Display when booking is complete', 'mec-zi'); ?></label>
                </div>
                <div class="mec-form-row">

                    <label class="mec-col-5 label-checkbox" for="mec_zoom_hide_info_before_start"><input
                            <?php
                            if (isset($zoom_hide_info_before_start) and $zoom_hide_info_before_start == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_hide_info_before_start]" id="mec_zoom_hide_info_before_start" value="1" /><?php esc_html_e('Display above information until', 'mec-zi'); ?></label>
                    <input class="mec-col-1" type="number" name="mec[mec_zoom_show_info_time]" value="<?php echo ((isset($zoom_show_info_time) and trim($zoom_show_info_time)) ? esc_attr($zoom_show_info_time) : '0'); ?>" placeholder="<?php _e('e.g. 0', 'mec'); ?>">
                    <select class="mec-col-3" name="mec[mec_zoom_show_info_hm]" id="mec_zoom_show_info_hm">
                        <option value="day" <?php echo ($zoom_show_info_hm == 'day' ? 'selected="selected"' : ''); ?>><?php _e('Day', 'mec-zi'); ?></option>
                        <option value="hour" <?php echo ($zoom_show_info_hm == 'hour' ? 'selected="selected"' : ''); ?>><?php _e('Hour', 'mec-zi'); ?></option>
                        <option value="minute" <?php echo ($zoom_show_info_hm == 'minute' ? 'selected="selected"' : ''); ?>><?php _e('Minute', 'mec-zi'); ?></option>
                    </select>
                    <label class="mec-col-3" for="mec_zoom_show_info_time"><?php esc_html_e('before event start.', 'mec-zi'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label for="mec_zoom_hide_info">
                        <input
                            <?php
                            if (isset($mec_zoom_hide_info) and $mec_zoom_hide_info == true) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" name="mec[mec_zoom_hide_info]" id="mec_zoom_hide_info" value="1" />
                        <?php _e('Hide above information when event is live', 'mec-zi'); ?>
                    </label>
                </div>


            </div>
        </div>
        <script>
            jQuery(document).ready(function() {
                jQuery('input[name="mec[mec_zoom_event]"]').on('change', function() {

                    if (jQuery(this).val() != 'none') {
                        jQuery('.mec-zoom-event-wrap').show();
                    } else {
                        jQuery('.mec-zoom-event-wrap').hide();
                    }

                });
            });
        </script>
    <?php
    }

    public function save_event($post_id)
    {
        // Check if our nonce is set.
        if (!isset($_POST['mec_event_nonce'])) return false;

        // Verify that the nonce is valid.
        if (!wp_verify_nonce(sanitize_text_field($_POST['mec_event_nonce']), 'mec_event_data')) return false;

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if (defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return false;

        // Get Modern Events Calendar Data
        $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();

        $mec_zoom_event = (isset($_mec['mec_zoom_event']) and !empty($_mec['mec_zoom_event'])) ? $_mec['mec_zoom_event'] : 'none';
        update_post_meta($post_id, 'mec_zoom_event', $mec_zoom_event);

        $mec_zoom_badge_shortcode = (isset($_mec['mec_zoom_badge_shortcode']) and !empty($_mec['mec_zoom_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_badge_shortcode', $mec_zoom_badge_shortcode);

        $mec_display_booking_history = isset($_mec['mec_display_booking_history']) ? '1' : '0';
        update_post_meta($post_id, 'mec_display_booking_history', $mec_display_booking_history);

        $mec_zoom_badge_single = (isset($_mec['mec_zoom_badge_single']) and !empty($_mec['mec_zoom_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_badge_single', $mec_zoom_badge_single);

        $mec_zoom_join_url = (isset($_mec['mec_zoom_join_url']) and !empty($_mec['mec_zoom_join_url'])) ? $_mec['mec_zoom_join_url'] : '';
        update_post_meta($post_id, 'mec_zoom_join_url', $mec_zoom_join_url);

        $mec_zoom_join_title = (isset($_mec['mec_zoom_join_title']) and !empty($_mec['mec_zoom_join_title'])) ? $_mec['mec_zoom_join_title'] : '';
        update_post_meta($post_id, 'mec_zoom_join_title', $mec_zoom_join_title);

        $mec_zoom_join_target = (isset($_mec['mec_zoom_join_target']) and !empty($_mec['mec_zoom_join_target'])) ? $_mec['mec_zoom_join_target'] : '';
        update_post_meta($post_id, 'mec_zoom_join_target', $mec_zoom_join_target);

        $mec_zoom_link_url = (isset($_mec['mec_zoom_link_url']) and !empty($_mec['mec_zoom_link_url'])) ? $_mec['mec_zoom_link_url'] : '';
        update_post_meta($post_id, 'mec_zoom_link_url', $mec_zoom_link_url);

        $mec_zoom_link_title = (isset($_mec['mec_zoom_link_title']) and !empty($_mec['mec_zoom_link_title'])) ? $_mec['mec_zoom_link_title'] : '';
        update_post_meta($post_id, 'mec_zoom_link_title', $mec_zoom_link_title);

        $mec_zoom_link_target = (isset($_mec['mec_zoom_link_target']) and !empty($_mec['mec_zoom_link_target'])) ? $_mec['mec_zoom_link_target'] : '';
        update_post_meta($post_id, 'mec_zoom_link_target', $mec_zoom_link_target);

        $mec_zoom_embed = (isset($_mec['mec_zoom_embed']) and !empty($_mec['mec_zoom_embed'])) ? $_mec['mec_zoom_embed'] : '';
        update_post_meta($post_id, 'mec_zoom_embed', $mec_zoom_embed);

        $mec_zoom_show_info_time = (isset($_mec['mec_zoom_show_info_time']) and !empty($_mec['mec_zoom_show_info_time'])) ? $_mec['mec_zoom_show_info_time'] : '';
        update_post_meta($post_id, 'mec_zoom_show_info_time', $mec_zoom_show_info_time);

        $mec_zoom_show_info_hm = (isset($_mec['mec_zoom_show_info_hm']) and !empty($_mec['mec_zoom_show_info_hm'])) ? $_mec['mec_zoom_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_zoom_show_info_hm', $mec_zoom_show_info_hm);

        $mec_zoom_hide_info = (isset($_mec['mec_zoom_hide_info']) and !empty($_mec['mec_zoom_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_hide_info', $mec_zoom_hide_info);

        $mec_zoom_hide_info_before_start = (isset($_mec['mec_zoom_hide_info_before_start']) and !empty($_mec['mec_zoom_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_hide_info_before_start', $mec_zoom_hide_info_before_start);

        $mec_zoom_password = (isset($_mec['mec_zoom_password']) and !empty($_mec['mec_zoom_password'])) ? $_mec['mec_zoom_password'] : '';
        update_post_meta($post_id, 'mec_zoom_password', $mec_zoom_password);

        $mec_zoom_display_password_in_booking = (isset($_mec['mec_zoom_display_password_in_booking']) and !empty($_mec['mec_zoom_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_password_in_booking', $mec_zoom_display_password_in_booking);

        $mec_zoom_display_join_in_booking = (isset($_mec['mec_zoom_display_join_in_booking']) and !empty($_mec['mec_zoom_display_join_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_join_in_booking', $mec_zoom_display_join_in_booking);

        $mec_zoom_display_link_in_booking = (isset($_mec['mec_zoom_display_link_in_booking']) and !empty($_mec['mec_zoom_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_link_in_booking', $mec_zoom_display_link_in_booking);

        $mec_zoom_display_embed_in_booking = (isset($_mec['mec_zoom_display_embed_in_booking']) and !empty($_mec['mec_zoom_display_embed_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_embed_in_booking', $mec_zoom_display_embed_in_booking);

        $mec_zoom_meeting_id = (isset($_mec['mec_zoom_meeting_id']) and !empty($_mec['mec_zoom_meeting_id'])) ? $_mec['mec_zoom_meeting_id'] : '';
        update_post_meta($post_id, 'mec_zoom_meeting_id', $mec_zoom_meeting_id);
        $mec_zoom_display_meeting_id_in_booking = (isset($_mec['mec_zoom_display_meeting_id_in_booking']) and !empty($_mec['mec_zoom_display_meeting_id_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_meeting_id_in_booking', $mec_zoom_display_meeting_id_in_booking);



        return true;
    }

    public function save_fes_form($post_id, $mec)
    {

        // $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();

        $mec_zoom_event = (isset($mec['mec_zoom_event']) and !empty($mec['mec_zoom_event'])) ? $mec['mec_zoom_event'] : 'none';
        update_post_meta($post_id, 'mec_zoom_event', $mec_zoom_event);

        $mec_zoom_badge_shortcode = (isset($mec['mec_zoom_badge_shortcode']) and !empty($mec['mec_zoom_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_badge_shortcode', $mec_zoom_badge_shortcode);

        $mec_display_booking_history = isset($_mec['mec_display_booking_history']) ? '1' : '0';
        update_post_meta($post_id, 'mec_display_booking_history', $mec_display_booking_history);

        $mec_zoom_badge_single = (isset($mec['mec_zoom_badge_single']) and !empty($mec['mec_zoom_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_badge_single', $mec_zoom_badge_single);

        $mec_zoom_join_url = (isset($mec['mec_zoom_join_url']) and !empty($mec['mec_zoom_join_url'])) ? $mec['mec_zoom_join_url'] : '';
        update_post_meta($post_id, 'mec_zoom_join_url', $mec_zoom_join_url);

        $mec_zoom_join_title = (isset($mec['mec_zoom_join_title']) and !empty($mec['mec_zoom_join_title'])) ? $mec['mec_zoom_join_title'] : '';
        update_post_meta($post_id, 'mec_zoom_join_title', $mec_zoom_join_title);

        $mec_zoom_join_target = (isset($mec['mec_zoom_join_target']) and !empty($mec['mec_zoom_join_target'])) ? $mec['mec_zoom_join_target'] : '';
        update_post_meta($post_id, 'mec_zoom_join_target', $mec_zoom_join_target);

        $mec_zoom_link_url = (isset($mec['mec_zoom_link_url']) and !empty($mec['mec_zoom_link_url'])) ? $mec['mec_zoom_link_url'] : '';
        update_post_meta($post_id, 'mec_zoom_link_url', $mec_zoom_link_url);

        $mec_zoom_link_title = (isset($mec['mec_zoom_link_title']) and !empty($mec['mec_zoom_link_title'])) ? $mec['mec_zoom_link_title'] : '';
        update_post_meta($post_id, 'mec_zoom_link_title', $mec_zoom_link_title);

        $mec_zoom_link_target = (isset($mec['mec_zoom_link_target']) and !empty($mec['mec_zoom_link_target'])) ? $mec['mec_zoom_link_target'] : '';
        update_post_meta($post_id, 'mec_zoom_link_target', $mec_zoom_link_target);

        $mec_zoom_embed = (isset($mec['mec_zoom_embed']) and !empty($mec['mec_zoom_embed'])) ? $mec['mec_zoom_embed'] : '';
        update_post_meta($post_id, 'mec_zoom_embed', $mec_zoom_embed);

        $mec_zoom_show_info_time = (isset($mec['mec_zoom_show_info_time']) and !empty($mec['mec_zoom_show_info_time'])) ? $mec['mec_zoom_show_info_time'] : '';
        update_post_meta($post_id, 'mec_zoom_show_info_time', $mec_zoom_show_info_time);

        $mec_zoom_show_info_hm = (isset($mec['mec_zoom_show_info_hm']) and !empty($mec['mec_zoom_show_info_hm'])) ? $mec['mec_zoom_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_zoom_show_info_hm', $mec_zoom_show_info_hm);

        $mec_zoom_hide_info = (isset($mec['mec_zoom_hide_info']) and !empty($mec['mec_zoom_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_hide_info', $mec_zoom_hide_info);

        $mec_zoom_hide_info_before_start = (isset($mec['mec_zoom_hide_info_before_start']) and !empty($mec['mec_zoom_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_hide_info_before_start', $mec_zoom_hide_info_before_start);

        $mec_zoom_password = (isset($mec['mec_zoom_password']) and !empty($mec['mec_zoom_password'])) ? $mec['mec_zoom_password'] : '';
        update_post_meta($post_id, 'mec_zoom_password', $mec_zoom_password);

        $mec_zoom_display_password_in_booking = (isset($mec['mec_zoom_display_password_in_booking']) and !empty($mec['mec_zoom_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_password_in_booking', $mec_zoom_display_password_in_booking);

        $mec_zoom_display_join_in_booking = (isset($mec['mec_zoom_display_join_in_booking']) and !empty($mec['mec_zoom_display_join_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_join_in_booking', $mec_zoom_display_join_in_booking);

        $mec_zoom_display_link_in_booking = (isset($mec['mec_zoom_display_link_in_booking']) and !empty($mec['mec_zoom_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_link_in_booking', $mec_zoom_display_link_in_booking);

        $mec_zoom_display_embed_in_booking = (isset($mec['mec_zoom_display_embed_in_booking']) and !empty($mec['mec_zoom_display_embed_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_zoom_display_embed_in_booking', $mec_zoom_display_embed_in_booking);

        return true;
    }

    public static function display_badge_in_single($event_id)
    {
        $main = new \MEC_main();

        $eventx = isset($event_id->ID) ? $event_id->ID : null;
        if (!$eventx) return;

        $event_data = $event_id->ID;
        $timestamp = isset($event_id->time['start_timestamp']) ? $event_id->time['start_timestamp'] : null;

        if ($timestamp) {
            $timestamp = $main->get_start_time_of_multiple_days($event_data, $timestamp);
            $ex = explode(':', $timestamp);
            $timestamp = isset($ex[0]) ? (int) $ex[0] : time();
        } else {
            $timestamp = time();
        }

        $event_date = date('Y-m-d h:i a', $timestamp);

        $zoom_hide_info_before_start = get_post_meta($eventx, 'mec_zoom_hide_info_before_start', true) ?: false;
        $zoom_show_info_time = get_post_meta($eventx, 'mec_zoom_show_info_time', true) ?: 0;
        $zoom_show_info_hm = get_post_meta($eventx, 'mec_zoom_show_info_hm', true) ?: 'hours';
        $mec_zoom_hide_info = get_post_meta($eventx, 'mec_zoom_hide_info', true) ?: false;

        $get_meta = get_post_meta($eventx, 'mec_zoom_badge_single', true) ?: 0;
        $mec_zoom_webinar = get_post_meta($eventx, 'mec_zoom_event', true) === 'webinar' ? esc_html__('Zoom Webinar', 'mec-zi') : '';
        $mec_zoom_meeting = get_post_meta($eventx, 'mec_zoom_event', true) === 'meeting' ? esc_html__('Zoom Meeting', 'mec-zi') : '';

        $content = '';
        if ($mec_zoom_webinar || $mec_zoom_meeting) {
            $content = '<div class="mec-single-zoom-badge"><i class="mec-sl-camrecorder"></i><h3>' . $mec_zoom_webinar . $mec_zoom_meeting . '</h3></div>';
        }

        if ($get_meta == 1) {
            if (
                $zoom_hide_info_before_start && $zoom_show_info_time > 0 &&
                $main->check_date_time_validation('Y-m-d h:i a', strtolower($event_date)) &&
                strtotime("-{$zoom_show_info_time}{$zoom_show_info_hm}", strtotime($event_date)) > current_time('timestamp', 0) &&
                !$mec_zoom_hide_info
            ) {
                echo $content;
            } elseif (!$mec_zoom_hide_info && !$zoom_hide_info_before_start) {
                echo $content;
            }
        }
    }

    public function display_badge_in_shortcode($event_id)
    {
        $get_meta = get_post_meta($event_id, 'mec_zoom_badge_shortcode', true) ?: 0;
        $mec_zoom_webinar = get_post_meta($event_id, 'mec_zoom_event', true) === 'webinar' ? esc_html__('Zoom Webinar', 'mec-zi') : '';
        $mec_zoom_meeting = get_post_meta($event_id, 'mec_zoom_event', true) === 'meeting' ? esc_html__('Zoom Meeting', 'mec-zi') : '';

        if (($mec_zoom_webinar || $mec_zoom_meeting) && $get_meta) {
            echo '<span class="mec-shortcode-zoom-badge">
                    <i class="mec-sl-camrecorder"></i><span>' . $mec_zoom_webinar . $mec_zoom_meeting . '</span>
                  </span>';
        }
    }

    public function display_badge_in_monthly($events_str, $event_id)
    {
        $get_meta = get_post_meta($event_id, 'mec_zoom_badge_shortcode', true) ?: 0;
        $mec_zoom_webinar = get_post_meta($event_id, 'mec_zoom_event', true) === 'webinar' ? esc_html__('Zoom Webinar', 'mec-zi') : '';
        $mec_zoom_meeting = get_post_meta($event_id, 'mec_zoom_event', true) === 'meeting' ? esc_html__('Zoom Meeting', 'mec-zi') : '';

        if (($mec_zoom_webinar || $mec_zoom_meeting) && $get_meta) {
            $events_str = '<span class="mec-shortcode-zoom-badge">
                            <i class="mec-sl-camrecorder"></i><span>' . $mec_zoom_webinar . $mec_zoom_meeting . '</span>
                          </span>';
        }

        return $events_str;
    }


    public function assets()
    {
        wp_enqueue_style('mec-zoom-style', MECZIDASSETS . 'mec-zoom.css');
    }

    public static function display_in_single_page($event)
    {
        $main = new \MEC_main();
        $event_id = isset($event->data->ID) ? $event->data->ID : $event->ID;
        $timestamp = $event->data->time['start_timestamp'];
        $timestamp = $main->get_start_time_of_multiple_days($event_id, $timestamp);

        $ex = explode(':', $timestamp);
        $timestamp = (int) $ex[0];

        $year = date('Y', $timestamp);
        $month = date('m', $timestamp);
        $day = date('d', $timestamp);
        $hour = date('H', $timestamp);
        $minutes = date('i', $timestamp);

        $user_books = EventBook::getInstance()->get_user_books($event_id);
        $user_has_book = (is_array($user_books) && count($user_books)) ? true : false;

        // Ticket Selling Stop
        $event_date = date('Y-m-d h:i a', $timestamp);

        $zoom_join_url = get_post_meta($event_id, 'mec_zoom_join_url', true);
        $zoom_join_title = get_post_meta($event_id, 'mec_zoom_join_title', true);
        $zoom_join_target = get_post_meta($event_id, 'mec_zoom_join_target', true);
        $mec_zoom_display_join_in_booking = get_post_meta($event_id, 'mec_zoom_display_join_in_booking', true);

        $zoom_join = ($zoom_join_title and ($user_has_book || $mec_zoom_display_join_in_booking != '1'))  ? '<a class="mec-event-zoom-join" href="' . $zoom_join_url . '" target="' . $zoom_join_target . '">' . $zoom_join_title . '</a>' : '';

        $zoom_link_url = get_post_meta($event_id, 'mec_zoom_link_url', true);
        $zoom_link_title = get_post_meta($event_id, 'mec_zoom_link_title', true);
        $zoom_link_target = get_post_meta($event_id, 'mec_zoom_link_target', true);
        $mec_zoom_display_link_in_booking = get_post_meta($event_id, 'mec_zoom_display_link_in_booking', true);

        $zoom_link = ($zoom_link_title and ($user_has_book || $mec_zoom_display_link_in_booking != '1'))  ? '<a class="mec-event-zoom-link" href="' . $zoom_link_url . '" target="' . $zoom_link_target . '">' . $zoom_link_title . '</a>' : '';

        $mec_zoom_display_embed_in_booking = get_post_meta($event_id, 'mec_zoom_display_embed_in_booking', true);
        $zoom_embed = ($user_has_book || $mec_zoom_display_embed_in_booking !== '1') && get_post_meta($event_id, 'mec_zoom_embed', true) ? '<div class="mec-event-zoom-embed">' . get_post_meta($event_id, 'mec_zoom_embed', true) . '</div>' : '';

        $zoom_hide_info_before_start = get_post_meta($event_id, 'mec_zoom_hide_info_before_start', true);
        $zoom_show_info_time = get_post_meta($event_id, 'mec_zoom_show_info_time', true);
        $zoom_show_info_hm = get_post_meta($event_id, 'mec_zoom_show_info_hm', true);

        $mec_zoom_hide_info = get_post_meta($event_id, 'mec_zoom_hide_info', true);

        $zoom_display_password_in_booking = get_post_meta($event_id, 'mec_zoom_display_password_in_booking', true);
        $zoom_password = (get_post_meta($event_id, 'mec_zoom_password', true) and ($user_has_book || $zoom_display_password_in_booking != '1')) ? '<div class="mec-zoom-password"><strong>' . esc_html__('Password:', 'mec-zi') . '</strong> <span>' . get_post_meta($event_id, 'mec_zoom_password', true) . '</span></div>' : '';

        $zoom_display_meeting_in_booking = get_post_meta($event_id, 'mec_zoom_display_meeting_in_booking', true);
        $zoom_meeting = (get_post_meta($event_id, 'mec_zoom_meeting_id', true) and ($user_has_book || $zoom_display_meeting_in_booking != '1')) ? '<div class="mec-zoom-meeting"><strong>' . esc_html__('Meeting ID:', 'mec-zi') . '</strong> <span>' . get_post_meta($event_id, 'mec_zoom_meeting_id', true) . '</span></div>' : '';

        $mec_display_booking_history = get_post_meta($event_id, 'mec_display_booking_history', true);

        $content = "";
        if (!empty($zoom_embed) || !empty($zoom_join) || !empty($zoom_link) || !empty($zoom_password) || !empty($zoom_meeting)) {
            $mec_display_booking_history = get_post_meta($event_id, 'mec_display_booking_history', true);
            if ($mec_display_booking_history == '0') {
                $content = '<div class="mec-event-data-fields mec-frontbox" style="display: none;">' .
                    $zoom_embed .
                    $zoom_join .
                    $zoom_link .
                    $zoom_password .
                    $zoom_meeting .
                    '</div>';
            } else {
                $content = '<div class="mec-event-data-fields mec-frontbox">' .
                    $zoom_embed .
                    $zoom_join .
                    $zoom_link .
                    $zoom_password .
                    $zoom_meeting .
                    '</div>';
            }
        }

        if ($zoom_hide_info_before_start and $zoom_show_info_time > 0  and $main->check_date_time_validation('Y-m-d h:i a', strtolower($event_date)) and strtotime("-{$zoom_show_info_time}{$zoom_show_info_hm}", strtotime($event_date)) > current_time('timestamp', 0) and !$mec_zoom_hide_info) {
            echo $content;
        } elseif ($mec_zoom_hide_info and !$main->is_ongoing($event)) {
            echo $content;
        } elseif (!$mec_zoom_hide_info and !$zoom_hide_info_before_start) {
            echo $content;
        } elseif ($user_has_book) {
            // echo $content;
        }
    }

    public function display_password_in_booking($content, $event_id, $book_id)
    {
        $zoom_join_url = get_post_meta($event_id, 'mec_zoom_join_url', true);
        $zoom_join_title = get_post_meta($event_id, 'mec_zoom_join_title', true);
        $zoom_join_target = get_post_meta($event_id, 'mec_zoom_join_target', true);
        $mec_zoom_display_join_in_booking = get_post_meta($event_id, 'mec_zoom_display_join_in_booking', true);

        $zoom_join = ($zoom_join_title and $mec_zoom_display_join_in_booking == '1')
            ? '<div class="mec-event-zoom-join-wrap"><strong>' . esc_html('Zoom Join:', 'mec-zi') . '</strong> <a class="mec-zoom-join-in-booking" href="' . $zoom_join_url . '" target="' . $zoom_join_target . '">' . $zoom_join_title . '</a></div>'
            : '';

        $zoom_link_url = get_post_meta($event_id, 'mec_zoom_link_url', true);
        $zoom_link_title = get_post_meta($event_id, 'mec_zoom_link_title', true);
        $zoom_link_target = get_post_meta($event_id, 'mec_zoom_link_target', true);
        $mec_zoom_display_link_in_booking = get_post_meta($event_id, 'mec_zoom_display_link_in_booking', true);

        $zoom_link = ($zoom_link_title and $mec_zoom_display_link_in_booking == '1')
            ? '<div class="mec-event-zoom-link-wrap"><strong>' . esc_html('Zoom Link:', 'mec-zi') . '</strong> <a class="mec-zoom-link-in-booking" href="' . $zoom_link_url . '" target="' . $zoom_link_target . '">' . $zoom_link_title . '</a></div>'
            : '';

        $zoom_display_password_in_booking = get_post_meta($event_id, 'mec_zoom_display_password_in_booking', true);
        $zoom_password = (get_post_meta($event_id, 'mec_zoom_password', true) and $zoom_display_password_in_booking == '1')
            ? '<div class="mec-zoom-password-in-booking"><strong>' . esc_html__('Zoom Event Password:', 'mec-zi') . '</strong> <span>' . get_post_meta($event_id, 'mec_zoom_password', true) . '</span></div>'
            : '';

        $zoom_meeting_id = get_post_meta($event_id, 'mec_zoom_meeting_id', true);
        $zoom_display_meeting_id_in_booking = get_post_meta($event_id, 'mec_zoom_display_meeting_id_in_booking', true);
        $zoom_meeting = ($zoom_meeting_id and $zoom_display_meeting_id_in_booking == '1')
            ? '<div class="mec-event-zoom-meeting-id-wrap"><strong>' . esc_html__('Meeting ID:', 'mec-zi') . '</strong> <span>' . esc_html($zoom_meeting_id) . '</span></div>'
            : '';

        $mec_zoom_display_embed_in_booking = get_post_meta($event_id, 'mec_zoom_display_embed_in_booking', true);
        $zoom_embed = ($mec_zoom_display_embed_in_booking == '1' && get_post_meta($event_id, 'mec_zoom_embed', true))
            ? '<div class="mec-zoom-embed-in-booking">' . get_post_meta($event_id, 'mec_zoom_embed', true) . '</div>'
            : '';

        $mec_confirmed = get_post_meta($book_id, 'mec_confirmed', true);

        if (!$mec_confirmed) return;

        $content .= $zoom_join . $zoom_link . $zoom_meeting . $zoom_password;

        return $content;
    }


    public function display_notification_field()
    {
    ?>
        <li><span>%%zoom_join%%</span>: <?php _e('Zoom Join', 'mec-zi'); ?></li>
        <li><span>%%zoom_link%%</span>: <?php _e('Zoom link', 'mec-zi'); ?></li>
        <li><span>%%zoom_password%%</span>: <?php _e('Zoom password', 'mec-zi'); ?></li>
        <li><span>%%zoom_embed%%</span>: <?php _e('Zoom embed', 'mec-zi'); ?></li>
        <li><span>%%zoom_meeting_id%%</span>: <?php _e('Zoom Meeting ID', 'mec-zi'); ?></li>
    <?php
    }

    public static function add_header_event_detail_to_dashboard()
    {

        echo '<td>' . __('Zoom', 'mec-zi') . '</td>';
    }

    public static function add_event_detail_to_dashboard($event_id, $book_id, $event)
    {

        if (!$event_id || !$book_id) {
            echo '<td>-</td>';
            return;
        }

        $timestamp = get_post_meta($book_id, 'mec_attention_time_start', true);

        $zoom_join_url = get_post_meta($event_id, 'mec_zoom_join_url', true);
        $zoom_join_title = get_post_meta($event_id, 'mec_zoom_join_title', true);
        $zoom_join_target = get_post_meta($event_id, 'mec_zoom_join_target', true);

        $zoom_join = ($zoom_join_title)  ? '<a class="mec-event-zoom-join" href="' . $zoom_join_url . '" target="' . $zoom_join_target . '">' . $zoom_join_title . '</a>' : '';

        $zoom_link_url = get_post_meta($event_id, 'mec_zoom_link_url', true);
        $zoom_link_title = get_post_meta($event_id, 'mec_zoom_link_title', true);
        $zoom_link_target = get_post_meta($event_id, 'mec_zoom_link_target', true);

        $zoom_link = ($zoom_link_title)  ? '<a class="mec-event-zoom-link" href="' . $zoom_link_url . '" target="' . $zoom_link_target . '">' . $zoom_link_title . '</a>' : '';

        $mec_zoom_display_embed_in_booking = get_post_meta($event_id, 'mec_zoom_display_embed_in_booking', true);
        $zoom_embed = $mec_zoom_display_embed_in_booking !== '1' && get_post_meta($event_id, 'mec_zoom_embed', true) ? '<div class="mec-event-zoom-embed">' . get_post_meta($event_id, 'mec_zoom_embed', true) . '</div>' : '';

        $zoom_hide_info_before_start = get_post_meta($event_id, 'mec_zoom_hide_info_before_start', true);
        $zoom_show_info_time = get_post_meta($event_id, 'mec_zoom_show_info_time', true);
        $zoom_show_info_hm = get_post_meta($event_id, 'mec_zoom_show_info_hm', true);

        $mec_zoom_hide_info = get_post_meta($event_id, 'mec_zoom_hide_info', true);

        $zoom_password = (get_post_meta($event_id, 'mec_zoom_password', true)) ? '<div class="mec-zoom-password"><strong>' . esc_html__('Password:', 'mec-zi') . '</strong> <span>' . get_post_meta($event_id, 'mec_zoom_password', true) . '</span></div>' : '';

        $html = "";
        if (!empty($zoom_embed) || !empty($zoom_join) || !empty($zoom_link) || !empty($zoom_password)) {
            $html = '
                <div class="mec-event-data-fields mec-frontbox">
                    ' . $zoom_embed . '
                    ' . $zoom_join . '
                    ' . $zoom_link . '
                    ' . $zoom_password . '
                </div>
            ';
        }
    ?>
        <td>
            <?php if (!empty($html)): ?>
                <a class="mec-booking-zoom-access-info-link mec-booking-number-of-attendees" href="#mec_profile_booking_zoom_info_<?php echo $book_id; ?>">
                    <?php echo __('<i class="mec-sl-eye"></i>', 'mec-virtual'); ?>
                </a>
                <div id="mec_profile_booking_zoom_info_<?php echo $book_id; ?>" class="mec-booking-zoom-access-info-content mec-booking-attendees lity-hide">
                    <?php echo $html; ?>
                </div>
            <?php else: ?>
                -
            <?php endif; ?>
        </td>
<?php
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zoom_Integration\Autoloader')) {
            return;
        }
    }
} //MecCTP
