<?php

function mec_zoom_admin_notifications_field_creator($notifications,$section){

    $group_id = $section;
    $box_id = 'mec_'.$group_id.'_send_custom_message_for_zoom_events_toggle';
    ?>
    <div class="mec-form-row">
        <?php
           $checked = (isset($notifications[$group_id]['send_custom_message_for_zoom_events']) and $notifications[$group_id]['send_custom_message_for_zoom_events'] == 1) ? true : false;
        ?>
		<label for="mec_notifications_<?php echo $group_id; ?>_custom_message_for_zoom_events">
            <input onchange="jQuery('#<?php echo $box_id; ?>').toggle();" type="checkbox" name="mec[notifications][<?php echo $group_id; ?>][send_custom_message_for_zoom_events]" value="1" id="mec_notifications_<?php echo $group_id; ?>_custom_message_for_zoom_events" <?php checked(true,$checked) ?> />
            <?php _e('Custom message for zoom events', 'mec'); ?>
        </label>
	</div>
    <div id="<?php echo $box_id; ?>" class="<?php echo !$checked ? 'mec-util-hidden': ''  ?>">
        <div class="mec-form-row">
            <label for="mec_notifications_<?php echo $group_id; ?>_zoom_content"><?php _e('Email zoom event Content', 'mec'); ?></label>
            <?php
                $content = isset($notifications[$group_id]['zoom_content']) ? stripslashes($notifications[$group_id]['zoom_content']) : '';
                wp_editor(
                    $content,
                    'mec_notifications_'.$group_id.'_zoom_content',
                     array(
                        'textarea_name'=>'mec[notifications]['.$group_id.'][zoom_content]'
                    )
                );
            ?>
        </div>
    </div>
    <?php
}

function mec_zoom_admin_notifications_field_creator_for_event($notifications,$section){

    $group_id = $section;
    ?>
    <div class="mec-form-row">
        <?php $checked = (isset($notifications[$group_id]['send_custom_message_for_zoom_events']) and $notifications[$group_id]['send_custom_message_for_zoom_events'] == 1) ? true : false; ?>
        <label for="mec_notifications_<?php echo $group_id; ?>_zoom_custom_message_for_zoom_events">
            <input onchange="jQuery('#mec_notification_<?php echo $group_id; ?>_zoom_container_toggle').toggle();" type="checkbox" name="mec[notifications][<?php echo $group_id; ?>][send_custom_message_for_zoom_events]" value="1" id="mec_notifications_<?php echo $group_id; ?>_custom_message_for_zoom_events" <?php checked(true,$checked) ?> />    
            <?php _e('Custom message for zoom events', 'mec'); ?>
        </label>
	</div>
    <?php
        $hidden_class = '';
        $hidden = (isset($notifications[$group_id]['send_custom_message_for_zoom_events']) and !$notifications[$group_id]['send_custom_message_for_zoom_events']) || !isset($notifications[$group_id]['send_custom_message_for_zoom_events']) ? true : false;
        if($hidden) {

            $hidden_class = 'mec-util-hidden';
        }
    ?>
    <div id="mec_notification_<?php echo $group_id; ?>_zoom_container_toggle" class="<?php echo $hidden_class ?>">

        <div class="mec-form-row">
            <label for="mec_notifications_<?php echo $group_id; ?>_zoom_subject"><?php _e('Email Subject', 'mec'); ?></label>
            <input type="text" name="mec[notifications][<?php echo $group_id; ?>][zoom_subject]" id="mec_notifications_<?php echo $group_id; ?>_zoom_subject" value="<?php echo (isset($notifications[$group_id]['zoom_subject']) ? stripslashes($notifications[$group_id]['zoom_subject']) : ''); ?>" />
        </div>

        <div class="mec-form-row">
            <div class="mec-col-2">
                <label for="mec_notifications_<?php echo $group_id; ?>_zoom_content"><?php _e('Email zoom event Content', 'mec'); ?></label>
            </div>

            <div class="mec-col-10">
                <?php
                    $content = isset($notifications[$group_id]['zoom_content']) ? stripslashes($notifications[$group_id]['zoom_content']) : '';
                    wp_editor(
                        $content,
                        'mec_notifications_'.$group_id.'_zoom_content',
                        array(
                            'textarea_name'=>'mec[notifications]['.$group_id.'][zoom_content]'
                        )
                    );
                ?>
            </div>
        </div>
    </div>
    <?php
}

function mec_add_zoom_type_to_settings_notifications_js_content_types($content_types){

    $content_types['zoom'] = "_zoom";

    return $content_types;
}

function mec_get_custom_args_for_zoom_event_notifications($text,$notification_type,$event_id){

    $is_zoom_event = get_post_meta($event_id, 'mec_zoom_event', true);
    if('none' === $is_zoom_event){

        return $text;
    }

    $mec_options = get_option('mec_options', array());

    $notification = $mec_options['notifications'][$notification_type] ?? false;
    $global_text = '';
    if($notification){
        $is_enabled_zoom_notification_in_global = isset($notification['send_custom_message_for_zoom_events']) && $notification['send_custom_message_for_zoom_events'] ? true : false;
        if($is_enabled_zoom_notification_in_global){

            if('mec_notification_get_content' === current_filter()){
                
                $global_text = $notification['zoom_content'] ?? null;
            }elseif('mec_notification_get_subject' === current_filter()){

                $global_text = $notification['subject'] ?? null;
            }
        }
    }
    
    $custom_event_notification = false;
    if(isset($mec_options['settings']['notif_per_event']) && $mec_options['settings']['notif_per_event']){
        
        $notifications = get_post_meta($event_id,'mec_notifications',true);
        $notification = $notifications[$notification_type] ?? false;
        if($notification){

            $custom_event_notification = isset($notification['status']) && '1' == $notification['status'];
            if($custom_event_notification){
                $is_enabled_zoom_notification_in_local = isset($notification['send_custom_message_for_zoom_events']) && $notification['send_custom_message_for_zoom_events'] ? true : false;
                if($is_enabled_zoom_notification_in_local){
    
                    if('mec_notification_get_content' === current_filter()){
                        
                        return $notification['zoom_content'] ?? null;
                    }elseif('mec_notification_get_subject' === current_filter()){
        
                        return $notification['zoom_subject'] ?? null;
                    }                
                }
            }
            

        }
    }

    return $custom_event_notification ? $text : $global_text;
}