<?php
/**
*	Plugin Name: MEC Zoom Integration
*	Plugin URI: http://webnus.net/modern-events-calendar/
*	Description: Zoom Integration
*	Version: 1.3.0
*	Text Domain: mec-zi
*	Domain Path: /languages
*   Author: Webnus
*	Author URI: http://webnus.net
**/
namespace MEC_Zoom_Integration;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Zoom_Integration
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
			self::init();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_Zoom_Integration_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECZIVERSION' , '1.3.0');
		define('MECZIDIR' , plugin_dir_path(__FILE__));
		define('MECZIURL' , plugin_dir_url(__FILE__));
		define('MECZIDASSETS' , MECZIURL . 'assets/' );
		define('MECZINAME' , 'Zoom Integration');
		define('MECZISLUG' , 'mec-zoom-integration');
		define('MECZIOPTIONS' , 'mec_zoom_integration_options');
		define('MECZITEXTDOMAIN' , 'mec-zi');
		define('MECZIMAINFILEPATH' ,__FILE__);
		define('MECZIABSPATH', dirname(__FILE__));

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
		add_action( 'plugins_loaded', [$This,'addon_load_text_domain'] );
	}

	/**
	 * Load plugin textdomain.
	 */
	public function addon_load_text_domain() {
		load_plugin_textdomain( 'mec-zi', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECZIDIR . DS . 'core' . DS . 'autoloader.php';
		include_once __DIR__ .'/includes/functions.php';
	}

	public static function init(){
		//admin
		add_action('mec_display_notification_settings','mec_zoom_admin_notifications_field_creator',10,2);
		add_action('mec_display_notification_settings_for_event','mec_zoom_admin_notifications_field_creator_for_event',10,2);
		add_filter('mec_settings_notifications_js_content_types','mec_add_zoom_type_to_settings_notifications_js_content_types');


		//wp
		// MEC notifications
		add_filter('mec_notification_get_content','mec_get_custom_args_for_zoom_event_notifications',10,3);
		add_filter('mec_notification_get_subject','mec_get_custom_args_for_zoom_event_notifications',10,3);

		add_filter( 'mec_ical_single_description', array( __CLASS__, 'filter_ical_single_description' ), 10, 3 );
		add_action( 'mec_add_to_calander_event_description', array( __CLASS__, 'add_to_calendar_event_description' ), 10, 1 );
	}

	public static function filter_ical_single_description( $content, $event_id, $event ){

		$is_zoom = in_array(
			get_post_meta( $event_id, 'mec_zoom_event', true ),
			array('webinar', 'meeting'),
			false
		);

		if( $is_zoom ){

			$content .= self::get_zoom_details_for_export( $event );;
		}

		return $content;
	}

	public static function add_to_calendar_event_description( $event ){

		$event_id = $event->ID;
		echo self::filter_ical_single_description('', $event_id, $event );
	}

	public static function get_zoom_details_for_export( $event ){

		$single = new \MEC_Zoom_Integration\Core\singleOptions\SingleOptions();
		ob_start();
			$single->display_in_single_page( $event );
		$html = ob_get_clean();

		$html = str_replace( '<div', '<p',$html );
		$html = str_replace( '</div', '</p', $html );

		return $html;
	}

} //Base

Base::instance();
