<?php
namespace Elementor;

/** no direct access */
defined( 'MECEXEC' ) or die();

/**
 * Webnus MEC elementor agenda View class
 *
 * @author Webnus <info@webnus.biz>
 */
class MEC_elementor_agenda_display_opts {


	/**
	 * Register Elementor agenda View options
	 *
	 * @author Webnus <info@webnus.biz>
	 */
	public static function options( $self ) {

		$style_options = apply_filters(
			'mec_shortcode_builder_style_options',
			array(
				'clean' => __( 'Clean', 'mec-shortcode-builder' ),
			),
			'agenda'
		);

		// Style
		$self->add_control(
			// mec_sk_options_
			'agenda_style',
			array(
				'label'     => __( 'Style', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'clean',
				'options'   => $style_options,
				'condition' => [
					'skin' => 'agenda',
				],
			)
		);
		// Start Date
		$self->add_control(
			// mec_sk_options_
			'agenda_start_date_type',
			array(
				'label'     => __( 'Start Date', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'today',
				'options'   => [
					'today'               => __( 'Today', 'mec-shortcode-builder' ),
					'tomorrow'            => __( 'Tomorrow', 'mec-shortcode-builder' ),
					'start_current_month' => __( 'Start of Current Month', 'mec-shortcode-builder' ),
					'start_next_month'    => __( 'Start of Next Month', 'mec-shortcode-builder' ),
					'date'                => __( 'On a certain date', 'mec-shortcode-builder' ),
				],
				'condition' => [
					'skin' => [
						'agenda',
					],
				],
			)
		);

		$self->add_control(
			// mec_sk_options_
			'agenda_end_date_type',
			array(
				'label'     => __( 'End Date', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'date',
				'options'   => [
					'date' 				  => __( 'On a certain date', 'mec-shortcode-builder' ),
					'today'               => __( 'Today', 'mec-shortcode-builder' ),
					'tomorrow'            => __( 'Tomorrow', 'mec-shortcode-builder' ),
				],
				'condition' => [
					'skin' => [
						'agenda',
					],
				],
			)
		);

		$self->add_control(
			// mec_sk_options_
			'agenda_end_date',
			array(
				'label'       => __( 'On a certain date', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::DATE_TIME,
				'description' => __( 'Maximum Date', 'mec-shortcode-builder' ),
				'condition'   => [
					'skin'         => [
						'agenda',
					],
					'agenda_end_date_type' => [
						'date',
					],
				],
				'picker_options' => [
					'dateFormat' => 'M d Y',
				],
				'default'        => '',
			)
		);

		// Descending Order
		$self->add_control(
			'agenda_order_method',
			[
				'label'        => __( 'Descending Order', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'DESC', 'mec-shortcode-builder' ),
				'label_off'    => __( 'ASC', 'mec-shortcode-builder' ),
				'return_value' => 'DESC',
				'default'      => '',
				'description'  => __( 'Enable this option to sort events in descending order.', 'mec-shortcode-builder' ),
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);

		// Date Formats clean
		$self->add_control(
			// mec_sk_options_
			'agenda_clean_date_format1',
			array(
				'label'       => __( 'Date Format 1', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'l',
				'description' => __( 'Default value is "l". <a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">Date format list</a>', 'mec-shortcode-builder' ),
				'condition'   => [
					'skin'         => [
						'agenda',
					],
					'agenda_style' => [
						'clean',
					],
				],
			)
		);
		$self->add_control(
			// mec_sk_options_
			'agenda_clean_date_format2',
			array(
				'label'       => __( 'Date Format 2', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'F j',
				'description' => __( 'Default value is "F j". <a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">Date format list</a>', 'mec-shortcode-builder' ),
				'condition'   => [
					'skin'         => [
						'agenda',
					],
					'agenda_style' => [
						'clean',
					],
				],
			)
		);

		// On a certain date
		$self->add_control(
			'agenda_start_date',
			[
				'label'          => __( 'On a certain date', 'mec-shortcode-builder' ),
				'type'           => \Elementor\Controls_Manager::DATE_TIME,
				'condition'      => [
					'skin'                   => [
						'agenda',
					],
					'agenda_start_date_type' => [
						'date',
					],
				],
				'picker_options' => [
					'dateFormat' => 'M d Y',
				],
				'default'        => date( 'M d Y', current_time( 'timestamp' ) ),
			]
		);
		// Limit
		$self->add_control(
			'agenda_limit',
			[
				'label'       => __( 'Limit', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => __( 'eg. 6', 'mec-shortcode-builder' ),
				'min'         => 1,
				'max'         => 99999999,
				'step'        => 1,
				'default'     => 6,
				'condition'   => [
					'skin' => [
						'agenda',
					],
				],
			]
		);

		// Pagination Method
		$self->add_control(
			'agenda_pagination_method',
			[
				'label'        => __( 'Pagination Method', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'loadmore',
				'options'     => [
					'loadmore'  => __( 'Load More Button', 'mec-shortcode-builder' ),
					'scroll' => __( 'Infinite Scroll', 'mec-shortcode-builder' ),
					'nextprev' => __( 'Next / Prev', 'mec-shortcode-builder' ),
					'0' => __( 'Disabled', 'mec-shortcode-builder' ),
				],
				'condition'    => [
					'skin' => [
						'agenda',
					],
					'agenda_style' => array(
						'clean',
					)
				],
			]
		);

		// Load More Button
		$self->add_control(
			'agenda_load_more_button',
			[
				'label'        => __( 'Load More Button', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '1',
				'condition'    => [
					'skin' => [
						'agenda',
					],
					'agenda_style!' => array(
						'clean',
					)
				],
			]
		);
		// Localtime
		$self->add_control(
			'agenda_include_local_time',
			[
				'label'        => __( 'Include Local Time', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);
		// Normal Label
		$self->add_control(
			'agenda_display_label',
			[
				'label'        => __( 'Display Normal Labels', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);
		// Reason for Cancellation
		$self->add_control(
			'agenda_reason_for_cancellation',
			[
				'label'        => __( 'Display Reason for Cancellation', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);

		$self->add_control(
			// mec_sk_options_
			'agenda_custom_data',
			[
				'label'        => __( 'Display Custom Fields', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);

		$self->add_control(
			// mec_sk_options_
			'agenda_booking_button',
			[
				'label'        => __( 'Booking Button / Icon', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);

		// Show Month Divider
		$self->add_control(
			'agenda_month_divider',
			[
				'label'        => __( 'Show Month Divider', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda',
					],
				],
			]
		);
		// Single Event Display Method
		$self->add_control(
			'agenda_sed_method',
			[
				'label'       => __( 'Single Event Display Method', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'label_block' => true,
				'options'     => [
					'0'  => __( 'Current Window', 'mec-shortcode-builder' ),
					'new' => __( 'New Window', 'mec-shortcode-builder' ),
					'm1' => __( 'Modal Popup', 'mec-shortcode-builder' ),
					'no' => __( 'Disable Link', 'mec-shortcode-builder' ),
				],
				'condition'   => [
					'skin'          => [
						'agenda',
					],
					'agenda_style!' => [
						'accordion',
					],
				],

			]
		);

		$self->add_control(
			// mec_sk_options_
			'agenda_image_popup',
			[
				'label'        => __( 'Display content\'s images as Popup', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'agenda'
					],
					'agenda_sed_method' => [
						'm1',
					]
				],
			]
		);
	}
}
