<?php
namespace Elementor;

/** no direct access **/
defined('MECEXEC') or die();

/**
 * Webnus MEC elementor daily View class
 * @author Webnus <info@webnus.biz>
 */
class MEC_elementor_daily_display_opts
{

    /**
     * Register Elementor daily View options
     * @author Webnus <info@webnus.biz>
     */
    public static function options($self)
    {

        $style_options = apply_filters(
			'mec_shortcode_builder_style_options',
			array(
				'classic'    => __('Classic', 'mec-shortcode-builder'),
			),
			'daily_view'
		);

        // Style
        $self->add_control(
            // mec_sk_options_
            'daily_view_style',
            array(
                'label'     => __('Style', 'mec-shortcode-builder'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'classic',
                'options'   => $style_options,
                'condition'     => [
                    'skin'  => [
                        'daily_view'
                    ],
                ]
            )
        );

        // Start Date
        $self->add_control(
            // mec_sk_options_
            'daily_start_date_type',
            array(
                'label'     => __('Start Date', 'mec-shortcode-builder'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'today',
                'options'   => [
                    'today'                 => __('Today', 'mec-shortcode-builder'),
                    'tomorrow'              => __('Tomorrow', 'mec-shortcode-builder'),
                    'start_current_month'   => __('Start of Current Month', 'mec-shortcode-builder'),
                    'start_next_month'      => __('Start of Next Month', 'mec-shortcode-builder'),
                    'date'                  => __('On a certain date', 'mec-shortcode-builder'),
                ],
                'condition'     => [
                    'skin'  => [
                        'daily_view'
                    ],
                ]
            )
        );
        // On a certain date
        $self->add_control(
            'daily_start_date',
            [
                'label'     => __('On a certain date', 'mec-shortcode-builder'),
                'type'      => \Elementor\Controls_Manager::DATE_TIME,
                'condition' => [
                    'skin' => [
                        'daily_view'
                    ],
                    'daily_start_date_type' => [
                        'date'
                    ],
                ],
                'picker_options' => [
                    'dateFormat' => 'M d Y'
                ],
                'default'   => date('M d Y', current_time('timestamp'))
            ]
        );
        // Events per day
        $self->add_control(
            'daily_limit',
            [
                'label'         => __('Events per day', 'mec-shortcode-builder'),
                'type'          => \Elementor\Controls_Manager::NUMBER,
                'placeholder'   => __('eg. 6', 'mec-shortcode-builder'),
                'min'           => 1,
                'max'           => 99999999,
                'step'          => 1,
                'default'       => 6,
                'condition' => [
                    'skin' => [
                        'daily_view'
                    ],
                    'daily_view_style!' => [
                        'liquid',
                    ],
                ],
            ]
        );
        // Next/Previous Buttons
        $self->add_control(
            'daily_next_previous_button',
            [
                'label'         => __('Next/Previous Buttons', 'mec-shortcode-builder'),
                'type'          => \Elementor\Controls_Manager::SWITCHER,
                'label_on'      => __('Show', 'mec-shortcode-builder'),
                'label_off'     => __('Hide', 'mec-shortcode-builder'),
                'return_value'  => '1',
                'default'       => '1',
                'condition' => [
                    'skin' => [
                        'daily_view'
                    ],
                    'daily_view_style!' => [
                        'liquid',
                    ],
                ],
            ]
        );
		// Localtime
		$self->add_control(
			'daily_include_local_time',
			[
				'label'        => __( 'Include Local Time', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'daily_view',
					],
                    'daily_view_style!' => [
                        'liquid',
                    ],
				],
			]
		);
		// Normal Label
		$self->add_control(
			'daily_display_label',
			[
				'label'        => __( 'Display Normal Labels', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'daily_view',
					],
                    'daily_view_style!' => [
                        'liquid',
                    ],
				],
			]
		);
		// Reason for Cancellation
		$self->add_control(
			'daily_reason_for_cancellation',
			[
				'label'        => __( 'Display Reason for Cancellation', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'daily_view',
					],
                    'daily_view_style!' => [
                        'liquid',
                    ],
				],
			]
		);

        $self->add_control(
            // mec_sk_options_
            'daily_custom_data',
            [
                'label'        => __( 'Display Custom Fields', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view',
                    ],
                ],
            ]
        );

        $self->add_control(
            // mec_sk_options_
            'daily_booking_button',
            [
                'label'        => __( 'Booking Button / Icon', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view',
                    ],
                ],
            ]
        );

        $self->add_control(
            'daily_display_categories',
            [
                'label'        => __( 'Display Categories', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view',
                    ],
                    'daily_view_style!' => [
                        'liquid',
                    ],
                ],
            ]
        );

        $self->add_control(
            // mec_sk_options_
            'daily_display_organizer',
            [
                'label'        => __( 'Display Organizers', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view'
                    ],
                ],
            ]
        );

        $self->add_control(
            // mec_sk_options_
            'daily_detailed_time',
            [
                'label'        => __( 'Detailed Time', 'mec-shortcode-builder' ),
                'description'  => __( 'For Multiple Day Events', 'mec-shortode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view'
                    ],
                ],
            ]
        );

        // Single Event Display Method
        $self->add_control(
            'daily_sed_method',
            [
                'label'     => __('Single Event Display Method', 'mec-shortcode-builder'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '0',
                'label_block' => true,
                'options'   => [
					'0'  => __( 'Current Window', 'mec-shortcode-builder' ),
					'new' => __( 'New Window', 'mec-shortcode-builder' ),
					'm1' => __( 'Modal Popup', 'mec-shortcode-builder' ),
					'no' => __( 'Disable Link', 'mec-shortcode-builder' ),
                ],
                'condition' => [
                    'skin' => [
                        'daily_view'
                    ],
                ],

            ]
        );

        $self->add_control(
            // mec_sk_options_
            'daily_image_popup',
            [
                'label'        => __( 'Display content\'s images as Popup', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'daily_view'
                    ],
                    'daily_sed_method' => [
                        'm1',
                    ]
                ],
            ]
        );
    }
}
