<?php
namespace Elementor;

/** no direct access */
defined( 'MECEXEC' ) or die();

/**
 * Webnus MEC elementor custom View class
 *
 * @author Webnus <info@webnus.biz>
 */
class MEC_elementor_general_calendar_display_opts {

	/**
	 * Register Elementor custom View options
	 *
	 * @author Webnus <info@webnus.biz>
	 */
	public static function options( $self ) {

		// $style_options = apply_filters(
		// 	'mec_shortcode_builder_style_options',
		// 	array(
		// 		'classic'    => __('Classic', 'mec-shortcode-builder'),
		// 	),
		// 	'general_calendar'
		// );

        // // Style
        // $self->add_control(
        //     // mec_sk_options_
        //     'general_calendar_style',
        //     array(
        //         'label'     => __('Style', 'mec-shortcode-builder'),
        //         'type'      => \Elementor\Controls_Manager::SELECT,
        //         'default'   => 'modern',
        //         'options'   => $style_options,
        //         'condition'     => [
        //             'skin'  => [
        //                 'general_calendar'
        //             ],
        //         ]
        //     )
        // );

		// On a certain date
		$self->add_control(
			// mec_sk_options_
			'general_calendar_start_date_type',
			array(
				'label'     => __( 'Start Date', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'today',
				'options'   => [
					'today'               => __( 'Today', 'mec-shortcode-builder' ),
					'tomorrow'            => __( 'Tomorrow', 'mec-shortcode-builder' ),
					'start_current_month' => __( 'Start of Current Month', 'mec-shortcode-builder' ),
					'start_next_month'    => __( 'Start of Next Month', 'mec-shortcode-builder' ),
					'date'                => __( 'On a certain date', 'mec-shortcode-builder' ),
				],
				'condition' => [
					'skin' => [
						'general_calendar',
					],
				],
			)
		);

		// Limit
		$self->add_control(
			'general_calendar_more_event',
			[
				'label'     => __( 'Number of events in a cell to view "more"', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => __( 'eg. 6', 'mec-shortcode-builder' ),
				'min'         => 1,
				'max'         => 99999999,
				'step'        => 1,
				'default'     => 6,
				'condition'   => [
					'skin' => [
						'general_calendar',
					],
				],
			]
		);

		// Localtime
		$self->add_control(
			'general_calendar_include_local_time',
			[
				'label'        => __( 'Include Local Time', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'general_calendar',
					],
				],
			]
		);

		// Normal Label
		$self->add_control(
			'general_calendar_display_label',
			[
				'label'        => __( 'Display Normal Labels', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'general_calendar',
					],
				],
			]
		);

		// Reason for Cancellation
		$self->add_control(
			'general_calendar_reason_for_cancellation',
			[
				'label'        => __( 'Display Reason for Cancellation', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'general_calendar',
					],
				],
			]
		);

		// Single Event Display Method
		$self->add_control(
			'general_calendar_sed_method',
			[
				'label'       => __( 'Single Event Display Method', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'label_block' => true,
				'options'     => [
					'0'  => __( 'Current Window', 'mec-shortcode-builder' ),
					'new' => __( 'New Window', 'mec-shortcode-builder' ),
					'm1' => __( 'Modal Popup', 'mec-shortcode-builder' ),
					'no' => __( 'Disable Link', 'mec-shortcode-builder' ),
				],
				'condition'   => [
					'skin'        => [
						'general_calendar',
					],
				],

			]
		);

		$self->add_control(
			// mec_sk_options_
			'general_calendar_image_popup',
			[
				'label'        => __( 'Display content\'s images as Popup', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'general_calendar'
					],
					'general_calendar_sed_method' => [
						'm1',
					]
				],
			]
		);

		// Image Size
		$self->add_control(
			'general_calendar_image_size',
			[
				'label'       => __( 'Image Size', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'default',
				'label_block' => true,
				'options'     => [
					'default'      => __( 'Default', 'mec-shortcode-builder' ),
					'thumbnail'    => __( 'Thumbnail', 'mec-shortcode-builder' ),
					'medium'       => __( 'Medium', 'mec-shortcode-builder' ),
					'medium_large' => __( 'Medium Large', 'mec-shortcode-builder' ),
					'large'        => __( 'Large', 'mec-shortcode-builder' ),
					'full'         => __( 'Full', 'mec-shortcode-builder' ),
				],
				'condition'   => [
					'skin' => [
						'general_calendar',
					],
				],
			]
		);
	}
}
