<?php
namespace Elementor;

/** no direct access */
defined( 'MECEXEC' ) or die();

/**
 * Webnus MEC elementor timeline View class
 *
 * @author Webnus <info@webnus.biz>
 */
class MEC_elementor_timeline_display_opts {


	/**
	 * Register Elementor timeline View options
	 *
	 * @author Webnus <info@webnus.biz>
	 */
	public static function options( $self ) {

		// $style_options = apply_filters(
		// 	'mec_shortcode_builder_style_options',
		// 	array(
		// 		'classic'    => __('Classic', 'mec-shortcode-builder'),
		// 	),
		// 	'timeline'
		// );

        // // Style
        // $self->add_control(
        //     // mec_sk_options_
        //     'timeline_style',
        //     array(
        //         'label'     => __('Style', 'mec-shortcode-builder'),
        //         'type'      => \Elementor\Controls_Manager::SELECT,
        //         'default'   => 'modern',
        //         'options'   => $style_options,
        //         'condition'     => [
        //             'skin'  => [
        //                 'timeline'
        //             ],
        //         ]
        //     )
        // );

		// Start Date
		$self->add_control(
			// mec_sk_options_
			'timeline_start_date_type',
			array(
				'label'     => __( 'Start Date', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'start_current_month',
				'options'   => [
					'today'               => __( 'Today', 'mec-shortcode-builder' ),
					'tomorrow'            => __( 'Tomorrow', 'mec-shortcode-builder' ),
					'start_current_month' => __( 'Start of Current Month', 'mec-shortcode-builder' ),
					'start_next_month'    => __( 'Start of Next Month', 'mec-shortcode-builder' ),
					'date'                => __( 'On a certain date', 'mec-shortcode-builder' ),
				],
				'condition' => [
					'skin' => [
						'timeline',
					],
				],
			)
		);
		// On a certain date
		$self->add_control(
			'timeline_start_date',
			[
				'label'          => __( 'On a certain date', 'mec-shortcode-builder' ),
				'type'           => \Elementor\Controls_Manager::DATE_TIME,
				'picker_options' => [
					'dateFormat' => 'M d Y',
				],
				'default'        => date( 'M d Y', current_time( 'timestamp' ) ),
				'condition'      => [
					'skin'                   => [
						'timeline',
					],
					'timeline_start_date_type' => [
						'date',
					],
				],
			]
		);

		$self->add_control(
			// mec_sk_options_
			'timeline_end_date_type',
			array(
				'label'     => __( 'End Date', 'mec-shortcode-builder' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'date',
				'options'   => [
					'date' 				  => __( 'On a certain date', 'mec-shortcode-builder' ),
					'today'               => __( 'Today', 'mec-shortcode-builder' ),
					'tomorrow'            => __( 'Tomorrow', 'mec-shortcode-builder' ),
				],
				'condition' => [
					'skin' => [
						'timeline',
					],
				],
			)
		);

		$self->add_control(
			// mec_sk_options_
			'timeline_end_date',
			array(
				'label'       => __( 'On a certain date', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::DATE_TIME,
				'description' => __( 'Maximum Date', 'mec-shortcode-builder' ),
				'condition'   => [
					'skin'         => [
						'timeline',
					],
					'timeline_end_date_type' => [
						'date',
					],
				],
				'picker_options' => [
					'dateFormat' => 'M d Y',
				],
				'default'        => '',
			)
		);

		// Date Formats modern
		$self->add_control(
			// mec_sk_options_
			'timeline_date_format1',
			array(
				'label'       => __( 'Date Format', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'd F Y',
				'description' => __( 'Default value is "d F Y". <a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">Date format list</a>', 'mec-shortcode-builder' ),
				'condition'   => [
					'skin' => [
						'timeline',
					],
				],
			)
		);
		// Events per day
		$self->add_control(
			'timeline_limit',
			[
				'label'       => __( 'Limit', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => __( 'eg. 6', 'mec-shortcode-builder' ),
				'min'         => 1,
				'max'         => 99999999,
				'step'        => 1,
				'default'     => 6,
				'condition'   => [
					'skin' => [
						'timeline',
					],
				],
			]
        );

		// Pagination Method
		$self->add_control(
			'timeline_pagination_method',
			[
				'label'        => __( 'Pagination Method', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'loadmore',
				'options'     => [
					'loadmore'  => __( 'Load More Button', 'mec-shortcode-builder' ),
					'scroll' => __( 'Infinite Scroll', 'mec-shortcode-builder' ),
					'nextprev' => __( 'Next / Prev', 'mec-shortcode-builder' ),
					'0' => __( 'Disabled', 'mec-shortcode-builder' ),
				],
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);

        // Normal Label
		$self->add_control(
			'timeline_display_label',
			[
				'label'        => __( 'Display Normal Labels', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);
		// Reason for Cancellation
		$self->add_control(
			'timeline_reason_for_cancellation',
			[
				'label'        => __( 'Display Reason for Cancellation', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);

		$self->add_control(
            // mec_sk_options_
            'timeline_custom_data',
            [
                'label'        => __( 'Display Custom Fields', 'mec-shortcode-builder' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
                'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
                'return_value' => '1',
                'default'      => '0',
                'condition'    => [
                    'skin' => [
                        'timeline',
                    ],
                ],
            ]
        );

		$self->add_control(
			// mec_sk_options_
			'timeline_booking_button',
			[
				'label'        => __( 'Booking Button / Icon', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);

		$self->add_control(
			'timeline_display_categories',
			[
				'label'        => __( 'Display Categories', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);

		$self->add_control(
			// mec_sk_options_
			'timeline_display_organizer',
			[
				'label'        => __( 'Display Organizers', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline'
					],
				],
			]
		);

		// Localtime
		$self->add_control(
			'timeline_include_local_time',
			[
				'label'        => __( 'Include Local Time', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);
		// Show Month Divider
		$self->add_control(
			'timeline_month_divider',
			[
				'label'        => __( 'Show Month Divider', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '1',
				'condition'    => [
					'skin' => [
						'timeline',
					],
				],
			]
		);

		// Single Event Display Method
		$self->add_control(
			'timeline_sed_method',
			[
				'label'       => __( 'Single Event Display Method', 'mec-shortcode-builder' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'label_block' => true,
				'options'     => [
					'0'  => __( 'Current Window', 'mec-shortcode-builder' ),
					'new' => __( 'New Window', 'mec-shortcode-builder' ),
					'm1' => __( 'Modal Popup', 'mec-shortcode-builder' ),
					'no' => __( 'Disable Link', 'mec-shortcode-builder' ),
				],
				'condition'   => [
					'skin' => [
						'timeline',
					],
				],

			]
		);

		$self->add_control(
			// mec_sk_options_
			'timeline_image_popup',
			[
				'label'        => __( 'Display content\'s images as Popup', 'mec-shortcode-builder' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'mec-shortcode-builder' ),
				'label_off'    => __( 'Hide', 'mec-shortcode-builder' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'skin' => [
						'timeline'
					],
					'timeline_sed_method' => [
						'm1',
					]
				],
			]
		);
	}
}
