<?php
namespace Elementor;

use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;

/** no direct access */
defined( 'MECEXEC' ) or die();

if ( ! class_exists( 'MEC_addon_elementor_shortcode_builder' ) ) :
	/**
	 * Webnus MEC elementor addon shortcode class
	 *
	 * @author Webnus <info@webnus.biz>
	 */
	class MEC_addon_elementor_shortcode_builder extends \Elementor\Widget_Base {

		/**
		 * Retrieve MEC widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'MEC-SHORTCODE-BUILDER';
		}

		/**
		 * Retrieve MEC widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'MEC Shortcode Builder', 'mec-shortcode-builder' );
		}

		/**
		 * Retrieve MEC widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-archive-posts';
		}

		/**
		 * Set widget category.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return array Widget category.
		 */
		public function get_categories() {
			return array( 'mec' );
		}

		/**
		 * Set Scripts.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return array Scripts Array.
		 */
		public function get_script_depends() {
			return [
				'mec-isotope-script',
				'mec-owl-carousel-script',
				'googlemap',
				'mec-richmarker-script',
				'mec-frontend-script',
				// Ensure General Calendar preview works inside Elementor editor
				'mec-general-calendar-script',
			];
		}

		public function get_style_depends() {
			return [ 'mec-frontend-style', 'mec-owl-carousel-style', 'mec-owl-carousel-theme-style', 'mec-general-calendar-style' ];
		}

		public function get_all_skins(){

			$skins = array(
				'list'           	=> __( 'List View', 'mec-shortcode-builder' ),
				'grid'           	=> __( 'Grid View', 'mec-shortcode-builder' ),
				'agenda'         	=> __( 'Agenda View', 'mec-shortcode-builder' ),
				'full_calendar'  	=> __( 'Full Calendar', 'mec-shortcode-builder' ),
				'yearly_view'    	=> __( 'Yearly View', 'mec-shortcode-builder' ),
				'monthly_view'   	=> __( 'Calendar / Monthly View', 'mec-shortcode-builder' ),
				'daily_view'     	=> __( 'Daily View', 'mec-shortcode-builder' ),
				'weekly_view'    	=> __( 'Weekly View', 'mec-shortcode-builder' ),
				'timetable'      	=> __( 'Timetable View', 'mec-shortcode-builder' ),
				'masonry'        	=> __( 'Masonry View', 'mec-shortcode-builder' ),
				'map'            	=> __( 'Map View', 'mec-shortcode-builder' ),
				'cover'          	=> __( 'Cover View', 'mec-shortcode-builder' ),
				'countdown'      	=> __( 'Countdown View', 'mec-shortcode-builder' ),
				'available_spot' 	=> __( 'Available Spot', 'mec-shortcode-builder' ),
				'carousel'       	=> __( 'Carousel View', 'mec-shortcode-builder' ),
				'slider'         	=> __( 'Slider View', 'mec-shortcode-builder' ),
				'timeline'  	 	=> __( 'Timeline View', 'mec-shortcode-builder' ),
				'tile'  	 		=> __( 'Tile View', 'mec-shortcode-builder' ),
				'general_calendar'  => __( 'General Calendar View', 'mec-shortcode-builder' ),
			);

			if (defined('MECSHORTCODEDESIGNERNAME')) {

				$skins['custom'] = __( 'Shortcode Designer', 'mec-shortcode-builder' );
			}

			return $skins;
		}




		/**
		 * Register MEC widget controls.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function register_controls() {

			// Display Options
			$this->start_controls_section(
				'display_options',
				array(
					'label' => __( 'Display Options', 'mec-shortcode-builder' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				)
			);

			$this->add_control(
				'skin',
				array(
					'label'   => __( 'Skin', 'mec-shortcode-builder' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'options' => $this->get_all_skins(),
					'default' => 'list',
				)
			);

			MEC_elementor_list_display_opts::options( $this );
			MEC_elementor_grid_display_opts::options( $this );
			MEC_elementor_agenda_display_opts::options( $this );
			MEC_elementor_full_calendar_display_opts::options( $this );
			MEC_elementor_yearly_display_opts::options( $this );
			MEC_elementor_monthly_display_opts::options( $this );
			MEC_elementor_daily_display_opts::options( $this );
			MEC_elementor_weekly_display_opts::options( $this );
			MEC_elementor_timetable_display_opts::options( $this );
			MEC_elementor_masonry_display_opts::options( $this );
			MEC_elementor_map_display_opts::options( $this );
			MEC_elementor_cover_display_opts::options( $this );
			MEC_elementor_countdown_display_opts::options( $this );
			MEC_elementor_available_spot_display_opts::options( $this );
			MEC_elementor_carousel_display_opts::options( $this );
			MEC_elementor_slider_display_opts::options( $this );
			MEC_elementor_timeline_display_opts::options( $this );
			MEC_elementor_tile_display_opts::options( $this );
			MEC_elementor_general_calendar_display_opts::options( $this );
			if (defined('MECSHORTCODEDESIGNERNAME')) {
				MEC_elementor_custom_display_opts::options( $this );
			}

			$this->end_controls_section();

			// Null Days (next/prev month days inside current month grid)
			$this->start_controls_section(
				'mec_null_day_style',
				[
					'label' => __( 'Null Days (Next/Prev Month)', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'monthly_view',
						],
					],
				]
			);
			$this->add_control(
				'mec_null_day_color',
				[
					'label' => __('Null Day Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-table-nullday' => 'color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'mec_null_day_bg_color',
				[
					'label' => __('Null Day Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-table-nullday' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_null_day_box_shadow',
					'label' => __('Box Shadow', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-table-nullday',
				]
			);
			$this->add_control(
				'mec_null_day_hover_heading',
				[
					'label' => __('Hover Effects', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'mec_null_day_hover_bg_color',
				[
					'label' => __('Null Day Hover Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-table-nullday:hover' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'mec_null_day_hover_text_color',
				[
					'label' => __('Null Day Hover Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-table-nullday:hover' => 'color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'mec_null_day_hover_box_shadow',
				[
					'label' => __('Null Day Hover Box Shadow', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::BOX_SHADOW,
					'selectors' => [
						'{{WRAPPER}} .mec-table-nullday:hover' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
					],
				]
			);
			$this->end_controls_section();

			// Search Form
			$this->start_controls_section(
				'search_form',
				[
					'label'     => __( 'Search Form', 'mec-shortcode-builder' ),
					'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
					'condition' => [
						'skin!' => [
							'masonry',
							'cover',
							'countdown',
							'available_spot',
							'carousel',
							'slider',
							'timeline',
						],
					],
				]
			);

			MEC_elementor_list_search_form::options( $this );
			MEC_elementor_grid_search_form::options( $this );
			MEC_elementor_agenda_search_form::options( $this );
			MEC_elementor_full_calendar_search_form::options( $this );
			MEC_elementor_yearly_search_form::options( $this );
			MEC_elementor_monthly_search_form::options( $this );
			MEC_elementor_daily_search_form::options( $this );
			MEC_elementor_weekly_search_form::options( $this );
			MEC_elementor_timetable_search_form::options( $this );
			MEC_elementor_map_search_form::options( $this );
			MEC_elementor_tile_search_form::options( $this );
			MEC_elementor_general_calendar_search_form::options( $this );
			if (defined('MECSHORTCODEDESIGNERNAME')) {
				MEC_elementor_custom_search_form::options( $this );
			}

			$this->end_controls_section();

			// Filter Options
			$this->start_controls_section(
				'filter_options',
				array(
					'label' => __( 'Filter Options', 'mec-shortcode-builder' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
					'condition' => [
						'skin!' => array(
							'countdown',
							'available_spot'
						),
					]
				)
			);
			MEC_elementor_filter_options::options( $this );
			$this->end_controls_section();
			// Start Style Tab

			// General Calendar Tooltip Styles
			$this->start_controls_section(
				'mec_general_calendar_tooltip_style',
				[
					'label' => __( 'General Calendar Tooltip', 'mec-shortcode-builder' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'general_calendar',
						],
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_bg_color',
				[
					'label' => __( 'Tooltip Background', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_border_color',
				[
					'label' => __( 'Tooltip Border Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip' => 'border-color: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_general_calendar_tooltip_box_shadow',
					'label' => __( 'Tooltip Box Shadow', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-gCalendar-tooltip',
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_title_color',
				[
					'label' => __( 'Title Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip-title a' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'mec_general_calendar_tooltip_title_typography',
					'label' => __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-gCalendar-tooltip-title a',
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_date_color',
				[
					'label' => __( 'Date Text Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip-date-text' => 'color: {{VALUE}};',
						'{{WRAPPER}} .mec-gCalendar-tooltip-date-time' => 'color: {{VALUE}};',
						'{{WRAPPER}} .mec-gCalendar-tooltip-date-day' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_date_bg_color',
				[
					'label' => __( 'Date Area Background', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip-date' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_icon_color',
				[
					'label' => __( 'Icons Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip i.mec-sl-calendar' => 'color: {{VALUE}};',
						'{{WRAPPER}} .mec-gCalendar-tooltip i.mec-sl-clock' => 'color: {{VALUE}};',
						'{{WRAPPER}} .mec-gCalendar-tooltip i.mec-sl-location-pin' => 'color: {{VALUE}};',
					],
				]
			);

			// General Calendar: Day Cell Styles (day numbers & cell backgrounds)
			$this->add_control(
				'mec_general_calendar_day_bg_color',
				[
					'label' => __( 'Day Background', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc-daygrid-day-frame' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_day_number_color',
				[
					'label' => __( 'Day Number Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc .fc-daygrid-day-number' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_today_bg_color',
				[
					'label' => __( 'Today Background', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc-day-today .fc-daygrid-day-frame' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_other_month_bg_color',
				[
					'label' => __( 'Other Month Days Background', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc-day-other .fc-daygrid-day-frame' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'mec_general_calendar_day_border',
					'label' => __( 'Day Cell Border', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .fc-daygrid-day-frame',
				]
			);

			$this->add_responsive_control(
				'mec_general_calendar_day_border_radius',
				[
					'label' => __( 'Day Cell Border Radius', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .fc-daygrid-day-frame' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_tooltip_location_color',
				[
					'label' => __( 'Location Text Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-gCalendar-tooltip-location' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_event_accent_color',
				[
					'label' => __( 'Event Accent (Border)', 'mec-shortcode-builder' ),
					'description' => __( 'Sets the event accent color on the left border of each calendar event.', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc .fc-daygrid-event' => 'border-left-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_general_calendar_event_overlay_color',
				[
					'label' => __( 'Event Overlay', 'mec-shortcode-builder' ),
					'description' => __( 'Controls the translucent overlay bar appended inside each event block.', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fc .fc-daygrid-event > span' => 'background-color: {{VALUE}} !important;',
					],
				]
			);

			$this->end_controls_section();

			// Time Display
			$this->start_controls_section(
				'search_settings',
				[
					'label' => __( 'Search Filter Settings', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' =>
						[
							'masonry',
							'cover',
							'countdown',
							'available_spot',
							'carousel',
							'slider',
							'timeline',
							'custom',
						],
					],
				]
			);
			$this->add_control(
				'search_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 15,
					],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box i,
						 {{WRAPPER}} .mec-gCalendar-filters i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'search_icon_color',
				[
					'label' 		=> __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'default' 		=> '#777',
					'selectors' 	=> [
						'{{WRAPPER}} .mec-totalcal-box i,
						 {{WRAPPER}} .mec-gCalendar-filters i' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_control(
				'search_icon_bg_color',
				[
					'label' 		=> __( 'Icon Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-totalcal-box i,
						 {{WRAPPER}} .mec-gCalendar-filters i' => 'background: {{VALUE}} !important',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'search_pleaceholder_typography',
					'separator' => 'before',
					'label' 	=> __( 'Divider Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span,
						 {{WRAPPER}} .mec-totalcal-box input,
						 {{WRAPPER}} .mec-totalcal-box select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select .current,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select .option',
				]
			);
			$this->add_control(
				'search_pleaceholder_color',
				[
					'label' => __( 'Pleaceholder Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#777',
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span,
						 {{WRAPPER}} .mec-totalcal-box input,
						 {{WRAPPER}} .mec-totalcal-box select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select .current,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select .option' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_control(
				'search_placeholder_bg_color',
				[
					'label' => __( 'Placeholder Background', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#fff',
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span,
						 {{WRAPPER}} .mec-totalcal-box input,
						 {{WRAPPER}} .mec-totalcal-box select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select,
						 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select .current' => 'background: {{VALUE}} !important',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'search_pleaceholder_border',
					'label' => __( 'Icon and Placeholder Border', 'mec-shortcode-builder' ),
					'selector' =>
					'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span,
					 {{WRAPPER}} .mec-totalcal-box input,
					 {{WRAPPER}} .mec-totalcal-box select,
					 {{WRAPPER}} .mec-totalcal-box i,
					 {{WRAPPER}} .mec-gCalendar-filters-wrap .nice-select',
				]
			);
			$this->add_responsive_control(
				'search_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'search_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'search_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
					'{{WRAPPER}} .mec-totalcal-box',
				]
			);
			$this->add_responsive_control(
				'search_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'search_box_bg_color',
				[
					'label' => __( 'Box Background', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#fff',
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box' => 'background: {{VALUE}} !important',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'esearch_box_shadow',
					'label' => __( 'Box Shadow', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-totalcal-box',
				]
			);

			$this->add_control(
				'thisisfullcalendarbreakline',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);

			$this->add_control(
				'register_view_skin_button_display',
				[
					'label' 		=>  esc_html__( 'Buttons Display', 'mec-shortcode-builder' ),
					'description' => '',
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span' => 'display:{{VALUE}};',
					],
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'register_view_skin_button_displaytypography',
					'separator' => 'before',
					'label' 	=> __( 'Buttons Typography', 'mec-shortcode-builder' ),
					'selector' 	=> '{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span',
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);

			// Style Subtitle Tabs
			$this->start_controls_tabs('mec_fullcalendar_view_buttons');

			$this->start_controls_tab(
				'tab_1_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);

			$this->add_control(
				'register_view_skin_button_detail_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span' => 'fill: {{VALUE}} !important; color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'register_view_skin_button_detail_bg',
				[
					'label' => __( 'Background', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span' => 'background: {{VALUE}} !important;',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'register_view_skin_button_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}}.mec-wrap .mec-totalcal-box .mec-totalcal-view span.mec-totalcalview-selected,
						 {{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span',
				]
			);

			$this->add_responsive_control(
				'register_view_skin_button_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'register_view_skin_button_detail_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);

			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_1_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);

			$this->add_control(
				'register_view_skin_button_detail_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span:hover' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'register_view_skin_button_detail_bg_hover',
				[
					'label' => __( 'Background Hover', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span:hover' => 'background: {{VALUE}} !important;',
					],
				]
			);

			$this->add_responsive_control(
				'register_view_skin_button_detail_padding_hover',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);

			$this->end_controls_tab();
			$this->end_controls_tabs(); // End Tabs

			$this->end_controls_section();

			// Divider Tab
			$this->start_controls_section(
				'divider_style',
				[
					'label' => __( 'Divider Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'list',
							'full_calendar',
							'monthly_view',
							'agenda',
							'custom',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'divider_typography',
					'separator' => 'before',
					'label' 	=> __( 'Divider Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-month-divider span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4',

				]
			);
			$this->add_control(
				'divider_color',
				[
					'label' 		=> __( 'Divider Title Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-month-divider span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'divider_title_border_span',
					'label' => __( 'Divider Title Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-month-divider span,
						 {{WRAPPER}} .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-calendar-a-month h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month',
				]
			);
			$this->add_control(
				'divider_before_color',
				[
					'label' 		=> __( 'Divider Shape Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-month-divider span:before' => 'border-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'divider_shape_border',
					'label' => __( 'Divider Shape Border', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-month-divider span:before',
				]
			);
			$this->add_control(
				'divider_bg_color',
				[
					'label' 		=> __( 'Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-month-divider,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'divider_alignment',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-month-divider span' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'divider_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-month-divider,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'divider_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-month-divider,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'divider_border',
					'label' => __( 'Divider Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-month-divider span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month',
				]
			);
			$this->add_responsive_control(
				'divider_border_radius',
				[
					'label' 		=> __( 'Divider Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-month-divider,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'the_arrow_for_date_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month i,
						 {{WRAPPER}} .mec-previous-month.mec-load-month i,
						 {{WRAPPER}} .mec-next-year.mec-load-year i,
						 {{WRAPPER}} .mec-previous-year.mec-load-year i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'divider_arrow_width',
				[
					'label' 		=> __( 'Arrow Width', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month,
						 {{WRAPPER}} .mec-previous-month.mec-load-month,
						 {{WRAPPER}} .mec-next-year.mec-load-year,
						 {{WRAPPER}} .mec-previous-year.mec-load-year' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'divider_arrow_height',
				[
					'label' 		=> __( 'Arrow Height', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month,
						 {{WRAPPER}} .mec-previous-month.mec-load-month,
						 {{WRAPPER}} .mec-next-year.mec-load-year,
						 {{WRAPPER}} .mec-previous-year.mec-load-year' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'next_arrow_margin',
				[
					'label' 		=> __( 'Next Button Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month,
						 {{WRAPPER}} .mec-next-year.mec-load-year' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'previous_arrow_margin',
				[
					'label' 		=> __( 'Previous Button Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month,
						 {{WRAPPER}} .mec-next-year.mec-load-year' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'divider_padding_arrow_icon',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-next-month.mec-load-month,
						 {{WRAPPER}} .mec-previous-month.mec-load-month,
						 {{WRAPPER}} .mec-previous-year.mec-load-year,
						 {{WRAPPER}} .mec-previous-year.mec-load-year' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->end_controls_section();
			// End Typo style

			// Divider Tab
			$this->start_controls_section(
				'event_item_style',
				[
					'label' => __( 'Event Item Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' => [
							'timeline',
							'general_calendar',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_title_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-timetable .mec-month-navigator .mec-month-label,
						' => 'text-align: {{VALUE}};',
					],
					'condition' => [
						'timetable_style' =>
						[
							'modern',
						],
					],
				]
			);
			$this->add_responsive_control(
				'timetable_height_size_item',
				[
					'label' 		=> __( 'Timetable Clean Item Height', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 400,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 185,
					],
					'condition' => [
						'timetable_style' =>
						[
							'clean',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-timetable-t2-content' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'event_item_style_bg_color',
				[
					'label' 		=> __( 'Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-full-calendar-skin-container article .mec-event-footer,
						 {{WRAPPER}} article .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-masonry .mec-masonry-content,
						 {{WRAPPER}} .mec-masonry .mec-masonry-head,
						 {{WRAPPER}} .mec-av-spot-wrap .mec-event-content,
						 {{WRAPPER}} .gm-style .gm-style-iw-c,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-head,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-content,
						 {{WRAPPER}} .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-event-countdown-style2,
						 {{WRAPPER}} .mec-event-countdown-style1,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple,
						 {{WRAPPER}} .mec-event-cover-classic,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event' => 'background: {{VALUE}} !important; transition: all .3s ease;',
					],
				]
			);
			$this->add_control(
				'event_item_style_bg_hover_color',
				[
					'label' 		=> __( 'Background Hover Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article):hover,
						 {{WRAPPER}} .mec-agenda-event:hover,
						 {{WRAPPER}} .mec-timetable-event:hover,
						 {{WRAPPER}} .mec-av-spot-wrap:hover .mec-event-content,
						 {{WRAPPER}} article:hover .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-masonry:hover .mec-masonry-content,
						 {{WRAPPER}} .mec-masonry:hover .mec-masonry-head,
						 {{WRAPPER}} .mec-full-calendar-skin-container article:hover .mec-event-footer,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-article:hover .novel-grad-bg,
						 {{WRAPPER}} .gm-style:hover .gm-style-iw-c,
						 {{WRAPPER}} .mec-av-spot:hover .mec-av-spot-head,
						 {{WRAPPER}} .mec-av-spot:hover .mec-av-spot-content,
						 {{WRAPPER}} .mec-event-countdown-style3:hover,
						 {{WRAPPER}} .mec-event-countdown-style2:hover,
						 {{WRAPPER}} .mec-event-countdown-style1:hover,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple:hover,
						 {{WRAPPER}} .mec-event-cover-classic:hover
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended:hover,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content:hover,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item:hover,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content:hover,
						 {{WRAPPER}} .fc-daygrid-event:hover' => 'background: {{VALUE}} !important',
					],
				]
			);
			$this->add_responsive_control(
				'event_item_style_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'event_item_style_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'event_item_style_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event',
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'event_item_style_border_list_standard',
					'label' => __( 'Divider Border', 'mec-shortcode-builder' ),
					'description' => __( 'Border for after the content', 'mec-shortcode-builder' ),
					'selector' => '.mec-event-list-standard .mec-event-meta-wrap',
					'allowed_dimensions' => ['top', 'bottom', 'right'],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);

			$this->add_responsive_control(
				'event_item_style_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-event-countdown-style2,
						 {{WRAPPER}} .mec-event-countdown-style1,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item:before,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-article,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'event_item_style_box_shadow',
					'label' => __( 'Normal Box Shadow', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article),
						 {{WRAPPER}} .mec-agenda-event,
						 {{WRAPPER}} .mec-monthly-tooltip.event-single-link-simple,
						 {{WRAPPER}} .mec-timetable-event,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content,
						 {{WRAPPER}} .fc-daygrid-event',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'event_item_style_box_shadow_hover',
					'label' => __( 'Hover Box Shadow', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-event-article:not(.mec-masonry>.mec-event-article):hover,
						 {{WRAPPER}} .mec-agenda-event:hover,
						 {{WRAPPER}} .mec-timetable-event:hover,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended:hover,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-event-content:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-countdown-style3:hover,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item:hover,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-event-content:hover,
						 {{WRAPPER}} .fc-daygrid-event:hover',
				]
			);
			$this->add_control(
				'event_item_list_standard_footer_style_bg_color',
				[
					'label' 		=> __( 'Footer Background Color (Standard)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'separator' => 'before',
					'selectors' 	=> [
						'{{WRAPPER}} article .mec-event-footer' => 'background: {{VALUE}}; transition: all .3s ease;',
					],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_control(
				'event_item_list_standard_footer_style_bg_hover_color',
				[
					'label' 		=> __( 'Footer Background Hover Color (Standard)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} article:hover .mec-event-footer' => 'background: {{VALUE}}',
					],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_list_standard_footer_style_padding',
				[
					'label' 		=> __( 'Footer Padding (Standard)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_list_standard_footer_style_margin',
				[
					'label' 		=> __( 'Footer Margin (Standard)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'event_item_list_standard_footer_style_border',
					'label' => __( 'Footer Border (Standard)', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-event-footer',
					 'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_list_standard_footer_style_border_radius',
				[
					'label' 		=> __( 'Footer Border Radius (Standard)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-footer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_control(
				'event_item_grid_footer_style_bg_color',
				[
					'label' 		=> __( 'Footer Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'separator' => 'before',
					'selectors' 	=> [
						'.mec-event-article .mec-event-footer' => 'background-color: {{VALUE}} !important; transition: all .3s ease;',
					],
					'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' =>
						[
							'fluent',
						],
					],
				]
			);

			$this->add_control(
				'event_item_grid_footer_style_bg_hover_color',
				[
					'label' 		=> __( 'Footer Background Hover Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'.mec-event-article:hover .mec-event-footer' => 'background-color: {{VALUE}} !important',
					],
					'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_grid_footer_style_padding',
				[
					'label' 		=> __( 'Footer Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-event-article .mec-event-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
					'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_grid_footer_style_margin',
				[
					'label' 		=> __( 'Footer Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-event-article .mec-event-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
					'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'event_item_grid_footer_style_border',
					'label' => __( 'Footer Border', 'mec-shortcode-builder' ),
					'selector' => '.mec-event-article .mec-event-footer',
					 'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'event_item_grid_footer_style_border_radius',
				[
					'label' 		=> __( 'Footer Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-event-article .mec-event-footer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
					'condition' => [
						'list_style!' =>
						[
							'fluent',
							'liquid-large',
							'liquid-medium',
							'liquid-small',
							'liquid-minimal',
						],
						'grid_style' =>
						[
							'classic',
							'clean',
							'fluent'
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->end_controls_section();
			// End Typo style

			// Title Style
			$this->start_controls_section(
				'title_style',
				[
					'label' => __( 'Title Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' => array(
							'custom',
						)
					]
				]
			);
			$this->add_control(
				'title_display',
				[
					'label' 		=>  esc_html__( 'Title Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-title,
						 {{WRAPPER}} .mec-agenda-event-title,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title,
						 {{WRAPPER}} .mec-agenda-event-title,
						 {{WRAPPER}} .mec-calendar .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-single-event-novel,
						 {{WRAPPER}} .mec-monthly-tooltip h4,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-span a,
						 {{WRAPPER}} .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-title,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title,
						 {{WRAPPER}} .mec-timeline-main-content h4 a,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title a,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title'=>'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_title_typo',
					'separator' => 'before',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title a,
						 {{WRAPPER}} .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4 a,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel h4,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip h4,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title a,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title a,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title a,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title a,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-title,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a,
						 {{WRAPPER}} .mec-timeline-main-content h4 a,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title a,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title',

				]
			);
			$this->add_responsive_control(
				'title_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title,
						 {{WRAPPER}} .mec-agenda-event-title,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title,
						 {{WRAPPER}} .mec-timeline-main-content h4,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title' => 'text-align: {{VALUE}};',
					],
				]
			);
			// Style Tabs
			$this->start_controls_tabs( 'tabs_title_style' );
			$this->start_controls_tab(
				'tab_title_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'title_text_color',
				[
					'label' => __( 'Title Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title a,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4 a,
						 {{WRAPPER}} .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-table .mec-single-event-novel h4.mec-event-title,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip h4,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title a,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title a,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title a,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title a,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-title,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a,
						 {{WRAPPER}} .mec-timeline-main-content h4 a,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title a,
                         {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
                         {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
                         {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title a,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title a,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'title_text_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title a,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4 a,
						 {{WRAPPER}} .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title a,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel h4,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip h4,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title a,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title a,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title a,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title a,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title a,
					     {{WRAPPER}} .mec-calendar-weekly .mec-event-title a,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-title,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a,
						 {{WRAPPER}} .mec-timeline-main-content h4 a,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title a,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title a,
                         {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
                         {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
                         {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title a,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title a,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title'
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_title_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'title-hover_color',
				[
					'label' => __( 'Text Hover Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title a:hover,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title:hover,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4 a:hover,
						 {{WRAPPER}} .mec-agenda-event-title a:hover,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title a:hover,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title a:hover,
						 {{WRAPPER}} .mec-calendar .mec-calendar-table .mec-single-event-novel h4:hover,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip:hover h4,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title a:hover,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title a:hover,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title a:hover,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title:hover,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title:hover,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming:hover,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming:hover,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming:hover,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title a:hover,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title a:hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title a:hover,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title a:hover,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title a:hover,
						 {{WRAPPER}} .mec-timeline-main-content h4 a:hover,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title a:hover,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title a:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title a:hover,
                         {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4:hover,
                         {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4:hover,
                         {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4:hover,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title a:hover,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title a:hover,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title:hover' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs(); // End Tabs
			$this->add_responsive_control(
				'title_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4,
						 {{WRAPPER}} .mec-agenda-event-title,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title,
						 {{WRAPPER}} .mec-timeline-main-content h4,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-title,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-title,
						 {{WRAPPER}} .mec-events-toggle .mec-toogle-inner-month-divider .mec-toggle-title,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-modern .mec-event-title,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content h4,
						 {{WRAPPER}} .mec-agenda-event-title,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-event-title,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-calendar .mec-event-article.mec-single-event-novel,
						 {{WRAPPER}} .mec-event-container-simple .mec-monthly-tooltip,
						 {{WRAPPER}} .mec-timetable-t2-content .mec-event-title,
						 {{WRAPPER}} .mec-timetable-event .mec-timetable-event-title,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-detail .mec-event-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-content .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-upcoming,
						 {{WRAPPER}} .mec-event-carousel-type1 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-event-carousel-title,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-title
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-title,
						 {{WRAPPER}} .mec-timeline-main-content h4,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-title,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-content span:first-child,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-content h4.mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap dt .simple-skin-ended h4,
						 {{WRAPPER}} .mec-fluent-wrap .simple-skin-ended h4,
                         {{WRAPPER}} .mec-fluent-wrap .mec-calendar .mec-event-article h4,
                         {{WRAPPER}} .mec-fluent-wrap.mec-skin-masonry-container .mec-masonry .mec-masonry-content .mec-event-content .mec-event-title,
                         {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-title,
                         {{WRAPPER}} .fc-daygrid-event .fc-event-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			// Subtitle
			$this->add_control(
				'count_down_subtitle_display',
				array(
					'label' 		=>  esc_html__( 'Subtitle Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'separator' => 'before',
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> 'block',
					'condition' => [
						'skin' =>[
							'countdown',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title' => 'display:{{VALUE}} !important;',
					],
				)
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_subtitle_typo',
					'label' 	=> __( 'Subtitle Typography', 'mec-shortcode-builder' ),
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
					'selector' 	=>
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title',

				]
			);
			$this->add_responsive_control(
				'sub_title_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title' => 'text-align: {{VALUE}};',
					],
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			// Style Subtitle Tabs
			$this->start_controls_tabs('tabs_sub_title_style');
			$this->start_controls_tab(
				'tab_sub_title_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
					'condition' => [
						'skin' => [
							'countdown'
						],
					],
				]
			);
			$this->add_control(
				'sub_title_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-content .mec-event-title a' => 'color: {{VALUE}} !important',
					],
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'subtitle_text_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-content .mec-event-title a',

					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_sub_title_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			$this->add_control(
				'sub_title-hover_color',
				[
					'label' => __( 'Text Hover Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title:hover,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title:hover,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-countdown-container .mec-event-content .mec-event-title a:hover' => 'color: {{VALUE}} !important',
					],
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs(); // End Tabs
			$this->add_responsive_control(
				'sub_title_padding',
				[
					'label' 		=> __( 'Subtitle padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			$this->add_responsive_control(
				'sub_title_margin',
				[
					'label' 		=> __( 'Subtitle margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown-part1 .mec-event-title,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown-part1 .mec-event-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' =>[
							'countdown'
						],
					],
				]
			);
			// End sub
			$this->add_control(
				'title_bullet',
				[
					'label' 		=>  esc_html__( 'Title Bullet Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'separator' => 'before',
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'condition' => [
						'skin!' =>
						[
							'countdown',
							'carousel',
							'map',
						],
						'yearly_style!' => [
							'fluent',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .event-color' => 'display:{{Value}}',
					],
				]
			);
			$this->add_responsive_control(
				'bullet_border_radius',
				[
					'label' 		=> __( 'Bullet Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .event-color' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin!' =>
						[
							'countdown',
							'carousel',
							'map',
						],
						'yearly_style!' => [
							'fluent',
						],
						'title_bullet[return_value]!' => 'none',
					],
				]
			);
			$this->add_responsive_control(
			'bullet_width',
				[
					'label' => __( 'Bullet width', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .event-color' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin!' =>
						[
							'countdown',
							'carousel',
							'map',
						],
						'yearly_style!' => [
							'fluent',
						],
						'title_bullet[return_value]!' => 'none',
					],
				]
			);
			$this->add_responsive_control(
				'bullet_height',
				[
					'label' => __( 'Bullet height', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .event-color' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin!' =>
						[
							'countdown',
							'carousel',
							'map',
						],
						'yearly_style!' => [
							'fluent',
						],
						'title_bullet[return_value]!' => 'none',
					],
				]
			);
			$this->add_control(
				'title_tag',
				[
					'label' 		=>  esc_html__( 'Soldout Tag Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'separator' => 'before',
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} span.mec-event-title-soldout' => 'display:{{Value}}',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'the_tag_border',
					'label' => __( 'Soldout Border', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} span.mec-event-title-soldout',
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'title_tag_border_radius',
				[
					'label' 		=> __( 'Soldout Tag Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} span.mec-event-title-soldout' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'the_tag_typo',
					'label' 	=> __( 'Soldout Tag Typography', 'mec-shortcode-builder' ),
					'selector' 	=> '{{WRAPPER}} span.mec-event-title-soldout',
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'the_tag__padding',
				[
					'label' 		=> __( 'Soldout Tag Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} span.mec-event-title-soldout' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_control(
				'the_tag_color',
				[
					'label' => __( 'Soldout Tag Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,

					'selectors' => [
						'{{WRAPPER}} span.mec-event-title-soldout' => 'color: {{VALUE}}',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_control(
				'the_tag_bg_color',
				[
					'label' => __( 'Soldout Tag Background Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,

					'selectors' => [
						'{{WRAPPER}} span.mec-event-title-soldout' => 'background: {{VALUE}}',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'location_typography',
					'label' 	=> __( 'Location Typography', 'mec-shortcode-builder' ),
					'separator' => 'before',
					'selector' 	=>
						'{{WRAPPER}} .mec-location,
						 {{WRAPPER}} .mec-venue-details span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-detail,
						 {{WRAPPER}} .mec-daily-view-date-events .mec-event-detail,
						 {{WRAPPER}} .mec-calendar-table .mec-event-detail,
						 {{WRAPPER}} .mec-calendar-side .mec-event-detail,
						 {{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						 {{WRAPPER}} .mec-timetable-event-location span,
						 {{WRAPPER}} .mec-event-loction span,
						 {{WRAPPER}} .mec-weekly-view-dates-events .mec-event-detail,
						 ',
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_control(
				'location_color',
				[
					'label' => __( 'Location Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,

					'selectors' => [
						'{{WRAPPER}} .mec-location,
						 {{WRAPPER}} .mec-venue-details span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-detail,
						 {{WRAPPER}} .mec-daily-view-date-events .mec-event-detail,
						 {{WRAPPER}} .mec-calendar-table .mec-event-detail,
						 {{WRAPPER}} .mec-calendar-side .mec-event-detail,
						 {{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						 {{WRAPPER}} .mec-timetable-event-location span,
						 {{WRAPPER}} .mec-event-loction span,
						 {{WRAPPER}} .mec-weekly-view-dates-events .mec-event-detail
						 ' => 'color: {{VALUE}}',
					],
					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->end_controls_section();
			// End Typo style

			// Excerpt Style
			$this->start_controls_section(
				'excerpt_standard_style',
				[
					'label' => __( 'Excerpt Style List View (Standard)', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'list_style' =>
						[
							'standard',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'excerpt_standard_typography',
					'label' 	=> __( 'Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-article .mec-event-content .mec-event-description' ,
				]
			);
			$this->add_responsive_control(
				'excerpt_standard_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'excerpt_full_standard_style',
				[
					'label' => __( 'Excerpt Style Full Calendar View (Standard)', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'full_calendar',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'excerpt_full_standard_typography',
					'label' 	=> __( 'Typography', 'mec-shortcode-builder' ),
					'selector' 	=> '.mec-event-article .mec-event-content .mec-event-description' ,
				]
			);
			$this->add_responsive_control(
				'excerpt_full_standard_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'excerpt_slider_style',
				[
					'label' => __( 'Excerpt Style Slider View (Type 5)', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'slider_style' =>
						[
							't5',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'excerpt_slider_typography',
					'label' 	=> __( 'Typography', 'mec-shortcode-builder' ),
					'selector' 	=> '{{WRAPPER}} .mec-event-grid-modern .mec-event-content p',
				]
			);
			$this->add_responsive_control(
				'excerpt_slider_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-modern .mec-event-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			// End Excerpt style

			// Excerpt Style
			$this->start_controls_section(
				'excerpt_timeline_style',
				[
					'label' => __( 'Excerpt Style Timeline  View', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'timeline',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'excerpt_timeline_typography',
					'label' 	=> __( 'Typography', 'mec-shortcode-builder' ),
					'selector' 	=> '{{WRAPPER}} .mec-timeline-main-content p',
				]
			);
			$this->add_responsive_control(
				'excerpt_timeline_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-timeline-main-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			// Start Date Style
			$this->start_controls_section(
				'date_style',
				[
					'label' => __( 'Date Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'list_style!' =>
						[
							'modern',
						],
						'skin!' => [
							'custom',
							'general_calendar',
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_control(
				'date_display',
				[
					'label' 		=>  esc_html__( 'Date Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 	=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 		=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-item-col .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-date-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .event-tile-view-head,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-time,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-slider-container .mec-date-wrap' => 'display:{{VALUE}} !important;',
					],
					'condition' => [
						'skin!' => [
							'map'
						],
					],
				]
			);
			$this->add_control(
				'date_number_grd_display',
				[
					'label' 		=>  esc_html__( 'Date Number Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 	=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 		=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-minimal .mec-event-date span,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dday,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date .mec-date1,
						 {{WRAPPER}} .mec-event-grid-modern:not(.mec-slider-t1-content) .event-grid-modern-head .mec-event-date,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-slider-container .mec-date-wrap span.mec-event-day-num' => 'display:{{VALUE}} !important;',
					],
					'condition' => [
						'skin' =>
						[
							'daily_view',
							'cover',
							'available_spot',
							'map',
							'slider',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_date_number_typo',
					'separator' => 'before',
					'label' 	=> __( 'Date Number Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-grid-minimal .mec-event-date span,
						 {{WRAPPER}} .mec-start-date-label span,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dday,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date .mec-date1,
						 {{WRAPPER}} .mec-event-grid-modern:not(.mec-slider-t1-content) .event-grid-modern-head .mec-event-date,,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-carousel-content-type2 .mec-event-date-info .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-slider-container .mec-date-wrap span.mec-event-day-num',
					'condition' => [
						'skin' =>
						[
							'grid',
							'daily_view',
							'cover',
							'available_spot',
							'carousel',
							'map',
							'slider',
						],
					],
				]
			);
			$this->add_control(
				'mec_date_number_color',
				[
					'label' => __( 'Date Number Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,

					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-minimal .mec-event-date span,
						 {{WRAPPER}} .mec-start-date-label span,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dday,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date .mec-date1,
						 {{WRAPPER}} .mec-event-grid-modern:not(.mec-slider-t1-content) .event-grid-modern-head .mec-event-date,,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-carousel-content-type2 .mec-event-date-info .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-slider-container .mec-date-wrap span.mec-event-day-num' => 'color: {{VALUE}} !important;',
					],
					'condition' => [
						'skin' =>
						[
							'grid',
							'daily_view',
							'cover',
							'available_spot',
							'carousel',
							'map',
							'slider',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'mec_date_number_bg_color',
					'label' => __( 'Date Number Background', 'mec-shortcode-builder' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' =>
						'{{WRAPPER}} .mec-event-grid-minimal .mec-event-date span,
						 {{WRAPPER}} .mec-start-date-label span,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dday,
						 {{WRAPPER}} .mec-event-grid-modern:not(.mec-slider-t1-content) .event-grid-modern-head .mec-event-date,,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}}.colorskin-custom .mec-event-list-minimal .mec-event-date.mec-bg-color,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-article .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-carousel-content-type2 .mec-event-date-info .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date .mec-event-day-num,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-slider-container .mec-date-wrap span.mec-event-day-num',
					'condition' => [
						'skin' =>
						[
							'grid',
							'daily_view',
							'cover',
							'carousel',
							'available_spot',
							'map',
							'slider',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_date_typo',
					'label' 	=> __( 'Date Typography', 'mec-shortcode-builder' ),
					'separator' => 'before',
					'selector' 	=>

						'{{WRAPPER}} .mec-event-list-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-date span,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-meta span.mec-event-d,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-date-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-meta .mec-event-d span,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dmonth,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dyear,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-info,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-info-year,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info span,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .event-tile-view-head,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-time,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-carousel-content-type2 .mec-event-date-info .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-start-date-label,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) div span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date div,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details .mec-event-d',

					'conditions' => [
						'terms' => [
							[
								'name' => 'skin',
								'operator' => '!in',
								'value' => [
									'map',
								],
							],
						],
					],
				]
			);
			$this->add_control(
				'mec_date_color',
				[
					'label' => __( 'Date Color', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-start-date-label,
						{{WRAPPER}} .mec-event-list-classic .mec-end-date-label,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-date,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-date-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-meta .mec-event-d span,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .mec-event-time,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date span,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dmonth,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date .dyear,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-info,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-info-year,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info span,
						 {{WRAPPER}} .mec-event-tile-view article.mec-tile-item .event-tile-view-head,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details .mec-start-date-label,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-start-date-label,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) div span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date div,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details .mec-event-d' => 'color: {{VALUE}} !important;',
					],
					'conditions' => [
						'terms' => [
							[
								'name' => 'skin',
								'operator' => '!in',
								'value' => [
									'map',
								],
							],
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'mec_date_bg_color',
					'label' => __( 'Date Background', 'mec-shortcode-builder' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-start-date-label,
						{{WRAPPER}} .mec-event-list-classic .mec-end-date-label,
						{{WRAPPER}} .mec-event-grid-classic .mec-event-article .mec-event-content .mec-event-date.mec-bg-color,
						{{WRAPPER}} .mec-date-details,
						{{WRAPPER}} .mec-event-date-carousel,
						{{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						{{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						{{WRAPPER}} .mec-event-list-standard .mec-event-meta .mec-event-d span,
						{{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						{{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						{{WRAPPER}} .mec-yearly-calendar .mec-agenda-date
						{{WRAPPER}} .mec-event-list-accordion .mec-toggle-item-col .mec-event-month,
						{{WRAPPER}} .event-grid-t2-head,
						{{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-item-col .mec-event-month,
						{{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						{{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month,
						{{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						{{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						{{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						{{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						{{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						{{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						{{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						{{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						{{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						{{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						{{WRAPPER}} .mec-event-list-minimal .mec-event-date.mec-bg-color,
						{{WRAPPER}} .mec-event-list-minimal .mec-event-article .mec-event-date,
						{{WRAPPER}}.colorskin-custom .mec-event-list-minimal .mec-event-date.mec-bg-color,
						{{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						{{WRAPPER}} .event-carousel-type2-head .mec-event-carousel-content-type2 .mec-event-date-info .mec-start-date-label,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details',
					'condition' => [
						'skin!' =>
						[
							'countdown',
							'carousel',
							'map',
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'date_ing3_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel' => 'background-color: {{VALUE}};','{{WRAPPER}} .mec-event-countdown-style3 .mec-event-date:after, {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel:after' => 'border-bottom-color: {{VALUE}} !important;'
					],
					'condition' => [
						'ing' =>
							'style3',
							'carousel_style' => 'type1',
					],
				]
			);
			$this->add_responsive_control(
				'date_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-agenda-date,
						 {{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-item-col,
						 {{WRAPPER}} .mec-agenda-date-wrap,
						 {{WRAPPER}} .mec-date-details,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-list-weekly-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .mec-start-date-label,
						 {{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details' => 'text-align: {{VALUE}} !important;'
					],
					'condition' => [
						'skin!' => [
							'tile',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'date_bg_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head,
						 {{WRAPPER}} .mec-date-details,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-list-weekly-date,
						 {{WRAPPER}} .mec-event-date-carousel,
						 {{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details'
				]
			);
			$this->add_responsive_control(
				'date_bg_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-grid-clean .event-grid-t2-head,
						 {{WRAPPER}} .mec-date-details,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-list-weekly-date,
						 {{WRAPPER}} .mec-event-date-carousel,
						 {{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-minimal .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->add_responsive_control(
				'date_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-agenda-date,
						 {{WRAPPER}} .mec-event-month,
						 {{WRAPPER}} .mec-date-details,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-list-weekly-date,
						 {{WRAPPER}} .mec-event-date-carousel,
						 {{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'date_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-agenda-date,
						 {{WRAPPER}} .mec-event-month,
						 {{WRAPPER}} .mec-date-details,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-list-weekly-date,
						 {{WRAPPER}} .mec-event-date-carousel,
						 {{WRAPPER}} .mec-start-date-label,
						 {{WRAPPER}} .mec-masonry-item-wrap .mec-event-grid-modern .event-grid-modern-head,
						 {{WRAPPER}} .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-month,
						 {{WRAPPER}} .mec-events-agenda-wrap .mec-agenda-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-month span,
						 {{WRAPPER}} .mec-event-grid-simple .mec-event-date span,
						 {{WRAPPER}} .mec-calendar .mec-calendar-header h2,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month h4,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date span,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-date,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-date,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-date,
						 {{WRAPPER}} .event-carousel-type1-head .mec-event-date-carousel,
						 {{WRAPPER}} .event-carousel-type2-head .mec-event-date-info,
						 {{WRAPPER}} .mec-event-footer-carousel-type3 .mec-event-date-info,
						 {{WRAPPER}} .mec-slider-t5 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t4 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t3 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t2 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-slider-t1 .mec-event-grid-modern .mec-event-month,
						 {{WRAPPER}} .mec-skin-timeline-container .mec-timeline-event-date,
						 {{WRAPPER}} .mec-marker-infowindow-wp .mec-marker-infowindow-count,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-date,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'date_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-date i.mec-sl-calendar,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-sl-calendar,
						 {{WRAPPER}} .mec-sl-calendar,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details:before,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-skin-list-container .mec-wrap .mec-event-meta-wrap .mec-date-details:before,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-icon,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details::before,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-sl-calendar,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details i:before,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-datetime-info-wrap .mec-event-date-info i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
						'list',
						'cover',
						'grid',
						'available_spot',
						'carousel',
						],
					],
				]
			);
			$this->add_control(
				'date_icon_color',
				[
					'label' 		=> __( 'Icon color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-date i.mec-sl-calendar,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-sl-calendar,
						 {{WRAPPER}} .mec-sl-calendar,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details:before,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-skin-list-container .mec-wrap .mec-event-meta-wrap .mec-date-details:before,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-icon,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details::before,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details i:before,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-datetime-info-wrap .mec-event-date-info i' => 'color: {{VALUE}}',
					],
					'condition' => [
						'skin' => [
						'list',
						'cover',
						'grid',
						'available_spot',
						'carousel',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'mec_date_icon_bg_color',
					'label' => __( 'Icon Background', 'mec-shortcode-builder' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' =>
						'{{WRAPPER}} .mec-event-cover-classic .mec-event-icon,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details:before,
						 {{WRAPPER}} .mec-event-list-classic .mec-event-date i.mec-sl-calendar,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details::before,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-sl-calendar,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) i
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-datetime-info-wrap .mec-event-date-info i',

					'condition' => [
						'skin' => [
						'list',
						'cover',
						'grid',
						'available_spot',
						'carousel',
						],
					],
				]
			);
			$this->add_responsive_control(
				'date_icon_padding',
				[
					'label' 		=> __( 'Icon padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-sl-calendar:before,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details:before,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-icon,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details::before,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-sl-calendar,
					     {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-datetime-info-wrap .mec-event-date-info i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
						'list',
						'cover',
						'grid',
						'available_spot',
						'carousel',
						],
					],
				]
			);
			$this->add_responsive_control(
				'date_icon_margin',
				[
					'label' 		=> __( 'Icon margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-sl-calendar:before,
						 {{WRAPPER}} .mec-event-list-standard .mec-date-details:before,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-month::before,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-icon,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-date-details::before,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-grid-wrap .mec-event-article .mec-event-image .mec-event-date .mec-sl-calendar,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-date i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-date-details i,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-datetime-info-wrap .mec-event-date-info i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
						'list',
						'cover',
						'grid',
						'available_spot',
						'carousel',
						],
					],
				]
			);
			$this->end_controls_section();
			// End Date Style

			// Start Spot
			$this->start_controls_section(
				'spot_style',
				[
					'label' => __( 'Spot Style For Available Spot', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'available_spot',
						],
					],
				]
			);
			$this->add_control(
				'spot_display',
				[
					'label' 		=>  esc_html__( 'Spots Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box' => 'display:{{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'spot_title_typo',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box .mec-av-spot-box-inner .mec-av-spot-text',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'spot_typo',
					'label' 	=> __( 'Spot Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box .mec-av-spot-box-inner .mec-av-spot-count',
				]
			);
			$this->add_control(
				'spot_title_color',
				[
					'label' 		=> __( 'Title color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box .mec-av-spot-box-inner .mec-av-spot-text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'spot_color',
				[
					'label' 		=> __( 'Spot Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box .mec-av-spot-box-inner .mec-av-spot-count' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'spot_bg_color',
				[
					'label' 		=> __( 'Spot Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box .mec-av-spot-box-inner .mec-av-spot-count' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'spot_box_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'spot_box_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'spot_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>  '{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
					{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box',
				]
			);
			$this->add_responsive_control(
				'spot_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot .mec-av-spot-head .mec-av-spot-box,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-img .mec-av-spot-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_section();
			// End Spot

			// Start Countdown
			$this->start_controls_section(
				'countdown_style_for_available_spot',
				[
					'label' => __( 'Countdown Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'available_spot',
						],
					],
				]
			);
			$this->add_control(
				'countdown_display',
				[
					'label' 		=>  esc_html__( 'Countdown Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown' => 'display:{{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'countdown_number_typo',
					'label' 	=> __( 'Number Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown li span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown li span',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'countdown_label_typo',
					'label' 	=> __( 'Label Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown p,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown p',
				]
			);
			$this->add_control(
				'countdown_title_color',
				[
					'label' 		=> __( 'Number color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown li span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown li span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'countdown_color',
				[
					'label' 		=> __( 'Label Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown p,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'countdown_bg_color',
				[
					'label' 		=> __( 'Countdown Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown .block-w li' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'countdown_box_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown .block-w li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'countdown_box_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown .block-w li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'countdown_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>  '{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
									{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown .block-w li',
				]
			);
			$this->add_responsive_control(
				'countdown_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}}  .mec-av-spot .mec-av-spot-head .mec-event-countdown,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-countdown .block-w li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_section();
			// End Countdown

			// Start Date Modern Style
			$this->start_controls_section(
				'list_modern_date_style',
				[
					'label' => __( 'List Modern Date Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'list_style' =>
						[
							'modern',
						],
					],
				]
			);
			$this->add_control(
				'list_modern_date_displaing',
				[
					'label' 		=>  esc_html__( 'Date Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-date .event-d,
						 {{WRAPPER}} .mec-event-date .event-f' => 'display:{{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'list_modern_date_typo',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
					'{{WRAPPER}} .mec-event-date .event-f',
				]
			);
			$this->add_control(
				'list_modern_date_color',
				[
					'label' 		=> __( 'Date color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-date .event-f' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'list_modern_date_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'list_modern_date_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'list_modern_date_num_size',
				[
					'label' 		=> __( 'Date Number Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-date .event-d' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'list_modern_date_num_color',
				[
					'label' 		=> __( 'Date Number color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-date .event-d' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'list_modern_date_num_indent',
				[
					'label' => __( 'Date Number Spacing', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-date .event-d' => 'padding-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .mec-event-list-modern .mec-event-date .event-d' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			// End Date Modern Style

			// Start Date Modern Style
			$this->start_controls_section(
				'monthly_modern_date_style',
				[
					'label' => __( 'Monthly Modern Date Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'monthly_style' =>
						[
							'modern',
						],
					],
				]
			);
			$this->add_control(
				'monthly_modern_date_display',
				[
					'label' 		=>  esc_html__( 'Date Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title' => 'display:{{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'monthly_modern_date_typo',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						{{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title',
				]
			);
			$this->add_control(
				'monthly_modern_date_color',
				[
					'label' 		=> __( 'Date color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_num_size',
				[
					'label' 		=> __( 'Date Number Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-day' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'monthly_modern_date_num_color',
				[
					'label' 		=> __( 'Date Number color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-day' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_num_indent',
				[
					'label' => __( 'Date Number Spacing', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h2,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-table-side-day' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'monthly_modern_date_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>  '{{WRAPPER}} .mec-calendar .mec-calendar-events-side .mec-table-side-day',
				]
			);
			$this->add_responsive_control(
				'monthly_modern_date_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar .mec-calendar-events-side .mec-table-side-day' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_section();
			// End Date Modern Style

			// Weekday Style for All Skin (unless list and grid)
			$this->start_controls_section(
				'mec_list_weekdays_styles',
				[
					'label' => __( 'Weekdays Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'list_style' =>
						[
							'modern',
							'minimal',
						],
					],
				]
			);
			$this->add_control(
				'mec_list_week_day_display',
				[
					'label' 		=>  esc_html__( 'Weekday Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > Minimal and Modern - Yearly Style > Modern - TimeTable Style > Modern and Clean - Grid Style > Clean and Colorful', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-day' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'mec_list_shortcode_weekday_typo',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-date .event-da',
				]
			);
			$this->add_responsive_control(
				'mec_list_weekday_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-da' => 'text-align: {{VALUE}};',
					],
				]
			);
			//fullcalendar Weekly View
			$this->add_control(
				'mec_list_weekday_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-date .event-da' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'mec_list_weekday_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-da' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'mec_list_weekday_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-da'
				]
			);
			$this->add_responsive_control(
				'mec_list_weekday_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-da' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'mec_list_weekday_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-detail,
						 {{WRAPPER}} .mec-event-date .event-da' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			// Day Event Square Style
			$this->start_controls_section(
				'mec_square_style',
				[
					'label' => __( 'Square Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'monthly_view',
						],
					],
				]
			);

			$this->add_control(
				'mec_selected_day_bg_color',
				[
					'label' => __('Selected Day Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day' => 'background-color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_selected_day_link_color',
				[
					'label' => __('Selected Day Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day a,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day a' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'mec_selected_day_typography',
					'label' => __('Selected Day Typography', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day a,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day a',
				]
			);

			$this->add_control(
				'mec_selected_day_border_radius',
				[
					'label' => __('Border Radius', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%'],
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_selected_day_box_shadow',
					'label' => __('Box Shadow', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day',
				]
			);

			// Hover Effects
			$this->add_control(
				'mec_selected_day_hover_heading',
				[
					'label' => __('Hover Effects', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'mec_selected_day_hover_bg_color',
				[
					'label' => __('Hover Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day:hover,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day:hover' => 'background-color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_selected_day_hover_text_color',
				[
					'label' => __('Hover Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day:hover a,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day:hover a' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_selected_day_hover_box_shadow',
				[
					'label' => __('Hover Box Shadow', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::BOX_SHADOW,
					'selectors' => [
						'{{WRAPPER}} .mec-wrap.colorskin-custom .mec-calendar:not(.mec-event-calendar-classic) .mec-selected-day:hover,
						 {{WRAPPER}} .mec-calendar-row .mec-selected-day:hover' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
					],
				]
			);

			$this->end_controls_section();

			// other day Square Style
			$this->start_controls_section(
				'mec_other_day_square_style',
				[
					'label' => __( 'Other Day Square Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'monthly_view',
						],
					],
				]
			);

			$this->add_control(
				'mec_other_day_bg_color',
				[
					'label' => __('Other Day Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day ' => 'background-color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_other_day_link_color',
				[
					'label' => __('Other Day Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day ' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'mec_other_day_typography',
					'label' => __('Other Day Typography', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-calendar-day',
				]
			);

			$this->add_control(
				'mec_other_day_border_radius',
				[
					'label' => __('Border Radius', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%'],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_other_day_box_shadow',
					'label' => __('Box Shadow', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-calendar-day',
				]
			);

			// Hover Effects
			$this->add_control(
				'mec_other_day_hover_heading',
				[
					'label' => __('Hover Effects', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'mec_other_day_hover_bg_color',
				[
					'label' => __('Hover Background Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day:hover' => 'background-color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_other_day_hover_text_color',
				[
					'label' => __('Hover Text Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day:hover' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'mec_other_day_hover_box_shadow',
				[
					'label' => __('Hover Box Shadow', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::BOX_SHADOW,
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-day:hover' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
					],
				]
			);

			$this->end_controls_section();

			$this->start_controls_section(
				'mec_other_day_table_side_day_style',
				[
					'label' => __( 'Other Day Table Side Day Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'monthly_view',
						],
					],
				]
			);
			$this->add_control(
				'mec_other_day_table_side_day_color',
				[
					'label' => __('Other Day Table Side Day Color', 'mec-shortcode-builder'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-calendar-events-sec .mec-table-side-day' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'mec_other_day_table_side_day_typography',
					'label' => __('Other Day Table Side Day Typography', 'mec-shortcode-builder'),
					'selector' => '{{WRAPPER}} .mec-calendar-events-sec .mec-table-side-day',
				]
			);

			$this->end_controls_section();
			// Weekday Style for All Skins
			$this->start_controls_section(
				'mec_all_skin_weekdays_styles',
				[
					'label' => __( 'Weekdays Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'agenda',
							'full_calendar',
							'yearly_view',
							'monthly_view',
							'daily_view',
							'weekly_view',
							'timetable',
							'cover',
							'slider',
						],
					],
				]
			);
			$this->add_control(
				'mec_all_skin_week_day_display',
				[
					'label' 		=>  esc_html__( 'Weekday Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > Minimal and Modern - Yearly Style > Modern - TimeTable Style > Modern and Clean - Grid Style > Clean and Colorful', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} mec-calendar-table-head,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day' => 'display:{{VALUE}} !important;',
					],
					'condition' => [
						'skin!' =>
						[
							'yearly_view',
							'monthly_view',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'mec_all_skin_shortcode_weekday_typo',
					'label' 	=> __( 'Weekdays Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-view-weekday,
						 {{WRAPPER}} .mec-weekly-view-monthday,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day span,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day span',
				]
			);
			$this->add_responsive_control(
				'mec_all_skin_weekday_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-date .event-da,
						 {{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-day,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day' => 'text-align: {{VALUE}};',
					],
				]
			);
			//fullcalendar Weekly View
			$this->add_control(
				'mec_all_skin_weekday_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-day,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-date .event-da,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap .mec-event-day,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap .mec-event-day' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'mec_all_skin_weekday_text_color',
				[
					'label' => __( 'Weekday Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-date .event-da,
						 {{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day span,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'mec_all_skin_weekday_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-date .event-da,
						 {{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title, {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-day,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap-inner .mec-event-day'
				]
			);
			$this->add_responsive_control(
				'mec_all_skin_weekday_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-date .event-da,
						 {{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-day,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap .mec-event-day,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap .mec-event-day' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'mec_all_skin_weekday_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-date .event-da,
						 {{WRAPPER}} .mec-event-day,
						 {{WRAPPER}} .mec-agenda-day,
						 {{WRAPPER}} .mec-weekly-disabled,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-calendar.mec-calendar-weekly .mec-calendar-d-table dl dt,
						 {{WRAPPER}} .mec-ttt2-title,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-date,
						 {{WRAPPER}} .mec-event-grid-modern .event-grid-modern-head .mec-event-day,
						 {{WRAPPER}} .mec-fluent-wrap .mec-calendar.mec-event-calendar-classic .mec-calendar-table-head dt,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-date-wrap,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-date-wrap .mec-event-day' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			// Weekday Style for Grid view
			$this->start_controls_section(
				'mec_grid_style_weekdays_styles',
				[
					'label' => __( 'Weekdays Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'grid_style' =>
						[
							'modern',
							'colorful',
						],
					],
				]
			);
			$this->add_control(
				'mec_grid_style_week_day_display',
				[
					'label' 		=>  esc_html__( 'Weekday Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > Minimal and Modern - Yearly Style > Modern - TimeTable Style > Modern and Clean - Grid Style > Clean and Colorful', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'mec_grid_style_shortcode_weekday_typo',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-day',
				]
			);
			$this->add_responsive_control(
				'mec_grid_style_weekday_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'text-align: {{VALUE}};',
					],
				]
			);
			//fullcalendar Weekly View
			$this->add_control(
				'mec_grid_style_weekday_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'mec_grid_style_weekday_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'mec_grid_style_weekday_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-day'
				]
			);
			$this->add_responsive_control(
				'mec_grid_style_weekday_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'mec_grid_style_weekday_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-day' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			// Time Display
			$this->start_controls_section(
				'time_style',
				[
					'label' => __( 'Time Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'list',
							'grid',
							'daily_view',
							'agenda',
							'full_calendar',
							'yearly_view',
							'timetable',
							'countdown',
							'monthly_view',
							'available_spot',
						],
					],
				]
			);
			$this->add_control(
				'time_display',
				[
					'label' 		=>  esc_html__( 'Time Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > Standard and Accordion - Agenda Style > Clean - TimeTable Style > Modern and Clean - Grid Style > Novel - Countdown', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time .mec-start-time,
						 {{WRAPPER}} .mec-agenda-time .mec-end-time,
						 {{WRAPPER}} .mec-time-details,
						 {{WRAPPER}} .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time,
						 .mec-event-countdown .clockdiv,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details
						 ' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'time_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail::before,
						 {{WRAPPER}} .mec-agenda-event i,
						 {{WRAPPER}} .mec-event-list-standard .mec-color-before .mec-time-details:before,
						 {{WRAPPER}} .mec-sl-clock-o:before,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event i,
						 {{WRAPPER}} .mec-timetable-t2-content i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details::before,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time i,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details:before' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' =>
						[
							'list',
							'grid',
							'daily_view',
							'agenda',
							'monthly_view',
							'timetable',
						],
					],
				]
			);
			$this->add_control(
				'time_icon_color',
				[
					'label' 		=> __( 'Icon color (leave blank for default color)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail::before,
						 {{WRAPPER}} .mec-agenda-event i,
						 {{WRAPPER}} .mec-event-list-standard .mec-color-before .mec-time-details:before,
						 {{WRAPPER}} .mec-sl-clock-o:before,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event i,
						 {{WRAPPER}} .mec-timetable-t2-content i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details::before,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time i,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details:before' => 'color: {{VALUE}}',
					],
					'condition' => [
						'skin' =>
						[
							'list',
							'grid',
							'daily_view',
							'agenda',
							'monthly_view',
							'timetable',
						],
					],
				]
			);
			$this->add_control(
				'time_icon_indent',
				[
					'label' => __( 'Icon Spacing', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail::before,
						 {{WRAPPER}} .mec-agenda-event i,
						 {{WRAPPER}} .mec-event-list-standard .mec-color-before .mec-time-details:before,
						 {{WRAPPER}} .mec-sl-clock-o:before,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details::before' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail::before,
						 {{WRAPPER}} .mec-agenda-event i,
						 {{WRAPPER}} .mec-time-details:before,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event i,
						 {{WRAPPER}} .mec-timetable-t2-content i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details::before,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time i,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details:before' => 'margin-right: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' =>
						[
							'list',
							'grid',
							'daily_view',
							'agenda',
							'monthly_view',
							'timetable',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_time_number_typo',
					'label' 	=> __( 'Number Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-countdown li span,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-article .mec-time-details,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown li span,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown li span,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown li span',

					'condition' => [
						'skin' => 'countdown',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'shortcode_time_typo',
					'label' 	=> __( 'Time Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-event-time,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-agenda-time .mec-start-time,
						 {{WRAPPER}} .mec-agenda-time .mec-end-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,.mec-event-countdown li .label-w,
						 {{WRAPPER}} .mec-event-time span,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time span,
						 {{WRAPPER}} .mec-event-countdown-style1 .mec-event-countdown li .lable-w,
						 {{WRAPPER}} .mec-event-countdown-style2 .mec-event-countdown li .lable-w,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-countdown li .lable-w,
						 {{WRAPPER}} .mec-event-countdown li p,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) div span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time div,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details span',
				]
			);
			$this->add_responsive_control(
				'time_align_main',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-event-countdown li,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details' => 'text-align: {{VALUE}};',
					],

					'condition' => [
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_responsive_control(
				'time_number_color',
				[
					'label' => __( 'Number Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}}  .mec-event-countdown li span,
						.mec-wrap .mec-event-countdown-style1 .mec-event-countdown li span,
						.mec-wrap .mec-event-countdown-style2 .mec-event-countdown li span,
						.mec-wrap .mec-event-countdown-style3 .mec-event-countdown li span' => 'color: {{VALUE}}',
					],
					'condition' => [
						'skin' => 'countdown',
					],
				]
			);
			$this->add_control(
				'time_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-event-countdown li .label-w,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time span,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time span,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) div span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time div,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'time_text_shadow',
					'selector' => '
						{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-event-countdown li .label-w,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time span,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time span,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2) div span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time div,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1) span,
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details span',
				]
			);
			$this->add_responsive_control(
				'time_padding',
				[
					'label' 		=> __( 'padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-event-countdown li,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time span,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time span,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'time_margin',
				[
					'label' 		=> __( 'margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-grid-novel .mec-event-detail,
						 {{WRAPPER}} .mec-agenda-time,
						 {{WRAPPER}} .mec-event-list-standard .mec-time-details,
						 {{WRAPPER}} .mec-event-article .mec-event-time,
						 {{WRAPPER}} .mec-tooltip-event-time,
						 {{WRAPPER}} .mec-timetable-event-span .mec-timetable-event-time,
						 {{WRAPPER}} .event-grid-modern-head .mec-event-detail,
						 {{WRAPPER}} .mec-event-countdown li,
						 {{WRAPPER}} .mec-toggle-item-col .mec-event-detail,
						 {{WRAPPER}} .mec-event-time span,
						 {{WRAPPER}} .mec-timetable-events-list .mec-timetable-event-span.mec-timetable-event-time span,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-time-details,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(2),
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-details .mec-liquid-event-time,
						 {{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(1),
						 {{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-time-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			// Categorie Style
			$this->start_controls_section(
				'categories_style',
				[
					'label'     => __( 'Categories Style', 'mec-shortcode-builder' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [ 'list', 'grid', 'daily_view', 'weekly_view','masonry', 'tile' ],
						'list_display_categories' => '1',
					],
				]
			);

			// Icon Size
			$this->add_control(
				'categories_icon_size',
				[
					'label' => __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-categories-wrapper i,
						 {{WRAPPER}} .mec-categories-wrapper i::before,
						 {{WRAPPER}} .mec-categories-wrapper .mec-sl-folder,
						 {{WRAPPER}} .mec-categories-wrapper .mec-sl-folder::before,
						 {{WRAPPER}} .mec-event-list-standard .mec-categories-wrapper .mec-sl-folder::before,
						 {{WRAPPER}} .mec-event-meta .mec-categories-wrapper .mec-sl-folder::before,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-sl-folder,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-sl-folder::before' => 'font-size: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			// Icon Color
			$this->add_control(
				'categories_icon_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-categories-wrapper i,
						 {{WRAPPER}} .mec-categories-wrapper i::before,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-sl-folder,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-sl-folder::before' => 'color: {{VALUE}};',
					],
				]
			);

			// Link Color
			$this->add_control(
				'categories_link_color',
				[
					'label' => __( 'Link Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-categories-wrapper .mec-category a,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-category a' => 'color: {{VALUE}};',
					],
				]
			);

			// Link Hover Color
			$this->add_control(
				'categories_link_hover_color',
				[
					'label' => __( 'Link Hover Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-categories-wrapper .mec-category a:hover,
						 {{WRAPPER}} .mec-categories-wrapper .mec-category a.mec-color-hover:hover,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-category a:hover,
						 {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-category a.mec-color-hover:hover' => 'color: {{VALUE}};',
					],
				]
			);

			// Typography
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'categories_typography',
					'label'    => __( 'Typography', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-categories-wrapper .mec-category a,
								   {{WRAPPER}} .mec-categories-wrapper .mec-categories .mec-category a',
				]
			);

			$this->end_controls_section();


			//Organizers Style
			$this->start_controls_section(
				'organizers_style',
				[
					'label'     => __( 'Organizers Style', 'mec-shortcode-builder' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [ 'list', 'grid', 'daily_view', 'weekly_view', 'masonry','tile' ],
						'list_display_organizer' => '1',
					],
				]
			);

			// Icon Size
			$this->add_control(
				'organizer_icon_size_main',
				[
					'label' => __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-shortcode-organizers i,
						 {{WRAPPER}} .mec-shortcode-organizers i::before,
						 {{WRAPPER}} .mec-shortcode-organizers .mec-sl-user,
						 {{WRAPPER}} .mec-shortcode-organizers .mec-sl-user::before' => 'font-size: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			// Icon Color
			$this->add_control(
				'organizer_icon_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-shortcode-organizers i,
						 {{WRAPPER}} .mec-shortcode-organizers i::before,
						 {{WRAPPER}} .mec-shortcode-organizers .mec-sl-user,
						 {{WRAPPER}} .mec-shortcode-organizers .mec-sl-user::before' => 'color: {{VALUE}};',
					],
				]
			);

			// Text Color for <a>
			$this->add_control(
				'organizer_link_color',
				[
					'label' => __( 'Link Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-shortcode-organizers .mec-organizers .mec-organizer-item a' => 'color: {{VALUE}};',
					],
				]
			);

			// Hover Color for <a>
			$this->add_control(
				'organizer_link_hover_color',
				[
					'label' => __( 'Link Hover Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-shortcode-organizers .mec-organizers .mec-organizer-item a:hover,
						 {{WRAPPER}} .mec-shortcode-organizers .mec-organizers .mec-organizer-item a.mec-color-hover:hover' => 'color: {{VALUE}};',
					],
				]
			);

			// Typography
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'organizer_typography_main',
					'label'    => __( 'Typography', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-shortcode-organizers .mec-organizers .mec-organizer-item a',
				]
			);

			$this->end_controls_section();


			//Price Style
			$this->start_controls_section(
				'price_style',
				[
					'label'     => __( 'Price Style', 'mec-shortcode-builder' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [ 'list' ],
						'list_display_price' => '1',
					],
				]
			);

			$this->add_control(
				'price_icon_size',
				[
					'label' => __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-price-details i,
						 {{WRAPPER}} .mec-price-details i::before,
						 {{WRAPPER}} .mec-price-details .mec-sl-wallet,
						 {{WRAPPER}} .mec-price-details .mec-sl-wallet::before' => 'font-size: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_control(
				'price_icon_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-price-details i,
						 {{WRAPPER}} .mec-price-details i::before' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'price_typography',
					'label'    => __( 'Price Typography', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-price-details span',
				]
			);

			$this->add_control(
				'price_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-price-details span' => 'color: {{VALUE}};',
					],
				]
			);

			$this->end_controls_section();

			//Location Style
			$this->start_controls_section(
				'location_style',
				[
					'label' => __( 'Location Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' => [
							'custom',
							'general_calendar',
						],
						'yearly_style!' => [
							'fluent',
						],
					],
				]
			);
			$this->add_control(
				'location_display',
				[
					'label' => __( 'Location Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-timeline-event-location,
						{{WRAPPER}} .mec-timetable-event-location,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'location_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-event-location i,
						{{WRAPPER}} .mec-masonry-col6 .mec-event-location i,
						{{WRAPPER}} .mec-slider-t5-col6 .mec-event-location i,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place i,
						{{WRAPPER}} .mec-timeline-event-location i,
						{{WRAPPER}} .mec-timetable-event-location i,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-skin-list-container .mec-wrap .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-event-content .mec-event-address:before,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details::before,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-list-wrap .mec-list-liquid-large .details ul li > i.mec-sl-location-pin,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) i,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location i:before' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'location_icon_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-event-location i,
						{{WRAPPER}} .mec-masonry-col6 .mec-event-location i,
						{{WRAPPER}} .mec-slider-t5-col6 .mec-event-location i,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place i,
						{{WRAPPER}} .mec-timeline-event-location i,
						{{WRAPPER}} .mec-timetable-event-location i,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-skin-list-container .mec-wrap .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-event-content .mec-event-address:before,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details::before,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-list-wrap .mec-list-liquid-large .details ul li > i.mec-sl-location-pin,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) i,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location i:before
						' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'location_icon_indent',
				[
					'label' => __( 'Icon Spacing', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-event-location i,
						{{WRAPPER}} .mec-masonry-col6 .mec-event-location i,
						{{WRAPPER}} .mec-slider-t5-col6 .mec-event-location i,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place i,
						{{WRAPPER}} .mec-timeline-event-location i,
						{{WRAPPER}} .mec-timetable-event-location i,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-skin-list-container .mec-wrap .mec-event-meta-wrap .mec-venue-details:before,
						{{WRAPPER}} .mec-event-content .mec-event-address:before,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details::before,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-list-wrap .mec-list-liquid-large .details ul li > i.mec-sl-location-pin,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li i,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location i,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) i,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location i:before,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location i:before' => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'location_typo',
					'label' 	=> __( 'Location Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details span,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details address,
						{{WRAPPER}} .mec-timeline-event-location span,
						{{WRAPPER}} .mec-timetable-event-location span,
						{{WRAPPER}} .mec-event-location-det h6,
						{{WRAPPER}} .mec-event-location-det .mec-events-address,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address .mec-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address span,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address span',
				]
			);
			$this->add_responsive_control(
				'time_align_location',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details span,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details address,
						{{WRAPPER}} .mec-timeline-event-location span,
						{{WRAPPER}} .mec-timetable-event-location span,
						{{WRAPPER}} .mec-event-location-det h6,
						{{WRAPPER}} .mec-event-location-det .mec-events-address,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address .mec-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address span,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address span' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'location_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details span,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details address,
						{{WRAPPER}} .mec-timeline-event-location span,
						{{WRAPPER}} .mec-timetable-event-location span,
						{{WRAPPER}} .mec-event-location-det h6,
						{{WRAPPER}} .mec-event-location-det .mec-events-address,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address .mec-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address span,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address span' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'location_text_shadow',
					'selector' => '
						{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details span,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details address,
						{{WRAPPER}} .mec-timeline-event-location span,
						{{WRAPPER}} .mec-timetable-event-location span,
						{{WRAPPER}} .mec-event-location-det h6,
						{{WRAPPER}} .mec-event-location-det .mec-events-address,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address .mec-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div span,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address span,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address span',
				]
			);
			$this->add_responsive_control(
				'location_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-timeline-event-location,
						{{WRAPPER}} .mec-timetable-event-location,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'location_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-av-spot-content .mec-location,
						{{WRAPPER}} .mec-av-spot-content .mec-address,
						{{WRAPPER}} .mec-event-countdown-part2 .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-place,
						{{WRAPPER}} .mec-event-detail .mec-event-loc-place,
						{{WRAPPER}} .mec-event-content .mec-event-address,
						{{WRAPPER}} .mec-grid-event-location,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-event-meta-wrap .mec-venue-details,
						{{WRAPPER}} .mec-timeline-event-location,
						{{WRAPPER}} .mec-timetable-event-location,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-event-location-det,
						{{WRAPPER}} .mec-carousel-event-location,
						{{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-venue-details,
						{{WRAPPER}} .mec-fluent-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-location,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .details ul:not(.mec-organizers) li:nth-of-type(3) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-medium ul.location-event li div,
						{{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-content .mec-event-location .mec-events-address,
						{{WRAPPER}} .mec-liquid-wrap .item-liquid-daily .details ul li:nth-of-type(2) div,
						{{WRAPPER}} .mec-liquid-wrap .mec-av-spot-content .mec-event-location address,
						{{WRAPPER}} .mec-liquid-wrap.mec-skin-carousel-container .mec-event-footer-carousel-type3 .mec-event-location address' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->end_controls_section();

			// Register Button
			$this->start_controls_section(
				'register_button_detail_style',
				[
					'label' => __( 'Skin Button Style', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' =>
						[
							'map',
							'daily_view',
							'weekly_view',
							'timetable',
							'monthly_view',
							'agenda',
							'tile',
							'yearly_view',
							'custom',
							'general_calendar',
						],
					],
				]
			);
			$this->add_control(
				'register_button_display',
				[
					'label' 		=>  esc_html__( 'Button Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > minimal and Standard and modern - Agenda Style > Clean - TimeTable Style > Clean - Grid Style > Classic and Clean and Modern and Novel and Colorful - Countdown > Style1', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .btn-wrapper .mec-detail-button,
						 {{WRAPPER}}  .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-event-article .mec-event-footer .mec-event-button,
						 {{WRAPPER}}  .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style1 .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style2 .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'register_button_detail_typography',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
                    ],
					'selector' =>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style1 .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style2 .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button',

				]
			);
			$this->start_controls_tabs( 'tabs_register_button_detail_style' );
			$this->start_controls_tab(
				'tab_register_button_detail_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'register_button_detail_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag.mec-color,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}}  .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style1 .mec-event-countdown-part3 .mec-event-button,
						 .mec-event-countdown-style2 .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'fill: {{VALUE}} !important; color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'booking_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'background:  {{VALUE}} !important; background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'booking_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-cover-container .mec-booking-button,
						 {{WRAPPER}} .mec-liquid-wrap.mec-skin-cover-container .mec-booking-button',
				]
			);
			$this->add_responsive_control(
				'booking_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_register_button_detail_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'register_button_detail_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:hover,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:focus,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button:hover,
						 {{WRAPPER}} .mec-booking-button:hover,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link:hover,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag:hover,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore:hover,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover:hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover:hover,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button:hover' => 'color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'booking_background_hover_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:hover,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:focus,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button:hover,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button:focus,
						 {{WRAPPER}} .mec-booking-button:hover,
						 {{WRAPPER}} .mec-booking-button:focus,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button:focus,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link:hover,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag:hover,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore:hover,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover:hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover:hover,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button:hover' => 'background-color: {{VALUE}}  !important;',
					],
				]
			);
			$this->add_control(
				'booking_hover_border_color',
				[
					'label' => __( 'Border Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'separator' => 'after',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:hover,
						 {{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button:focus,
						 {{WRAPPER}} .mec-booking-button:hover,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link:hover,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button:hover,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag:hover,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore:hover,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button.mec-bg-color-hover:hover,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button.mec-bg-color-hover:hover,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button:hover' => 'border-color: {{VALUE}} !important;',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs(); // End Tabs
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'register_button_detail_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-event-grid-clean .mec-booking-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'register_button_detail_box_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 {{WRAPPER}} .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-totalcal-box .mec-totalcal-view span,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button',
				]
			);
			$this->add_responsive_control(
				'register_button_detail_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
					],
				]
			);
			$this->add_responsive_control(
				'register_button_detail_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-minimal .mec-event-article.mec-clear .btn-wrapper .mec-detail-button,
						 {{WRAPPER}} .mec-booking-button,
						 {{WRAPPER}} .mec-event-countdown-part3 .mec-event-button,
						 {{WRAPPER}} .mec-event-countdown-part-details .mec-event-link,
						 {{WRAPPER}} .mec-event-cover-classic .mec-event-button,
						 {{WRAPPER}} .mec-event-cover-modern .mec-event-tag,
						 {{WRAPPER}} .mec-event-carousel-type2 .mec-booking-button,
						 {{WRAPPER}} .mec-event-carousel-type3 .mec-booking-button,
						 {{WRAPPER}} .mec-timeline-event-content a.mec-timeline-readmore,
						 .mec-wrap .mec-skin-list-events-container .mec-event-article .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-av-spot-content.mec-event-grid-modern .mec-event-footer .mec-booking-button,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-booking-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
					],
				]
			);
			$this->add_control(
				'register_button_detail_line_display',
				[
					'label' 		=>  esc_html__( 'Line Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .btn-wrapper .mec-detail-button:before,
						 {{WRAPPER}}  .mec-event-countdown-part-details .mec-event-link:before' => 'display:{{VALUE}}',
					],
					'separator' => 'before',
					'condition' => [
						'skin' => [
						'list',
						],
						'list_style' => [
						'minimal'
						],
					],
				]
			);
			$this->end_controls_section();
			// End Register Button Style

			// Booking Button
			$this->start_controls_section(
				'booking_button_detail_style',
				[
					'label' => __( 'Skin Booking Button Style', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' =>
						[
							'map',
							'daily_view',
							'weekly_view',
							'timetable',
							'monthly_view',
							'agenda',
							'tile',
							'yearly_view',
							'custom',
						],
						'list_style!' =>
						[
							'fluent'
						],
						'cover_view!' =>
						[
							'fluent'
						],
					],
				]
			);
			$this->add_control(
				'booking_button_display',
				[
					'label' 		=>  esc_html__( 'Button Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > minimal and Standard and modern - Agenda Style > Clean - TimeTable Style > Clean - Grid Style > Classic and Clean and Modern and Novel and Colorful - Countdown > Style1', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'display:{{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'booking_button_detail_typography',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
                    ],
					'selector' => '{{WRAPPER}} .mec-modal-booking-button',
				]
			);
			$this->start_controls_tabs( 'tabs_booking_button_detail_style' );
			$this->start_controls_tab(
				'tab_booking_button_detail_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'booking_button_detail_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'fill: {{VALUE}} !important; color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'booking_button_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'background:  {{VALUE}} !important; background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'booking_button_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' => '{{WRAPPER}} .mec-modal-booking-button',
				]
			);
			$this->add_responsive_control(
				'booking_button_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_booking_button_detail_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'booking_button_detail_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button:hover' => 'color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'booking_button_background_hover_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button:hover' => 'background-color: {{VALUE}}  !important;',
					],
				]
			);
			$this->add_control(
				'booking_button_hover_border_color',
				[
					'label' => __( 'Border Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'separator' => 'after',
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button:hover' => 'border-color: {{VALUE}} !important;',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs(); // End Tabs
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'booking_button_detail_shadow',
					'selector' => '{{WRAPPER}} .mec-modal-booking-button',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'booking_button_detail_box_shadow',
					'selector' => '{{WRAPPER}} .mec-modal-booking-button',
				]
			);
			$this->add_responsive_control(
				'booking_button_detail_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
					],
				]
			);
			$this->add_responsive_control(
				'booking_button_detail_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
					],
				]
			);
			$this->add_control(
				'booking_button_detail_line_display',
				[
					'label' 		=>  esc_html__( 'Line Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-modal-booking-button:before' => 'display:{{VALUE}}',
					],
					'separator' => 'before',
					'condition' => [
						'skin' => [
						'list',
						],
						'list_style' => [
						'minimal'
						],
					],
				]
			);
			$this->end_controls_section();
			// End Booking Button Style

			// Start Social Button
			$this->start_controls_section(
				'social_button_style',
				[
					'label' => __( 'Social Button Style', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'list',
							'grid',
							'carousel',
						],
					],
				]
			);
			$this->add_control(
				'mec_social_button_display',
				[
					'label' 		=>  esc_html__( 'Social Button Display', 'mec-shortcode-builder' ),
					'description' => __( 'List style > Standard and modern - Agenda Style > Clean - TimeTable Style > Clean - Grid Style > Classic and Clean and Modern and Novel and Colorful', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-sharing-wrap,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap li,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap>li:first-of-type' => 'display:{{VALUE}} !important',
					],
				]
			);
			$this->add_responsive_control(
				'social_button_width',
				[
					'label' => __( 'Button width', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap li i,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li i,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap > li:first-of-type' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'social_button_height',
				[
					'label' => __( 'Button height', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap li i,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li i,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap > li:first-of-type' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'social_icon_size',
				[
					'label' 		=> __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'separator' => 'before',
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-sharing-wrap li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap li a,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap li a,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li i,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs( 'tabs_social_button_style' );
			$this->start_controls_tab(
				'tab_social_button_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'social_button_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap li a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap li a,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li a,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type a,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li a i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li i
						 ' => 'fill: {{VALUE}}; color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'social_background_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap li a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap li,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-sharing-wrap li .mec-sl-share:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li a i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'social_button_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'social_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-sharing-wrap li a:hover,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li a:hover,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap:hover li a,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap:hover li a,
						 {{WRAPPER}} .mec-event-sharing-wrap li a:focus,
						 {{WRAPPER}} .mec-event-share:hover a,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i:hover,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li:hover a,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type a:hover,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li:hover a i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li:hover a i' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'social_button_background_hover_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'default' => '',
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-event-share:hover,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li:hover,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap li:hover,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li:hover,
						 {{WRAPPER}} .mec-event-share:focus,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i:hover,
						 {{WRAPPER}} .mec-event-sharing-wrap .mec-event-sharing li:hover a,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type a:hover,
						 {{WRAPPER}} .event-carousel-type3-head .mec-event-sharing-wrap li:first-of-type i:hover,
						 {{WRAPPER}} .mec-event-grid-colorful .event-grid-modern-head .mec-event-sharing-wrap li:hover i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li:hover a i,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li:hover a i' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs(); //end tabs
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'mec_social_button_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'separator' => 'before',
					'default' => '',
					'selector' =>
						'{{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap>li:first-of-type
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li:first-of-type',
				]
			);
			$this->add_control(
				'mec_social_buttons_border_radius',
				[
					'label' 		=> __( 'Social Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap>li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-sharing-wrap > li:first-of-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_social_button_box_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap>li:first-of-type,
						 {{WRAPPER}} .mec-event-sharing-wrap li:first-of-type,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-content .mec-event-sharing-wrap > li:first-of-type,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li:first-of-type',
				]
			);
			$this->add_responsive_control(
				'social_text_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'separator' => 'before',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap>li i,
						 {{WRAPPER}} .mec-event-sharing-wrap > li i,
						 {{WRAPPER}} .mec-event-sharing-wrap > li:first-of-type i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'social_text_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-modern .mec-event-sharing>li i,
						 {{WRAPPER}} .mec-event-grid-colorful .mec-event-sharing-wrap>li i,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-sharing-wrap>li i,
						 {{WRAPPER}} .mec-event-list-standard .mec-event-sharing-wrap>li i,
						 {{WRAPPER}} .mec-event-sharing-wrap>li i,
						 {{WRAPPER}} .mec-event-sharing-wrap>li:first-of-type i,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-sharing-wrap > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			// End Social Button

			// Start Countdown
			$this->start_controls_section(
				'countdown_style_for_countdown',
				[
					'label' => __( 'Countdown Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'countdown',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'countdown_number_typo_for_countdown',
					'label' 	=> __( 'Number Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li span,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li span,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li span',

				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'countdown_label_typo_for_countdown',
					'label' 	=> __( 'Label Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li p,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li p,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li p',

				]
			);
			$this->add_control(
				'countdown_title_color_for_countdown',
				[
					'label' 		=> __( 'Number color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li span,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li span,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li span' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_control(
				'countdown_color_for_countdown',
				[
					'label' 		=> __( 'Label Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li p,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li p,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li p' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_control(
				'countdown_bg_color_for_countdown',
				[
					'label' 		=> __( 'Countdown Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li' => 'background: {{VALUE}} !important',
					],
				]
			);
			$this->add_responsive_control(
				'countdown_box_padding_for_countdown',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};  !important',
					],
				]
			);
			$this->add_responsive_control(
				'countdown_box_margin_for_countdown',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'countdown_border_for_countdown',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li',
				]
			);
			$this->add_responsive_control(
				'countdown_border_radius_for_countdown',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-event-countdown-style1 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style2 .mec-event-countdown #countdown li,
						 .mec-wrap .mec-event-countdown-style3 .mec-event-countdown #countdown li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;'
					],
				]
			);
			$this->end_controls_section();
			// End Countdown

			// Start Feature Image Style
			$this->start_controls_section(
				'feature_image_style',
				[
					'label' => __( 'Feature Image Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' => [
							'timetable',
							'map',
							'tile',
							'custom',
							'general_calendar',
						],
					],
				]
			);
			$this->add_control(
				'feature_image_display',
				[
					'label' 		=>  esc_html__( 'Feature Image Display', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=>  esc_html__( 'Hide', 'mec-shortcode-builder' ),
					'label_off' 	=>  esc_html__( 'Show', 'mec-shortcode-builder' ),
					'return_value' 	=> 'none',
					'default' 		=> '',
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image,
						 {{WRAPPER}} .mec-topsec .mec-event-image,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image,
						 {{WRAPPER}} .mec-timeline-event-image,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image' => 'display:{{VALUE}} !important;',
				],
				'conditions' => [
					'terms' => [
						[
							'name' => 'skin',
							'operator' => '!in',
							'value' => [
								'cover',
								'slider',
							],
						],
					],
				],
				]
			);
			$this->add_responsive_control(
				'feature_image_width',
				[
					'label' => __( 'Image width', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1024,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}}  .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img' => 'width: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
				$this->add_responsive_control(
				'feature_image_height',
				[
					'label' => __( 'Image height', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1024,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img' => 'height: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'feature_image_align',
				[
					'label' => __( 'Alignment', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'mec-shortcode-builder' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image,
						 {{WRAPPER}} .mec-topsec .mec-event-image,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image,
						 {{WRAPPER}} .mec-timeline-event-image
						 {{WRAPPER}} .mec-masonry .mec-masonry-img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img' => 'text-align: {{VALUE}} !important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'feature_image_box_bg',
					'label' => __( 'Background image', 'mec-shortcode-builder' ),
					'types' => [ 'classic' , 'gradient' ],
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image'
				]
			);
			$this->add_group_control(
				Group_Control_Css_Filter::get_type(),
				[
					'name' => 'image_css_filter',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img'
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'image_box_shadow',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img'
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'feature_image_border',
					'label' => __( 'Image Border', 'mec-shortcode-builder' ),
					'separator' => 'before',
					'selector' =>
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img'
				]
			);
			$this->add_responsive_control(
				'feature_image_border_radius',
				[
					'label' 		=> __( 'Image Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-event-countdown-style3 .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);
			$this->add_responsive_control(
				'feature_image_padding',
				[
					'label' 		=> __( 'Image padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'feature_image_margin',
				[
					'label' 		=> __( 'Image margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-event-list-classic .mec-event-image img,
						 {{WRAPPER}} .mec-topsec .mec-event-image img,
						 {{WRAPPER}} .mec-toogle-inner-month-divider .mec-toggle-month-inner-image img,
						 {{WRAPPER}} .mec-event-grid-classic .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-grid-novel .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-events-sec .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-clean .mec-event-image img,
						 {{WRAPPER}} .mec-event-cover-modern,
						 {{WRAPPER}} .mec-owl-carousel .owl-item .mec-event-image img,
						 {{WRAPPER}} .mec-slider-t1 .mec-slider-t1-img,
						 {{WRAPPER}} .mec-slider-t2 .mec-slider-t2-img,
						 {{WRAPPER}} .mec-slider-t3 .mec-slider-t3-img,
						 {{WRAPPER}} .mec-slider-t4 .mec-slider-t4-img,
						 {{WRAPPER}} .mec-slider-t5 .mec-slider-t5-img,
						 {{WRAPPER}} .mec-av-spot .mec-av-spot-img,
						 {{WRAPPER}} .mec-calendar-weekly .mec-event-image img,
						 {{WRAPPER}} .mec-calendar-daily .mec-event-image img,
						 {{WRAPPER}} .mec-timeline-event-image img,
						 {{WRAPPER}} .mec-masonry .mec-masonry-img img,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-event-article .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-list-liquid-item .mec-event-image img,
						 {{WRAPPER}} .mec-liquid-wrap .mec-event-grid-classic .mec-event-image a img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

            // Start Local Time Style
			$this->start_controls_section(
				'localtime_button_style',
				[
					'label' => __( 'Local Time Style', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'list',
							'grid',
							'yearly_view',
							'monthly_view',
							'daily_view',
							'weekly_view',
							'masonry',
							'timetable',
							'agenda',
							'cover',
							'countdown',
							'available_spot',
							'carousel',
							'slider',
							'timeline',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'localtime_typography',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
                    ],
					'selector' => '{{WRAPPER}} .mec-localtime-details div, {{WRAPPER}} .mec-local-time-details div, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details .mec-local-title, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details',
				]
			);
			$this->add_control(
				'mec_localtime_button_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-localtime-details div, {{WRAPPER}} .mec-local-time-details div, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details .mec-local-title, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details .mec-local-date, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details .mec-local-time, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details span, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'mec_localtime_background_button_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-localtime-details, {{WRAPPER}} .mec-local-time-details, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details' => 'background-color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'localtime_button_border',
					'selector' => '{{WRAPPER}} .mec-localtime-details,{{WRAPPER}} .mec-local-time-details, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details',
					'separator' => 'before',
					'default' 		=> 'solid 0px',
				]
			);
			$this->add_responsive_control(
				'mec_localtime_button_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-localtime-details,
						 {{WRAPPER}} .mec-local-time-details,
						 {{WRAPPER}} .mec-event-list-standard .mec-local-time-details, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'localtime_box_shadow',
					'selector' => '{{WRAPPER}} .mec-localtime-details, {{WRAPPER}} .mec-local-time-details, {{WRAPPER}} .mec-event-list-standard .mec-local-time-details, {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details',
				]
			);
			$this->add_responsive_control(
				'localtime_text_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-localtime-wrap,
						 {{WRAPPER}} .mec-wrap .mec-event-list-standard .mec-local-time-details,
						 {{WRAPPER}} #mec_local_time_details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'localtime_text_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-localtime-wrap,
						 {{WRAPPER}} .mec-event-list-standard .mec-local-time-details,
						 {{WRAPPER}} #mec_local_time_details,
						 {{WRAPPER}} .mec-fluent-wrap.mec-skin-list-wrap .mec-local-time-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->end_controls_section();
			// End Local Time Style

			// Start Button Style
			$this->start_controls_section(
				'load_more_button_style',
				[
					'label' => __( 'Load More Button', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'list_load_more_button[return_value]' => '1',
						'skin' => [
							'list',
							'grid',
							'agenda',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'load_more_typography',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
                    ],
					'selector' => '{{WRAPPER}} .mec-load-more-button',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'load_more_text_shadow',
					'selector' => '{{WRAPPER}} .mec-load-more-button',
				]
			);
			$this->start_controls_tabs( 'tabs_load_more_button_style' );
			$this->start_controls_tab(
				'tab_load_more_button_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'mec_load_more_button_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-wrap .mec-load-more-button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'mec_load_more_background_button_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-wrap .mec-load-more-button' => 'background-color: {{VALUE}};'
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_load_more_button_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'load_more_button_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-button:hover' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'load_more_button_background_hover_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-button:hover,
						 {{WRAPPER}} .mec-load-more-button:focus' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'load_more_button_hover_border_color',
				[
					'label' => __( 'Border Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-button:hover' => 'border-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'load_more_hover_animation',
				[
					'label' => __( 'Hover Animation', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::HOVER_ANIMATION,
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'load_more_button_border',
					'selector' => '{{WRAPPER}} .mec-load-more-button',
					'separator' => 'before',
					'default' 		=> 'solid 2px',
				]
			);
			$this->add_responsive_control(
				'mec_load_more_button_border_radius',
				[
					'label' 		=> __( 'Button Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-wrap .mec-load-more-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'button_box_shadow',
					'selector' => '{{WRAPPER}} .mec-load-more-button',
				]
			);
			$this->add_responsive_control(
				'load_more_text_button_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'load_more_text_button_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-load-more-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			// End Button Style

			// Start Button Style
			$this->start_controls_section(
				'next_prev_button_style',
				[
					'label' => __( 'Next Prev Buttons', 'mec-shortcode-builder' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' => [
							'list',
							'grid',
							'agenda',
							'masonry',
							'timeline',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'next_prev_typography',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
                    ],
					'selector' => '{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'next_prev_text_shadow',
					'selector' => '{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button',
				]
			);
			$this->start_controls_tabs( 'tabs_next_prev_button_style' );
			$this->start_controls_tab(
				'tab_next_prev_button_normal',
				[
					'label' => __( 'Normal', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'mec_next_prev_button_text_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'mec_next_prev_background_button_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button' => 'background-color: {{VALUE}};'
					],
				]
			);

			$this->add_control(
				'mec_next_prev_button_icon_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button svg path, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button svg path' => 'fill: {{VALUE}} !important',
					],
				]
			);
			$this->add_control(
				'mec_next_prev_button_icon_size',
				[
					'label' => __( 'Icon Size', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::SLIDER,
					'range' => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button svg, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button svg' => 'width: {{SIZE}}{{UNIT}};height: auto;',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'tab_next_prev_button_hover',
				[
					'label' => __( 'Hover', 'mec-shortcode-builder' ),
				]
			);
			$this->add_control(
				'next_prev_button_hover_color',
				[
					'label' => __( 'Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button:hover, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button:hover' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'next_prev_button_background_hover_color',
				[
					'label' => __( 'Background Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button:hover, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button:hover,
						 {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button:focus, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button:focus' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'mec_next_prev_button_icon_hover_color',
				[
					'label' => __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button:hover svg path, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button:hover svg path' => 'fill: {{VALUE}} !important',
					],
				]
			);

			$this->add_control(
				'next_prev_button_hover_border_color',
				[
					'label' => __( 'Border Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button:hover' => 'border-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'next_prev_hover_animation',
				[
					'label' => __( 'Hover Animation', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::HOVER_ANIMATION,
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'next_prev_button_border',
					'selector' => '{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button',
					'separator' => 'before',
					'default' 		=> 'solid 2px',
				]
			);
			$this->add_responsive_control(
				'mec_next_prev_button_border_radius',
				[
					'label' 		=> __( 'Button Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'mec_next_prev_button_box_shadow',
					'selector' => '{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button',
				]
			);
			$this->add_responsive_control(
				'next_prev_text_button_margin',
				[
					'label' => __( 'Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'next_prev_text_button_padding',
				[
					'label' => __( 'Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-prev-button, {{WRAPPER}} .mec-nextprev-wrap .mec-nextprev-next-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			// End Button Style

			// Label Styles
			$this->start_controls_section(
				'label_style',
				[
					'label' => __( 'Label Style', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin!' => [
							'map',
							'custom',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'normal_labels_typography_inherit',
					'label' 	=> __( 'Label Typography (inherit)', 'mec-shortcode-builder' ),
					'selector' 	=> '{{WRAPPER}} .mec-wrap .mec-labels-normal .mec-label-normal',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'normal_labels_box_border_inherit',
					'label' => __( 'Label Border (inherit)', 'mec-shortcode-builder' ),
					'selector' =>  '{{WRAPPER}} .mec-wrap .mec-labels-normal .mec-label-normal',
				]
			);
			$this->add_responsive_control(
				'normal_labels_box_border_radius_inherit',
				[
					'label' 		=> __( 'Label Border Radius (inherit)', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-wrap .mec-labels-normal .mec-label-normal' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'normal_labels_margin_inherit',
				[
					'label' => __( 'Label Margin (inherit)', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-wrap .mec-labels-normal .mec-label-normal' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'normal_labels_padding_inherit',
				[
					'label' => __( 'Label Padding (inherit)', 'mec-shortcode-builder' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'separator' => 'after',
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-wrap .mec-labels-normal .mec-label-normal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_control(
				'all_labels_line_seprator',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			$this->add_control(
				'all_ongoing_labels_bg_color',
				[
					'label' => __( 'Background Color For Ongoing Label', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-labels-normal .mec-ongoing-normal-label' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'all_ongoing_labels_txt_color',
				[
					'label' => __( 'Ongoing Label Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-labels-normal .mec-ongoing-normal-label' => 'color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'all_expired_labels_bg_color',
				[
					'label' => __( 'Background Color For Expired Label', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-labels-normal .mec-expired-normal-label' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'all_expired_labels_txt_color',
				[
					'label' => __( 'Expired Label Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-labels-normal .mec-expired-normal-label' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'all_cancellation_labels_bg_color',
				[
					'label' => __( 'Background Color For Cancellation Label', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-cancellation-reason span' => 'background: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'all_cancellation_labels_txt_color_secondary',
				[
					'label' => __( 'Cancellation Label Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-cancellation-reason span' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'all_cancellation_labels_txt_color',
				[
					'label' => __( 'Cancellation Label Text Color', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mec-cancellation-reason span' => 'color: {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'all_end_labels_line_seprator',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);

			// Reason for Cancellation
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'reason_label_typography',
					'label' 	=> __( 'Reason for Cancellation Typography', 'mec-shortcode-builder' ),
					'separator' => 'before',
					'selector' 	=> '.mec-wrap .mec-cancellation-reason span ',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'reason_label_box_border',
					'label' => __( 'Reason for Cancellation Border', 'mec-shortcode-builder' ),
					'selector' =>  '.mec-wrap .mec-cancellation-reason span ',
				]
			);
			$this->add_responsive_control(
				'reason_label_box_border_radius',
				[
					'label' 		=> __( 'Reason for Cancellation Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-cancellation-reason span ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'reason_label_margin',
				[
					'label' => __( 'Reason for Cancellation Margin', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-cancellation-reason span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'reason_label_padding',
				[
					'label' => __( 'Reason for Cancellation Padding', 'mec-shortcode-builder' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'.mec-wrap .mec-cancellation-reason span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);

			$this->end_controls_section();

			// Next and Previous Tab
			$this->start_controls_section(
				'organizer_style',
				[
					'label' => __( 'Organizer Styles', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
								'timetable',
						],
						'timetable_style!' =>
						[
							'fluent',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'organizer_typography_timetable',
					'separator' => 'before',
					'label' 	=> __( 'Organizer Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer span',
				]
			);
			$this->add_control(
				'organizer_color',
				[
					'label' 		=> __( 'Organaizer Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'organizer_color_hover',
				[
					'label' 		=> __( 'Hover Organaizer Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer span:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'organizer_bg_color',
				[
					'label' 		=> __( 'Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'organizer_bg_color_hover',
				[
					'label' 		=> __( 'Hover Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer:hover' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'organizer_padding',
				[
					'label' 		=> __( 'Organaizer Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'organizer_margin',
				[
					'label' 		=> __( 'Organaizer Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'organizer_border',
					'label' => __( 'Organaizer Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer',
				]
			);
			$this->add_responsive_control(
				'organizer_border_radius',
				[
					'label' 		=> __( 'Organaizer Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'organizer_icon_size_timetable',
				[
					'label' 		=> __( 'Organaizer Icon Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'organizer_i_color',
				[
					'label' 		=> __( 'Organaizer Icon Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'organizer_i_color_hover',
				[
					'label' 		=> __( 'Hover Organaizer Icon Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-timetable-wrap .mec-event-organizer:hover i' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->end_controls_section();
			// End Typo style

			// Next and Previous Tab
			$this->start_controls_section(
				'nxt_pre_style',
				[
					'label' => __( 'Next and Previous Styles', 'mec-shortcode-builder' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'skin' =>
						[
							'monthly_view',
							'full_calendar',
							'daily_view',
							'weekly_view',
							'timetable',
							'tile',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'nxt_pre_typography',
					'separator' => 'before',
					'label' 	=> __( 'Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-a-month h4',

				]
			);
			$this->add_control(
				'nxt_pre_color',
				[
					'label' 		=> __( 'Title Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month a,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'nxt_pre_color_hover',
				[
					'label' 		=> __( 'Hover Title Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month:hover,
						{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month:hover a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month:hover,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month:hover a,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year:hover,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year:hover,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month:hover a,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month:hover a,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'nxt_pre_bg_color',
				[
					'label' 		=> __( 'Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-previous-month' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'nxt_pre_bg_color_hover',
				[
					'label' 		=> __( 'Hover Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month:hover,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month:hover a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month:hover,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month:hover a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month:hover,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month:hover,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year:hover,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month:hover,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month:hover,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month:hover,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-next-month:hover,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-previous-month:hover' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'second_typo_style_daily_and_weekly',
					'separator' => 'before',
					'label' 	=> __( 'Second Title Typography', 'mec-shortcode-builder' ),
					'selector' 	=>
						'{{WRAPPER}} .mec-calendar-d-top h3,
						{{WRAPPER}} .mec-skin-tile-month-navigator-container h2,
						{{WRAPPER}} .mec-today-container .mec-today-count',

					'condition' => [
						'skin' =>
						[
							'daily_view',
							'weekly_view',
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'second_nxt_pre_color_mec',
				[
					'label' 		=> __( 'Second Title Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar-d-top h3,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container h2,
						 {{WRAPPER}} .mec-today-container .mec-today-count' => 'color: {{VALUE}}',
					],
					'condition' => [
						'skin' =>
						[
							'daily_view',
							'weekly_view',
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'scond_nxt_pre_color_hover',
				[
					'label' 		=> __( 'Second Hover Title Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar-d-top h3:hover,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container h2:hover,
						 {{WRAPPER}} .mec-today-container .mec-today-count:hover' => 'color: {{VALUE}}',
					],
					'condition' => [
						'skin' =>
						[
							'daily_view',
							'weekly_view',
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'scond_nxt_pre_bg_color',
				[
					'label' 		=> __( 'Second Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar-d-top h3,
						{{WRAPPER}} .mec-skin-tile-month-navigator-container h2,
						 {{WRAPPER}} .mec-today-container .mec-today-count' => 'background: {{VALUE}}',
					],
					'condition' => [
						'skin' =>
						[
							'daily_view',
							'weekly_view',
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'scond_nxt_pre_bg_color_hover',
				[
					'label' 		=> __( 'Second Hover Background Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-calendar-d-top h3:hover,
						{{WRAPPER}} .mec-skin-tile-month-navigator-container h2:hover,
						 {{WRAPPER}} .mec-today-container .mec-today-count:hover' => 'background: {{VALUE}}',
					],
					'condition' => [
						'skin' =>
						[
							'daily_view',
							'weekly_view',
							'tile',
						],
					],
				]
			);
			$this->add_responsive_control(
				'nxt_pre_padding',
				[
					'label' 		=> __( 'Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'second_nxt_pre_padding',
				[
					'label' 		=> __( 'Second Title Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_responsive_control(
				'nxt_pre_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'nxt_pre_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month',
				]
			);
			$this->add_responsive_control(
				'nxt_pre_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month a,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-previous-month a,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-next-month,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-next-month,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container .mec-previous-month,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year,
						 {{WRAPPER}} .mec-calendar-a-month .mec-previous-month,
						 {{WRAPPER}} .mec-calendar-a-month .mec-next-month' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'the_arrow_size',
				[
					'label' 		=> __( 'Arrow Size', 'mec-shortcode-builder' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' 		=> [
						'px' 		=> [
							'min' 		=> 0,
							'max' 		=> 200,
							'step' 		=> 1,
						],
						'%' 		=> [
							'min' 		=> 0,
							'max' 		=> 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}}.colorskin-custom .mec-calendar .mec-calendar-side .mec-previous-month i,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year i,
						 {{WRAPPER}} .mec-tile .mec-next-month i,
						 {{WRAPPER}} .mec-tile .mec-previous-month i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-next-month i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-previous-month i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'full_calendar',
						],
					],
				]
			);
			$this->add_control(
				'nxt_pre_i_color',
				[
					'label' 		=> __( 'Icon Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}}.colorskin-custom .mec-calendar .mec-calendar-side .mec-previous-month i,
						 {{WRAPPER}} .mec-calendar .mec-calendar-side .mec-next-month i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year i,
						 {{WRAPPER}} .mec-tile .mec-next-month i,
						 {{WRAPPER}} .mec-tile .mec-previous-month i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-next-month i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-previous-month i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'nxt_pre_i_color_hover',
				[
					'label' 		=> __( 'Hover Icon Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-previous-month:hover i,
						 {{WRAPPER}} .mec-next-month:hover i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-next-year:hover i,
						 {{WRAPPER}} .mec-yearly-title-sec .mec-previous-year:hover i,
						 {{WRAPPER}} .mec-tile .mec-next-month:hover i,
						 {{WRAPPER}} .mec-tile .mec-previous-month:hover i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-next-month:hover i,
						 {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-previous-month:hover i' => 'color: {{VALUE}} !important',
					],
				]
			);
			$this->add_responsive_control(
				'tile_box_padding',
				[
					'label' 		=> __( 'Box Padding', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_responsive_control(
				'tile_box_margin',
				[
					'label' 		=> __( 'Margin', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'tile_box_border',
					'label' => __( 'Border', 'mec-shortcode-builder' ),
					'selector' =>
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container',
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_responsive_control(
				'tile_box_border_radius',
				[
					'label' 		=> __( 'Border Radius', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'tile_box_color',
				[
					'label' 		=> __( 'Box Background', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container' => 'background: {{VALUE}} !important',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->add_control(
				'tile_box_arrow_color',
				[
					'label' 		=> __( 'Box Arrow Color', 'mec-shortcode-builder' ),
					'type' 			=> \Elementor\Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .mec-skin-tile-month-navigator-container:before,
						 {{WRAPPER}} .mec-skin-tile-month-navigator-container:after' => 'border-color: {{VALUE}} transparent transparent transparent !important',
					],
					'condition' => [
						'skin' => [
							'tile',
						],
					],
				]
			);
			$this->end_controls_section();
			// End Typo style

            // Other Style
            $this->start_controls_section(
                'other_style',
                [
                    'label' => __( 'Other Style', 'mec-shortcode-builder' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'skin' =>
                            [
                                'monthly_view',
                                'full_calendar',
                                'daily_view',
                                'weekly_view',
                                'yearly_view',
                            ],
                    ],
                ]
            );
            $this->add_control(
                'other_style_bg_color',
                [
                    'label' 		=> __( 'Background Color', 'mec-shortcode-builder' ),
                    'type' 			=> \Elementor\Controls_Manager::COLOR,
                    'selectors' 	=> [
                        '{{WRAPPER}} .mec-full-calendar-wrap,
                         {{WRAPPER}} .mec-yearly-view-wrap,
                         {{WRAPPER}} .mec-yearly-view-wrap .mec-yearly-calendar-sec,
                         {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-events-wrap,
                         {{WRAPPER}} .mec-calendar,
                         {{WRAPPER}} .mec-calendar .mec-event-footer,
                         {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-top,
                         {{WRAPPER}} .mec-daily-view-dates-events,
                         {{WRAPPER}} .mec-calendar.mec-calendar-daily .mec-calendar-d-table .mec-daily-view-day,
                         {{WRAPPER}} .mec-calendar .mec-calendar-topsec
                        ' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'other_style_border_color',
                [
                    'label' 		=> __( 'Border Color', 'mec-shortcode-builder' ),
                    'type' 			=> \Elementor\Controls_Manager::COLOR,
                    'selectors' 	=> [
                        '{{WRAPPER}} .mec-yearly-view-wrap,
                         {{WRAPPER}} .mec-calendar,
                         {{WRAPPER}} .mec-yearly-view-wrap .mec-agenda-events-wrap
                         ' => 'border-color: {{VALUE}}',
                    ],
                ]
            );
            $this->end_controls_section();
            // End Typo style
		}
		/**
		 * Render MEC widget output on the frontend.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings       = $this->get_settings_for_display();
			$skin           = $settings['skin'];
			$display_option = $search_form = $filter_options = array();

			// Frontend-only inline style to enforce color and typography when Elementor's preview selectors are not present
			$widget_id = $this->get_id();
			$frontend_css = '';
			if ( ! empty( $settings['mec_other_day_table_side_day_color'] ) ) {
				$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-calendar-events-sec .mec-table-side-day{color:' . $settings['mec_other_day_table_side_day_color'] . ' !important;}';
			}
			// Typography: Elementor renders via selectors in editor; mirror key props inline for frontend
			$typo = isset( $settings['mec_other_day_table_side_day_typography_typography'] ) ? $settings['mec_other_day_table_side_day_typography_typography'] : '';
			if ( $typo === 'custom' ) {
				$font_size = isset( $settings['mec_other_day_table_side_day_typography_font_size'] ) ? $settings['mec_other_day_table_side_day_typography_font_size'] : '';
				$font_weight = isset( $settings['mec_other_day_table_side_day_typography_font_weight'] ) ? $settings['mec_other_day_table_side_day_typography_font_weight'] : '';
				$line_height = isset( $settings['mec_other_day_table_side_day_typography_line_height'] ) ? $settings['mec_other_day_table_side_day_typography_line_height'] : '';
				$font_family = isset( $settings['mec_other_day_table_side_day_typography_font_family'] ) ? $settings['mec_other_day_table_side_day_typography_font_family'] : '';
				$props = array();
				if ( ! empty( $font_family ) ) { $props[] = 'font-family:"' . $font_family . '"'; }
				if ( ! empty( $font_weight ) ) { $props[] = 'font-weight:' . $font_weight; }
				if ( ! empty( $font_size ) && is_array( $font_size ) && ! empty( $font_size['size'] ) && ! empty( $font_size['unit'] ) ) { $props[] = 'font-size:' . $font_size['size'] . $font_size['unit']; }
				if ( ! empty( $line_height ) && is_array( $line_height ) && ! empty( $line_height['size'] ) && ! empty( $line_height['unit'] ) ) { $props[] = 'line-height:' . $line_height['size'] . $line_height['unit']; }
				if ( ! empty( $props ) ) {
					$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-calendar-events-sec .mec-table-side-day{' . implode( ';', $props ) . ';}';
				}
			}
			// Null day frontend CSS (make sure it applies on frontend as well)
			if ( ! empty( $settings['mec_null_day_color'] ) ) {
				$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-table-nullday{color:' . $settings['mec_null_day_color'] . ' !important;}';
			}
			if ( ! empty( $settings['mec_null_day_bg_color'] ) ) {
				$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-table-nullday{background-color:' . $settings['mec_null_day_bg_color'] . ' !important;}';
			}
			if ( ! empty( $settings['mec_null_day_hover_bg_color'] ) ) {
				$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-table-nullday:hover{background-color:' . $settings['mec_null_day_hover_bg_color'] . ' !important;}';
			}
			if ( ! empty( $settings['mec_null_day_hover_text_color'] ) ) {
				$frontend_css .= '#elementor-widget-' . $widget_id . ' .mec-table-nullday:hover{color:' . $settings['mec_null_day_hover_text_color'] . ' !important;}';
			}

			if ( $frontend_css !== '' ) {
				echo '<style id="mec-side-day-style-' . esc_attr( $widget_id ) . '">' . wp_kses_post( $frontend_css ) . '</style>';
			}

			if ( isset( $settings['skin'] ) ) {
				$display_option['skin'] = $settings['skin'];
				$settings['skin']       = str_replace( '_view', '', $settings['skin'] );
				$skin                   = $settings['skin'];
			}


			$setting_fields = array(
				'booking_button',
				'display_categories',
				'display_organizer',
			);
			if (!empty($settings['mec_other_day_link_color'])) {
				$widget_id = $this->get_id(); // دریافت ID ویجت برای خاص‌تر کردن سلکتور
				$custom_css = "
					.elementor-element-{$widget_id} .mec-calendar .mec-calendar-day a {
						color: {$settings['mec_other_day_link_color']} !important;
					}
				";
				// افزودن استایل به صورت inline
				echo '<style>' . wp_strip_all_tags($custom_css) . '</style>';
			}
			foreach( $setting_fields as $setting_key ){

				$display_option[ $setting_key ] =  $settings[ $skin . '_' . $setting_key ] ?? '0';
			}

			if ( isset( $settings[ $skin . '_fit_to_row' ] ) ) {
				$display_option['fit_to_row'] = $settings[ $skin . '_fit_to_row' ];
			}

			if ( isset( $settings[ $skin . '_custom_data' ] ) ) {
				$display_option['custom_data'] = $settings[ $skin . '_custom_data' ];
			}

			if ( isset( $settings[ $skin . '_booking_button' ] ) ) {
				$display_option['booking_button'] = $settings[ $skin . '_booking_button' ];
			}

			if ( isset( $settings[ $skin . '_display_organizer' ] ) ) {
				$display_option['display_organizer'] = $settings[ $skin . '_display_organizer' ];
			}

		if ( isset( $settings[ $skin . '_image_popup' ] ) ) {
			$display_option['image_popup'] = $settings[ $skin . '_image_popup' ];
		}

		if ( isset( $settings[ $skin . '_image_size' ] ) ) {
			$display_option['image_size'] = $settings[ $skin . '_image_size' ];
		}

		if ( isset( $settings[ $skin . '_more_event' ] ) ) {
			$display_option['more_event'] = $settings[ $skin . '_more_event' ];
		}

			if ( isset( $settings[ $skin . '_style' ] ) || isset( $settings[ $skin . '_view_style' ] ) ) {
				$display_option['style'] = $settings[ $skin . '_style' ] ?? $settings[ $skin . '_view_style' ];
			}
			if ( isset( $settings[ $skin . '_start_date_type' ] ) ) {
				$display_option['start_date_type'] = $settings[ $skin . '_start_date_type' ];
			}
			if ( isset( $settings[ $skin . '_start_date' ] ) ) {
				$display_option['start_date'] = $settings[ $skin . '_start_date' ];
			}
			if ( isset( $settings[ $skin . '_end_date_type' ] ) ) {
				$display_option['end_date_type'] = $settings[ $skin . '_end_date_type' ];
			}
			if ( isset( $settings[ $skin . '_end_date' ] ) ) {
				$display_option['end_date'] = $settings[ $skin . '_end_date' ];
			}
			if ( isset( $settings[ $skin . '_order_method' ] ) && !empty( $settings[ $skin . '_order_method' ] ) ) {
				$display_option['order_method'] = $settings[ $skin . '_order_method' ];
			}
			if ( isset( $settings[ $skin . '_months' ] ) ) {
				$display_option['months'] = $settings[ $skin . '_months' ];
			}
			if ( isset( $settings[ $skin . '_activate_first_date' ] ) ) {
				$display_option['activate_first_date'] = $settings[ $skin . '_activate_first_date' ];
			}
			if ( isset( $settings[ $skin . '_activate_current_day' ] ) ) {
				$display_option['activate_current_day'] = $settings[ $skin . '_activate_current_day' ];
			}
			if ( isset( $settings[ $skin . '_display_all' ] ) ) {
				$display_option['display_all'] = $settings[ $skin . '_display_all' ];
			}
			if ( isset( $settings[ $skin . '_classic_date_format1' ] ) ) {
				$display_option['classic_date_format1'] = $settings[ $skin . '_classic_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_classic_date_format1' ] ) ) {
				$display_option['date_format_classic1'] = $settings[ $skin . '_classic_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_classic_date_format2' ] ) ) {
				$display_option['date_format_classic2'] = $settings[ $skin . '_classic_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_minimal_date_format1' ] ) ) {
				$display_option['minimal_date_format1'] = $settings[ $skin . '_minimal_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_minimal_date_format2' ] ) ) {
				$display_option['minimal_date_format2'] = $settings[ $skin . '_minimal_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_minimal_date_format3' ] ) ) {
				$display_option['minimal_date_format3'] = $settings[ $skin . '_minimal_date_format3' ];
			}
			if ( isset( $settings[ $skin . '_modern_date_format1' ] ) ) {
				$display_option['modern_date_format1'] = $settings[ $skin . '_modern_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_date_format_modern1' ] ) ) {
				$display_option['date_format_modern1'] = $settings[ $skin . '_date_format_modern1' ];
			}
			if ( isset( $settings[ $skin . '_date_format_list' ] ) ) {
				$display_option['date_format_list'] = $settings[ $skin . '_date_format_list' ];
			}
			if ( isset( $settings[ $skin . '_date_format_yearly_1' ] ) ) {
				$display_option['date_format_yearly_1'] = $settings[ $skin . '_date_format_yearly_1' ];
			}
			if ( isset( $settings[ $skin . '_date_format_yearly_2' ] ) ) {
				$display_option['date_format_yearly_2'] = $settings[ $skin . '_date_format_yearly_2' ];
			}
			if ( isset( $settings[ $skin . '_modern_date_format2' ] ) ) {
				$display_option['modern_date_format2'] = $settings[ $skin . '_modern_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_modern_date_format3' ] ) ) {
				$display_option['modern_date_format3'] = $settings[ $skin . '_modern_date_format3' ];
			}
			if ( isset( $settings[ $skin . '_simple_date_format1' ] ) ) {
				$display_option['simple_date_format1'] = $settings[ $skin . '_simple_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_novel_date_format1' ] ) ) {
				$display_option['novel_date_format1'] = $settings[ $skin . '_novel_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_clean_date_format1' ] ) ) {
				$display_option['clean_date_format1'] = $settings[ $skin . '_clean_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_clean_date_format2' ] ) ) {
				$display_option['clean_date_format2'] = $settings[ $skin . '_clean_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_clean_date_format3' ] ) ) {
				$display_option['clean_date_format3'] = $settings[ $skin . '_clean_date_format3' ];
			}
			if ( isset( $settings[ $skin . '_standard_date_format1' ] ) ) {
				$display_option['standard_date_format1'] = $settings[ $skin . '_standard_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_accordion_date_format1' ] ) ) {
				$display_option['accordion_date_format1'] = $settings[ $skin . '_accordion_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_accordion_date_format2' ] ) ) {
				$display_option['accordion_date_format2'] = $settings[ $skin . '_accordion_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_style1_date_format1' ] ) ) {
				$display_option['date_format_style11'] = $settings[ $skin . '_style1_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_style2_date_format1' ] ) ) {
				$display_option['date_format_style21'] = $settings[ $skin . '_style2_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_style3_date_format1' ] ) ) {
				$display_option['date_format_style31'] = $settings[ $skin . '_style3_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_style3_date_format2' ] ) ) {
				$display_option['date_format_style32'] = $settings[ $skin . '_style3_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_style3_date_format3' ] ) ) {
				$display_option['date_format_style33'] = $settings[ $skin . '_style3_date_format3' ];
			}
			if ( isset( $settings[ $skin . '_date_format1' ] ) ) {
				$display_option['date_format1'] = $settings[ $skin . '_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_date_format2' ] ) ) {
				$display_option['date_format2'] = $settings[ $skin . '_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_type1_date_format1' ] ) ) {
				$display_option['type1_date_format1'] = $settings[ $skin . '_type1_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_type1_date_format2' ] ) ) {
				$display_option['type1_date_format2'] = $settings[ $skin . '_type1_date_format2' ];
			}
			if ( isset( $settings[ $skin . '_type1_date_format3' ] ) ) {
				$display_option['type1_date_format3'] = $settings[ $skin . '_type1_date_format3' ];
			}
			if ( isset( $settings[ $skin . '_type2_date_format1' ] ) ) {
				$display_option['type2_date_format1'] = $settings[ $skin . '_type2_date_format1' ];
			}
			if ( isset( $settings[ $skin . '_type3_date_format1' ] ) ) {
				$display_option['type3_date_format1'] = $settings[ $skin . '_type3_date_format1' ];
			}

			if ( isset( $settings[ $skin . '_fluent_date_format1' ] ) ) {
				$display_option['fluent_date_format1'] = $settings[ $skin . '_fluent_date_format1' ];
			}

			if ( isset( $settings[ $skin . '_liquid_date_format1' ] ) ) {
				$display_option['liquid_date_format1'] = $settings[ $skin . '_liquid_date_format1' ];
			}

			if ( isset( $settings[ $skin . '_autoplay' ] ) ) {
				$display_option['autoplay'] = $settings[ $skin . '_autoplay' ];
			}
			if ( isset( $settings[ $skin . '_sed_method' ] ) ) {
				$display_option['sed_method'] = $settings[ $skin . '_sed_method' ];
			}
			if ( isset( $settings[ $skin . '_count' ] ) ) {
				$display_option['count'] = $settings[ $skin . '_count' ];
			}
			if ( isset( $settings[ $skin . '_number_of_days' ] ) ) {
				$display_option['number_of_days'] = $settings[ $skin . '_number_of_days' ];
			}
			if ( isset( $settings[ $skin . '_week_start' ] ) ) {
				$display_option['week_start'] = $settings[ $skin . '_week_start' ];
			}
			if ( isset( $settings[ $skin . '_event' ] ) ) {
				$display_option['event_id'] = $settings[ $skin . '_event' ];
			}
			if ( isset( $settings[ $skin . '_default_view' ] ) ) {
				$display_option['default_view'] = $settings[ $skin . '_default_view' ];
			}

			if( 'full_calendar' === $skin ) {
				$display_option['monthly_style'] = $settings[ $skin . '_monthly_style' ];
			} elseif ( isset( $settings[ $skin . '_style' ] ) ) {
				$display_option['monthly_style'] = $settings[ $skin . '_style' ];
			}

			if ( isset( $settings[ $skin . '_limit' ] ) ) {
				$display_option['limit'] = $settings[ $skin . '_limit' ];
			}
			if ( isset( $settings[ $skin . '_filter_by' ] ) ) {
				$display_option['filter_by'] = $settings[ $skin . '_filter_by' ];
			}
			if ( isset( $settings[ $skin . '_list' ] ) && $settings[ $skin . '_list' ] == '1' ) {
				$display_option['list'] = $settings[ $skin . '_list' ] = '1';
			} else {
				$display_option['list'] = $settings[ $skin . '_list' ] = '0';
			}
			if ( isset( $settings[ $skin . '_grid' ] ) && $settings[ $skin . '_grid' ] == '1' ) {
				$display_option['grid'] = $settings[ $skin . '_grid' ] = '1';
			} else {
				$display_option['grid'] = $settings[ $skin . '_grid' ] = '0';
			}
			if ( isset( $settings[ $skin . '_tile' ] ) && $settings[ $skin . '_tile' ] == '1' ) {
				$display_option['tile'] = $settings[ $skin . '_tile' ] = '1';
			} else {
				$display_option['tile'] = $settings[ $skin . '_tile' ] = '0';
			}
			if ( isset( $settings[ $skin . '_yearly' ] ) && $settings[ $skin . '_yearly' ] == '1' ) {
				$display_option['yearly'] = $settings[ $skin . '_yearly' ] = '1';
			} else {
				$display_option['yearly'] = $settings[ $skin . '_yearly' ] = '0';
			}
			if ( isset( $settings[ $skin . '_monthly' ] ) && $settings[ $skin . '_monthly' ] == '1' ) {
				$display_option['monthly'] = $settings[ $skin . '_monthly' ] = '1';
			} else {
				$display_option['monthly'] = $settings[ $skin . '_monthly' ] = '0';
			}
			if ( isset( $settings[ $skin . '_weekly' ] ) && $settings[ $skin . '_weekly' ] == '1' ) {
				$display_option['weekly'] = $settings[ $skin . '_weekly' ] = '1';
			} else {
				$display_option['weekly'] = $settings[ $skin . '_weekly' ] = '0';
			}
			if ( isset( $settings[ $skin . '_daily' ] ) && $settings[ $skin . '_daily' ] == '1' ) {
				$display_option['daily'] = $settings[ $skin . '_daily' ] = '1';
			} else {
				$display_option['daily'] = $settings[ $skin . '_daily' ] = '0';
			}
			if ( isset( $settings[ $skin . '_display_price' ] ) && $settings[ $skin . '_display_price' ] == '1' ) {
				$display_option['display_price'] = $settings[ $skin . '_display_price' ] = '1';
			} else {
				$display_option['display_price'] = $settings[ $skin . '_display_price' ] = '0';
			}
			if ( isset( $settings[ $skin . '_display_available_tickets' ] ) && $settings[ $skin . '_display_available_tickets' ] == '1' ) {
				$display_option['display_available_tickets'] = $settings[ $skin . '_display_available_tickets' ] = '1';
			} else {
				$display_option['display_available_tickets'] = $settings[ $skin . '_display_available_tickets' ] = '0';
			}
			if ( isset( $settings[ $skin . '_next_previous_button' ] ) && $settings[ $skin . '_next_previous_button' ] == '1' ) {
				$display_option['next_previous_button'] = $settings[ $skin . '_next_previous_button' ] = '1';
			} else {
				$display_option['next_previous_button'] = $settings[ $skin . '_next_previous_button' ] = '0';
			}
			if ( isset( $settings[ $skin . '_like_grid' ] ) && $settings[ $skin . '_like_grid' ] == '1' ) {
				$display_option[ $skin . '_like_grid' ] = $settings[ $skin . '_like_grid' ] = '1';
			} else {
				$display_option[ $skin . '_like_grid' ] = $settings[ $skin . '_like_grid' ] = '0';
			}
			if ( isset( $settings[ $skin . '_geolocation' ] ) && $settings[ $skin . '_geolocation' ] == '1' ) {
				$display_option['geolocation'] = $settings[ $skin . '_geolocation' ] = '1';
			}
			if( isset( $settings[ $skin . '_pagination_method' ] ) ){

				$display_option['pagination'] = $settings[ $skin . '_pagination_method' ] ?? 'loadmore';
			} elseif ( isset( $settings[ $skin . '_load_more_button' ] ) && $settings[ $skin . '_load_more_button' ] == '1' ) {

				$display_option['load_more_button'] = $settings[ $skin . '_load_more_button' ] = '1';
			} else {

				$display_option['load_more_button'] = $settings[ $skin . '_load_more_button' ] = '0';
			}



			if ( isset( $settings[ $skin . '_include_local_time' ] ) && $settings[ $skin . '_include_local_time' ] == '1' ) {
				$display_option['include_local_time'] = $settings[ $skin . '_include_local_time' ] = '1';
			} else {
				$display_option['include_local_time'] = $settings[ $skin . '_include_local_time' ] = '0';
			}
			if ( isset( $settings[ $skin . '_display_label' ] ) && $settings[ $skin . '_display_label' ] == '1' ) {
				$display_option['display_label'] = $settings[ $skin . '_display_label' ] = '1';
			} else {
				$display_option['display_label'] = $settings[ $skin . '_display_label' ] = '0';
			}
			if ( isset( $settings[ $skin . '_reason_for_cancellation' ] ) && $settings[ $skin . '_reason_for_cancellation' ] == '1' ) {
				$display_option['reason_for_cancellation'] = $settings[ $skin . '_reason_for_cancellation' ] = '1';
			} else {
				$display_option['reason_for_cancellation'] = $settings[ $skin . '_reason_for_cancellation' ] = '0';
			}
			if ( isset( $settings[ $skin . '_include_events_times' ] ) && $settings[ $skin . '_include_events_times' ] == '1' ) {
				$display_option['include_events_times'] = $settings[ $skin . '_include_events_times' ] = '1';
			} else {
				$display_option['include_events_times'] = $settings[ $skin . '_include_events_times' ] = '0';
			}
			if ( isset( $settings[ $skin . '_map_on_top' ] ) && $settings[ $skin . '_map_on_top' ] == '1' ) {
				$display_option['map_on_top'] = $settings[ $skin . '_map_on_top' ] = '1';
			} else {
				$display_option['map_on_top'] = $settings[ $skin . '_map_on_top' ] = '0';
			}
			if ( isset( $settings[ $skin . '_set_geolocation' ] ) && $settings[ $skin . '_set_geolocation' ] == '1' ) {
				$display_option['set_geolocation'] = $settings[ $skin . '_set_geolocation' ] = '1';
			} else {
				$display_option['set_geolocation'] = $settings[ $skin . '_set_geolocation' ] = '0';
			}
			if ( isset( $settings[ $skin . '_set_geolocation_focus' ] ) && $settings[ $skin . '_set_geolocation_focus' ] == '1' ) {
				$display_option['set_geolocation_focus'] = $settings[ $skin . '_set_geolocation_focus' ] = '1';
			} else {
				$display_option['set_geolocation_focus'] = $settings[ $skin . '_set_geolocation_focus' ] = '0';
			}
			if ( isset( $settings[ $skin . '_month_divider' ] ) && $settings[ $skin . '_month_divider' ] == '1' ) {
				$display_option['month_divider'] = $settings[ $skin . '_month_divider' ] = '1';
			} else {
				$display_option['month_divider'] = $settings[ $skin . '_month_divider' ] = '0';
			}
			if ( isset( $settings[ $skin . '_toggle_month_divider' ] ) && $settings[ $skin . '_toggle_month_divider' ] == '1' ) {
				$display_option['toggle_month_divider'] = $settings[ $skin . '_toggle_month_divider' ] = '1';
			} else {
				$display_option['toggle_month_divider'] = $settings[ $skin . '_toggle_month_divider' ] = '0';
			}
			if ( isset( $settings[ 'view_mode' ] ) ) {
				$display_option[ 'view_mode' ] = $settings[ 'view_mode' ];
			}
			if ( isset( $settings[ 'map_zoom' ] ) ) {
				$display_option[ 'map_zoom' ] = $settings[ 'map_zoom' ];
			}
			if ( isset( $settings[ 'map_center_lat' ] ) ) {
				$display_option[ 'map_center_lat' ] = $settings[ 'map_center_lat' ];
			}
			if ( isset( $settings[ 'map_center_long' ] ) ) {
				$display_option[ 'map_center_long' ] = $settings[ 'map_center_long' ];
			}
			// search form options
			if ( isset( $settings[ $skin . '_sf_status' ] ) && $settings[ $skin . '_sf_status' ] == '1' ) {
				$search_form[ $skin . '_sf_status' ] = '1';
			}
			if ( isset( $settings[ $skin . '_sf_display_label' ] ) && $settings[ $skin . '_sf_display_label' ] == '1' ) {
				$search_form[ $skin . '_sf_display_label' ] = '1';
			}
			if ( isset( $settings[ $skin . '_sf_dropdown_method' ] ) ) {
				$search_form[ $skin . '_sf_dropdown_method' ] = $settings[ $skin . '_sf_dropdown_method' ];
			}
			if ( isset( $settings[ $skin . '_category_type' ] ) ) {
				$search_form[ $skin . '_category_type' ] = $settings[ $skin . '_category_type' ];
			}
			if ( isset( $settings[ $skin . '_location_type' ] ) ) {
				$search_form[ $skin . '_location_type' ] = $settings[ $skin . '_location_type' ];
			}
			if ( isset( $settings[ $skin . '_organizer_type' ] ) ) {
				$search_form[ $skin . '_organizer_type' ] = $settings[ $skin . '_organizer_type' ];
			}
			if ( isset( $settings[ $skin . '_speaker_type' ] ) ) {
				$search_form[ $skin . '_speaker_type' ] = $settings[ $skin . '_speaker_type' ];
			}
			if ( isset( $settings[ $skin . '_tag_type' ] ) ) {
				$search_form[ $skin . '_tag_type' ] = $settings[ $skin . '_tag_type' ];
			}
			if ( isset( $settings[ $skin . '_label_type' ] ) ) {
				$search_form[ $skin . '_label_type' ] = $settings[ $skin . '_label_type' ];
			}
			if ( isset( $settings[ $skin . '_address_search_type' ] ) ) {
				$search_form[ $skin . '_address_search_type' ] = $settings[ $skin . '_address_search_type' ];
			}
			if ( isset( $settings[ $skin . '_address_search_placeholder' ] ) ) {
				$search_form[ $skin . '_address_search_placeholder' ] = $settings[ $skin . '_address_search_placeholder' ];
			}
			if ( isset( $settings[ $skin . '_event_cost_type' ] ) ) {
				$search_form[ $skin . '_event_cost_type' ] = $settings[ $skin . '_event_cost_type' ];
			}
			if ( isset( $settings[ $skin . '_month_filter_type' ] ) ) {
				$search_form[ $skin . '_month_filter_type' ] = $settings[ $skin . '_month_filter_type' ];
			}
			if ( isset( $settings[ $skin . '_time_filter_type' ] ) ) {
				$search_form[ $skin . '_time_filter_type' ] = $settings[ $skin . '_time_filter_type' ];
			}
			if ( isset( $settings[ $skin . '_text_search_type' ] ) ) {
				$search_form[ $skin . '_text_search_type' ] = $settings[ $skin . '_text_search_type' ];
				if ( $search_form[ $skin . '_text_search_type' ] == 'dropdown' ) {
					$search_form[ $skin . '_text_search_type' ] = 'text_input';
				}
				if ( isset( $settings[ $skin . '_text_search_placeholder' ] ) ) {
					$search_form[ $skin . '_text_search_placeholder' ] = $settings[ $skin . '_text_search_placeholder' ];
				}
			}

			if ( ! empty( $settings['skin'] ) ) {
				isset( $settings['filter_options_categories'] ) && ! is_array( $settings['filter_options_categories'] ) ? $settings['filter_options_categories'] 	= [ $settings['filter_options_categories'] ] : '';
				isset( $settings['filter_options_exclude_categories'] ) && ! is_array( $settings['filter_options_exclude_categories'] ) ? $settings['filter_options_exclude_categories'] 	= [ $settings['filter_options_exclude_categories'] ] : '';
				isset( $settings['filter_options_locations'] ) && ! is_array( $settings['filter_options_locations'] ) ? $settings['filter_options_locations']    	= [ $settings['filter_options_locations'] ] : '';
				isset( $settings['filter_options_exclude_locations'] ) && ! is_array( $settings['filter_options_exclude_locations'] ) ? $settings['filter_options_exclude_locations']    	= [ $settings['filter_options_exclude_locations'] ] : '';
				isset( $settings['filter_options_organizers'] ) && ! is_array( $settings['filter_options_organizers'] ) ? $settings['filter_options_organizers'] 	= [ $settings['filter_options_organizers'] ] : '';
				isset( $settings['filter_options_exclude_organizers'] ) && ! is_array( $settings['filter_options_exclude_organizers'] ) ? $settings['filter_options_exclude_organizers'] 	= [ $settings['filter_options_exclude_organizers'] ] : '';
				isset( $settings['filter_options_labels'] ) && ! is_array( $settings['filter_options_labels'] ) ? $settings['filter_options_labels']             	= [ $settings['filter_options_labels'] ] : '';
				isset( $settings['filter_options_tags'] ) && ! is_array( $settings['filter_options_tags'] ) ? $settings['filter_options_tags']                   	= [ $settings['filter_options_tags'] ] : '';
				isset( $settings['filter_options_authors'] ) && ! is_array( $settings['filter_options_authors'] ) ? $settings['filter_options_authors']          	= [ $settings['filter_options_authors'] ] : '';
				isset( $settings['filter_options_dates'] ) && ! is_array( $settings['filter_options_dates'] ) ? $settings['filter_options_dates']                	= [ $settings['filter_options_dates'] ] : '';
				isset( $settings['filter_options_occurrence'] ) && ! is_array( $settings['filter_options_occurrence'] ) ? $settings['filter_options_occurrence']	= [ $settings['filter_options_occurrence'] ] : '';

				$args = [
					'display_options' 	=> [
						$display_option,
					],
					'search_form'     	=> [
						$search_form,
					],
					'filter_options' 	=> [
							'categories' 	=> isset( $settings['filter_options_categories'] ) ? implode( ',', $settings['filter_options_categories'] ) : '',
							'exclude_categories' 	=> isset( $settings['filter_options_exclude_categories'] ) ? implode( ',', $settings['filter_options_exclude_categories'] ) : '',
							'locations' 	=> isset( $settings['filter_options_locations'] ) ? implode( ',', $settings['filter_options_locations'] ) : '',
							'exclude_locations' 	=> isset( $settings['filter_options_exclude_locations'] ) ? implode( ',', $settings['filter_options_exclude_locations'] ) : '',
							'organizers' 	=> isset( $settings['filter_options_organizers'] ) ? implode( ',', $settings['filter_options_organizers'] ) : '',
							'exclude_organizers' 	=> isset( $settings['filter_options_exclude_organizers'] ) ? implode( ',', $settings['filter_options_exclude_organizers'] ) : '',
							'label'      	=> isset( $settings['filter_options_labels'] ) ? implode( ',', $settings['filter_options_labels'] ) : '',
							'tags'       	=> isset( $settings['filter_options_tags'] ) ? implode( ',', $settings['filter_options_tags'] ) : '',
							'authors'    	=> isset( $settings['filter_options_authors'] ) ? implode( ',', $settings['filter_options_authors'] ) : '',
							'dates'			=> isset( $settings['filter_options_dates'] ) ? implode( ',', $settings['filter_options_dates'] ) : '',
							'occurrence' 	=> isset( $settings['filter_options_occurrence'] ) ? implode( ',', $settings['filter_options_occurrence'] ) : '',
					],
				];
				$sf_options = array(
					'category'    		=> array( 'type' => 'dropdown' ),
					'text_search' 		=> array( 'type' => 'text_input' ),
				);
				// Create Default Calendars
				$e_skin                                       							= $display_option['skin'];
				$e_args                                       							= [];
				$e_args['skin']                               							= $e_skin;
				$e_args['sk-options'][ $e_skin ]              							= $display_option;
				$e_args['sf-options'][ $e_skin ]['category']  							= isset( $search_form[ $skin . '_category_type' ] ) ? [ 'type' => $search_form[ $skin . '_category_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['location']  							= isset( $search_form[ $skin . '_location_type' ] ) ? [ 'type' => $search_form[ $skin . '_location_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['organizer'] 							= isset( $search_form[ $skin . '_organizer_type' ] ) ? [ 'type' => $search_form[ $skin . '_organizer_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['speaker']								= isset( $search_form[ $skin . '_speaker_type' ] ) ? [ 'type' => $search_form[ $skin . '_speaker_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['tag'] 								= isset( $search_form[ $skin . '_tag_type' ] ) ? [ 'type' => $search_form[ $skin . '_tag_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['label']     							= isset( $search_form[ $skin . '_label_type' ] ) ? [ 'type' => $search_form[ $skin . '_label_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['address_search']['type']				= isset( $search_form[ $skin . '_address_search_type' ] ) ? $search_form[ $skin . '_address_search_type' ] : '0';
				$e_args['sf-options'][ $e_skin ]['address_search']['placeholder']		= isset( $search_form[ $skin . '_address_search_placeholder' ] ) ? $search_form[ $skin . '_address_search_placeholder' ] : '';
				$e_args['sf-options'][ $e_skin ]['event_cost'] 							= isset( $search_form[ $skin . '_event_cost_type' ] ) ? [ 'type' => $search_form[ $skin . '_event_cost_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['month_filter'] 						= isset( $search_form[ $skin . '_month_filter_type' ] ) ? [ 'type' => $search_form[ $skin . '_month_filter_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['time_filter'] 						= isset( $search_form[ $skin . '_time_filter_type' ] ) ? [ 'type' => $search_form[ $skin . '_time_filter_type' ] ] : [ 'type' => 0 ];
				$e_args['sf-options'][ $e_skin ]['text_search']['type']					= isset( $search_form[ $skin . '_text_search_type' ] ) ? $search_form[ $skin . '_text_search_type' ] : '0';
				$e_args['sf-options'][ $e_skin ]['text_search']['placeholder']			= isset( $search_form[ $skin . '_text_search_placeholder' ] ) ? $search_form[ $skin . '_text_search_placeholder' ] : '';

				if ( $args['filter_options']['dates'] == 'include-expired-events' ) {
					$e_args['show_past_events']         = 1;
					$e_args['show_only_past_events']    = 0;
					$e_args['show_only_ongoing_events'] = 0;
					$e_args['show_ongoing_events']		= 0;
				} elseif ( $args['filter_options']['dates'] == 'show-only-ongoing-events' ) {
					$e_args['show_only_ongoing_events'] = 1;
					$e_args['show_past_events']         = 0;
					$e_args['show_only_past_events']    = 0;
					$e_args['show_ongoing_events']		= 1;
				} elseif ( $args['filter_options']['dates'] == 'show-only-expired-events' ) {
					$e_args['show_only_past_events']    = 1;
					$e_args['show_past_events']         = 1;
					$e_args['show_only_ongoing_events'] = 0;
					$e_args['show_ongoing_events']		= 0;
				} elseif ( $args['filter_options']['dates'] == 'show-ongoing-events' ) {
					$e_args['show_only_past_events']    = 0;
					$e_args['show_past_events']         = 1;
					$e_args['show_only_ongoing_events'] = 0;
					$e_args['show_ongoing_events']		= 1;
				} elseif ( $args['filter_options']['dates'] == 'show-upcoming-events' ) {
					$e_args['show_only_past_events']    = 0;
					$e_args['show_past_events']         = 0;
					$e_args['show_only_ongoing_events'] = 0;
					$e_args['show_ongoing_events']		= 0;
				} else {
					$e_args['show_past_events']         = 0;
					$e_args['show_only_past_events']    = 0;
					$e_args['show_only_ongoing_events'] = 0;
					$e_args['show_ongoing_events']		= 0;
				}

				$e_args['show_only_one_occurrence'] = isset( $settings['filter_options_occurrence']['0'] ) ? $settings['filter_options_occurrence']['0'] : '';

				$r_key = $skin . '_sf_reset_button';
				if ( isset( $settings[ $r_key ] ) ) {
					$e_args['sf_reset_button'] = $settings[ $r_key ];
				}

				$r_key = $skin . '_sf_refine';
				if ( isset( $settings[ $r_key ] ) ) {
					$e_args['sf_refine'] = $settings[ $r_key ];
				}

				$e_args['sf_status']             	= isset( $search_form[ $skin . '_sf_status' ] ) ? $search_form[ $skin . '_sf_status' ] : '0';
				$e_args['sf_display_label']			= isset( $search_form[ $skin . '_sf_display_label' ] ) ? $search_form[ $skin . '_sf_display_label' ] : '0';
				$e_args['sf_dropdown_method']		= isset( $search_form[ $skin . '_sf_dropdown_method' ] ) ? $search_form[ $skin . '_sf_dropdown_method' ] : '1';
				$e_args['category']              	= isset( $args['filter_options']['categories'] ) ? $args['filter_options']['categories'] : '';
				$e_args['ex_category']              	= isset( $args['filter_options']['exclude_categories'] ) ? $args['filter_options']['exclude_categories'] : '';
				if( is_tax('mec_category') and get_queried_object_id() ) {

					$e_args['category'] .= !empty( $e_args['category'] ) ? ',' . get_queried_object_id() : get_queried_object_id();
				}
				$e_args['location']              	= isset( $args['filter_options']['locations'] ) ? $args['filter_options']['locations'] : '';
				$e_args['ex_location']              	= isset( $args['filter_options']['exclude_locations'] ) ? $args['filter_options']['exclude_locations'] : '';
				$e_args['organizer']             	= isset( $args['filter_options']['organizers'] ) ? $args['filter_options']['organizers'] : '';
				$e_args['ex_organizer']             	= isset( $args['filter_options']['exclude_organizers'] ) ? $args['filter_options']['exclude_organizers'] : '';
				$e_args['label']                 	= isset( $args['filter_options']['label'] ) ? $args['filter_options']['label'] : '';
				$e_args['tag']                   	= isset( $args['filter_options']['tags'] ) ? $args['filter_options']['tags'] : '';
				$e_args['author']                	= isset( $args['filter_options']['authors'] ) ? $args['filter_options']['authors'] : '';
				$e_args['occurrence']				= isset( $args['filter_options']['occurrence'] ) ? $args['filter_options']['occurrence'] : '';
				$e_args['sk-options'][ $e_skin ] 	= $display_option;

                $e_args['tag'] = str_replace("&amp;","&",$e_args['tag']);

				$new            = new \MEC_render();
				$new->post_atts = $e_args;
				echo $new->shortcode( [ 'id' => md5( microtime() ) ] );
				$bootstrap_class = new \MEC_Shortcode_Builder_Bootstrap();
				$bootstrap_class->load_footer();

			// Force initialize General Calendar in Elementor editor to ensure live preview
			if ( Plugin::$instance->editor->is_edit_mode() && $skin === 'general_calendar' ) {
				$widget_id = $this->get_id();
				$direction = is_rtl() ? 'rtl' : 'ltr';
				$border_direction = is_rtl() ? 'border-right-width' : 'border-left-width';
				$border_direction_style = is_rtl() ? 'border-left-style' : 'border-right-style';
				$lang = !empty(substr(get_locale(), 0, strpos(get_locale(), "_"))) ? substr(get_locale(), 0, strpos(get_locale(), "_")) : get_locale();
				$week_start_day = (int) get_option('start_of_week');
				$sed_method = isset($display_option['sed_method']) ? ($display_option['sed_method'] == 'new' ? '_blank' : ($display_option['sed_method'] == '0' ? '_self' : $display_option['sed_method'])) : '_self';
				$more_event = isset($display_option['more_event']) ? (int) $display_option['more_event'] : 10;
				
				echo '<script>
				jQuery(function(){
					var $widget = jQuery("[data-id=\'' . esc_js( $widget_id ) . '\']");
					var $container = $widget.find(".elementor-widget-container");
					var $wrap = $container.find("#mec-gCalendar-wrap");
					if($wrap.length && window.FullCalendar && !$wrap.data("mec-initialized")){
						try{
							var calendar = new FullCalendar.Calendar($wrap[0], {
								initialView: "dayGridMonth",
								editable: false,
								selectable: false,
								businessHours: false,
								height: "auto",
								eventLimit: false,
								direction: "' . esc_js($direction) . '",
								locale: "' . esc_js($lang) . '",
								lang: "' . esc_js($lang) . '",
								firstDay: ' . esc_js($week_start_day) . ',
								headerToolbar: {
									left: "title,prevYear,prev,today,next,nextYear",
									center: "",
									right: "filterEvents,findEvents"
								},
								buttonText: {
									today: "Today"
								},
								customButtons: {
									findEvents: {
										text: "Find Events",
										click: function() {
											// Refetch events from server with current filters
											if (calendar) {
												calendar.refetchEvents();
											}
										}
									},
									filterEvents: {
										text: "Filter",
										click: function() {
											jQuery(".mec-gCalendar-filters").fadeToggle("fast", "linear");
										}
									}
								},
								eventDidMount: function(info) {
									// Fallbacks like original skin: ensure we always have a sane color
									var rawBg  = info.backgroundColor || "#00acf8";
									var rawBor = info.borderColor || "#00acf8";
									var backgroundColor = (rawBg === "#") ? "#00acf8" : rawBg;
									var borderColor     = (rawBor === "#") ? "#00acf8" : rawBor;

									jQuery(info.el).css({
										"padding": "8px 3px",
										"font-size": "12px",
										"font-weight": "400",
										"border-radius": "0",
										"border-top": "none",
										"border-bottom": "none",
										"' . $border_direction . '": "3px",
										"' . $border_direction_style . '": "none",
										"background-color": "#fff",
										"border-left-style": "solid",
										"border-left-color": borderColor,
										"white-space": "normal",
										"font-family": "-apple-system,BlinkMacSystemFont,\\"Segoe UI\\",Roboto,sans-serif",
										"line-height": "1.2",
										"margin-top": "0"
									});

									jQuery(info.el).attr("target", "' . esc_js($sed_method) . '");
									' . ($sed_method == 'no' ? 'jQuery(info.el).css({"cursor": "default","pointer-events": "none","text-decoration": "none"});' : '') . '
									jQuery(info.el).attr("data-event-id", info.event._def.publicId);

									// Ensure overlay span exists (same structure as frontend skin)
									if (!jQuery(info.el).children("span").length) {
										jQuery(info.el).append("<span class=\"\" style=\"background-color:" +  backgroundColor + ";position: absolute;top: 0;right: 0;bottom: 0;left: -1px;z-index: 0;opacity: .25;\"></span>");
									}

									jQuery(info.el).append(info.event._def.extendedProps.reason_for_cancellation || "");
									jQuery(info.el).append(info.event._def.extendedProps.locaTimeHtml || "");
									jQuery(info.el).append(info.event._def.extendedProps.labels || "");
								},
								eventMouseEnter: function(info) {
									// Remove any existing tooltip in this cell
									jQuery(info.el).parent().find(".mec-gCalendar-tooltip").remove();

									var hasImage = !!info.event._def.extendedProps.image;
									var imageHtml = hasImage ? "<div class=\\"mec-gCalendar-tooltip-image\\">" + (info.event._def.extendedProps.gridsquare || "") + "</div>" : "";

									var dateText;
									if (info.event._def.extendedProps.startDateStr && info.event._def.extendedProps.endDateStr && info.event._def.extendedProps.startDateStr !== info.event._def.extendedProps.endDateStr) {
										dateText = "<i class=\\"mec-sl-calendar\\"></i><div><span class=\\"mec-gCalendar-tooltip-date-start\\">" + (info.event._def.extendedProps.start_date || "") + "</span>" +
											"<span class=\\"mec-gCalendar-tooltip-date-end\\">" + (info.event._def.extendedProps.end_date || "") + "</span></div>";
									} else {
										dateText = "<i class=\\"mec-sl-calendar\\"></i><div><span class=\\"mec-gCalendar-tooltip-date-start\\">" + (info.event._def.extendedProps.start_date || "") + "</span>" +
											"<span class=\\"mec-gCalendar-tooltip-date-day\\">" + (info.event._def.extendedProps.startDay || "") + "</span></div>";
									}

									var dateTime = "<i class=\\"mec-sl-clock\\"></i><div><span class=\\"mec-gCalendar-tooltip-time-start\\">" + (info.event._def.extendedProps.start_time || "") + "</span>" +
										"<span class=\\"mec-gCalendar-tooltip-time-end\\">" + (info.event._def.extendedProps.end_time || "") + "</span></div>";

									var locationHtml = "";
									if (info.event._def.extendedProps.location) {
										locationHtml = "<div class=\\"mec-gCalendar-tooltip-location\\"><i class=\\"mec-sl-location-pin\\"></i>" + info.event._def.extendedProps.location + "</div>";
									}

									var titleHtml = "<div class=\\"mec-gCalendar-tooltip-title\\"><a data-event-id=\\"" + info.event._def.publicId + "\\" target=\\"' . esc_js($sed_method) . '\\" href=\\"" + info.event._def.url + "\\">" +
										info.event._def.title + "<span style=\\"background:" + info.event._def.ui.backgroundColor + "\\"></span></a></div>";

									var tooltip = "<div class=\\"mec-gCalendar-tooltip\\">" +
										imageHtml +
										"<div class=\\"mec-gCalendar-tooltip-date\\">" +
											"<div class=\\"mec-gCalendar-tooltip-date-text\\">" + dateText + "</div>" +
											"<div class=\\"mec-gCalendar-tooltip-date-time\\">" + dateTime + "</div>" +
										"</div>" +
										titleHtml +
										locationHtml +
									"</div>";

									if (jQuery(info.el).parent().find(".mec-gCalendar-tooltip").length < 1) {
										jQuery(info.el).parent().append(tooltip);
									}
								},
								dayMaxEvents: ' . esc_js($more_event) . ',
								moreLinkContent: function(arg) {
									return "+" + arg.num + " more";
								},
								timeZone: "' . get_option('gmt_offset') . '",
								events: {
									url: "' . esc_js( get_rest_url() ) . 'mec/v1/events",
									method: "GET",
									startParam: "startParam",
									endParam: "endParam",
									textColor: "#000",
									ajax: true,
									extraParams: function() {
										return {
											show_past_events: "' . (isset($e_args['show_past_events']) ? esc_js($e_args['show_past_events']) : '0') . '",
											show_only_past_events: "' . (isset($e_args['show_only_past_events']) ? esc_js($e_args['show_only_past_events']) : '0') . '",
											show_only_one_occurrence: "' . (isset($e_args['show_only_one_occurrence']) ? esc_js($e_args['show_only_one_occurrence']) : '0') . '",
											display_label: "' . (isset($display_option['display_label']) ? esc_js($display_option['display_label']) : '0') . '",
											reason_for_cancellation: "' . (isset($display_option['reason_for_cancellation']) ? esc_js($display_option['reason_for_cancellation']) : '0') . '",
											local_time: "' . (isset($display_option['include_local_time']) ? esc_js($display_option['include_local_time']) : '0') . '",
											image_size: "' . (isset($display_option['image_size']) ? esc_js($display_option['image_size']) : 'default') . '",
											filter_category: "' . (isset($e_args['category']) ? esc_js($e_args['category']) : '') . '",
											filter_ex_category: "' . (isset($e_args['ex_category']) ? esc_js($e_args['ex_category']) : '') . '",
											filter_location: "' . (isset($e_args['location']) ? esc_js($e_args['location']) : '') . '",
											filter_ex_location: "' . (isset($e_args['ex_location']) ? esc_js($e_args['ex_location']) : '') . '",
											filter_organizer: "' . (isset($e_args['organizer']) ? esc_js($e_args['organizer']) : '') . '",
											filter_ex_organizer: "' . (isset($e_args['ex_organizer']) ? esc_js($e_args['ex_organizer']) : '') . '",
											filter_label: "' . (isset($e_args['label']) ? esc_js($e_args['label']) : '') . '",
											filter_tag: "' . (isset($e_args['tag']) ? esc_js($e_args['tag']) : '') . '",
											filter_author: "' . (isset($e_args['author']) ? esc_js($e_args['author']) : '') . '",
											locale: "' . esc_js($lang) . '",
											lang: "' . esc_js($lang) . '"
										};
									},
									failure: function() {
										console.error("Error fetching events for General Calendar");
									}
								},
								forceEventDuration: true,
								loading: function(bool) {
									var loadingEl = document.getElementById("gCalendar-loading");
									if(loadingEl) loadingEl.style.display = bool ? "block" : "none";
								}
							});
							calendar.render();

							// Hide the default FullCalendar event dot in Elementor preview
							jQuery("[data-id=\'' . esc_js( $widget_id ) . '\'] .fc-daygrid-event-dot").css("display", "none");

							// Inject search bar and move filters into header toolbar, similar to frontend skin
							var calendarHeaderFirstChild = jQuery(".fc-header-toolbar").find(".fc-toolbar-chunk").first().find("h2");
							var calendarHeaderLastChild = jQuery(".fc-header-toolbar").find(".fc-toolbar-chunk").last();
							var calendarHeaderButton = calendarHeaderLastChild.find(".fc-button-group");

							// Search input
							if (!jQuery(".mec-gCalendar-search-text-wrap").length) {
								jQuery("<div class=\\"mec-gCalendar-search-text-wrap\\"><i class=\\"mec-sl-magnifier\\"></i><input type=\\"text\\" class=\\"mec-gCalendar-search-text\\" placeholder=\\"Search for events\\" /></div>").insertBefore(".fc-header-toolbar .fc-toolbar-chunk:last-child .fc-button-group");

								jQuery(".mec-gCalendar-search-text").on("keypress", function(event){
									var keycode = event.keyCode ? event.keyCode : event.which;
									if(keycode == 13){
										jQuery(".fc-findEvents-button").trigger("click");
									}
								});
							}

							// Move filter container beside buttons
							setTimeout(function(){
								if (calendarHeaderButton.length && jQuery(".mec-gCalendar-filters").length) {
									jQuery(".mec-gCalendar-filters").appendTo(calendarHeaderButton);
								}
							}, 500);

							// Remove tooltip when leaving events area
							jQuery(document).on("mouseleave", ".fc-daygrid-event-harness", function() {
								jQuery(this).find(".mec-gCalendar-tooltip").remove();
							});

							$wrap.data("mec-initialized", true);
						}catch(e){
							console.error("FullCalendar initialization error:", e);
						}
					}
				});
				</script>';
			}
			}

			if ( Plugin::$instance->editor->is_edit_mode() ) {
				echo '<script>
				jQuery(document).ready(function () {
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-minmax-event-cost").parent().find(".mec-text-address-search").addClass("with-mec-cost");
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-text-address-search").parent().find(".mec-minmax-event-cost").addClass("with-mec-address");
					jQuery(".mec-full-calendar-search-ends").find(".mec-text-input-search").parent().find(".mec-tab-loader").removeClass("col-md-12").addClass("col-md-6");
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-text-input-search").parent().find(".mec-date-search").parent().find(".mec-text-input-search").addClass("col-md-6");
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-text-input-search").parent().find(".mec-time-picker-search").parent().find(".mec-text-input-search").addClass("col-md-6");
					jQuery(".mec-full-calendar-search-ends").find(".mec-text-input-search").addClass("col-md-12").parent().find(".mec-time-picker-search").addClass("col-md-6");
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-date-search").parent().find(".mec-time-picker-search").addClass("with-mec-date-search");
					jQuery(".mec-search-form.mec-totalcal-box").find(".mec-time-picker-search").parent().find(".mec-date-search").addClass("with-mec-time-picker");
				});
				</script>';
			}

		}
	}
	add_action( 'wp_head', function() {
		echo '<style type="text/css">
		.fc-daygrid-event-dot {
			display: none
		}	
		</style>';
	});
endif;
