<?php

namespace MEC_Advanced_Organizer\Core\Elementor;

final class Elementor {


	public static function init() {

		add_action( 'elementor/widgets/register', [ __CLASS__, 'register_widgets' ] );
		add_action( 'elementor/elements/categories_registered', [ __CLASS__, 'add_elementor_widget_categories' ] );
		add_action('elementor/editor/after_enqueue_styles', [__CLASS__, 'editor_styles']);
	}

	public static function editor_styles() {
	}

	/**
	 * Init Widgets
	 *
	 * Include widgets files and register them
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public static function register_widgets() {

		require_once __DIR__ . '/widgets/list.php';
		require_once __DIR__ . '/widgets/featured.php';

		// Register widget
		\Elementor\Plugin::instance()->widgets_manager->register( new Widgets\OrganizersList() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Widgets\OrganizersFeatured() );
	}

	public static function add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'mec_advanced_organizer',
			[
				'title' => __( 'MEC Advanced Organizer', 'mec-advanced-organizer' ),
				'icon' => 'fa fa-plug',
			]
		);
	}
}
