<?php

namespace MEC_Advanced_Organizer\Core\Elementor\Widgets;

use Elementor\Controls_Manager;
use MEC_Advanced_Organizer\Core\OrganizerWidget\MEC_Advanced_Organizer_OrganizerWidget_Frontend;

class OrganizersFeatured extends \Elementor\Widget_Base {

	public function get_name() {

		return 'mec_advanced_organizers_Featured';
	}

	public function get_title() {

		return __( 'Featured Organizers', 'mec-advanced-organizer' );
	}

	public function get_icon() {

		return 'eicon-person';
	}

	public function get_categories() {

		return [ 'mec_advanced_organizer' ];
	}

	public function get_style_depends() {

		return [ 'mec-advanced-organizer-style' ];
	}

	public function get_script_depends() {

		return [ 'mec-advanced-organizer-frontend-script' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'mec_advanced_organizers_list_settings',
            array(
                'label' 	=> __( 'Settings', 'mec-advanced-organizer' ),
                'tab'   	=> Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'limit',
			array(
				'label' 		=> __('Limit', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 3,
            )
		);

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $atts = array(
            'limit' => $settings['limit'] ?? 0,
        );

        echo MEC_Advanced_Organizer_OrganizerWidget_Frontend::organizer_featured_content( $atts, false );
	}

}