<?php

namespace MEC_Advanced_Organizer\Core\Elementor\Widgets;

use Elementor\Controls_Manager;
use MEC_Advanced_Organizer\Core\Lib\MEC_Advanced_Organizer_Lib_Factory;
use MEC_Advanced_Organizer\Core\OrganizerWidget\MEC_Advanced_Organizer_OrganizerWidget_Frontend;

class OrganizersList extends \Elementor\Widget_Base {

	public function get_name() {

		return 'mec_advanced_organizers_list';
	}

	public function get_title() {

		return __( 'Organizers List', 'mec-advanced-organizer' );
	}

	public function get_icon() {

		return 'eicon-person';
	}

	public function get_categories() {

		return [ 'mec_advanced_organizer' ];
	}

	public function get_style_depends() {

		return [ 'mec-advanced-organizer-style' ];
	}

	public function get_script_depends() {

		return [ 'mec-advanced-organizer-frontend-script' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'mec_advanced_organizers_list_settings',
            array(
                'label' 	=> __( 'Settings', 'mec-advanced-organizer' ),
                'tab'   	=> Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'limit',
			array(
				'label' 		=> __('Limit', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 3,
            )
		);

        $this->add_control(
			'cols',
			array(
				'label' 		=> __('Columns', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 1,
            )
		);

        $this->add_control(
			'load_more',
			array(
				'label' 		=> __('Load More', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'display_style',
			array(
				'label' 		=> __('Display Style', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'list' => __( 'List', 'mec-advanced-organizer' ),
                    'grid' => __( 'Grid', 'mec-advanced-organizer' ),
                ),
                'default' => 'list',
            )
		);

        $this->add_control(
			'filter',
			array(
				'label' 		=> __('Filter', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'search',
			array(
				'label' 		=> __('Search', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

		$args = array(
			'taxonomy' => 'mec_organizer',
			'hide_empty' => false,
			'count' => true,
			'fields' => 'id=>name',
		);

        $terms = get_terms( $args );
        $this->add_control(
			'exclude',
			array(
				'label' 		=> __('Exclude', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $terms,
            )
		);

		$meta_keys = MEC_Advanced_Organizer_Lib_Factory::get_meta_keys();
        $this->add_control(
			'exclude_details',
			array(
				'label' 		=> __('Exclude Details', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $meta_keys,
            )
		);

        $this->add_control(
			'random',
			array(
				'label' 		=> __('Random', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'order_by',
			array(
				'label' 		=> __('Order By', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'name' => __( 'Name', 'mec-advanced-organizer' ),
                    'added_date' => __( 'Added Date', 'mec-advanced-organizer' ),
                    'all_events' => __( 'All Events', 'mec-advanced-organizer' ),
					'featured' => __( 'Featured', 'mec-advanced-organizer' ),
                ),
            )
		);

        $this->add_control(
			'order',
			array(
				'label' 		=> __('Order', 'mec-advanced-organizer'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'desc' => __( 'DESC', 'mec-advanced-organizer' ),
                    'asc' => __( 'ASC', 'mec-advanced-organizer' ),
                ),
                'default' => 'desc',
            )
		);

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $atts = array(
            'limit' => $settings['limit'] ?? 0,
            'load_more' => 'yes' == $settings['load_more'] ? 'true' : 'false',
            'display_style' => $settings['display_style'] ?? 'list',
            'filter' => 'yes' == $settings['filter'] ? 'true' : 'false',
            'search' => 'yes' == $settings['search'] ? 'true' : 'false',
            'random' => 'yes' == $settings['random'] ? 'true' : 'false',
            'cols' => $settings['cols'] ?? 1,
            'exclude' => is_array( $settings['exclude'] ) ? implode( ',', $settings['exclude'] ) : '',
            'exclude_details' => is_array( $settings['exclude_details'] ) ? implode( ',', $settings['exclude_details'] ) : '',
            'order_by' => $settings['order_by'],
            'order' => $settings['order'] ?? 'desc',
        );

        echo MEC_Advanced_Organizer_OrganizerWidget_Frontend::organizer_list_content( $atts, '', false );
	}

}