<?php

namespace MEC_Advanced_Location\Core\Elementor;

final class Elementor {


	public static function init() {

		add_action( 'elementor/widgets/register', [ __CLASS__, 'register_widgets' ] );
		add_action( 'elementor/elements/categories_registered', [ __CLASS__, 'add_elementor_widget_categories' ] );
		add_action( 'elementor/preview/enqueue_styles', function() {
			$settings = get_option('mec_options');
            \MEC\Base::get_main()->load_map_assets();
            wp_enqueue_script('googlemap', '//maps.googleapis.com/maps/api/js?libraries=places'.((isset($settings['settings']['google_maps_api_key']) and trim($settings['settings']['google_maps_api_key']) != '') ? '&key='.$settings['settings']['google_maps_api_key'] : ''));
		} );
		add_action('elementor/editor/after_enqueue_styles', [__CLASS__, 'editor_styles']);
	}

	public static function editor_styles() {
	}

	/**
	 * Init Widgets
	 *
	 * Include widgets files and register them
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public static function register_widgets() {

		require_once __DIR__ . '/widgets/list.php';
		require_once __DIR__ . '/widgets/featured.php';

		// Register widget
		\Elementor\Plugin::instance()->widgets_manager->register( new Widgets\LocationsList() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Widgets\LocationsFeatured() );
	}

	public static function add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'mec_advanced_location',
			[
				'title' => __( 'MEC Advanced Location', 'mec-advanced-location' ),
				'icon' => 'fa fa-plug',
			]
		);
	}
}
