<?php

namespace MEC_Advanced_Location\Core\Elementor\Widgets;

use Elementor\Controls_Manager;
use MEC_Advanced_Location\Core\LocationWidget\MEC_Advanced_Location_LocationWidget_Frontend;

class LocationsFeatured extends \Elementor\Widget_Base {

	public function get_name() {

		return 'mec_advanced_locations_Featured';
	}

	public function get_title() {

		return __( 'Featured Locations', 'mec-advanced-location' );
	}

	public function get_icon() {

		return 'eicon-google-maps';
	}

	public function get_categories() {

		return [ 'mec_advanced_location' ];
	}

	public function get_style_depends() {

		return [ 'mec-advanced-location-style' ];
	}

	public function get_script_depends() {

		return [ 'mec-advanced-location-frontend-script' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'mec_advanced_locations_list_settings',
            array(
                'label' 	=> __( 'Settings', 'mec-advanced-locationnnnns' ),
                'tab'   	=> Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'limit',
			array(
				'label' 		=> __('Limit', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 3,
            )
		);

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $atts = array(
            'limit' => $settings['limit'] ?? 0,
        );

        echo MEC_Advanced_Location_LocationWidget_Frontend::location_featured_content( $atts, '', false );
	}

}