<?php

namespace MEC_Advanced_Location\Core\Elementor\Widgets;

use Elementor\Controls_Manager;
use MEC_Advanced_Location\Core\Lib\MEC_Advanced_Location_Lib_Factory;
use MEC_Advanced_Location\Core\LocationWidget\MEC_Advanced_Location_LocationWidget_Frontend;

class LocationsList extends \Elementor\Widget_Base {

	public function get_name() {

		return 'mec_advanced_locations_list';
	}

	public function get_title() {

		return __( 'Locations List', 'mec-advanced-location' );
	}

	public function get_icon() {

		return 'eicon-google-maps';
	}

	public function get_categories() {

		return [ 'mec_advanced_location' ];
	}

	public function get_style_depends() {

		return [ 'mec-advanced-location-style' ];
	}

	public function get_script_depends() {

		return [ 'mec-advanced-location-frontend-script' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'mec_advanced_locations_list_settings',
            array(
                'label' 	=> __( 'Settings', 'mec-advanced-locationnnnnnnnnnns' ),
                'tab'   	=> Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'limit',
			array(
				'label' 		=> __('Limit', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 3,
            )
		);

        $this->add_control(
			'cols',
			array(
				'label' 		=> __('Columns', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 1,
            )
		);

        $this->add_control(
			'load_more',
			array(
				'label' 		=> __('Load More', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'display_style',
			array(
				'label' 		=> __('Display Style', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'list' => __( 'List', 'mec-advanced-location' ),
                    'grid' => __( 'Grid', 'mec-advanced-location' ),
                ),
                'default' => 'list',
            )
		);

        $this->add_control(
			'filter',
			array(
				'label' 		=> __('Filter', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'search',
			array(
				'label' 		=> __('Search', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

		$this->add_control(
			'search_in',
			array(
				'label' 		=> __('Search in', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'name' => __( 'Name', 'mec-advanced-location' ),
                    'address' => __( 'Address', 'mec-advanced-location' ),
                ),
                'default' => 'name',
            )
		);

		$args = array(
			'taxonomy' => 'mec_location',
			'hide_empty' => false,
			'count' => true,
			'fields' => 'id=>name',
		);

        $terms = get_terms( $args );
        $this->add_control(
			'exclude',
			array(
				'label' 		=> __('Exclude', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $terms,
            )
		);

		$meta_keys = MEC_Advanced_Location_Lib_Factory::get_meta_keys();
        $this->add_control(
			'exclude_details',
			array(
				'label' 		=> __('Exclude Details', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $meta_keys,
            )
		);

        $this->add_control(
			'random',
			array(
				'label' 		=> __('Random', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
            )
		);

        $this->add_control(
			'order_by',
			array(
				'label' 		=> __('Order By', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'name' => __( 'Name', 'mec-advanced-location' ),
                    'added_date' => __( 'Added Date', 'mec-advanced-location' ),
                    'all_events' => __( 'All Events', 'mec-advanced-location' ),
					'featured' => __( 'Featured', 'mec-advanced-location' ),
                ),
            )
		);

        $this->add_control(
			'order',
			array(
				'label' 		=> __('Order', 'mec-advanced-location'),
				'type' 			=> Controls_Manager::SELECT,
                'options'       => array(
                    'desc' => __( 'DESC', 'mec-advanced-location' ),
                    'asc' => __( 'ASC', 'mec-advanced-location' ),
                ),
                'default' => 'desc',
            )
		);

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $atts = array(
            'limit' => $settings['limit'] ?? 0,
            'load_more' => 'yes' == $settings['load_more'] ? 'true' : 'false',
            'display_style' => $settings['display_style'] ?? 'list',
            'filter' => 'yes' == $settings['filter'] ? 'true' : 'false',
            'search' => 'yes' == $settings['search'] ? 'true' : 'false',
			'search_in' => $settings['search_in'] ?? 'name',
            'random' => 'yes' == $settings['random'] ? 'true' : 'false',
            'cols' => $settings['cols'] ?? 1,
            'exclude' => is_array( $settings['exclude'] ) ? implode( ',', $settings['exclude'] ) : '',
            'exclude_details' => is_array( $settings['exclude_details'] ) ? implode( ',', $settings['exclude_details'] ) : '',
            'order_by' => $settings['order_by'],
            'order' => $settings['order'] ?? 'desc',
        );

        echo MEC_Advanced_Location_LocationWidget_Frontend::location_list_content( $atts, '', false );
	}

}