jQuery(document).ready(function ($) {
    jQuery('.mec-ud-content-wrap .mec-ud-content:first-child').addClass('active');
    jQuery('.mec-ud-wrap .mec-ud-menu a:first-child').addClass('active');

    function mec_ud_form_init(content_wrap){

        // Input animation
        jQuery(content_wrap).find('.mec-ud-form').find('label').on('click', function () {
            jQuery(this).closest('.mec-ud-form').find('input , textarea , select').focus();
        });
        jQuery('.mec-ud-form',content_wrap).find('input , textarea , select').on('focusin', function () {
            var $this = jQuery(this),
                value = $this.val();
            $this.closest('.mec-ud-form').addClass('mec-ud-active');
        });
        jQuery('.mec-ud-form',content_wrap).find('input , textarea , select').on('focusout', function () {
            var $this = jQuery(this),
                value = $this.val();
            if (value == '' && $this[0]['localName'] != 'textarea') {
                jQuery(this).closest('.mec-ud-form').removeClass('mec-ud-active');
            }
            if ($this[0]['localName'] == 'textarea') jQuery(this).closest('.mec-ud-form').removeClass('mec-ud-active');
        });

        jQuery('.mec-ud-form',content_wrap).find('textarea').on('focusin', function () {
            var areaheight = jQuery(this)[0].scrollHeight;
            jQuery(this).css({
                'height': areaheight,
            })
        });
    }

    function mec_ud_paginate_init(content_wrap){

        $('a.page-numbers', content_wrap).on('click',function(e){

            e.preventDefault();

            var url = new URL($(this).attr('href'));
            var page_id = url.searchParams.get('paged');
            page_id = 'undefined' != page_id ? page_id : 1;
            var wrap = $(this).parents('.mec-ud-wrap');
            var menu_id = $(this).parents('.mec-ud-content').data('menu');

            mec_ud_get_menu_content_by_ajax(menu_id, wrap, page_id);

            return false;
        });
    }

    function mec_ud_get_menu_content_by_ajax( menu_id, wrap, page_id = 1 ){

        $('.mec-ud-content-wrap', wrap).css('opacity','0.4');
        $.post(
            mec_ud_config.ajax_url,
            {
                action: 'mec_ud_menu_content',
                menu: menu_id,
                p_url: window.location.href,
                paged: page_id,
            },
            function(r){

                if( true == r.success ){

                    if( r.data.content ){

                        if( 0 == $('.mec-ud-content-wrap', wrap).find('#mec-ud-'+menu_id).length ){

                            $('.mec-ud-content-wrap',wrap).append( r.data.content );

                            switch(menu_id){
                                case 'speaker':
                                    mec_ud_speaker_init();
                                    break;
                                case 'organizer':
                                    mec_ud_organizer_init();
                                    break;
                                case 'reports':
                                    mec_ud_reports_init();
                                    break;
                            }

                        }else{

                            $('.mec-ud-content-wrap',wrap).find('#mec-ud-'+menu_id).replaceWith( r.data.content );
                        }

                        var p_wrap = $('.mec-ud-content-wrap', wrap).find('#mec-ud-'+menu_id);
                        mec_ud_form_init(p_wrap);
                        mec_ud_paginate_init(p_wrap);
                        mec_ud_render_content(menu_id, wrap);
                    }
                }

                $('.mec-ud-content-wrap', wrap).css('opacity','1');
            }
        );
    }

    function mec_ud_render_content(menu_id, wrap){

        jQuery('.mec-ud-content-wrap .mec-ud-content', wrap).removeClass('active');
        jQuery('.mec-ud-content-wrap', wrap).find('#mec-ud-'+menu_id).addClass('active');

        jQuery('.mec-ud-wrap .mec-ud-menu a', wrap).removeClass('active');
        jQuery(this).addClass('active', wrap);
    }

    jQuery('.mec-ud-menu a').on('click', function (e) {

        var wrap = $(this).parents('.mec-ud-wrap');
        var menu_id = $(this).data('menu');
        var menu_content = $('.mec-ud-content-wrap', wrap).find('#mec-ud-'+menu_id);

        if( 'logout' === menu_id ){

            return true;
        }else{

            e.preventDefault();
        }

        wrap.find('a.active').removeClass('active');

        $(e.currentTarget).addClass('active');

        if( 'undefined' != typeof menu_id && 0 == menu_content.length ){

            mec_ud_get_menu_content_by_ajax( menu_id, wrap );
        }else{

            mec_ud_render_content( menu_id, wrap );
        }
    });

    // Content
    var $content = jQuery('.mec-ud-wrap .col-md-9');

    var $formNotice;
    var $imgForm;
    var $imgNotice;
    var $imgPreview;
    var $imgFile;
    var $imgId;
    var $userId;
    var $img_bg;

    // Organizer form
    var $orgForm;
    var $orgID;
    var $orgFile;
    var $orgImgId;
    var $orgNotice;
    var $orgPreview;
    var $org_bg;

    // Speaker form
    var $speakerForm;
    var $speakerID;
    var $speakerFile;
    var $speakerImgId;
    var $speakerNotice;
    var $speakerPreview;
    var $speaker_bg;

    // Load chart Filters by default
    var $chartForm;
    var $chartDate;
    var $chartData;
    var $chartSign;

    // Pie form
    var $PieForm;
    var $PieLabels;
    var $PieData;
    var $PieColors;

    // Submit Chart Filter
    var $chartStart;
    var $chartEnd;
    var $chartType;
    var $chartChart;

    function mec_ud_profile_init(){
        // Profile form
        $formNotice = jQuery('.form-notice');
        $imgForm = jQuery('.mec-profile-form');
        $imgNotice = $imgForm.find('.image-notice');
        $imgPreview = $imgForm.find('.mec-ud-attachment-image');
        $imgFile = $imgForm.find('.image-file');
        $imgId = $imgForm.find('[name="image_id"]');
        $userId = $imgForm.find('[name="mec_ud_userID"]');
        $img_bg = jQuery(".mec-ud-submit-profile").find('img').clone();

        // Save profile avatar
        $imgFile.on('change', function (e) {
            e.preventDefault();
            var formData = new FormData();

            formData.append('action', 'upload-attachment');
            formData.append('async-upload', $imgFile[0].files[0]);
            formData.append('name', $imgFile[0].files[0].name);
            formData.append('_wpnonce', mec_ud_config.nonce);

            jQuery.ajax({
                url: mec_ud_config.upload_url,
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                type: 'POST',
                beforeSend: function () {
                    $imgNotice.html('Uploading&hellip;').show();
                },
                success: function (resp) {
                    if (resp.success) {
                        $imgNotice.html('Successfully uploaded.');
                        var img = jQuery('<img>', {
                            src: resp.data.url
                        });

                        $imgId.val(resp.data.id);
                        //$imgPreview.html(img).show();

                        jQuery.ajax({
                            url: mec_ud_config.ajax_url,
                            data: {
                                action: 'mec_ud_update_custom_user_profile_frontend',
                                mec_ud_userID: $userId.val(),
                                mec_ud_imgID: $imgId.val(),
                            },
                            type: 'POST',
                            success: function (data) {
                                $imgPreview.html(data).show();
                            }
                        });

                    } else {
                        $imgNotice.html('Fail to upload image. Please try again.');
                        $imgFile.show();
                        $imgId.val('');
                    }
                }
            });
        });

        // Save profile data
        jQuery('.mec-ud-submit-profile').on('click', function (e) {
            e.preventDefault();

            var $mec_user_fname = ($imgForm.find('[name="mec_user_fname"]').val() == '') ? $imgForm.find('[name="mec_user_fname_hidden"]') : $imgForm.find('[name="mec_user_fname"]');
            var $mec_user_lname = ($imgForm.find('[name="mec_user_lname"]').val() == '') ? $imgForm.find('[name="mec_user_lname_hidden"]') : $imgForm.find('[name="mec_user_lname"]');
            var $mec_user_email = ($imgForm.find('[name="mec_user_email"]').val() == '') ? $imgForm.find('[name="mec_user_email_hidden"]') : $imgForm.find('[name="mec_user_email"]');
            var $mec_user_url = ($imgForm.find('[name="mec_user_url"]').val() == '') ? $imgForm.find('[name="mec_user_url_hidden"]') : $imgForm.find('[name="mec_user_url"]');
            var $mec_user_dash_color = ($imgForm.find('[name="mec_user_dash_color"]').val() == '') ? $imgForm.find('[name="mec_user_dash_color_hidden"]') : $imgForm.find('[name="mec_user_dash_color"]');
            jQuery.ajax({
                url: mec_ud_config.ajax_url,
                data: {
                    action: 'mec_ud_update_custom_user_profile_details_frontend',
                    mec_ud_userID: $userId.val(),
                    mec_ud_imgID: $imgId.val(),
                    mec_user_fname: $mec_user_fname.val(),
                    mec_user_lname: $mec_user_lname.val(),
                    mec_user_email: $mec_user_email.val(),
                    mec_user_url: $mec_user_url.val(),
                    mec_user_dash_color: $mec_user_dash_color.val(),
                },
                type: 'POST',
                beforeSend: function () {
                    jQuery(".mec-ud-submit-profile").find('img').remove();
                    jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo($content);
                    jQuery("<div class=\"mec-ud-saveLoader\"><div class=\"mec-loader\"></div></div>").insertBefore(".mec-ud-submit-profile span");
                },
                success: function (resp) {
                    $content.find('.mec-ud-saveLoader').remove();
                    $content.find('.mec-ud-saveLoader-hover').remove();
                    $img_bg.insertBefore(".mec-ud-submit-profile span");
                }
            });
        });

        mec_ud_form_init($('#mec-ud-profile'));
    }

    function mec_ud_organizer_init(){

        // Organizer form
        $orgForm = jQuery('.mec-organizer-form');
        $orgID = $orgForm.find('[name="mec_ud_orgID"]');
        $orgFile = $orgForm.find('.image-file');
        $orgImgId = $orgForm.find('[name="image_id"]');
        $orgNotice = $orgForm.find('.image-notice');
        $orgPreview = $orgForm.find('.mec-ud-attachment-image');
        $org_bg = jQuery(".mec-ud-submit-organizer").find('img').clone();

        // Save organizer image
        $orgFile.on('change', function (e) {
            e.preventDefault();

            var orgFormData = new FormData();
            orgFormData.append('action', 'upload-attachment');
            orgFormData.append('async-upload', $orgFile[0].files[0]);
            orgFormData.append('name', $orgFile[0].files[0].name);
            orgFormData.append('_wpnonce', mec_ud_config.nonce);

            jQuery.ajax({
                url: mec_ud_config.upload_url,
                data: orgFormData,
                processData: false,
                contentType: false,
                dataType: 'json',
                type: 'POST',
                beforeSend: function () {
                    $orgNotice.html('Uploading&hellip;').show();
                },
                success: function (resp) {
                    if (resp.success) {
                        $orgNotice.html('Successfully uploaded.');
                        var img = jQuery('<img>', {
                            src: resp.data.url
                        });
                        $orgImgId.val(resp.data.id);
                        //$orgPreview.html(img).show();

                        jQuery.ajax({
                            url: mec_ud_config.ajax_url,
                            data: {
                                action: 'mec_ud_update_organizer_thumbnail',
                                mec_ud_orgID: $orgID.val(),
                                mec_ud_orgImgID: $orgImgId.val(),
                            },
                            type: 'POST',
                            success: function (data) {
                                $orgPreview.html(img).show();
                            }
                        });

                    } else {
                        $orgNotice.html('Fail to upload image. Please try again.');
                        $orgFile.show();
                        $orgImgId.val('');
                    }
                }
            });
        });

        // Save orgaznizer data
        jQuery('.mec-ud-submit-organizer').on('click', function (e) {
            e.preventDefault();

            var $mec_organizer_name = ($orgForm.find('[name="mec_organizer_name"]').val() == '') ? $orgForm.find('[name="mec_organizer_name_hidden"]') : $orgForm.find('[name="mec_organizer_name"]');
            var $mec_organizer_description = ($orgForm.find('[name="mec_organizer_desc"]').val() == '') ? $orgForm.find('[name="mec_organizer_desc_hidden"]') : $orgForm.find('[name="mec_organizer_desc"]');
            var $mec_organizer_tel = ($orgForm.find('[name="mec_organizer_tel"]').val() == '') ? $orgForm.find('[name="mec_organizer_tel_hidden"]') : $orgForm.find('[name="mec_organizer_tel"]');
            var $mec_organizer_email = ($orgForm.find('[name="mec_organizer_email"]').val() == '') ? $orgForm.find('[name="mec_organizer_email_hidden"]') : $orgForm.find('[name="mec_organizer_email"]');
            var $mec_organizer_facebook = ($orgForm.find('[name="mec_organizer_facebook"]').val() == '') ? $orgForm.find('[name="mec_organizer_facebook_hidden"]') : $orgForm.find('[name="mec_organizer_facebook"]');
            var $mec_organizer_instagram = ($orgForm.find('[name="mec_organizer_instagram"]').val() == '') ? $orgForm.find('[name="mec_organizer_instagram_hidden"]') : $orgForm.find('[name="mec_organizer_instagram"]');
            var $mec_organizer_linkedin = ($orgForm.find('[name="mec_organizer_linkedin"]').val() == '') ? $orgForm.find('[name="mec_organizer_linked_hidden"]') : $orgForm.find('[name="mec_organizer_linkedin"]');
            var $mec_organizer_twitter = ($orgForm.find('[name="mec_organizer_twitter"]').val() == '') ? $orgForm.find('[name="mec_organizer_twitter_hidden"]') : $orgForm.find('[name="mec_organizer_twitter"]');
            var $mec_organizer_url = ($orgForm.find('[name="mec_organizer_url"]').val() == '') ? $orgForm.find('[name="mec_organizer_url_hidden"]') : $orgForm.find('[name="mec_organizer_url"]');

            jQuery.ajax({
                url: mec_ud_config.ajax_url,
                data: {
                    action: 'mec_ud_update_organizer_data',
                    mec_ud_orgID: $orgID.val(),
                    mec_ud_org_name: $mec_organizer_name.val(),
                    mec_ud_org_desc: $mec_organizer_description.val(),
                    mec_ud_org_tel: $mec_organizer_tel.val(),
                    mec_ud_org_email: $mec_organizer_email.val(),
                    mec_ud_org_facebook: $mec_organizer_facebook.val(),
                    mec_ud_org_instagram: $mec_organizer_instagram.val(),
                    mec_ud_org_linkedin: $mec_organizer_linkedin.val(),
                    mec_ud_org_twitter: $mec_organizer_twitter.val(),
                    mec_ud_org_url: $mec_organizer_url.val(),
                    mec_ud_orgImgID: $orgImgId.val(),
                },
                type: 'POST',
                beforeSend: function () {
                    jQuery(".mec-ud-submit-organizer").find('img').remove();
                    jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo($orgForm);
                    jQuery("<div class=\"mec-ud-saveLoader\"><div class=\"mec-loader\"></div></div>").insertBefore(".mec-ud-submit-organizer span");
                },
                success: function (resp) {
                    $orgForm.find('.mec-ud-saveLoader').remove();
                    $orgForm.find('.mec-ud-saveLoader-hover').remove();
                    $img_bg.insertBefore(".mec-ud-submit-organizer span");
                }
            });

        });
    }

    function mec_ud_speaker_init(){

        // Speaker form
        $speakerForm = jQuery('.mec-speaker-form');
        $speakerID = $speakerForm.find('[name="mec_ud_speakerID"]');
        $speakerFile = $speakerForm.find('.image-file');
        $speakerImgId = $speakerForm.find('[name="image_id"]');
        $speakerNotice = $speakerForm.find('.image-notice');
        $speakerPreview = $speakerForm.find('.mec-ud-attachment-image');
        $speaker_bg = jQuery(".mec-ud-submit-speaker").find('img').clone();

        // Save speaker image
        $speakerFile.on('change', function (e) {
            e.preventDefault();

            var speakerFormData = new FormData();
            speakerFormData.append('action', 'upload-attachment');
            speakerFormData.append('async-upload', $speakerFile[0].files[0]);
            speakerFormData.append('name', $speakerFile[0].files[0].name);
            speakerFormData.append('_wpnonce', mec_ud_config.nonce);

            jQuery.ajax({
                url: mec_ud_config.upload_url,
                data: speakerFormData,
                processData: false,
                contentType: false,
                dataType: 'json',
                type: 'POST',
                beforeSend: function () {
                    $speakerNotice.html('Uploading&hellip;').show();
                },
                success: function (resp) {
                    if (resp.success) {
                        $speakerNotice.html('Successfully uploaded.');
                        var img = jQuery('<img>', {
                            src: resp.data.url
                        });
                        $speakerImgId.val(resp.data.id);
                        //$speakerPreview.html(img).show();

                        jQuery.ajax({
                            url: mec_ud_config.ajax_url,
                            data: {
                                action: 'mec_ud_update_speaker_thumbnail',
                                mec_ud_speakerID: $speakerID.val(),
                                mec_ud_speakerImgID: $speakerImgId.val(),
                            },
                            type: 'POST',
                            success: function (data) {
                                $speakerPreview.html(img).show();
                            }
                        });

                    } else {
                        $speakerNotice.html('Fail to upload image. Please try again.');
                        $speakerFile.show();
                        $speakerImgId.val('');
                    }
                }
            });
        });

        // Save speaker data
        jQuery('.mec-ud-submit-speaker').on('click', function (e) {
            e.preventDefault();

            var $mec_speaker_name = ($speakerForm.find('[name="mec_speaker_name"]').val() == '') ? $speakerForm.find('[name="mec_speaker_name_hidden"]') : $speakerForm.find('[name="mec_speaker_name"]');
            var $mec_speaker_description = ($speakerForm.find('[name="mec_speaker_desc"]').val() == '') ? $speakerForm.find('[name="mec_speaker_desc_hidden"]') : $speakerForm.find('[name="mec_speaker_desc"]');
            var $mec_speaker_job_title = ($speakerForm.find('[name="mec_speaker_job_title"]').val() == '') ? $speakerForm.find('[name="mec_speaker_job_title_hidden"]') : $speakerForm.find('[name="mec_speaker_job_title"]');
            var $mec_speaker_tel = ($speakerForm.find('[name="mec_speaker_tel"]').val() == '') ? $speakerForm.find('[name="mec_speaker_tel_hidden"]') : $speakerForm.find('[name="mec_speaker_tel"]');
            var $mec_speaker_email = ($speakerForm.find('[name="mec_speaker_email"]').val() == '') ? $speakerForm.find('[name="mec_speaker_email_hidden"]') : $speakerForm.find('[name="mec_speaker_email"]');
            var $mec_speaker_facebook = ($speakerForm.find('[name="mec_speaker_facebook"]').val() == '') ? $speakerForm.find('[name="mec_speaker_facebook_hidden"]') : $speakerForm.find('[name="mec_speaker_facebook"]');
            var $mec_speaker_instagram = ($speakerForm.find('[name="mec_speaker_instagram"]').val() == '') ? $speakerForm.find('[name="mec_speaker_instagram_hidden"]') : $speakerForm.find('[name="mec_speaker_instagram"]');
            var $mec_speaker_linkedin = ($speakerForm.find('[name="mec_speaker_linkedin"]').val() == '') ? $speakerForm.find('[name="mec_speaker_linked_hidden"]') : $speakerForm.find('[name="mec_speaker_linkedin"]');
            var $mec_speaker_twitter = ($speakerForm.find('[name="mec_speaker_twitter"]').val() == '') ? $speakerForm.find('[name="mec_speaker_twitter_hidden"]') : $speakerForm.find('[name="mec_speaker_twitter"]');

            jQuery.ajax({
                url: mec_ud_config.ajax_url,
                data: {
                    action: 'mec_ud_update_speaker_data',
                    mec_ud_speakerID: $speakerID.val(),
                    mec_ud_speaker_name: $mec_speaker_name.val(),
                    mec_ud_speaker_desc: $mec_speaker_description.val(),
                    mec_ud_speaker_job_title: $mec_speaker_job_title.val(),
                    mec_ud_speaker_tel: $mec_speaker_tel.val(),
                    mec_ud_speaker_email: $mec_speaker_email.val(),
                    mec_ud_speaker_facebook: $mec_speaker_facebook.val(),
                    mec_ud_speaker_instagram: $mec_speaker_instagram.val(),
                    mec_ud_speaker_linkedin: $mec_speaker_linkedin.val(),
                    mec_ud_speaker_twitter: $mec_speaker_twitter.val(),
                    mec_ud_speakerImgID: $speakerImgId.val(),
                },
                type: 'POST',
                beforeSend: function () {
                    jQuery(".mec-ud-submit-speaker").find('img').remove();
                    jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo($speakerForm);
                    jQuery("<div class=\"mec-ud-saveLoader\"><div class=\"mec-loader\"></div></div>").insertBefore(".mec-ud-submit-speaker span");
                },
                success: function (resp) {
                    $speakerForm.find('.mec-ud-saveLoader').remove();
                    $speakerForm.find('.mec-ud-saveLoader-hover').remove();
                    $img_bg.insertBefore(".mec-ud-submit-speaker span");
                }
            });

        });
    }


    // me-ud-spec-ticket clicked
    jQuery('.me-ud-spec-ticket').on('click', function () {
        jQuery('.mec-ud-menu a[data-onclick="mec-ud-tickets"]').trigger('click');
    });

    // me-ud-spec-event clicked
    jQuery('.me-ud-spec-event').on('click', function () {
        jQuery('.mec-ud-menu a[data-onclick="mec-ud-events"]').trigger('click');
    })

    function mec_ud_reports_init(){

        // Load chart Filters by default
        $chartForm = jQuery('.mec-ud-reports-filters.mec-ud-sales-report');
        $chartDate = $chartForm.find('input[name="mec-ud-date"]');
        $chartData = $chartForm.find('input[name="mec-ud-data"]');
        $chartSign = $chartForm.find('input[name="mec-ud-sign"]');

        // Pie form
        $PieForm = jQuery('.mec-ud-reports-filters.mec-ud-gateway-report');
        $PieLabels = $PieForm.find('input[name="mec-ud-pie-lables"]');
        $PieData = $PieForm.find('input[name="mec-ud-pie-data"]');
        $PieColors = $PieForm.find('input[name="mec-ud-pie-colors"]');

        // Submit Chart Filter
        $chartStart = $chartForm.find('.mec-ud-filter-start');
        $chartEnd = $chartForm.find('.mec-ud-filter-end');
        $chartType = $chartForm.find('select[name="type"]');
        $chartChart = $chartForm.find('select[name="chart"]');

        // Load Report chart by default
        if (jQuery(".mec-ud-reports-filters").length > 0) {
            var udChart = document.getElementById("mec_ud_reports_chatrs");
            var mecReportChart = new Chart(udChart, {
                type: "line",
                data: {
                    labels: $chartDate.val().split(','),
                    datasets: [{
                        label: "Total " + $chartSign.val(),
                        data: $chartData.val().split(','),
                        backgroundColor: "rgba(159, 216, 255, 0.3)",
                        borderColor: "#36A2EB",
                        borderWidth: 1
                    }]
                }
            });

            var udPie = document.getElementById("mec_ud_gateways_chart");
            var mecReportPie = new Chart(udPie, {
                type: "pie",
                data: {
                    labels: $PieLabels.val().split(','),
                    datasets: [{
                        data: $PieData.val().split(','),
                        backgroundColor: $PieColors.val().split(',')
                    }]
                }
            });

        }

        // Load Pie report by default


        // Select Event in Reports
        jQuery('.mec-ud-reports-selectbox-event').select2();
        jQuery('.mec-ud-reports-selectbox-event').on('change', function () {
            // Change Tickets and Total
            var $tickets_and_total = jQuery('.mec-ud-reports-number');
            var $event_id = jQuery('.mec-ud-reports-selectbox-event').val();
            jQuery.ajax({
                url: mec_ud_config.ajax_url,
                data: {
                    action: 'get_tickets_and_total',
                    event_id: $event_id,
                    start: $chartStart.val(),
                    end: $chartEnd.val(),
                    type: $chartType.val(),
                },
                type: 'POST',
                beforeSend: function () {
                    jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo($content);
                },
                success: function (resp) {
                    id_numbers = JSON.parse(resp);
                    $tickets_and_total.find('.mec-ud-reports-number-spec-ticket').find('div:first-of-type').text(id_numbers[0]);
                    $tickets_and_total.find('.mec-ud-reports-number-spec-total').find('div:first-of-type span:last-of-type').text(id_numbers[1]);
                    $chartDate.val(id_numbers[2]);
                    $chartData.val(id_numbers[3]);
                    $PieLabels.val(id_numbers[4])
                    $PieData.val(id_numbers[5])
                    $PieColors.val(id_numbers[6])

                    // Refresh chart
                    mecReportChart.destroy();
                    mecReportChart = new Chart(udChart, {
                        type: "line",
                        data: {
                            labels: $chartDate.val().split(','),
                            datasets: [{
                                label: "Total " + $chartSign.val(),
                                data: $chartData.val().split(','),
                                backgroundColor: "rgba(159, 216, 255, 0.3)",
                                borderColor: "#36A2EB",
                                borderWidth: 1
                            }]
                        }
                    });

                    // Refresh Pie
                    mecReportPie.destroy();
                    mecReportPie = new Chart(udPie, {
                        type: "pie",
                        data: {
                            labels: $PieLabels.val().split(','),
                            datasets: [{
                                data: $PieData.val().split(','),
                                backgroundColor: $PieColors.val().split(',')
                            }]
                        }
                    });

                    if (jQuery('.mec-ud-reports-sales-wrap').hasClass('active')) {
                        jQuery('#mec_ud_gateways_chart').hide();
                    } else if (jQuery('.mec-ud-reports-gateway-wrap').hasClass('active')) {
                        jQuery('#mec_ud_reports_chatrs').hide();
                    }

                    $content.find('.mec-ud-saveLoader-hover').remove();
                }
            });
        });

        // Filter Button
        jQuery('.mec-ud-reports-filters button').on('click', function (event) {
            event.preventDefault()
            var $event_id = jQuery('.mec-ud-reports-selectbox-event').val();
            jQuery.ajax({
                url: mec_ud_config.ajax_url,
                data: {
                    action: 'chart_data_filter_button',
                    event_id: $event_id,
                    start: $chartStart.val(),
                    end: $chartEnd.val(),
                    type: $chartType.val(),
                },
                type: 'POST',
                beforeSend: function () {
                    jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo($content);
                },
                success: function (resp) {
                    info = JSON.parse(resp);

                    // Refresh chart
                    mecReportChart.destroy();
                    mecReportChart = new Chart(udChart, {
                        type: $chartChart.val(),
                        data: {
                            labels: info[0].split(','),
                            datasets: [{
                                label: "Total " + $chartSign.val(),
                                data: info[1].split(','),
                                backgroundColor: "rgba(159, 216, 255, 0.3)",
                                borderColor: "#36A2EB",
                                borderWidth: 1
                            }]
                        }
                    });

                    // Refresh Pie
                    mecReportPie.destroy();
                    mecReportPie = new Chart(udPie, {
                        type: "pie",
                        data: {
                            labels: info[2].split(','),
                            datasets: [{
                                data: info[3].split(','),
                                backgroundColor: info[4].split(',')
                            }]
                        }
                    });

                    if (jQuery('.mec-ud-reports-sales-wrap').hasClass('active')) {
                        jQuery('#mec_ud_gateways_chart').hide();
                    } else if (jQuery('.mec-ud-reports-gateway-wrap').hasClass('active')) {
                        jQuery('#mec_ud_reports_chatrs').hide();
                    }

                    $content.find('.mec-ud-saveLoader-hover').remove();
                }
            });
        })

        // Pie chart
        jQuery('#mec_ud_gateways_chart').hide();
        jQuery('.mec-ud-btn-gateways').on('click', function (event) {
            event.preventDefault();
            jQuery(this).addClass('mec-selected');
            jQuery('.mec-ud-btn-sales').removeClass('mec-selected');
            jQuery('#mec_ud_gateways_chart').show();
            jQuery('#mec_ud_reports_chatrs').hide();
            jQuery('form.mec-ud-reports-filters select').hide();
            jQuery('.mec-ud-reports-sales-wrap').removeClass('active');
            jQuery('.mec-ud-reports-gateway-wrap').addClass('active').show();
        })
        jQuery('.mec-ud-btn-sales').on('click', function (event) {
            event.preventDefault();
            jQuery(this).addClass('mec-selected');
            jQuery('.mec-ud-btn-gateways').removeClass('mec-selected');
            jQuery('#mec_ud_gateways_chart').hide();
            jQuery('#mec_ud_reports_chatrs').show();
            jQuery('form.mec-ud-reports-filters select').show();
            jQuery('.mec-ud-reports-gateway-wrap').removeClass('active');
            jQuery('.mec-ud-reports-sales-wrap').addClass('active').show();
        });
    }

    jQuery('.mec-ud-woocommerce form').on('submit', function (e) {
        e.preventDefault(); // avoid to execute the actual submit of the form.

        var form = jQuery(this);
        var url = form.attr('action');
        var button = form.find('[type="submit"]');
        jQuery.ajax({
            type: "POST",
            url: url,
            data: form.serialize(), // serializes the form's elements.
            beforeSend: function () {
                button.addClass('disabled');
                jQuery("<div class=\"mec-ud-saveLoader\"><div class=\"mec-loader\"></div></div>").appendTo(button);
                jQuery("<div class=\"mec-ud-saveLoader-hover\"></div>").appendTo(button);
            },
            success: function (resp) {
                button.removeClass('disabled');
                button.find('.mec-ud-saveLoader').remove();
                button.find('.mec-ud-saveLoader-hover').remove();
            }
        });
        return false;
    })

    jQuery('.dashbord-custom-color span').on('click', function () {
        var color = jQuery(this).data('color');
        var css = '.mec-ud-main-content .mec-ud-wrap-header {background: ' + color + ';}';
        css += '.mec-ud-main-content .mec-profile .mec-booking-number-of-attendees i, .mec-ud-main-content .mec-profile .mec-profile-bookings-view-invoice i, .mec-ud-main-content .mec-ud-image-url .image-file+label, .mec-ud-org-image-url .image-file+label, .mec-ud-speaker-image-url .image-file+label, .mec-ud-main-content .mec-profile i, .mec-ud-main-content .mec-ud-menu a.active,.mec-ud-main-content .mec-ud-menu a:focus,.mec-ud-main-content .mec-ud-menu a:hover {color:' + color + ';}';
        css += '.mec-ud-main-content .mec-ud-form.mec-ud-active svg path, .mec-ud-main-content .mec-ud-menu a:hover svg path, .mec-ud-main-content .mec-ud-menu a.active svg path {fill:' + color + ';}';
        css += '.mec-ud-main-content .mec-ud-woocommerce table.woocommerce-orders-table td a.woocommerce-button, .mec-ud-main-content .event-pagination span, .mec-ud-main-content .event-pagination a,.mec-ud-main-content .mec-ud-woocommerce-menu-item:before {background-color: ' + color + ';}';
        css += '.mec-ud-main-content .mec-ud-events-add-new a {background-color: ' + color + ';}';
        css += '.mec-ud-main-content .mec-ud-woocommerce .woocommerce-Button, .mec-ud-main-content .mec-ud-woocommerce [type="submit"], .mec-ud-main-content button.mec-ud-submit-form {background-color: ' + color + ' !important;}';
        css += '.mec-ud-wrap .mec-ud-form.mec-ud-active input, .mec-ud-wrap .mec-ud-form.mec-ud-active textarea {border-color:' + color + ' !important;}';
        jQuery('#mec_user_das_color_hidden').val(color);
        jQuery('#mec-udc-css').remove();
        jQuery('head').append('<style id="mec-udc-css"> ' + css + ' </style>');
    });


    $('.mec-ud-main-content.mec-user-not-login .mec-login-form .mec-sl-display-controller-password').on('click',function(e){

        $(this).toggleClass('show');
        if( $(this).hasClass('show') ){
            $(this).parents('.mec-login-input').find('[name=password]').attr('type','text');
        }else{
            $(this).parents('.mec-login-input').find('[name=password]').attr('type','password');
        }
    });

    mec_ud_profile_init();
    $('.mec-ud-wrap .mec-ud-menu > a:first-child').trigger('click');
});