<?php

namespace MEC_User_Dashboard;

/**
 * Core Version: 1.0.0
 */
class CoreChecker{

    public static $plugin_title;
    public static $text_domain;
    public static $required_min_version;
    public static $required_min_pro_version;
    public static $required_min_version_text;
    public static $required_min_pro_version_text;

    /**
	 * Check Plugins
	 *
	 * @since     1.0.0
	 */
    public static function checkPlugins(){

        self::$text_domain = 'mec-ud';
        self::$plugin_title = __('MEC User Dashboard', self::$text_domain );
        self::$required_min_version = 540;
        self::$required_min_version_text = '5.4.0';
        self::$required_min_pro_version = 540;
        self::$required_min_pro_version_text = '5.4.0';


        if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		if ( !( is_plugin_active( 'modern-events-calendar/mec.php' ) || is_plugin_active( 'modern-events-calendar-lite/modern-events-calendar-lite.php' ) ) ) {

            add_action('admin_notices', [__CLASS__, 'MECNotice']);

            return false;
		}elseif ( is_plugin_active('modern-events-calendar/mec.php') ) {

            $plugin_data = get_plugin_data(realpath(WP_PLUGIN_DIR . '/modern-events-calendar/mec.php'));
            $version     = str_replace('.', '', $plugin_data['Version']);
            if ($version < self::$required_min_version) {

                add_action('admin_notices', [__CLASS__, 'MECVersionAdminNotice'], 'version');

                return false;
            }
        } elseif ( is_plugin_active('modern-events-calendar-lite/modern-events-calendar-lite.php') ) {

            $plugin_data = get_plugin_data(realpath(WP_PLUGIN_DIR . '/modern-events-calendar-lite/modern-events-calendar-lite.php'));
            $version     = str_replace('.', '', $plugin_data['Version']);
            if ($version < self::$required_min_version) {

                add_action('admin_notices', [__CLASS__, 'MECLiteVersionAdminNotice'], 'version');

                return false;
            }
        }

        return true;
    }

    /**
     ** Send Admin Notice (MEC)
     **
     ** @since 1.0.0
     **/
    public static function MECNotice($type = false){

        $screen = get_current_screen();
        if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
            return;
        }

        $installed_version = self::is_mec_installed();
        switch( $installed_version ){
            case 'pro':

                $plugin = 'modern-events-calendar/mec.php';

                break;
            case 'lite':

                $plugin = 'modern-events-calendar-lite/modern-events-calendar-lite.php';

                break;
        }

        $user_can_active_plugins = current_user_can('activate_plugins');
        if ( ( 'pro' === $installed_version || 'lite' === $installed_version ) && $user_can_active_plugins ) {

            if (!current_user_can('activate_plugins')) {

                return;
            }
            $activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin);
            $message        = '<h3>' . __( 'Thanks for installing the User Dashboard!', self::$text_domain ) . '</h3><p>' . __('User Dashboard requires the Modern Events Calendar plugin to work. Please activate it to continue.', self::$text_domain) . '</p>';
            $message       .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $activation_url, __('Activate Modern Events Calendar', self::$text_domain)) . '</p>';
        } elseif ( 'not-installed' === $installed_version ) {

            if (!current_user_can('install_plugins')) {

                return;
            }

            $install_url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=modern-events-calendar-lite'), 'install-plugin_modern-events-calendar-lite');
            $message        = '<h3>' . __( 'Thanks for installing the User Dashboard!', self::$text_domain ) . '</h3><p>' . __('User Dashboard requires the Modern Events Calendar plugin to work. Please install it to continue.', self::$text_domain) . '</p>';
            $message       .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $install_url, __('Install Modern Events Calendar Now', self::$text_domain)) . '</p>';
        }

        if(!empty($message)):
            ?>
            <div class="notice notice-error is-dismissible mec-notice-content">
                <p><?php echo $message; ?></p>
            </div>
            <?php
        endif;
    }

	/**
     **  MEC Version Admin Notice
     **
     **  @since     1.0.0
     */
    public static function MECVersionAdminNotice($type = false){

        $screen = get_current_screen();
        if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
            return;
        }

        $mec_pro			= 'modern-events-calendar/mec.php';
		$mec_lite			= 'modern-events-calendar-lite/modern-events-calendar-lite.php';
		$installed_plugins 	= get_plugins();
		if ( isset( $installed_plugins[ $mec_pro ] ) ) {

			$pro_data = get_plugin_data( realpath( WP_PLUGIN_DIR . '/modern-events-calendar/mec.php' ) );
		} elseif ( isset( $installed_plugins[ $mec_lite ] ) )  {

			$lite_data = get_plugin_data( realpath( WP_PLUGIN_DIR . '/modern-events-calendar-lite/modern-events-calendar-lite.php' ) );
		}

        $installed_version = self::is_mec_installed();
        if ( 'pro' === $installed_version && $user_can_active_plugins ) {

            $pro_version     = str_replace( '.', '', $pro_data['Version'] );
            if ( $pro_version < self::$required_min_pro_version ) {
                $install_url = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=modern-events-calendar' ), 'install-plugin_' . $mec_pro );
                $message  = '<div><p>' . self::$plugin_title .' '. __( 'is not working because you need to install latest version of Modern Events Calendar Pro plugin - Minimum version required', self::$text_domain ) . ': <b> ' . self::$required_min_pro_version . ' </b> </p>';
                $message  .= '<p class="mec-shortcode-designer-notice is-dismissible">' . sprintf( '<a href="%s">%s</a>', $install_url, __( 'Update Modern Events Calendar Pro Now', self::$text_domain ) ) . '</p></div>';
            }
        } elseif ( 'lite' === $installed_version  ) {

            $lite_version     = str_replace( '.', '', $lite_data['Version'] );
            if ( $lite_version < self::$required_min_version ) {
                $install_url = wp_nonce_url( self_admin_url( 'update.php?action=upgrade-plugin&plugin=modern-events-calendar-lite%2Fmodern-events-calendar-lite.php' ), 'install-plugin_' . $mec_lite );
                $message  = '<div><p>' . self::$plugin_title .' '. __( 'is not working because you need to install latest version of Modern Events Calendar Lite plugin - Minimum version required', self::$text_domain ) . ': <b> ' . self::$required_min_version . ' </b> </p>';
                $message  .= '<p class="mec-shortcode-designer-notice is-dismissible">' . sprintf( '<a href="%s">%s</a>', $install_url, __( 'Update Modern Events Calendar Lite Now', self::$text_domain ) ) . '</p></div>';
            }
        }

        if (
            ( 'pro' === $installed_version  && $pro_version < self::$required_min_pro_version )
            ||
            ( 'lite' === $installed_version && $lite_version < self::$required_min_version )
        ){
            if (!current_user_can('install_plugins')) {

                return;
            }

            $pro_version     = str_replace( '.', '', $pro_data['Version'] );
            $lite_version     = str_replace( '.', '', $lite_data['Version'] );
            ?>
                <div class="notice notice-error is-dismissible">
                <p><?php echo $message; ?></p>
                </div>
            <?php
        }
    }

        /**
     **  MEC Version Admin Notice
     **
     **  @since     1.0.0
     */
    public static function MECLiteVersionAdminNotice($type = false){

        $screen = get_current_screen();
        if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
            return;
        }

        $plugin = 'modern-events-calendar-lite/modern-events-calendar-lite.php';

        if (!current_user_can('install_plugins')) {
            return;
        }

        $install_url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=modern-events-calendar-lite'), 'install-plugin_' . $plugin);
        $message     = '<p>' . self::$plugin_title.' ' . __('is not working because you need to install latest version of Modern Events Calendar plugin', self::$text_domain) . '</p>';
        $message    .= esc_html__('Minimum version required') . ': <b> '. self::$required_min_version_text .' </b>';
        $message    .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $install_url, __('Update Modern Events Calendar Now', self::$text_domain)) . '</p>';
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo $message; ?></p>
        </div>
        <?php
    }

    /**
	 * Is MEC installed
	 *
	 * @since     1.0.0
	 */
	public static function is_mec_installed() {

		$mec_pro			= 'modern-events-calendar/mec.php';
		$mec_lite			= 'modern-events-calendar-lite/modern-events-calendar-lite.php';
		$installed_plugins 	= get_plugins();
		if ( isset( $installed_plugins[ $mec_pro ] ) ) {
			return 'pro';
		} elseif ( isset( $installed_plugins[ $mec_lite ] ) )  {
			return 'lite';
		} else {
			return 'no-installed';
		}
	}
}