<?php

namespace MEC_User_Dashboard\Core\addExtraFields;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecExtraFields
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('mec_add_organizer_extra_fields', [$This,'organizer_add_new'] );
        add_action('mec_edit_organizer_extra_fields', [$This,'organizer_edit_form'] , 99 , 1 );
        add_action('mec_save_organizer_extra_fields', [$This,'sava_organizer_meta'] , 99 , 1 );

        add_action('mec_add_speaker_extra_fields', [$This,'speaker_add_new'] );
        add_action('mec_edit_speaker_extra_fields', [$This,'speaker_edit_form'] , 99 , 1 );
        add_action('mec_save_speaker_extra_fields', [$This,'sava_speaker_meta'] , 99 , 1 );

        add_filter( 'organizer_filter_column',[$This,'organizer_filter_columns'], 99 , 1 );
        add_filter( 'organizer_filter_column_content',[$This,'organizer_filter_columns_content'], 99 , 3 );

        add_filter( 'speaker_filter_column',[$This,'speaker_filter_columns'], 99 , 1 );
        add_filter( 'speaker_filter_column_content',[$This,'speaker_filter_columns_content'], 99 , 3 );

        add_action( 'show_user_profile', array( __CLASS__, 'add_user_custom_fields' ) );
		add_action( 'edit_user_profile', array( __CLASS__, 'add_user_custom_fields' ) );
        add_action( 'personal_options_update', array( __CLASS__, 'update_user_custom_fields' ) );
        add_action( 'edit_user_profile_update', array( __CLASS__, 'update_user_custom_fields' ) );

    }

    public static function get_users( $args = array(), $role = '' ) {

        $args = wp_parse_args(
            $args,
            array(
                'meta_query' => array(),
            )
        );

        if( empty( $role ) ) {

            $args['meta_query']['role'] = array(
                'relation' => 'or',
                array(
                    'key'	  => "mec_user_is_{$role}",
                    'value'	=>	'0',
                ),
                array(
                    'key'	  => "mec_user_is_{$role}",
                    'compare' => 'NOT EXISTS',
                )
            );
        }

        $user_query = new \WP_User_Query( $args );

        return $user_query->get_results();
    }

    /**
     * Set Organizer Filter columns
     *
     * @since   1.0.0
     */
    public function organizer_filter_columns($columns)
    {

        $columns['user'] = __('User', 'mec-ud');

        return $columns;
    }

    /**
     * Set Organizer Filter columns content
     *
     * @since   1.0.0
     */
    public function organizer_filter_columns_content($content , $column_name, $term_id)
    {

        switch($column_name)
        {
            case 'user':

                $user_id = get_metadata('term', $term_id, 'mec_organizer_user', true);
                if ( $user_id != 0 ) {
                    $user_obj = get_user_by('id', $user_id);
                    $user_url = get_edit_user_link( $user_id );
                    $content = '<a href="'.$user_url.'">'.$user_obj->user_nicename.'</a>';
                }

                break;

            default:
                break;
        }

        return $content;
    }

    /**
     * Set Speaker Filter columns
     *
     * @since   1.0.0
     */
    public function speaker_filter_columns($columns)
    {

        $columns['user'] = __('User', 'mec-ud');

        return $columns;
    }

    /**
     * Set Speaker Filter columns content
     *
     * @since   1.0.0
     */
    public function speaker_filter_columns_content($content , $column_name, $term_id)
    {

        switch($column_name)
        {
            case 'user':

                $user_id = get_metadata('term', $term_id, 'mec_speaker_user', true);
                if ( $user_id != 0 ) {
                    $user_obj = get_user_by('id', $user_id);
                    if( is_a( $user_obj, '\WP_User') ){

                        $user_url = get_edit_user_link( $user_id );
                        $content = '<a href="'.$user_url.'">'.$user_obj->user_nicename.'</a>';
                    }
                }

                break;

            default:
                break;
        }

        return $content;
    }

    /**
     * Set fields to add new organizer
     *
     * @since   1.0.0
     */
    public function organizer_add_new()
    {
        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');

        $users = static::get_users( [], 'organizer' );
        ?>
        <div class="form-field">
            <label for="mec_organizer_user">
            <?php _e('Select User', 'mec-ud'); ?>
            <span class="mec-tooltip">
                <div class="box">
                    <h5 class="title"><?php _e('Assign user to organizer', 'mec-ud'); ?></h5>
                    <div class="content"><p><?php _e('After assigning, user can edit the above information from frontend dashboard. Please refresh the page after adding a new organizer.', 'mec-ud'); ?></p></div>
                </div>
                <i title="" class="dashicons-before dashicons-editor-help"></i>
            </span>
            </label>
            <select id="mec_organizer_user" name="mec_organizer_user">
                <option value="none"><?php echo esc_html__('None' ,'mec-ud'); ?></option>
                <?php
                foreach ( $users as $user ) {
                    echo '<option value="'.$user->data->ID.'">' . esc_html( $user->user_login ) . ' - ' . esc_html( $user->user_email ) . '</option>';
                }
                ?>
            </select>
        </div>
        <script>
            jQuery(document).ready(function() {
                jQuery("#mec_organizer_user").select2();
            });
        </script>
        <?php
    }

    /**
     * Set fields to edit organizer
     *
     * @since   1.0.0
     */
    public function organizer_edit_form($term)
    {
        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');
        $user_info = '';
        $user_id = get_metadata('term', $term->term_id, 'mec_organizer_user', true);

        $user_info = get_userdata($user_id);

        $current_user_info =  isset( $user_id ) && ( $user_id != 'none' ) && ( $user_id != '0' ) && ( $user_info != false ) ? esc_html( $user_info->user_login ) . ' - ' . esc_html( $user_info->user_email ) : esc_html__('None' ,'mec-ud');
        $users = static::get_users( [], 'organizer' );
        ?>
        <tr class="form-field">
            <th scope="row" valign="top">
                <label for="mec_organizer_user"><?php _e('Select User', 'mec-ud'); ?></label>
            </th>
            <td>
                <select id="mec_organizer_user" name="mec_organizer_user">
                    <option></option>
                    <option value="none" checkdate><?php echo esc_html__('None' ,'mec-ud'); ?></option>
                    <?php
                    foreach ( $users as $user ) {
                        echo '<option value="'.$user->data->ID.'">' . esc_html( $user->user_login ) . ' - ' . esc_html( $user->user_email ) . '</option>';
                    }
                    ?>
                </select>
                <script>
                    jQuery(document).ready(function() {
                        jQuery("#mec_organizer_user").select2({
                            placeholder: "<?php echo $current_user_info; ?>",
                        });
                    });
                </script>
            </td>
        </tr>

        <?php
    }

    /**
     * save meta and add user meta
     *
     * @since   1.0.0
     */
    public function sava_organizer_meta($term_id)
    {
        $user_id = isset($_POST['mec_organizer_user']) ? sanitize_text_field($_POST['mec_organizer_user']) : '';
        if (empty($user_id)) return;

        static::assign_user_to_term( $term_id, $user_id, 'organizer' );
    }


    /**
     * Set fields to add new organizer
     *
     * @since   1.0.0
     */
    public function speaker_add_new()
    {
        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');
        //$users = get_users();
        $users = static::get_users( [], 'speaker' );

        ?>
        <div class="form-field">
            <label for="mec_speaker_user">
            <?php _e('Select User', 'mec-ud'); ?>
            <span class="mec-tooltip">
                <div class="box">
                    <h5 class="title"><?php _e('Assign user to speaker', 'mec-ud'); ?></h5>
                    <div class="content"><p><?php _e('After assigning, user can edit the above information from frontend dashboard. Please refresh the page after adding a new speaker.', 'mec-ud'); ?></p></div>
                </div>
                <i title="" class="dashicons-before dashicons-editor-help"></i>
            </span>
            </label>
            <select id="mec_speaker_user" name="mec_speaker_user">
                <option value="none"><?php echo esc_html__('None' ,'mec-ud'); ?></option>
                <?php
                foreach ( $users as $user ) {
                    echo '<option value="'.$user->data->ID.'">' . esc_html( $user->user_login ) . ' - ' . esc_html( $user->user_email ) . '</option>';
                }
                ?>
            </select>
        </div>
        <script>
            jQuery(document).ready(function() {
                jQuery("#mec_speaker_user").select2();
            });
        </script>
        <?php
    }

    /**
     * Set fields to edit speaker
     *
     * @since   1.0.0
     */
    public function speaker_edit_form($term)
    {
        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');
        $user_id = get_metadata('term', $term->term_id, 'mec_speaker_user', true);
        $user_info = get_userdata($user_id);
        $current_user_info =  isset( $user_id ) && ( $user_id != 'none' ) && ( $user_id != '0' ) && ( $user_info != false ) ? esc_html( $user_info->user_login ) . ' - ' . esc_html( $user_info->user_email ) : esc_html__('None' ,'mec-ud');

        $users = static::get_users( [], 'speaker' );
        ?>
        <tr class="form-field">
            <th scope="row" valign="top">
                <label for="mec_speaker_user"><?php _e('Select User', 'mec-ud'); ?></label>
            </th>
            <td>
                <select id="mec_speaker_user" name="mec_speaker_user">
                    <option></option>
                    <option value="none" checkdate><?php echo esc_html__('None' ,'mec-ud'); ?></option>
                    <?php
                    foreach ( $users as $user ) {
                        echo '<option value="'.$user->data->ID.'">' . esc_html( $user->user_login ) . ' - ' . esc_html( $user->user_email ) . '</option>';
                    }
                    ?>
                </select>
                <script>
                    jQuery(document).ready(function() {
                        jQuery("#mec_speaker_user").select2({
                            placeholder: "<?php echo $current_user_info; ?>",
                        });
                    });
                </script>
            </td>
        </tr>

        <?php
    }

    /**
     * save meta and add user meta
     *
     * @since   1.0.0
     */
    public function sava_speaker_meta($term_id)
    {
        $user_id = isset($_POST['mec_speaker_user']) ? sanitize_text_field($_POST['mec_speaker_user']) : '';
        if (empty($user_id)) return;

        static::assign_user_to_term( $term_id, $user_id, 'speaker' );
    }

    public static function assign_user_to_term( $term_id, $user_id, $type ) {

        $assigned_user_id = get_term_meta( (int)$term_id , 'mec_'. $type .'_user' , true );
        if ( !empty( $assigned_user_id ) ) {

            update_user_meta( (int)$assigned_user_id, 'mec_user_is_'. $type , '0' ); // clear old data
        }

        update_term_meta( (int)$term_id, 'mec_'. $type .'_user', (int)$user_id ); //add term meta
        update_user_meta( (int)$user_id, 'mec_user_is_'. $type, (int)$term_id ); //add user meta
    }

    public static function assign_term_to_user( $user_id, $term_id, $type ) {

        $assigned_term_id = get_user_meta( (int)$user_id, 'mec_user_is_'. $type, true );
        if ( !empty( $assigned_term_id ) ) {

            delete_term_meta( (int)$assigned_term_id, 'mec_'. $type .'_user' ); // clear old data
        }

        update_term_meta( (int)$term_id, 'mec_'. $type .'_user', (int)$user_id ); //add term meta
        update_user_meta( (int)$user_id, 'mec_user_is_'. $type, $term_id );
    }

    public static function add_user_custom_fields( $user ) {
        $user_current = wp_get_current_user();
        $allowed_roles = array('administrator');
        if( ! array_intersect($allowed_roles, $user_current->roles ) ) {
            return;
        }

        $organizers = get_terms(array(
            'taxonomy' => 'mec_organizer',
            'hide_empty' => false,
        ));

        $speakers = get_terms(array(
            'taxonomy' => 'mec_speaker',
            'hide_empty' => false,
        ));

		$organizer_id = get_the_author_meta( 'mec_user_is_organizer', $user->ID );
        $speaker_id = get_the_author_meta( 'mec_user_is_speaker', $user->ID );
		?>
        <h2><?php esc_html_e( 'MEC User Dashboard', 'mec-ud' ); ?></h2>
        <table class="form-table" role="presentation">
            <tr>
                <th><label for="mec-organizer"><?php esc_html_e( 'Organizer', 'mec-ud' ); ?></label></th>
                <td>
                    <select name="mec-organizer" id="mec-organizer">
                        <?php
                        echo '<option value="0">' . esc_html__( 'None', 'mec-ud' ) . '</option>';
                        foreach( $organizers as $organizer ) {

                            $term_id = $organizer->term_id;
                            $name = $organizer->name;
                            echo '<option value="'. esc_html( $term_id ) .'" '.selected( $term_id, $organizer_id, false ).'>' . $name . '</option>';
                        }

                        ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="mec-speaker"><?php esc_html_e( 'Speaker', 'mec-ud' ); ?></label></th>
                <td>
                    <select name="mec-speaker" id="mec-speaker">
                        <?php
                        echo '<option value="0">' . esc_html__( 'None', 'mec-ud' ) . '</option>';
                        foreach( $speakers as $speaker ) {

                            $term_id = $speaker->term_id;
                            $name = $speaker->name;
                            echo '<option value="'. esc_html( $term_id ) .'" '.selected( $term_id, $speaker_id, false ).'>' . $name . '</option>';
                        }

                        ?>
                    </select>
                </td>
            </tr>
        </table>
        <script>
            jQuery(document).ready(function($) {

                jQuery("#mec-organizer").select2();
                jQuery("#mec-speaker").select2();
            });
        </script>
		<?php
	}

    public static function update_user_custom_fields( $user_id ) {
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'update-user_' . $user_id ) ) {
            return;
        }

        if ( !current_user_can( 'edit_user', $user_id ) ) {

            return false;
        }

        $organizer_id = $_POST['mec-organizer'] ?? '';
        $speaker_id = $_POST['mec-speaker'] ?? '';

        static::assign_term_to_user( $user_id, $organizer_id, 'organizer' );
        static::assign_term_to_user( $user_id, $speaker_id, 'speaker' );
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
