<?php

namespace MEC_User_Dashboard\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECUSERDASHBOARDDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    { 
        add_action('admin_init', function () {
            \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\checkLicense\UserDashboardAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }

        \MEC_User_Dashboard\Autoloader::addClasses(
            [
                'MEC_User_Dashboard\\Core\\shortcodeFunction\\MecUserDashboard' => self::$dir . '/shortcodeFunction/mec-user-dashboard.php',
                'MEC_User_Dashboard\\Core\\addExtraFields\\MecExtraFields' => self::$dir . '/addExtraFields/mec-fields.php',
                'MEC_User_Dashboard\\Core\\shortcodesMetabox\\MecShortcodeMetabox' => self::$dir . '/shortcodesMetabox/meta-box.php',
                'MEC_User_Dashboard\\Core\\setUserMeta\\MecUserMeta' => self::$dir . '/setUserMeta/user-meta.php',
                'MEC_User_Dashboard\\Core\\bookingMeta\\MecBookingMeta' => self::$dir . '/bookingMeta/booking-meta.php',
                'MEC_User_Dashboard\\Core\\settingsMenu\\MecSettingsMenu' => self::$dir . '/settingsMenu/settings-menu.php',
                'MEC_User_Dashboard\\Core\\checkLicense\\UserDashboardAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\shortcodeFunction\MecUserDashboard');
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\addExtraFields\MecExtraFields');
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\shortcodesMetabox\MecShortcodeMetabox');
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\setUserMeta\MecUserMeta');
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\bookingMeta\MecBookingMeta');
        \MEC_User_Dashboard\Autoloader::load('MEC_User_Dashboard\Core\settingsMenu\MecSettingsMenu');
    }
} //Loader

Loader::instance();
