<?php

namespace MEC_User_Dashboard\Core\bookingMeta;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecBookingMeta
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('add_event_booking_sections_left_menu', [$This,'add_booking_metabox_menu'] );
        add_action('mec_metabox_booking', [$This,'add_booking_metabox_content'] , 99 , 1);
        add_action('add_booking_variables', [$This,'mec_booking_settings'], 99, 1);

    }

        /**
     * Booking metabox menu item (login)
     *
     * @since     1.0.0
     */
    public function add_booking_metabox_menu()
    {
        ?>
            <a class="mec-add-booking-tabs-link" data-href="mec-limit-booking-for-users" href="#"><?php echo esc_html__('Limitation for users' ,'mec-ud'); ?></a>
        <?php
    }

    /**
     * Booking metabox (login)
     *
     * @since     1.0.0
     */
    public function add_booking_metabox_content($post)
    {
        $booking_options = get_post_meta($post->ID, 'mec_booking', true);
        if (!is_array($booking_options)) {
            $booking_options = array();
        }

        $bookings_limit_for_users = isset($booking_options['bookings_limit_for_users']) ? $booking_options['bookings_limit_for_users'] : 0;

        ?>

        <div class="mec-meta-box-fields mec-booking-tab-content" id="mec-limit-booking-for-users">
            <label for="mec_bookings_limit"><h4 class="mec-title"><?php _e('Limitation for users', 'mec-ud'); ?></h4>
            </label>
            <div class="mec-form-row">
                <label class="mec-col-8" for="mec_bookings_limit_for_users" id="mec_bookings_limit_for_users_label">
                    <input type="hidden" name="mec[booking][bookings_limit_for_users]" value="0"/>
                    <input id="mec_bookings_limit_for_users"
                        <?php
                        if ($bookings_limit_for_users == 1) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" value="1" name="mec[booking][bookings_limit_for_users]"/>
                    <?php _e('Display Booking section only for Logged in users', 'mec-ud'); ?>                       
                </label>
            </div>
        </div>

        <?php
    }

    
    public function mec_booking_settings($settings)
    {
        ?>
        <div class="mec-form-row">
            <div class="mec-col-12">
                <label for="mec_settings_booking_user_login">
                    <input type="hidden" name="mec[settings][booking_user_login]" value="0" />
                    <input type="checkbox" name="mec[settings][booking_user_login]" id="mec_settings_booking_user_login"
                        <?php echo ((isset($settings['booking_user_login']) and $settings['booking_user_login'] == '1') ? 'checked="checked"' : ''); ?>
                        value="1" />
                    <?php _e('Display Booking section only for Logged in users in single event page', 'mec-ud'); ?>
                </label>
            </div>
        </div>
        <?php
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
