<?php

namespace MEC_User_Dashboard\Core\setUserMeta;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecUserMeta
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {

    }

    public static function user_is_organizer( $user_id ){

        $is_organizer = get_user_meta( $user_id, 'mec_user_is_organizer',true);

        return !empty( $is_organizer ) ? $is_organizer : 0;
    }

    public static function user_is_speaker( $user_id ){

        $is_speaker = get_user_meta( $user_id, 'mec_user_is_speaker',true);

        return !empty( $is_speaker ) ? $is_speaker : 0; //'0'
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
