<?php

namespace MEC_User_Dashboard\Core\settingsMenu;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecSettingsMenu
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_filter( 'mec-settings-items-settings', [$This,'add_settings_content'], '', 1 );
        add_action( 'mec-settings-page-before-form-end', [$This,'add_user_dashboard_settings_content'], '', 1 );
    }

    /**
     * add user dashboard settings left menu item
     *
     * @since   1.0.0
     */
    public function add_settings_content($activated){
        $activated['User Dashboard']= 'userdashboard_option';
        return $activated;

    }

    /**
     * add user dashboard settings content
     *
     * @since   1.0.0
     */
    public function add_user_dashboard_settings_content($settings) {
        $pages = get_pages();
        ?>
        <div id="userdashboard_option" class="mec-options-fields">
            <h4 class="mec-form-subtitle"><?php _e('User Dashboard', 'mec-ud'); ?></h4>
            <div class="mec-form-row">
                <p><?php echo sprintf(__('Put %s shortcode into your desired page. Then users are able to see their dashboard.', 'mec-ud'), '<code>[MEC_user_dashboard]</code>'); ?></p>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_user_dashboard_page"><?php _e('User Dashboard Page', 'mec-ud'); ?></label>
                <div class="mec-col-4">
                    <select id="mec_settings_user_dashboard_page" name="mec[settings][user_dashboard_page]">
                        <option value="">----</option>
                        <?php foreach($pages as $page): ?>
                            <option <?php echo ((isset($settings['user_dashboard_page']) and $settings['user_dashboard_page'] == $page->ID) ? 'selected="selected"' : ''); ?> value="<?php echo $page->ID; ?>"><?php echo $page->post_title; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <p class="description"><?php echo esc_html__('This option is for back to dashboard button even editing events in frontend. Make sure to set it.' , 'mec-ud') ?></p>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_dashboard_date_format1"><?php esc_html_e('Date Format', 'mec'); ?></label>
                <div class="mec-col-9">
                    <input type="text" id="mec_settings_dashboard_date_format1" name="mec[settings][dashboard_date_format1]" value="<?php echo ((isset($settings['dashboard_date_format1']) and trim($settings['dashboard_date_format1']) != '') ? esc_attr(stripslashes($settings['dashboard_date_format1'])) : 'M d Y'); ?>" />
                    <span class="mec-tooltip">
                        <div class="box left">
                            <h5 class="title"><?php esc_html_e('Date Format', 'mec'); ?></h5>
                            <div class="content"><p><?php esc_attr_e("Specify the date format of date on the dashboard page date and time module.", 'mec'); ?></p></div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </div>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_dashboard_time_format1"><?php esc_html_e('Time Format', 'mec'); ?></label>
                <div class="mec-col-9">
                    <input type="text" id="mec_settings_dashboard_time_format1" name="mec[settings][dashboard_time_format1]" value="<?php echo ((isset($settings['dashboard_time_format1']) and trim($settings['dashboard_time_format1']) != '') ? esc_attr(stripslashes($settings['dashboard_time_format1'])) : 'h:i a'); ?>" />
                    <span class="mec-tooltip">
                        <div class="box left">
                            <h5 class="title"><?php esc_html_e('Time Format', 'mec'); ?></h5>
                            <div class="content"><p><?php esc_attr_e("Specify the time format of time on the dashboard page time and time module.", 'mec'); ?></p></div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </div>
            </div>
            <h5 class="mec-form-subtitle"><?php _e('User Dashboard Sections', 'mec-ud'); ?></h5>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_edit_dashboard">
                        <input type="hidden" name="mec[settings][dashboard_edit_dashboard]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_edit_dashboard]" id="mec_settings_dashboard_edit_dashboard"
                            <?php echo ((isset($settings['dashboard_edit_dashboard']) and $settings['dashboard_edit_dashboard'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Edit Profile', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_ticket_sec">
                        <input type="hidden" name="mec[settings][dashboard_ticket_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_ticket_sec]" id="mec_settings_dashboard_ticket_sec"
                            <?php echo ((isset($settings['dashboard_ticket_sec']) and $settings['dashboard_ticket_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Tickets', 'mec-ud'); ?>
                    </label>
                </div>
            </div>

            <?php if( function_exists('mec_rsvp_is_enabled') && mec_rsvp_is_enabled() ): ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <label for="mec_settings_dashboard_rsvp_sec">
                            <input type="hidden" name="mec[settings][dashboard_rsvp_sec]" value="0" />
                            <input type="checkbox" name="mec[settings][dashboard_rsvp_sec]" id="mec_settings_dashboard_rsvp_sec"
                                <?php echo ((isset($settings['dashboard_rsvp_sec']) and $settings['dashboard_rsvp_sec'] == '1') ? 'checked="checked"' : ''); ?>
                                value="1" />
                            <?php _e('RSVPs', 'mec-ud'); ?>
                        </label>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ( class_exists( \MEC_Waiting_List\MEC_Waiting_Base::class ) ) : ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <label for="mec_settings_dashboard_waiting_list_sec">
                            <input type="hidden" name="mec[settings][dashboard_waiting_list_sec]" value="0" />
                            <input type="checkbox" name="mec[settings][dashboard_waiting_list_sec]" id="mec_settings_dashboard_waiting_list_sec"
                                <?php echo ((isset($settings['dashboard_waiting_list_sec']) and $settings['dashboard_waiting_list_sec'] == '1') ? 'checked="checked"' : ''); ?>
                                value="1" />
                            <?php _e('Waiting list', 'mec-ud'); ?>
                        </label>
                    </div>
                </div>
            <?php endif; ?>

            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_event_sec">
                        <input type="hidden" name="mec[settings][dashboard_event_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_event_sec]" id="mec_settings_dashboard_event_sec"
                            <?php echo ((isset($settings['dashboard_event_sec']) and $settings['dashboard_event_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Events', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_organizer_sec">
                        <input type="hidden" name="mec[settings][dashboard_organizer_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_organizer_sec]" id="mec_settings_dashboard_organizer_sec"
                            <?php echo ((isset($settings['dashboard_organizer_sec']) and $settings['dashboard_organizer_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Organizers (This section will only be displayed if the user is registered as Organizer.)', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_speaker_sec">
                        <input type="hidden" name="mec[settings][dashboard_speaker_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_speaker_sec]" id="mec_settings_dashboard_speaker_sec"
                            <?php echo ((isset($settings['dashboard_speaker_sec']) and $settings['dashboard_speaker_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Speakers (This section will only be displayed if the user is registered as Speaker)', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_reports_sec">
                        <input type="hidden" name="mec[settings][dashboard_reports_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_reports_sec]" id="mec_settings_dashboard_reports_sec"
                            <?php echo ((isset($settings['dashboard_reports_sec']) and $settings['dashboard_reports_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Reports', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <?php # if( defined('WC_PLUGIN_FILE') ): ?>
            <?php if( false ): ?>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_woocommerce_sec">
                        <input type="hidden" name="mec[settings][dashboard_woocommerce_sec]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_woocommerce_sec]" id="mec_settings_dashboard_woocommerce_sec"
                            <?php echo ((isset($settings['dashboard_woocommerce_sec']) and $settings['dashboard_woocommerce_sec'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('WooCommerce my account', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <?php endif; ?>
            <?php if( defined('WC_PLUGIN_FILE') ): ?>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_ud_in_woo_account_page">
                        <input type="hidden" name="mec[settings][dashboard_ud_in_woo_account_page]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_ud_in_woo_account_page]" id="mec_settings_dashboard_ud_in_woo_account_page"
                            <?php echo ((isset($settings['dashboard_ud_in_woo_account_page']) and $settings['dashboard_ud_in_woo_account_page'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('User dashboard in WooCommerce "my account" page', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <?php endif; ?>

            <?php do_action( 'mec_dashboard_menu_settings', $settings ) ?>

            <h4 class="mec-form-subtitle"><?php _e('Events Sections Settings', 'mec-ud'); ?></h4>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_events_show_events_to_organizers">
                        <input type="hidden" name="mec[settings][dashboard_events_show_events_to_organizers]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_events_show_events_to_organizers]" id="mec_settings_dashboard_events_show_events_to_organizers"
                            <?php echo ((isset($settings['dashboard_events_show_events_to_organizers']) and $settings['dashboard_events_show_events_to_organizers'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Show events to organizer', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_events_hide_edit_button">
                        <input type="hidden" name="mec[settings][dashboard_events_hide_edit_button]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_events_hide_edit_button]" id="mec_settings_dashboard_events_hide_edit_button"
                            <?php echo ((isset($settings['dashboard_events_hide_edit_button']) and $settings['dashboard_events_hide_edit_button'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Hide edit link in events section', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_dashboard_events_hide_delete_button">
                        <input type="hidden" name="mec[settings][dashboard_events_hide_delete_button]" value="0" />
                        <input type="checkbox" name="mec[settings][dashboard_events_hide_delete_button]" id="mec_settings_dashboard_events_hide_delete_button"
                            <?php echo ((isset($settings['dashboard_events_hide_delete_button']) and $settings['dashboard_events_hide_delete_button'] == '1') ? 'checked="checked"' : ''); ?>
                            value="1" />
                        <?php _e('Hide delete link in events section', 'mec-ud'); ?>
                    </label>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
