<?php

namespace MEC_User_Dashboard\Core\shortcodeFunction;

use MEC_User_Dashboard\Core\setUserMeta\MecUserMeta;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecUserDashboard
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * The Query
     *
     * @access  public
     * @var     array
     */
    public static $query;

    /**
     * new MEC_main()
     *
     * @access  public
     * @var     array
     */
    public static $main_class;

    /**
     * new MEC_feature_fes()
     *
     * @access  public
     * @var     array
     */
    public static $fes_class;

    /**
     *
     * @access  public
     * @var     integer
     */
    public static $userId;

    /**
     *
     * @access  public
     * @var     string
     */
    public static $current_slug;

    /**
     *
     * @access  public
     * @var     array
     */
    public static $mec_settings;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('wp_enqueue_scripts', [$This, 'UD_assets']);
        //add_action('admin_enqueue_scripts', [$This, 'UD_assets']);

        add_shortcode('MEC_user_dashboard', [$This, 'user_dashboard'], 99);

        add_action('wp_ajax_mec_ud_update_custom_user_profile_frontend',  [$This, 'mec_ud_update_custom_user_profile_frontend']);
        add_action('wp_ajax_nopriv_mec_ud_update_custom_user_profile_frontend',  [$This, 'mec_ud_update_custom_user_profile_frontend']);

        add_action('wp_ajax_mec_ud_update_custom_user_profile_details_frontend',  [$This, 'mec_ud_update_custom_user_profile_details_frontend']);
        add_action('wp_ajax_nopriv_mec_ud_update_custom_user_profile_details_frontend',  [$This, 'mec_ud_update_custom_user_profile_details_frontend']);

        // Organizer image ajax
        add_action('wp_ajax_mec_ud_update_organizer_thumbnail',  [$This, 'mec_ud_update_organizer_thumbnail']);
        add_action('wp_ajax_nopriv_mec_ud_update_organizer_thumbnail',  [$This, 'mec_ud_update_organizer_thumbnail']);

        // Organizer data Ajax
        add_action('wp_ajax_mec_ud_update_organizer_data',  [$This, 'mec_ud_update_organizer_data']);
        add_action('wp_ajax_nopriv_mec_ud_update_organizer_data',  [$This, 'mec_ud_update_organizer_data']);

        // Speaker image ajax
        add_action('wp_ajax_mec_ud_update_speaker_thumbnail',  [$This, 'mec_ud_update_speaker_thumbnail']);
        add_action('wp_ajax_nopriv_mec_ud_update_speaker_thumbnail',  [$This, 'mec_ud_update_speaker_thumbnail']);

        // Speaker data Ajax
        add_action('wp_ajax_mec_ud_update_speaker_data',  [$This, 'mec_ud_update_speaker_data']);
        add_action('wp_ajax_nopriv_mec_ud_update_speaker_data',  [$This, 'mec_ud_update_speaker_data']);

        add_filter( 'get_avatar', [$This,'mec_ud_get_new_avatar'], 5, 5 );

        add_action( 'admin_post_generate_csv', [$This,'generate_orders_csv'] );

        add_action( 'mec_fes_form_top_actions', [$This,'change_fes_list_link'] );

        add_action('wp_ajax_get_tickets_and_total',  [$This, 'get_tickets_and_total']);
        add_action('wp_ajax_nopriv_get_tickets_and_total',  [$This, 'get_tickets_and_total']);

        add_action('wp_ajax_chart_data_filter_button',  [$This, 'chart_data_filter_button']);
        add_action('wp_ajax_nopriv_chart_data_filter_button',  [$This, 'chart_data_filter_button']);

        add_action('wp_ajax_mec_ud_menu_content',  [$This, 'dashboard_menu_content']);

        add_filter( 'woocommerce_account_menu_items', [$This, 'woocommerce_account_menu_items'], 99, 1);
        add_filter( 'wc_get_template_part', [$This, 'custom_wc_template_part'], 10, 3 );

        add_filter( 'woocommerce_prevent_admin_access', array( __CLASS__, 'filter_wc_async_upload_access' ),999 );

        add_action( 'init', array( $This, 'prepare_ud') ,9 );

        add_action( 'init', function() {

            if(isset(self::$mec_settings['dashboard_ud_in_woo_account_page']) && self::$mec_settings['dashboard_ud_in_woo_account_page'] == '1') {

                if ( isset(self::$mec_settings['dashboard_edit_dashboard']) && self::$mec_settings['dashboard_edit_dashboard'] == 1 ) {
                    add_rewrite_endpoint( 'mec-user-profile', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-user-profile_endpoint', function() {
                        wc_get_template_part('mec-user-profile');
                    });
                }
                if ( isset(self::$mec_settings['dashboard_ticket_sec']) && self::$mec_settings['dashboard_ticket_sec'] == 1 ) {
                    add_rewrite_endpoint( 'mec-tickets', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-tickets_endpoint', function() {
                        wc_get_template_part('mec-tickets');
                    });
                }

                if ( isset(self::$mec_settings['dashboard_rsvp_sec']) && self::$mec_settings['dashboard_rsvp_sec'] == 1 ) {
                    add_rewrite_endpoint( 'mec-rsvps', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-rsvps_endpoint', function() {
                        wc_get_template_part('mec-rsvps');
                    });
                }


                if ( isset(self::$mec_settings['dashboard_event_sec']) && self::$mec_settings['dashboard_event_sec'] == 1 ) {
                    add_rewrite_endpoint( 'mec-events', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-events_endpoint', function() {
                        wc_get_template_part('mec-events');
                    });
                }
                if ( !empty( MecUserMeta::user_is_organizer(self::$userId) ) && isset(self::$mec_settings['dashboard_organizer_sec']) &&self:: $mec_settings['dashboard_organizer_sec'] == 1 ) {
                    add_rewrite_endpoint( 'mec-organizer', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-organizer_endpoint', function() {
                        wc_get_template_part('mec-organizer');
                    });
                }
                if ( !empty(  MecUserMeta::user_is_speaker(self::$userId) ) && isset(self::$mec_settings['dashboard_speaker_sec']) &&self:: $mec_settings['dashboard_speaker_sec'] == 1  ) {
                    add_rewrite_endpoint( 'mec-speaker', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-speaker_endpoint', function() {
                        wc_get_template_part('mec-speaker');
                    });
                }
                if ( isset(self::$mec_settings['dashboard_reports_sec']) && self::$mec_settings['dashboard_reports_sec'] == 1 ) {
                    add_rewrite_endpoint( 'mec-report', EP_ROOT | EP_PAGES );
                    add_action( 'woocommerce_account_mec-report_endpoint', function() {
                        wc_get_template_part('mec-report');
                    });
                }
            }
        });

        add_filter( 'mec_profile_datetime_format', array( __CLASS__, 'filter_profile_datetime_format' ) );
    }

    public static function prepare_ud(){

        self::$userId = get_current_user_id();

        if(!self::$main_class) {
            self::$main_class = new \MEC_main();
            self::$fes_class = new \MEC_feature_fes();
            self::$mec_settings = apply_filters(
                'mec_dashboard_mec_settings',
                self::$main_class->get_settings()
            );
        }

        if ( ! class_exists( \MEC_Waiting_List\MEC_Waiting_Base::class ) ) {

            self::$mec_settings['dashboard_waiting_list_sec'] = false;
        }

        if( is_user_logged_in() && ! current_user_can( 'upload_files' )  ) {

            $user = wp_get_current_user();
            $roles = ( array ) $user->roles;
            foreach ($roles as  $role) {
                $new_role = get_role($role);
                $new_role->add_cap('upload_files');
            }
        }
    }

    /**
    * Sync User Dashboard Menu Items with WooCommerce Account Menu Items
    *
    * @since     1.0.0
    */
    public function woocommerce_account_menu_items ($items) {
        $my_items = [];

        self::prepare_ud();

        if(isset(self::$mec_settings['dashboard_ud_in_woo_account_page']) && self::$mec_settings['dashboard_ud_in_woo_account_page'] == '1') {
            if ( isset(self::$mec_settings['dashboard_edit_dashboard']) && self::$mec_settings['dashboard_edit_dashboard'] == 1 ) {
                $my_items['mec-user-profile'] = __('User Profile', 'mec-ud');
            }
            if ( isset(self::$mec_settings['dashboard_ticket_sec']) && self::$mec_settings['dashboard_ticket_sec'] == 1 )
            $my_items['mec-tickets'] = __('Tickets', 'mec-ud');
            if ( isset(self::$mec_settings['dashboard_rsvp_sec']) && self::$mec_settings['dashboard_rsvp_sec'] == 1 ) {
                $my_items['mec-rsvps'] = __('RSVPs', 'mec-ud');
            }
            if ( isset(self::$mec_settings['dashboard_event_sec']) && self::$mec_settings['dashboard_event_sec'] == 1 )
            $my_items['mec-events'] = __('Events', 'mec-ud');
            if ( !empty( MecUserMeta::user_is_organizer(self::$userId) ) && isset(self::$mec_settings['dashboard_organizer_sec']) &&self:: $mec_settings['dashboard_organizer_sec'] == 1 )
            $my_items['mec-organizer'] = \MEC\Base::get_main()->m('taxonomy_organizer', esc_html__('Organizer', 'mec-ud') );
            if ( !empty(  MecUserMeta::user_is_speaker(self::$userId) ) && isset(self::$mec_settings['dashboard_speaker_sec']) &&self:: $mec_settings['dashboard_speaker_sec'] == 1  )
            $my_items['mec-speaker'] = \MEC\Base::get_main()->m('taxonomy_speaker', esc_html__('Speaker', 'mec-ud') );
            if ( isset(self::$mec_settings['dashboard_reports_sec']) && self::$mec_settings['dashboard_reports_sec'] == 1 )
            $my_items['mec-report'] = __('Report', 'mec-ud');
        }

        $my_items = apply_filters( 'mec_dashboard_woocommerce_menus', $my_items );

        $my_items = array_slice( $items, 0, 1, true ) +
            $my_items +
            array_slice( $items, 1, count( $items ), true );

        return $my_items;

    }

    /**
    * Custom WC Template Part
    *
    * @since     1.0.0
    */
    public function custom_wc_template_part ($template, $slug, $name) {

        if(isset(self::$mec_settings['dashboard_ud_in_woo_account_page']) && self::$mec_settings['dashboard_ud_in_woo_account_page'] == '1') {
            $dash_parts = ['mec-tickets', 'mec-events', 'mec-organizer', 'mec-speaker', 'mec-report', 'mec-user-profile'];
            if(in_array($slug, $dash_parts)) {
                $template = trailingslashit( __DIR__ ) . 'template-parts/dashboard.php';
                self::$current_slug = $slug;
            }
        }
        return $template;
    }


    /**
     * Load assets
     *
     * @since     1.0.0
     */
    public function UD_assets()
    {
        $dashboard_page_id = \MEC\Settings\Settings::getInstance()->get_settings('user_dashboard_page');
        if( get_the_ID() != $dashboard_page_id ){
            if ( ! defined( 'ICL_SITEPRESS_VERSION' ) ) {
                return;
            }
        }

        wp_enqueue_media();
        wp_enqueue_script('mec-ud-chart', MECUSERDASHBOARDDASSETS . 'js/mec-ud-chart.js' );
        wp_enqueue_script('mec-ud-script', MECUSERDASHBOARDDASSETS . 'js/mec-ud.js' );
        $data = array(
            'upload_url' => admin_url('async-upload.php'),
            'ajax_url'   => admin_url('admin-ajax.php'),
            'nonce'      => wp_create_nonce('media-form')
        );
        wp_localize_script( 'mec-ud-script', 'mec_ud_config', $data );
        wp_enqueue_style('mec-ud-style', MECUSERDASHBOARDDASSETS . 'css/mec-ud.css' );
    }

    /**
     * Main Structure
     *
     * @since     1.0.0
     */
    public function user_dashboard()
    {
        $login_class =  !is_user_logged_in() ? ' mec-user-not-login' : '' ;
        $output = '<div class="mec-wrap clearfix mec-ud-main">';
        $output .= '<div class="mec-ud-main-content'.$login_class.'">';
        $output .= '<div class="row mec-head-wrap"><div class="mec-ud-wrap-header">'.esc_html__('User dashboard' , 'mec-ud').'</div></div>';
        if ( !is_user_logged_in() ){
            // $output .= '<span class="mec-ud-login-message">"' . __('Please login or create an account to purchase these tickets', 'mec-ud') . '"</span>';
            $output .= do_shortcode('[MEC_login]');
        } else {
            $output .= '<div class="row mec-ud-wrap">';
            $output .= '<div class="col-md-3">'. self::UD_menu() .'</div>';
            $output .= '<div class="col-md-9">'. self::UD_content() .'</div>';
            $output .= '</div>';
        }
        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }

    public static function add_author_query_to_event_query_args( $q_args ) {

        $user_organizer_id = get_user_meta( self::$userId, 'mec_user_is_organizer', true );

        $show_events_to_organizers = (bool)\MEC\Settings\Settings::getInstance()->get_settings('dashboard_events_show_events_to_organizers');

        if( $user_organizer_id && $show_events_to_organizers ) {

            $q_args['tax_query']['author_or_organizer'] = array(
                'relation' => 'OR',
                array(
                    'field' => 'author',
                    'value' => self::$userId,
                    'compare' => '=',
                ),
                array(
                    'taxonomy' => 'mec_organizer',
                    'field' => 'term_id',
                    'terms' => array( $user_organizer_id ),
                ),
            );

        }else{

            $q_args['author'] = self::$userId;
        }

        return $q_args;
    }

    public static function current_user_can_event( $cap ) {

        $user_id = get_current_user_id();
        $show_events_to_organizers = (bool)\MEC\Settings\Settings::getInstance()->get_settings('dashboard_events_show_events_to_organizers');
        $user_organizer_id = $user_id ? get_user_meta( (int)$user_id, 'mec_user_is_organizer', true ) : false;
        $user_current = wp_get_current_user();
        $allowed_roles = array('editor', 'administrator', 'author');

        $event_access_roles = self::$mec_settings['fes_access_roles'] ?? array();
        $has_access_role = in_array($user_current->roles[0], $event_access_roles ) && array_intersect($allowed_roles, $user_current->roles ) ? true : false;
        $has_access = false;
        if ( 'add_new' === $cap || 'edit' === $cap ) {
            $has_access = $has_access_role;
        } elseif( $user_organizer_id && $show_events_to_organizers ) {
            $has_access = $has_access_role || $user_organizer_id;
        }

        return $has_access;
    }

    /**
     * left content (menu)
     *
     * @since     1.0.0
     */
    public static function UD_menu()
    {
        if( !is_plugin_active('modern-events-calendar/mec.php') ){
            self::$mec_settings['dashboard_ticket_sec'] = false;
        }

        if ( !function_exists('mec_rsvp_is_enabled') || !mec_rsvp_is_enabled() ) {

            self::$mec_settings['dashboard_rsvp_sec'] = false;
        }

        self::prepare_ud();

        $menu = '
            <div class="mec-ud-menu">';
            if ( isset(self::$mec_settings['dashboard_edit_dashboard']) && self::$mec_settings['dashboard_edit_dashboard'] == 1 ) {
                $menu .= '
                        <a href="#" data-onClick="mec-ud-profile" data-menu="profile" class="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                            <path id="note" d="M17.974,3.115a.8.8,0,0,1-.032.094.706.706,0,0,1-.04.116.688.688,0,0,1-.1.147.757.757,0,0,1-.043.066l-7.5,7.491c-.013.013-.03.017-.043.029a1.045,1.045,0,0,1-.26.147c-.017.005-.029.017-.046.022l-3,.75A.742.742,0,0,1,6.728,12,.75.75,0,0,1,6,11.067l.75-3c0-.017.017-.029.023-.046a.737.737,0,0,1,.064-.135.72.72,0,0,1,.082-.123c.011-.014.016-.031.029-.044L14.45.231a.647.647,0,0,1,.073-.048A.719.719,0,0,1,14.65.1a.685.685,0,0,1,.143-.051.606.606,0,0,1,.081-.029,2.974,2.974,0,0,1,2.439.73A3.056,3.056,0,0,1,17.974,3.115ZM16.216,1.772a1.317,1.317,0,0,0-.907-.281L8.156,8.635l-.4,1.585,1.587-.4L16.5,2.68A1.4,1.4,0,0,0,16.216,1.772ZM9.083,2.881H1.514L1.477,16.493l13.662,0V8.932a.757.757,0,0,1,1.514,0v8.32c0,.414-.507.74-.922.74h-15A.722.722,0,0,1,0,17.252V2.125a.762.762,0,0,1,.757-.756H9.083a.756.756,0,1,1,0,1.513Z" transform="translate(0 0.009)" fill-rule="evenodd"/>
                            </svg>
                            <span>'.esc_html__('Edit Profile' , 'mec-ud').'</span>
                        </a>';
            }
        if ( isset(self::$mec_settings['dashboard_ticket_sec']) && self::$mec_settings['dashboard_ticket_sec'] == 1 )
            $menu .= '
                <a href="#" data-onClick="mec-ud-tickets" data-menu="tickets" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                    <path id="ticket" d="M705.756,567.395l-.412.413a1.126,1.126,0,0,1-1.657-1.525c.021-.023.044-.045.066-.066l.413-.412-1.488-1.488a1.833,1.833,0,0,0-2.591,0l-9.77,9.771a1.832,1.832,0,0,0,0,2.59l1.488,1.488.413-.412a1.125,1.125,0,1,1,1.656,1.525c-.02.022-.043.045-.066.066l-.412.412,1.488,1.488a1.832,1.832,0,0,0,2.591,0l9.77-9.77a1.832,1.832,0,0,0,0-2.591Zm-3.661-2.013a1.07,1.07,0,0,1,.248,1.068,2.234,2.234,0,0,0,2.772,2.77,1.065,1.065,0,0,1,1.066.248h0a1.047,1.047,0,0,1,0,1.479l-2.91,2.91a1.832,1.832,0,0,1-2.591,0l-2.976-2.976a1.834,1.834,0,0,1,0-2.591l2.91-2.91a1.047,1.047,0,0,1,1.479,0Zm-6.627,14.8a1.068,1.068,0,0,1-.247-1.068,2.235,2.235,0,0,0-2.773-2.769,1.067,1.067,0,0,1-1.065-.248l0,0a1.047,1.047,0,0,1,0-1.479l2.91-2.91a1.833,1.833,0,0,1,2.591,0l2.975,2.976a1.832,1.832,0,0,1,0,2.591l-2.91,2.909a1.045,1.045,0,0,1-1.479,0Z" transform="translate(-689.782 -563.781)"/>
                    </svg>
                    <span>'.esc_html__('Tickets' , 'mec-ud').'</span>
                </a>';

        if ( isset(self::$mec_settings['dashboard_waiting_list_sec']) && self::$mec_settings['dashboard_waiting_list_sec'] == 1 ) {

            $menu .= '
                <a href="#" data-onClick="mec-ud-waiting-list" data-menu="waiting-list" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                    <path id="ticket" d="M705.756,567.395l-.412.413a1.126,1.126,0,0,1-1.657-1.525c.021-.023.044-.045.066-.066l.413-.412-1.488-1.488a1.833,1.833,0,0,0-2.591,0l-9.77,9.771a1.832,1.832,0,0,0,0,2.59l1.488,1.488.413-.412a1.125,1.125,0,1,1,1.656,1.525c-.02.022-.043.045-.066.066l-.412.412,1.488,1.488a1.832,1.832,0,0,0,2.591,0l9.77-9.77a1.832,1.832,0,0,0,0-2.591Zm-3.661-2.013a1.07,1.07,0,0,1,.248,1.068,2.234,2.234,0,0,0,2.772,2.77,1.065,1.065,0,0,1,1.066.248h0a1.047,1.047,0,0,1,0,1.479l-2.91,2.91a1.832,1.832,0,0,1-2.591,0l-2.976-2.976a1.834,1.834,0,0,1,0-2.591l2.91-2.91a1.047,1.047,0,0,1,1.479,0Zm-6.627,14.8a1.068,1.068,0,0,1-.247-1.068,2.235,2.235,0,0,0-2.773-2.769,1.067,1.067,0,0,1-1.065-.248l0,0a1.047,1.047,0,0,1,0-1.479l2.91-2.91a1.833,1.833,0,0,1,2.591,0l2.975,2.976a1.832,1.832,0,0,1,0,2.591l-2.91,2.909a1.045,1.045,0,0,1-1.479,0Z" transform="translate(-689.782 -563.781)"/>
                    </svg>
                    <span>'.esc_html__('Waiting list' , 'mec-ud').'</span>
                </a>';
        }
        if ( isset(self::$mec_settings['dashboard_rsvp_sec']) && self::$mec_settings['dashboard_rsvp_sec'] == 1 )
            $menu .= '
                <a href="#" data-onClick="mec-ud-rsvps" data-menu="rsvps" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                    <path id="ticket" d="M705.756,567.395l-.412.413a1.126,1.126,0,0,1-1.657-1.525c.021-.023.044-.045.066-.066l.413-.412-1.488-1.488a1.833,1.833,0,0,0-2.591,0l-9.77,9.771a1.832,1.832,0,0,0,0,2.59l1.488,1.488.413-.412a1.125,1.125,0,1,1,1.656,1.525c-.02.022-.043.045-.066.066l-.412.412,1.488,1.488a1.832,1.832,0,0,0,2.591,0l9.77-9.77a1.832,1.832,0,0,0,0-2.591Zm-3.661-2.013a1.07,1.07,0,0,1,.248,1.068,2.234,2.234,0,0,0,2.772,2.77,1.065,1.065,0,0,1,1.066.248h0a1.047,1.047,0,0,1,0,1.479l-2.91,2.91a1.832,1.832,0,0,1-2.591,0l-2.976-2.976a1.834,1.834,0,0,1,0-2.591l2.91-2.91a1.047,1.047,0,0,1,1.479,0Zm-6.627,14.8a1.068,1.068,0,0,1-.247-1.068,2.235,2.235,0,0,0-2.773-2.769,1.067,1.067,0,0,1-1.065-.248l0,0a1.047,1.047,0,0,1,0-1.479l2.91-2.91a1.833,1.833,0,0,1,2.591,0l2.975,2.976a1.832,1.832,0,0,1,0,2.591l-2.91,2.909a1.045,1.045,0,0,1-1.479,0Z" transform="translate(-689.782 -563.781)"/>
                    </svg>
                    <span>'.esc_html__('RSVPs' , 'mec-ud').'</span>
                </a>';

        $user_current = wp_get_current_user();
        $current_user_id = get_current_user_id();
        $allowed_roles = array('editor', 'administrator', 'author');
        $can_view = self::current_user_can_event('view');
        $user_has_events = get_posts(array(
            'post_type'   => 'mec-events', 
            'author'      => $current_user_id,
            'post_status' => 'publish',
            'numberposts' => 1
        ));
        if (!empty($user_has_events)) {
            $can_view = true;
        }
        if (isset(self::$mec_settings['dashboard_event_sec']) && self::$mec_settings['dashboard_event_sec'] == 1 && $can_view) {
            $menu .= '
                <a href="#" data-onClick="mec-ud-events" data-menu="events" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19">
                        <path id="calendar" d="M17.417,19H1.583A1.585,1.585,0,0,1,0,17.417V3.167A1.585,1.585,0,0,1,1.583,1.583H5.542V.792a.792.792,0,1,1,1.583,0v.792h4.75V.792a.792.792,0,0,1,1.583,0v.792h3.958A1.585,1.585,0,0,1,19,3.167v14.25A1.585,1.585,0,0,1,17.417,19ZM13.458,3.167v.792a.792.792,0,0,1-1.583,0V3.167H7.125v.792a.792.792,0,0,1-1.583,0V3.167H1.583v14.25H17.414l0-14.25ZM15.042,14.25H13.458a.792.792,0,0,1-.792-.792V11.875a.792.792,0,0,1,.792-.792h1.583a.792.792,0,0,1,.792.792v1.583A.792.792,0,0,1,15.042,14.25Zm0-4.75H13.458a.792.792,0,0,1-.792-.792V7.125a.792.792,0,0,1,.792-.792h1.583a.792.792,0,0,1,.792.792V8.708A.792.792,0,0,1,15.042,9.5Zm-4.75,4.75H8.708a.792.792,0,0,1-.792-.792V11.875a.792.792,0,0,1,.792-.792h1.583a.792.792,0,0,1,.792.792v1.583A.792.792,0,0,1,10.292,14.25Zm0-4.75H8.708a.792.792,0,0,1-.792-.792V7.125a.792.792,0,0,1,.792-.792h1.583a.792.792,0,0,1,.792.792V8.708A.792.792,0,0,1,10.292,9.5Zm-4.75,4.75H3.958a.792.792,0,0,1-.792-.792V11.875a.792.792,0,0,1,.792-.792H5.542a.792.792,0,0,1,.792.792v1.583A.792.792,0,0,1,5.542,14.25Zm0-4.75H3.958a.792.792,0,0,1-.792-.792V7.125a.792.792,0,0,1,.792-.792H5.542a.792.792,0,0,1,.792.792V8.708A.792.792,0,0,1,5.542,9.5Z" transform="translate(0)" fill-rule="evenodd"/>
                    </svg>
                    <span>'.esc_html__('Events' , 'mec-ud').'</span>
                </a>';
        }
        if ( !empty( MecUserMeta::user_is_organizer(self::$userId) ) && isset(self::$mec_settings['dashboard_organizer_sec']) &&self:: $mec_settings['dashboard_organizer_sec'] == 1 )
            $menu .= '
                <a href="#" data-onClick="mec-ud-organizer" data-menu="organizer" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="18.999" viewBox="0 0 19 18.999"><g id="mec-organizer-icon" transform="translate(-1.5 -2)"><path id="Path_1" data-name="Path 1" d="M13.085,2A4.587,4.587,0,1,0,17.67,6.587,4.589,4.589,0,0,0,13.085,2Zm0,1.311A3.277,3.277,0,1,1,9.81,6.587,3.277,3.277,0,0,1,13.085,3.311Z" transform="translate(-2.413)" fill-rule="evenodd"/><path id="Path_2" data-name="Path 2" d="M2.811,24.553H11a.655.655,0,1,1,0,1.311H2.155a.656.656,0,0,1-.655-.655V23.9A5.9,5.9,0,0,1,7.4,18H11a.655.655,0,1,1,0,1.311H7.4A4.587,4.587,0,0,0,2.811,23.9Z" transform="translate(0 -5.52)" fill-rule="evenodd"/><path id="Path_3" data-name="Path 3" d="M21.761,18a4.259,4.259,0,1,0,4.259,4.259A4.261,4.261,0,0,0,21.761,18Zm0,1.311a2.948,2.948,0,1,1-2.948,2.948A2.95,2.95,0,0,1,21.761,19.311Z" transform="translate(-5.52 -5.52)" fill-rule="evenodd"/><path id="Path_4" data-name="Path 4" d="M23,21.655v1.966a.655.655,0,0,0,1.311,0V21.655a.655.655,0,0,0-1.311,0Z" transform="translate(-7.414 -6.552)" fill-rule="evenodd"/><path id="Path_5" data-name="Path 5" d="M25.621,24H23.655a.655.655,0,1,0,0,1.311h1.966a.655.655,0,1,0,0-1.311Z" transform="translate(-7.415 -7.586)" fill-rule="evenodd"/></g></svg>
                    <span>'.esc_html(\MEC\Base::get_main()->m('taxonomy_organizer', esc_html__('Organizer', 'mec-ud'))).'</span>
                </a>';
        if ( !empty( MecUserMeta::user_is_speaker(self::$userId) ) && isset(self::$mec_settings['dashboard_speaker_sec']) &&self:: $mec_settings['dashboard_speaker_sec'] == 1 )
            $menu .= '
                <a href="#" data-onClick="mec-ud-speaker" data-menu="speaker" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14.088" height="20" viewBox="0 0 14.088 20"><g id="mec-speaker-icon" transform="translate(-127.3 -80)"><path id="Path_1" data-name="Path 1" d="M177.189,93.123a4.2,4.2,0,0,0,4.189-4.185V84.185a4.189,4.189,0,0,0-8.378,0v4.753A4.187,4.187,0,0,0,177.189,93.123Zm-2.939-8.938a2.939,2.939,0,0,1,5.877,0v.225h-2.939a.625.625,0,1,0,0,1.249h2.939v1.8h-2.939a.625.625,0,1,0,0,1.249h2.939v.225a2.939,2.939,0,0,1-5.877,0h0Z" transform="translate(-42.845)"/><path id="Path_2" data-name="Path 2" d="M141.388,215.925a.625.625,0,0,0-1.25,0,5.794,5.794,0,0,1-11.587,0,.625.625,0,0,0-1.25,0,7.048,7.048,0,0,0,6.419,7.008v2.655h-2.425a.625.625,0,1,0,0,1.249h6.1a.625.625,0,1,0,0-1.249h-2.425v-2.655A7.053,7.053,0,0,0,141.388,215.925Z" transform="translate(0 -126.837)"/></g></svg>
                    <span>'.esc_html(\MEC\Base::get_main()->m('taxonomy_speaker', esc_html__('Speaker', 'mec-ud'))).'</span>
                </a>';
        if ( isset(self::$mec_settings['dashboard_reports_sec']) && self::$mec_settings['dashboard_reports_sec'] == 1 )
            $menu .= '
                <a href="#" data-onClick="mec-ud-reports" data-menu="reports" class="mec-ud-menu-ajax-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.002" height="16.342" viewBox="0 0 18.002 16.342"><g id="report-icon" transform="translate(-119.444 -70.754)"><path id="Path_13634" data-name="Path 13634" d="M135.888,85.814H121.022q-.067,0-.135-.006l.171.023a.976.976,0,0,1-.246-.068l.154.064a1.421,1.421,0,0,1-.147-.081c-.083-.051.1.094.051.043-.019-.019-.043-.036-.062-.056s-.032-.034-.047-.051c-.075-.077.085.135.032.041-.028-.049-.058-.1-.081-.147l.064.154a1.074,1.074,0,0,1-.068-.246c.009.058.015.113.023.171a3.96,3.96,0,0,1-.006-.451V73.9c0-.525,0-1.053,0-1.578,0-.045,0-.088.006-.132-.009.058-.015.113-.023.171a.976.976,0,0,1,.068-.246l-.064.154a1.421,1.421,0,0,1,.081-.147c.051-.083-.094.1-.043.051.019-.019.036-.043.056-.062s.034-.032.051-.047c.077-.075-.135.085-.041.032.049-.028.1-.058.147-.081l-.154.064a1.075,1.075,0,0,1,.246-.068l-.171.023a4.188,4.188,0,0,1,.491-.006h14.49q.067,0,.135.006l-.171-.023a.976.976,0,0,1,.246.068l-.154-.064a1.422,1.422,0,0,1,.147.081c.083.051-.1-.094-.051-.043.019.019.043.036.062.056s.032.034.047.051c.075.077-.085-.135-.032-.041.028.049.058.1.081.147l-.064-.154a1.074,1.074,0,0,1,.068.246c-.009-.058-.015-.113-.023-.171a3.956,3.956,0,0,1,.006.451v11.3c0,.525,0,1.053,0,1.578,0,.045,0,.088-.006.132.009-.058.015-.113.023-.171a.977.977,0,0,1-.068.246l.064-.154a1.418,1.418,0,0,1-.081.147c-.051.083.094-.1.043-.051-.019.019-.036.043-.056.062s-.034.032-.051.047c-.077.075.135-.085.041-.032-.049.028-.1.058-.147.081l.154-.064a1.074,1.074,0,0,1-.246.068l.171-.023a1.045,1.045,0,0,1-.115.006.641.641,0,0,0,0,1.281,1.571,1.571,0,0,0,1.525-1.243,2.365,2.365,0,0,0,.034-.406V72.326a1.572,1.572,0,0,0-1.589-1.572H121.1c-.051,0-.1,0-.154,0a1.621,1.621,0,0,0-1.023.436,1.586,1.586,0,0,0-.47,1,4.825,4.825,0,0,0-.006.527V84.954c0,.19,0,.382,0,.572a1.6,1.6,0,0,0,.7,1.311,1.545,1.545,0,0,0,.89.258H135.89a.641.641,0,1,0,0-1.281Z"/><path id="Path_13635" data-name="Path 13635" d="M231.086,267.978v-4.9a.7.7,0,0,0-1.4,0v4.9a.7.7,0,1,0,1.4,0Z" transform="translate(-105.97 -184.512)"/><path id="Path_13636" data-name="Path 13636" d="M334.9,158.725v-7.367c0-.339.009-.68,0-1.021v-.014a.706.706,0,0,0-1.4,0v7.367c0,.339-.009.68,0,1.021v.014a.706.706,0,0,0,1.4,0Z" transform="translate(-205.758 -75.599)"/><path id="Path_13637" data-name="Path 13637" d="M438.9,214.05v-7.3a.7.7,0,1,0-1.4,0v7.3a.7.7,0,1,0,1.4,0Z" transform="translate(-305.722 -130.469)"/></g></svg>
                    <span>'.esc_html__('Report' , 'mec-ud').'</span>
                </a>';

        // if ( isset(self::$mec_settings['dashboard_woocommerce_sec']) && self::$mec_settings['dashboard_woocommerce_sec'] == 1 ) {
        if ( false ) {
            if(class_exists('WooCommerce')) {
                foreach (wc_get_account_menu_items() as $slug => $item) {
                    if($slug == 'customer-logout' || $slug == 'dashboard' || $slug == 'downloads') {
                        continue;
                    }
                    $menu .= '
                        <a href="#" data-onClick="mec-ud-woocommerce-'. $slug . '" class="mec-ud-woocommerce-menu-item">
                            <span>'.esc_html__($item , 'mec-ud').'</span>
                        </a>';
                }
            }
        }

        $menu = apply_filters( 'mec_dashboard_menu', $menu, self::$mec_settings );

        $menu .= '
                <a href="'. wp_logout_url( get_permalink() ) .'" data-onClick="mec-ud-logout" data-menu="logout" class="">
                    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="16.731" viewBox="0 0 19 16.731"><g id="logout-icon-2" transform="translate(-143.245 -98)"><path id="Path_13640" data-name="Path 13640" d="M153.646,103.663a.761.761,0,0,0,.541-.226.777.777,0,0,0,.224-.546v-2.574a2.328,2.328,0,0,0-.672-1.638A2.282,2.282,0,0,0,152.116,98h-6.578a2.281,2.281,0,0,0-1.622.679,2.328,2.328,0,0,0-.672,1.638v12.1a2.328,2.328,0,0,0,.672,1.638,2.282,2.282,0,0,0,1.622.679h6.575a2.282,2.282,0,0,0,1.622-.679,2.328,2.328,0,0,0,.672-1.638V110.1a.774.774,0,0,0-.382-.669.757.757,0,0,0-.765,0,.773.773,0,0,0-.382.669v2.317a.777.777,0,0,1-.224.546.761.761,0,0,1-.541.226h-6.575a.761.761,0,0,1-.541-.226.776.776,0,0,1-.224-.546v-12.1a.776.776,0,0,1,.224-.546.761.761,0,0,1,.541-.226h6.575a.761.761,0,0,1,.541.226.777.777,0,0,1,.224.546v2.574a.777.777,0,0,0,.225.547.761.761,0,0,0,.542.225Z"/><path id="Path_13641" data-name="Path 13641" d="M251.38,181.154a.784.784,0,0,0,.224.55.759.759,0,0,0,.541.228h10.5l-2.834,2.851h0a.787.787,0,0,0-.182.739.771.771,0,0,0,.526.543.755.755,0,0,0,.729-.175l4.156-4.181a.787.787,0,0,0,0-1.107l-4.156-4.176a.756.756,0,0,0-.729-.175.772.772,0,0,0-.526.543.787.787,0,0,0,.182.739l2.834,2.851h-10.5a.758.758,0,0,0-.538.225.786.786,0,0,0-.227.545Z" transform="translate(-103.025 -74.661)"/></g></svg>
                    <span>'.esc_html__('Logout' , 'mec-ud').'</span>
                </a>';

        $menu .= '</div>';

        return $menu;
    }

    /**
     * right content
     *
     * @since     1.0.0
     */
    public static function UD_content()
    {
        if( !is_plugin_active('modern-events-calendar/mec.php') ){
            self::$mec_settings['dashboard_ticket_sec'] = false;
        }

        if ( !function_exists('mec_rsvp_is_enabled') || !mec_rsvp_is_enabled() ) {

            self::$mec_settings['dashboard_rsvp_sec'] = false;
        }

        $styles = '';
        $dash_color = get_user_meta( self::$userId, 'dash_color', true );
        if($dash_color) {
            $styles = '
            .mec-ud-main-content .mec-ud-wrap-header {background: ' . $dash_color . ';}
            .mec-ud-main-content .mec-profile .mec-booking-number-of-attendees i, .mec-ud-main-content .mec-profile .mec-profile-bookings-view-invoice i, .mec-ud-main-content .mec-ud-image-url .image-file+label, .mec-ud-org-image-url .image-file+label, .mec-ud-speaker-image-url .image-file+label, .mec-ud-main-content .mec-profile i, .mec-ud-main-content .mec-ud-menu a.active,.mec-ud-main-content .mec-ud-menu a:focus,.mec-ud-main-content .mec-ud-menu a:hover {color:' . $dash_color . ';}
            .mec-ud-main-content .mec-ud-form.mec-ud-active svg path, .mec-ud-main-content .mec-ud-menu a:hover svg path, .mec-ud-main-content .mec-ud-menu a.active svg path {fill:' . $dash_color . ';}
            .mec-ud-main-content .mec-ud-woocommerce table.woocommerce-orders-table td a.woocommerce-button, .mec-ud-main-content .event-pagination span, .mec-ud-main-content .event-pagination a,.mec-ud-main-content .mec-ud-woocommerce-menu-item:before {background-color: ' . $dash_color . ';box-shadow: 0 0 9px -3px ' . $dash_color . ' !important}
            .mec-ud-main-content .mec-ud-events-add-new a {background-color: ' . $dash_color . ';}
            .mec-ud-main-content .mec-ud-woocommerce .woocommerce-Button, .mec-ud-main-content .mec-ud-woocommerce [type="submit"], .mec-ud-main-content button.mec-ud-submit-form {background-color: ' . $dash_color . ' !important;}
            .mec-ud-wrap .mec-ud-form.mec-ud-active input, .mec-ud-wrap .mec-ud-form.mec-ud-active textarea {border-color:' . $dash_color . ' !important;}';
        }
        $content = '';
        if($styles) {
            //$content = '<style id="mec-udc-css">' . $styles . '</style>';
        }

        $content .= '<div class="mec-ud-content-wrap">';
        if ( isset(self::$mec_settings['dashboard_edit_dashboard']) && self::$mec_settings['dashboard_edit_dashboard'] == 1 ) {
            $content .= self::UD_content_profile();
        }

        // if ( isset(self::$mec_settings['dashboard_woocommerce_sec']) && self::$mec_settings['dashboard_woocommerce_sec'] == 1 )
        if ( false )
        $content .= self::UD_content_woocommerce();
        $content .= '</div>';

        return $content;
    }

    public function dashboard_menu_content(){

        $menu = isset( $_POST['menu'] ) ? $_POST['menu'] : false;

        $content = '';
        switch( $menu ){
            case 'tickets':

                if ( isset(self::$mec_settings['dashboard_ticket_sec']) && self::$mec_settings['dashboard_ticket_sec'] == 1 ){

                    $content = self::UD_content_tickets();
                }
                break;
            case 'rsvps':

                if ( isset(self::$mec_settings['dashboard_rsvp_sec']) && self::$mec_settings['dashboard_rsvp_sec'] == 1 ){

                    $content = self::UD_content_rsvps();
                }
                break;
            case 'waiting-list':

                if ( isset(self::$mec_settings['dashboard_waiting_list_sec']) && self::$mec_settings['dashboard_waiting_list_sec'] == 1 ){

                    $content = self::UD_content_waiting_lists();
                }
                break;
            case 'events':

                if ( isset(self::$mec_settings['dashboard_event_sec']) && self::$mec_settings['dashboard_event_sec'] == 1 ){

                    $content = self::UD_content_events();
                }
                break;
            case 'organizer':

                if ( !empty( MecUserMeta::user_is_organizer(self::$userId) ) && isset(self::$mec_settings['dashboard_organizer_sec']) &&self:: $mec_settings['dashboard_organizer_sec'] == 1 ){

                    $content .= self::UD_content_organizer();
                }
                break;
            case 'speaker':

                if ( !empty(  MecUserMeta::user_is_speaker(self::$userId) ) && isset(self::$mec_settings['dashboard_speaker_sec']) &&self:: $mec_settings['dashboard_speaker_sec'] == 1  ){

                    $content .= self::UD_content_speaker();
                }
                break;
            case 'reports':

                if ( isset(self::$mec_settings['dashboard_reports_sec']) && self::$mec_settings['dashboard_reports_sec'] == 1 ){

                    $content .= self::UD_content_reports();
                }
                break;
            default:

                $output = apply_filters( 'mec_dashboard_content', '', $menu, $this );
                if( !empty( $output ) ) {

                    $content .= '<div id="mec-ud-' . $menu . '" class="mec-ud-' . $menu . ' mec-ud-content"  data-menu="' . $menu . '">'
                        . $output .
                    '</div>';
                }

                break;
        }


        $data = array(
            'content' => $content,
            'menu' => $menu,
        );

        wp_send_json_success( $data );

    }

    /**
     * Profile content
     *
     * @since     1.0.0
     */
    public static function UD_content_profile()
    {
        if( !current_user_can('edit_user', (int)self::$userId) ) return false;
        $userInfo = get_userdata(self::$userId);

        $mec_ud_attachment_id = (int)get_user_meta( (int)self::$userId, 'mec_ud_attachment_id', true );
        if ( !empty(get_avatar_url(self::$userId)) && !empty($mec_ud_attachment_id) ) {
            $avatar =  get_avatar(self::$userId);
        } else {
            $avatar = '<img src="'.get_avatar_url(self::$userId).'" />';
        }

        $first_name = !empty($userInfo->first_name) ? $userInfo->first_name :  esc_html__( 'First Name' , 'mec-ud');
        $last_name = !empty($userInfo->last_name) ? $userInfo->last_name :  esc_html__( 'Last Name' , 'mec-ud');
        $user_email = !empty($userInfo->user_email) ? $userInfo->user_email :  esc_html__( 'E-mail' , 'mec-ud');
        $user_url = !empty($userInfo->user_url) ? $userInfo->user_url :  esc_html__( 'Website' , 'mec-ud');

        $ticket_query = new \WP_Query(array(
            'post_type'=>'mec-books',
            'author'=>self::$userId,
            'posts_per_page'=>'-1',
            'post_status'=>array('pending', 'draft', 'future', 'publish'),
            'orderby'=>'post_date',
            'order'=>'DESC',
            'fields' => 'ids',
        ));
        $ticket_count = $ticket_query->post_count;

        $event_query = new \WP_Query(
            static::add_author_query_to_event_query_args(
                array(
                    'post_type'=>'mec-events',
                    'posts_per_page'=>'-1',
                    'post_status'=>array('pending', 'draft', 'future', 'publish'),
                    'orderby'=>'post_date',
                    'order'=>'DESC',
                    'fields' => 'ids',
                )
        ));
        $event_count = $event_query->post_count;

        $ticket_report_html = '';
        if( is_plugin_active('modern-events-calendar/mec.php') ){

            $ticket_report_html = '<div class="me-ud-spec-ticket"><div>'.$ticket_count.'</div><div>'.esc_html__('Tickets', 'mec-ud').'</div></div>';
        }

        $profile = '
        <div id="mec-ud-profile" class="mec-ud-profile mec-ud-content" data-menu="profile">
            <div class="mec-ud-spec">
                '. $ticket_report_html .'
                <div class="me-ud-spec-event"><div>'.$event_count.'</div><div>'.esc_html__('Events', 'mec-ud').'</div></div>
            </div>
            <form method="post" action="" class="mec-profile-form">
                <div class="row row-ud-nm">
                    <div class="col-md-6 mec-ud-form">
                        <label>'.esc_html__('First Name', 'mec-ud').'</label>
                        <span class="mec-field-wrapper">
                            <span class="mec-field-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16">
                                    <path id="notebook" d="M12,16H2.105c-.019,0-.034-.009-.053-.011S2.019,16,2,16a.666.666,0,0,1-.667-.667V12.667H.667a.667.667,0,0,1,0-1.333h.667V8.667H.667a.667.667,0,0,1,0-1.333h.667V4.667H.667a.667.667,0,1,1,0-1.333h.667V.667A.666.666,0,0,1,2,0c.019,0,.035.009.053.011S2.087,0,2.105,0H12a2,2,0,0,1,2,2V14A2,2,0,0,1,12,16ZM2.667,3.333a.667.667,0,0,1,0,1.333V7.333a.667.667,0,0,1,0,1.333v2.667a.667.667,0,0,1,0,1.333v2H10V1.333H2.667ZM12.667,2A.667.667,0,0,0,12,1.333h-.667V14.667H12A.667.667,0,0,0,12.667,14Z" fill="#c1c5c9" fill-rule="evenodd"/>
                                </svg>
                            </span>
                            <input type="text" name="mec_user_fname" id="mec_user_fname" value="" placeholder='.$first_name.' />
                            <input type="hidden" name="mec_user_fname_hidden" id="mec_user_fname_hidden" value="'.$userInfo->first_name.'" />
                        </span>
                    </div>
                    <div class="col-md-6 mec-ud-form">
                        <label>'.esc_html__('Last Name', 'mec-ud').'</label>
                        <span class="mec-field-wrapper">
                            <span class="mec-field-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16">
                                    <path id="notebook" d="M12,16H2.105c-.019,0-.034-.009-.053-.011S2.019,16,2,16a.666.666,0,0,1-.667-.667V12.667H.667a.667.667,0,0,1,0-1.333h.667V8.667H.667a.667.667,0,0,1,0-1.333h.667V4.667H.667a.667.667,0,1,1,0-1.333h.667V.667A.666.666,0,0,1,2,0c.019,0,.035.009.053.011S2.087,0,2.105,0H12a2,2,0,0,1,2,2V14A2,2,0,0,1,12,16ZM2.667,3.333a.667.667,0,0,1,0,1.333V7.333a.667.667,0,0,1,0,1.333v2.667a.667.667,0,0,1,0,1.333v2H10V1.333H2.667ZM12.667,2A.667.667,0,0,0,12,1.333h-.667V14.667H12A.667.667,0,0,0,12.667,14Z" fill="#c1c5c9" fill-rule="evenodd"/>
                                </svg>
                            </span>
                            <input type="text" name="mec_user_lname" id="mec_user_lname" value="" placeholder='.$last_name.' />
                            <input type="hidden" name="mec_user_lname_hidden" id="mec_user_lname_hidden" value="'.$userInfo->last_name.'" />
                        </span>
                    </div>
                </div>
                <div class="row row-ud-nm">
                    <div class="col-md-6 mec-ud-form">
                        <label>'.esc_html__('Email', 'mec-ud').'</label>
                        <span class="mec-field-wrapper">
                            <span class="mec-field-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16.053" height="16" viewBox="0 0 16.053 16">
                                    <path id="envelope-open" d="M13.976,15.986H2.051A2.057,2.057,0,0,1,0,13.979V7.29a.616.616,0,0,1,.35-.528L7.568.159a.661.661,0,0,1,.892,0l7.206,6.592a.628.628,0,0,1,.388.539v6.689A2.08,2.08,0,0,1,13.976,15.986Zm.739-2.132v-5.2l-3.181,2.581Zm-1.122.8-5.579-4.6-5.58,4.6Zm-12.255-.82,3.154-2.6L1.338,8.672ZM8.014,1.554,1.744,7.289l3.8,3.081,1.8-1.48a1.093,1.093,0,0,1,1.352,0l1.8,1.484,3.8-3.081Z" transform="translate(0 0.014)" fill="#c1c5c9" fill-rule="evenodd"/>
                                </svg>
                            </span>
                            <input type="text" name="mec_user_email" id="mec_user_email" value="" placeholder='.$user_email.' />
                            <input type="hidden" name="mec_user_email_hidden" id="mec_user_email_hidden" value="'.$userInfo->user_email.'" />
                        </span>
                    </div>
                    <div class="col-md-6 mec-ud-form">
                        <label>'.esc_html__('Website', 'mec-ud').'</label>
                        <span class="mec-field-wrapper">
                            <span class="mec-field-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                    <path id="globe-1" d="M8,15.992a8,8,0,1,1,8-8A8.009,8.009,0,0,1,8,15.992Zm5.751-4.667H12.1a10.4,10.4,0,0,1-1.455,2.781A6.7,6.7,0,0,0,13.751,11.325Zm-3.078,0H8.667v3.023A9.162,9.162,0,0,0,10.673,11.325Zm.66-3.333a8.8,8.8,0,0,0-.245-2.023H8.667V9.992h2.427A8.753,8.753,0,0,0,11.333,7.992Zm-4,3.333H5.326A9.148,9.148,0,0,0,7.333,14.35ZM5.347,14.1a10.4,10.4,0,0,1-1.452-2.779H2.249A6.7,6.7,0,0,0,5.347,14.1ZM1.333,7.992a6.614,6.614,0,0,0,.31,2h1.9a10.244,10.244,0,0,1-.205-2,10.2,10.2,0,0,1,.211-2.024H1.652A6.613,6.613,0,0,0,1.333,7.992Zm.915-3.333H3.9A10.382,10.382,0,0,1,5.351,1.877,6.7,6.7,0,0,0,2.249,4.659ZM7.333,1.638A9.145,9.145,0,0,0,5.327,4.659H7.333ZM4.913,5.969a8.458,8.458,0,0,0-.007,4.023H7.333V5.969Zm3.754-1.31h2.007A9.158,9.158,0,0,0,8.667,1.636Zm1.985-2.78A10.389,10.389,0,0,1,12.1,4.659h1.647A6.7,6.7,0,0,0,10.651,1.879Zm3.7,4.09H12.456a10.183,10.183,0,0,1,.211,2.023,10.212,10.212,0,0,1-.206,2h1.9a6.6,6.6,0,0,0-.009-4.023Z" transform="translate(0 0.008)" fill="#c1c5c9" fill-rule="evenodd"/>
                                </svg>
                            </span>
                            <input type="text" name="mec_user_url" id="mec_user_url" value="" placeholder='.$user_url.' />
                            <input type="hidden" name="mec_user_url_hidden" id="mec_user_url_hidden" value="'.$userInfo->user_url.'" />
                        </span>
                    </div>
                </div>
                <div class="row row-ud-nm mec-ud-dashboard-color">
                    <div class="col-md-12">
                        <h5 class="mec-ud-form-subtitle">'.esc_html__('Dashboard Color Skin','mec-ud').'</h5>
                        <div class="dashbord-custom-color">
                            <span data-color="gray" class="gray-color"></span>
                            <span data-color="#ff3b3b" class="red-color"></span>
                            <span data-color="#008AFF" class="blue-color"></span>
                            <span data-color="#e2cf28" class="yellow-color"></span>
                            <span data-color="#8BC34A" class="green-color"></span>
                            <span data-color="#E91E63" class="pink-color"></span>
                            <span data-color="#9C27B0" class="purple-color"></span>
                            <span data-color="#009688" class="cyan-color"></span>
                            <input type="hidden" name="mec_user_dash_color" id="mec_user_das_color_hidden" value="'.get_user_meta( self::$userId, 'dash_color', true ).'" />
                        </div>
                    </div>
                </div>';

                if( current_user_can('upload_files') ) {

                    $profile .= '<div class="row row-ud-nm mec-ud-image">
                        <div class="col-md-12">
                            <h5 class="mec-ud-form-subtitle">'.esc_html__('Profile Picture', 'mec-ud').'</h5>
                            <div class="mec-ud-image-upload">
                                <div class="mec-ud-image-box">
                                    <input type="number" name="mec_ud_attachment_id" class="mec-ud-attachment-id" value="'. $mec_ud_attachment_id.'" />
                                    <div class="mec-ud-attachment-image">'.$avatar.'</div>
                                    <div class="mec-avatar-preview"></div>
                                </div>
                                <div class="mec-ud-image-url">
                                    <p><input type="file" id="file" name="async-upload" class="image-file" accept="image/*" required>
                                    <label for="file" />'.esc_html__('Change Profile Picture', 'mec-ud').'</label></p>
                                    <input type="hidden" name="image_id">
                                    <input type="hidden" name="mec_ud_userID" value="'.self::$userId.'">
                                    <input type="hidden" name="action" value="image_submission">
                                    <p class="image-notice">'.esc_html__('No File Choosen', 'mec-ud').'</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5"></div>
                    </div>';
                }

                $profile .= '<div class="row row-ud-nm">
                    <div class="col-md-12"><button class="mec-ud-submit-form mec-ud-submit-profile"><span>'.esc_html__('Save Changes' ,'mec-ud').'</span></button></div>
                </div>
            </form>
        </div>
        ';
        return $profile;
    }

    /**
     * Tickets content
     *
     * @since     1.0.0
     */
    public static function UD_content_tickets()
    {
        $output = '<div id="mec-ud-tickets" class="mec-ud-tickets mec-ud-content"  data-menu="tickets">'.do_shortcode('[MEC_profile]').'</div>';

        return $output;
    }

    public static function UD_content_rsvps() {

        $output = '<div id="mec-ud-rsvps" class="mec-ud-rsvps mec-ud-content"  data-menu="rsvps">'
            . do_shortcode('[mec-my-rsvps hide_actions="yes"]')
        .'</div>';

        return $output;
    }



    public static function get_dashboard_url(){

        $dashboard_url = isset( $_POST['p_url'] ) ? $_POST['p_url'] : '';

        return $dashboard_url;
    }

    public static function get_base_pagenum_link(){

        $dashboard_url = self::get_dashboard_url();
        $url = str_replace(
            admin_url('admin-ajax.php'),
            $dashboard_url,
            get_pagenum_link(9999)
        );

        $url = str_replace( 9999, '%#%', $url );

        return $url;
    }

    public static function UD_content_waiting_lists() {

        return '<div id="mec-ud-waiting-list" class="mec-ud-waiting-list mec-ud-content"  data-menu="waiting-list">'
                . do_shortcode('[mec-my-waiting-list hide_actions="no"]')
            .'</div>';
    }

    public static function get_events_query( $args = array() ) {
        $query = new \WP_Query(
            static::add_author_query_to_event_query_args(
                array(
                    'post_type'=>'mec-events',
                    'posts_per_page'=>'-1',
                    'post_status'=>array('pending', 'draft', 'future', 'publish'),
                    'orderby'=>'post_date',
                    'order'=>'DESC',
                    'fields' => 'ids',
                )
        ));

        return $query;
    }

    /**
     * Events content
     *
     * @since     1.0.0
     */
    public static function UD_content_events()
    {
        $args = array();
        $query = self::get_events_query( $args );
        $date_format = static::$mec_settings['dashboard_date_format1'] ?? get_option('date_format');

        $hide_delete_button = (bool)\MEC\Settings\Settings::getInstance()->get_settings('dashboard_events_hide_delete_button');
        $hide_edit_button = (bool)\MEC\Settings\Settings::getInstance()->get_settings('dashboard_events_hide_edit_button');
        $can_display_actions_column = $hide_delete_button && $hide_edit_button ? false : true;

        $output = '<div id="mec-ud-events" class="mec-ud-events mec-ud-content" data-menu="events">';
        if($query->have_posts()):
            $output .= '
            <div class="clearfix mec-ud-events-title">
                <div class="col-xs-1">
                    <span>'.esc_html__('ID' , 'mec-ud').'</span>
                </div>
                <div class="col-xs-4">
                    <span>'.esc_html__('Events' , 'mec-ud').'</span>
                </div>
                <div class="col-xs-2">
                    <span>'.esc_html__('Start Date' , 'mec-ud').'</span>
                </div>
                <div class="col-xs-2">
                    <span>'.esc_html__('Status' , 'mec-ud').'</span>
                </div>
                <div class="col-xs-2 mec-ud-download-attendees">
                    <span>'.esc_html__('Attendees' , 'mec-ud').'</span>
                </div>';

            if( $can_display_actions_column ) {

                $output .= '<div class="col-xs-2">
                        <span>'.esc_html__('Edit' , 'mec-ud').'</span>
                    </div>';
            }

            $output .= '
            </div>
            <div class="mec-ud-events-list">';
                while($query->have_posts()): $query->the_post();
                    global $post;
                    $status = self::$main_class->get_event_label_status(trim(get_post_status()));
                    $event_status = get_post_status(get_the_ID());
                    $output .= '
                    <div class="mec-fes-export-wrapper mec-fes-ud-export-wrapper mec-modal-wrap lity-hide" id="mec-fes-export-wrapper-'.get_the_ID().'" data-event-id="'. get_the_ID() .'">
                        <div class="mec-fes-btn-date">';
                        $mec_repeat_info = get_post_meta(get_the_ID(), 'mec_repeat', true);
                        $ids_text_field = '';

                        if(isset($mec_repeat_info['status']) and $mec_repeat_info['status']):
                            $output .= '<ul class="mec-export-list-wrapper">';
                            $past_month = strtotime('-1month', current_time('timestamp', 0));
                            $past_week = strtotime('-7 days', current_time('timestamp', 0));

                            $render = self::$fes_class->getRender();
                            $dates = $render->dates(get_the_ID(), NULL, 15, date('Y-m-d', $past_week));

                            // Attnedees
                            $current_user_id = is_user_logged_in() ? get_current_user_id() : false;
                            $current_user_books = self::$fes_class->db->select("SELECT `ID` FROM `#__posts` WHERE `post_type`='mec-books' AND `post_author`={$current_user_id}", 'loadAssocList');
                            $all_books_ids_info = array();

                            if(is_array($current_user_books) and count($current_user_books)):

                                foreach($current_user_books as $current_user_book):

                                    $book_ids_info = array();
                                    $book_ids_info['id'] = $current_user_book['ID'];
                                    $book_ids_info['info'] = array();
                                    $books_meta_info = self::$fes_class->db->select("SELECT `post_id`, `meta_key`, `meta_value` FROM `#__postmeta` WHERE `post_id`={$current_user_book['ID']}", 'loadAssocList');

                                    if(is_array($books_meta_info) and count($books_meta_info))
                                    {
                                        $books_data = array();
                                        foreach($books_meta_info as $book_meta_info)
                                        {
                                            $books_data = array_merge($books_data, array(trim($book_meta_info['meta_key']) => $book_meta_info['meta_value']));
                                        }
                                        $book_ids_info['info'] = $books_data;
                                        array_push($all_books_ids_info, $book_ids_info);

                                        if( isset($book_ids_info['info']['mec_event_id']) && get_the_ID() == $book_ids_info['info']['mec_event_id']) $ids_text_field .= $book_ids_info['id'] . ',';
                                    }
                                endforeach;
                            endif;
                            $book = self::$fes_class->getBook();
                            $main = new \MEC_main();
                            foreach($dates as $date):
                                if(isset($date['start']['date']) and isset($date['end']['date']))
                                {
                                    $attendees_count = 0;

                                    $bookings = $main->get_bookings(get_the_ID(), $date['start']['timestamp']);
                                    foreach($bookings as $booking)
                                    {
                                        $attendees_count += $book->get_total_attendees($booking->ID);
                                    }

                                    $output .= '<li class="mec-export-list-item" data-time="'.$date['start']['timestamp'].'">'. $main->date_label($date['start'], $date['end'], $date_format).' <span class="mec-export-badge">'. $attendees_count.'</span></li>';

                                }
                            endforeach;
                            $output .='</ul>';
                            else:
                            $output .='<div class="date-messgae"> '.__('Event is not repeating. No dates exist for this event!', 'mec-ud') .'</div>';
                            endif;
                            $output .='<input type="hidden" class="mec-certain-user-booking-ids" value="'. $ids_text_field .'">
                        </div>';

                        $mec_repeat_info = get_post_meta(get_the_ID(), 'mec_repeat', true);
                        $date_start = get_post_meta( get_the_ID(), 'mec_start_date', true );

                        $output .= '
                        <div class="mec-fes-btn-export">
                            <span class="mec-event-export-csv">'.esc_html__('CSV', 'mec-ud').'</span>
                            <span class="mec-event-export-excel">'.esc_html__('MS EXCEL', 'mec-ud').'</span>
                        </div>
                    </div>
                    <div id="mec_fes_event_'. get_the_ID() .'" class="clearfix mec-ud-events-list-item">
                        <div class="col-xs-1">
                            <span class="mec-fes-ud-event-id">' . get_the_ID() . '</span>
                        </div>
                        <div class="col-xs-4">
                            <span class="mec-fes-ud-event-title"><a href="'. get_post_permalink(get_the_ID()) .'">'. get_the_title() .'</a></span>
                        </div>
                        <div class="col-xs-2">
                            <span class="mec-fes-ud-event-date mec-event-start-date">' . date_i18n( $date_format, strtotime( $date_start ) ) .'</span>
                        </div>
                        <div class="col-xs-2">
                            <span class="mec-fes-ud-event-view mec-event-status '. $status['status_class'] .'">'. $status['label'] .'</span>
                        </div>';
                        if(isset($event_status) and strtolower($event_status) == 'publish'):
                    $output .= '
                        <div class="col-xs-2 mec-ud-download-attendees">
                            <span class="mec-fes-ud-event-export"><a href="#" data-lity-target="#mec-fes-export-wrapper-'.get_the_ID().'" data-lity><div class="wn-p-t-right"><div class="wn-p-t-text-content">'. esc_html__('Download Attendees', 'mec-ud') .'</div><i></i></div></a></span>
                        </div>';
                        endif;

                    if( $can_display_actions_column ) {
                        $output .='<div class="col-xs-2">';
                            if( current_user_can('delete_post', get_the_ID()) && !$hide_delete_button ):
                                $output .= '
                                    <span class="mec-fes-ud-event-remove mec-fes-event-remove" data-confirmed="0" data-id="'. get_the_ID() .'"><div class="wn-p-t-right"><div class="wn-p-t-text-content">'. esc_html__('Remove Event', 'mec-ud') .'</div><i></i></div></span>';
                            endif;
                            if(  !$hide_edit_button ):
                                $output .='
                                    <span class="mec-fes-ud-event-view"><a href="'. self::$fes_class->link_edit_event(get_the_ID()) .'"><div class="wn-p-t-right"><div class="wn-p-t-text-content">'. esc_html__('Edit Event', 'mec-ud') .'</div><i></i></div></a></span>';
                            endif;
                        $output .= '</div>';
                    }
                    $output .= '</div>';

                endwhile;
                $paged = isset( $_POST['paged'] ) ? $_POST['paged'] : 1;
                $output .= '<div class="event-pagination">';
                $output .= paginate_links( array(
                    'base' => self::get_base_pagenum_link(),
                    'format' => '?paged=%#%',
                    'current' => max( 1,  $paged ),
                    'prev_text' => __('Previous' , 'mec-ud'),
                    'next_text' => __('Next' , 'mec-ud'),
                    'total' => $query->max_num_pages
                ) );
                $output .= '</div>';
                wp_reset_postdata();
                $output .= '
            </div>';

            $can_add_new = self::current_user_can_event('add_new');
            if( $can_add_new ) {
                $output .= '<div class="mec-ud-events-add-new">
                    <a class="button" href="'. self::$fes_class->link_add_event() .'"><span>'. esc_html__('Add new', 'mec-ud') .'</span></a>
                </div>';
            }
            if(get_query_var('paged')) {
                $output .= '<script>
                jQuery(document).ready(function() {
                    jQuery("a[data-onclick=\"mec-ud-events\"]").trigger("click");
                });
                </script>';
            }
            $output .= '<script type="text/javascript">
            jQuery(document).ready(function()
            {
                jQuery(".mec-fes-event-remove").on("click", function(event)
                {
                    var id = jQuery(this).data("id");
                    var confirmed = jQuery(this).data("confirmed");

                    if(confirmed == "0")
                    {
                        jQuery(this).data("confirmed", "1");
                        jQuery(this).addClass("mec-fes-waiting");
                        jQuery(this).find(".wn-p-t-right").remove();
                        jQuery(this).append("<div class=\"confirm-remove-notice wn-p-t-right\"><div class=\"wn-p-t-text-content\">'. esc_html__('Click again to remove!', 'mec-ud') .'</div><i></i></div>");

                        return false;
                    }

                    // Add loading class to the row
                    jQuery("#mec_fes_event_"+id).addClass("loading");

                    jQuery.ajax(
                    {
                        type: "POST",
                        url: "'.admin_url('admin-ajax.php', NULL).'",
                        data: "action=mec_fes_remove&_wpnonce='.wp_create_nonce('mec_fes_remove').'&post_id="+id,
                        dataType: "JSON",
                        success: function(response)
                        {
                            if(response.success == "1")
                            {
                                // Remove the row
                                jQuery("#mec_fes_event_"+id).remove();
                            }
                            else
                            {
                                // Remove the loading class from the row
                                jQuery("#mec_fes_event_"+id).removeClass("loading");
                            }
                        },
                        error: function(jqXHR, textStatus, errorThrown)
                        {
                            // Remove the loading class from the row
                            jQuery("#mec_fes_event_"+id).removeClass("loading");
                        }
                    });
                });
            });
            </script>';
        else :
           $output .= '
           <div>' .esc_html__('No events found!', 'mec-ud'). '</div>';
           $can_add_new = self::current_user_can_event('add_new');
           if( $can_add_new ) {
            $output .= '<div class="mec-ud-events-add-new">
                    <a href="'. self::$fes_class->link_add_event() .'"><span>'. esc_html__('Add new', 'mec-ud') .'</span></a>
                </div>';
            }
        endif;
        $output .= '</div>';
        return $output;
    }

    /**
     * WooCommerce content
     *
     * @since     1.0.0
     */
    public static function UD_content_woocommerce()
    {
        $output = "";
        if (isset(self::$mec_settings['dashboard_woocommerce_sec']) && self::$mec_settings['dashboard_woocommerce_sec'] == 1) {
            if (class_exists('WooCommerce')) {
                $myAccountUrl = get_permalink( get_option('woocommerce_myaccount_page_id'));
                foreach (wc_get_account_menu_items() as $slug => $item) {
                    $output .= '<div id="mec-ud-woocommerce-'. $slug .'" class="mec-ud-woocommerce mec-ud-content"  data-menu="woocommerce">';
                    if (has_action('woocommerce_account_' . $slug . '_endpoint')) {
                        ob_start();
                        do_action('woocommerce_account_' . $slug . '_endpoint', '');
                        $output .= ob_get_clean();
                    }
                    $output .= '</div>';
                }

                $output = str_replace(substr(esc_url(wc_get_endpoint_url('', '')),0,-1), $myAccountUrl , $output);
            }
        }

        return $output;
    }

    /**
     * Reports
     *
     * @since     1.0.0
     */
    public static function UD_content_reports()
    {
        $query = self::get_events_query();

        $date_format = static::$mec_settings['dashboard_date_format1'] ?? 'Y-m-d';

        $render = self::$fes_class->getRender();
        $past_month = strtotime('-1month', current_time('timestamp', 0));
        $countt = $total_price = 0;

        $output = '<div id="mec-ud-reports" class="mec-ud-reports mec-ud-content" data-menu="reports">';

        // Reports Select Event
        $output .= '<div class="mec-ud-reports-head-select mec-search-form clearfix">';
            $output .= '<div class="mec-ud-reports-select-events"><label>'. esc_html__( 'Select Event' , 'mec-ud') .'</label><select name="mec-ud-report-event-id" class="mec-ud-reports-selectbox mec-ud-reports-selectbox-event"><option value="all">'. esc_html__( 'All' , 'mec-ud') .'</option>';
            if($query->have_posts()):
                while($query->have_posts()): $query->the_post();
                    $output .= '<option value="'.get_the_ID().'">' . get_the_title() . '</option>';
                    $past_week = strtotime('-7 days', current_time('timestamp', 0));
                    $dates = $render->dates(get_the_ID(), NULL, 15, date('Y-m-d', $past_week));
                    $current_user_books = self::$fes_class->db->select("SELECT `ID` FROM `#__posts` WHERE `post_type`='mec-books'", 'loadColumn');
                    $all_books_ids_info = array();
                    $ids_text_field = '';
                    $stats = '';
                    $labels = '';
                    $book_ids_info = array();
                    if(is_array($current_user_books) and count($current_user_books)):
                        foreach($current_user_books as $current_user_book_id => $current_user_book):
                            $books_meta_info = self::$fes_class->db->select("SELECT `post_id`, `meta_key`, `meta_value` FROM `#__postmeta` WHERE `post_id`={$current_user_book}", 'loadAssocList');

                            if(is_array($books_meta_info) and count($books_meta_info))
                            {
                                $books_data = array();
                                foreach($books_meta_info as $book_meta_info)
                                {
                                    $books_data = array_merge($books_data, array(trim($book_meta_info['meta_key']) => $book_meta_info['meta_value']));
                                }
                                $book_ids_info[$current_user_book_id]['id'] = $current_user_book;
                                $book_ids_info[$current_user_book_id]['info'] = $books_data;

                                if(get_the_ID() == $book_ids_info[$current_user_book_id]['info']['mec_event_id']) $ids_text_field .= $book_ids_info[$current_user_book_id]['id'] . ',';
                            }
                        endforeach;
                    endif;
                    foreach($dates as $date):
                        if(isset($date['start']['date']) and isset($date['end']['date'])):
                            $attendees_count = 0;
                            $certain_date_ids = "";
                            $render_date = $date['start']['timestamp'].':'.$date['end']['timestamp'];
                            if ( !empty($book_ids_info) ) :
                                foreach($book_ids_info as $book_info)
                                {
                                    if((isset($book_info['info']['mec_date']) and trim($book_info['info']['mec_date']) == $render_date) and (isset($book_info['info']['mec_event_id']) and trim($book_info['info']['mec_event_id']) == get_the_ID()))
                                    {

                                        if(isset($book_info['info']['mec_attendees']))
                                        {

                                            $attendees_info = unserialize($book_info['info']['mec_attendees']);

                                            $certain_date_ids .= $book_info['id'] . ',';
                                            if (isset($attendees_info)):
                                                foreach($attendees_info as $attendees_info)
                                                {
                                                    $c = isset( $attendees_info['count'] ) ? $attendees_info['count'] : 0;
                                                    $attendees_count += $c;
                                                }
                                            endif;
                                        }
                                        if(isset($book_info['info']['mec_price']))
                                        {

                                            $total_price += $book_info['info']['mec_price'];
                                        }
                                    }
                                }
                            endif;
                            $countt += $attendees_count;
                        endif;
                    endforeach;
                endwhile;
            endif;
            $output .= '</select></div>'; // Close .mec-ud-reports-select-events
        $output .= '</div>'; // Close .mec-ud-reports-head-select

        // Reports Number
        $output .= '
        <div class="mec-ud-reports-number">
            <div class="mec-ud-spec">
                <div class="mec-ud-reports-number-spec-ticket"><div>'. $countt .'</div><div>'. esc_html__( 'Tickets' , 'mec-ud') .'</div></div>
                <div class="mec-ud-reports-number-spec-total"><div><span>'. self::$main_class->get_currency_sign() . '</span><span>' . $total_price .'</span></div><div>'. esc_html__( 'Total' , 'mec-ud') .'</div></div>
            </div>
        </div>';

        $output .= '<ul class="mec-ud-reports-select-main-reports"><li class="mec-ud-reports-button mec-ud-btn-sales mec-selected">'. esc_html__( 'Sales' , 'mec-ud') .'</li><li class="mec-ud-reports-button mec-ud-btn-gateways">'. esc_html__( 'Gateways' , 'mec-ud') .'</li></ul>';

        // Sales Report
        $start_placeholder = date('Y-m-d', strtotime('-15 days'));
        $end_placeholder = date('Y-m-d', strtotime('+15 days'));
        $start = date('Y-m-d', strtotime('-15 days')) .' 00:00:00';
        $end = date('Y-m-d' , strtotime('+15 days')) . ' 23:59:59';
        $type = 'daily';
        $chart = 'line';
        $periods = self::$main_class->get_date_periods($start_placeholder, $end_placeholder, $type);

        $stats = '';
        $labels = '';
        $ud_gateway_labels = array();
        $args = array(
            'post_type' => 'mec-books',
            'numberposts' => -1,
            'post_status' => 'any',
            'meta_query' => array(
            array(
                'key' => 'mec_book_date_submit',
                'compare' => 'BETWEEN',
                'value' => array(date('YmdHis',strtotime($start)) , date('YmdHis',strtotime($end))),
            ),
            )
        );
        $book_posts = get_posts($args);

        foreach($periods as $period)
        {
            $date = date_i18n($date_format, strtotime($period['label']));
            $information[$date] = 0;
        }

        foreach ($book_posts as $keyy => $valuee)
        {
            foreach ($information as $key => $value)
            {
                if ( $key == date_i18n($date_format, strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                {
                    $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                    $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                    $information[$key] += intval($total_sells);
                }
            }
        }

        $numItems = count($information);
        $i = 0;
        foreach ($information as $array_label => $array_data)
        {
            if(++$i === $numItems) {
                $labels .= $array_label.'';
                $stats .= $array_data.'';
            } else {
                $labels .= $array_label.',';
                $stats .= $array_data.',';
            }

        }

        // Gateway Report
        $labelss = '';
        $data = '';
        $bg_colors = '';
        $ii = 0;
        $ud_pie_data = array_count_values($ud_gateway_labels);
        $final_pie_data = array();
        $main = new \MEC_main();
        $db = $main->getDB();
        $results = $db->select("SELECT COUNT(`meta_id`) AS count, `meta_value` AS gateway FROM `#__postmeta` WHERE `meta_key`='mec_gateway' GROUP BY `meta_value`", 'loadAssocList');
        foreach($results as $result)
        {
            if (!class_exists($result['gateway'])) {
                continue;
            }

            $gateway = new $result['gateway'];
            $final_pie_data[$gateway->title()]['count'] = $result['count'];
            $final_pie_data[$gateway->title()]['color'] = $gateway->color();
        }
        // foreach ($ud_pie_data as $gateway_label => $count) {
        //     if( $gateway_label == 'Pay Locally' ) {
        //         $gateway = new \MEC_gateway_pay_locally();
        //     } elseif ( $gateway_label == 'Stripe' ) {
        //         $gateway = new \MEC_gateway_stripe();
        //     } elseif ( $gateway_label == 'PayPal Express' ) {
        //         $gateway = new \MEC_gateway_paypal_express();
        //     } elseif ( $gateway_label == 'PayPal Credit Card' ) {
        //         $gateway = new \MEC_gateway_paypal_credit_card();
        //     } elseif ( $gateway_label == 'Pay by WooCommerce' ) {
        //         $gateway = new \MEC_gateway_woocommerce();
        //     } elseif ( $gateway_label == 'Stripe Connect' ) {
        //         $gateway = new \MEC_gateway_stripe_connect();
        //     }
        //     $final_pie_data[$gateway_label]['count'] =  $count;
        //     $final_pie_data[$gateway_label]['color'] =  $gateway->color();
        // }

        $numItemss = count($final_pie_data);

        foreach ($final_pie_data as $pie_labels => $pie_data) {

            if(++$ii === $numItemss) {
                $labelss .= $pie_labels;
                $data .= ((int) $pie_data['count']);
                $bg_colors .= $pie_data['color'];
            } else {
                $labelss .= $pie_labels.',';
                $data .= ((int) $pie_data['count']).',';
                $bg_colors .= $pie_data['color'].',';
            }
        }

        $output .= '
        <div class="mec-ud-reports-filters-wrap mec-ud-reports-sales-wrap active">
            <form class="mec-ud-reports-filters mec-ud-sales-report" method="GET" action="">
                <input name="mec-ud-date" type="hidden" value="'.$labels.'" />
                <input name="mec-ud-data" type="hidden" value="'.$stats.'" />
                <input name="mec-ud-sign" type="hidden" value="'.self::$main_class->get_currency_sign().'" />
                <input type="text" class="mec-ud-filter-start mec_date_picker" name="start" placeholder="'. esc_attr__('Start Date', 'mec-ud') .'" value="'. $start_placeholder .'" />
                <input type="text" class="mec-ud-filter-end mec_date_picker" name="end" placeholder="'. esc_attr__('End Date', 'mec-ud') .'" value="'. $end_placeholder .'" />
                <select name="type">
                    <option value="daily">'. esc_html__('Daily', 'mec-ud') .'</option>
                    <option value="monthly">'. esc_html__('Monthly', 'mec-ud') .'</option>
                    <option value="yearly">'. esc_html__('Yearly', 'mec-ud') .'</option>
                </select>
                <select name="chart">
                    <option value="line">'. esc_html__('Line', 'mec-ud') .'</option>
                    <option value="bar">'. esc_html__('Bar', 'mec-ud') .'</option>
                </select>
                <button type="submit">'. esc_html__('Filter', 'mec-ud') .'</button>
            </form>
            <canvas id="mec_ud_reports_chatrs" width="600" height="300"></canvas>
        </div>

        <div class="mec-ud-reports-filters-wrap mec-ud-reports-gateway-wrap">
            <form class="mec-ud-reports-filters mec-ud-gateway-report" method="GET" action="">
                <input name="mec-ud-pie-lables" type="hidden" value="'.$labelss.'" />
                <input name="mec-ud-pie-data" type="hidden" value="'.$data.'" />
                <input name="mec-ud-pie-colors" type="hidden" value="'.$bg_colors.'" />
            </form>
            <canvas id="mec_ud_gateways_chart" width="200" height="200"></canvas>
        </div>
        ';

        $output .= '</div>'; // Close .mec-ud-reports

        return $output;
    }

    /**
     * Get tickets and toal for each event via Ajax
     *
     * @since     1.0.0
     */
    public function get_tickets_and_total()
    {
        $date_format = static::$mec_settings['dashboard_date_format1'] ?? 'Y-m-d';

        $event_id = sanitize_text_field($_POST['event_id']);
        $fes_class = new \MEC_feature_fes();
        $main = new \MEC_main();
        $render = $fes_class->getRender();
        $past_month = strtotime('-1month', current_time('timestamp', 0));
        $total_price = $countt = 0;
        $start_placeholder = sanitize_text_field($_POST['start']);
        $end_placeholder =sanitize_text_field($_POST['end']);
        $start = sanitize_text_field($_POST['start']) . ' 00:00:00';
        $end = sanitize_text_field($_POST['end']) . ' 23:59:59';
        $type = sanitize_text_field($_POST['type']);
        $periods = $main->get_date_periods($start_placeholder, $end_placeholder, $type);
        $stats = '';
        $labels = '';
        $ud_gateway_labels = array();
        if ( $event_id == 'all' ) {
            $query = self::get_events_query();

            if($query->have_posts()):
                while($query->have_posts()): $query->the_post();

                    $past_week = strtotime('-7 days', current_time('timestamp', 0));
                    $dates = $render->dates(get_the_ID(), NULL, 15, date('Y-m-d', $past_week));
                    $current_user_books = $fes_class->db->select("SELECT `ID` FROM `#__posts` WHERE `post_type`='mec-books'", 'loadColumn');
                    $all_books_ids_info = array();
                    $ids_text_field = '';
                    $stats = '';
                    $labels = '';
                    $book_ids_info = array();

                    if(is_array($current_user_books) and count($current_user_books)):
                        foreach($current_user_books as $current_user_book_id => $current_user_book):
                            $books_meta_info = $fes_class->db->select("SELECT `post_id`, `meta_key`, `meta_value` FROM `#__postmeta` WHERE `post_id`={$current_user_book}", 'loadAssocList');

                            if(is_array($books_meta_info) and count($books_meta_info))
                            {
                                $books_data = array();
                                foreach($books_meta_info as $book_meta_info)
                                {
                                    $books_data = array_merge($books_data, array(trim($book_meta_info['meta_key']) => $book_meta_info['meta_value']));
                                }
                                $book_ids_info[$current_user_book_id]['id'] = $current_user_book;
                                $book_ids_info[$current_user_book_id]['info'] = $books_data;

                                if(get_the_ID() == $book_ids_info[$current_user_book_id]['info']['mec_event_id']) $ids_text_field .= $book_ids_info[$current_user_book_id]['id'] . ',';
                            }
                        endforeach;
                    endif;

                    foreach($dates as $date):
                        if(isset($date['start']['date']) and isset($date['end']['date'])):
                            $attendees_count = 0;
                            $certain_date_ids = "";
                            $render_date = $date['start']['timestamp'].':'.$date['end']['timestamp'];
                            if ( !empty($book_ids_info) ) :
                                foreach($book_ids_info as $book_info)
                                {

                                    if((isset($book_info['info']['mec_date']) and trim($book_info['info']['mec_date']) == $render_date) and (isset($book_info['info']['mec_event_id']) and trim($book_info['info']['mec_event_id']) == get_the_ID()))
                                    {
                                        if(isset($book_info['info']['mec_attendees']))
                                        {

                                            $attendees_info = unserialize($book_info['info']['mec_attendees']);
                                            $certain_date_ids .= $book_info['id'] . ',';
                                            foreach($attendees_info as $attendees_info)
                                            {
                                                $attendees_count += $attendees_info['count'];
                                            }
                                        }
                                        if(isset($book_info['info']['mec_price']))
                                        {

                                            $total_price += $book_info['info']['mec_price'];
                                        }
                                    }
                                }
                            endif;
                            $countt += $attendees_count;
                        endif;
                    endforeach;

                endwhile;
            endif;

            $args = array(
                'post_type' => 'mec-books',
                'post_status' => 'any',
                'numberposts' => -1,
                'meta_query' => array(
                'relation' => 'AND',
                    array(
                        'key' => 'mec_book_date_submit',
                        'compare' => 'BETWEEN',
                        'value' => array(date('YmdHis',strtotime($start)) , date('YmdHis',strtotime($end))),
                    ),
                )
            );
            $book_posts = get_posts($args);

            foreach($periods as $period)
            {
                $information[$period['label']] = 0;
            }

            foreach ($book_posts as $keyy => $valuee)
            {
                foreach ($information as $key => $value)
                {

                    if ( $type == 'monthly')
                    {
                        if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))) . ' ' . date_i18n('F', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                    if ( $type == 'daily')
                    {
                        if ( $key == date_i18n($date_format, strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                    if ( $type == 'yearly')
                    {
                        if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                }
            }

            $numItems = count($information);
            $i = 0;
            foreach ($information as $array_label => $array_data)
            {
                if(++$i === $numItems) {
                    $labels .= $array_label.'';
                    $stats .= $array_data.'';
                } else {
                    $labels .= $array_label.',';
                    $stats .= $array_data.',';
                }
            }

            // Gateway Report
            $labelss = '';
            $data = '';
            $bg_colors = '';
            $ii = 0;
            $ud_pie_data = array_count_values($ud_gateway_labels);
            $final_pie_data = array();
            foreach ($ud_pie_data as $gateway_label => $count) {
                if( $gateway_label == 'Pay Locally' ) {
                    $gateway = new \MEC_gateway_pay_locally();
                } elseif ( $gateway_label == 'Stripe' ) {
                    $gateway = new \MEC_gateway_stripe();
                } elseif ( $gateway_label == 'PayPal Express' ) {
                    $gateway = new \MEC_gateway_paypal_express();
                } elseif ( $gateway_label == 'PayPal Credit Card' ) {
                    $gateway = new \MEC_gateway_paypal_credit_card();
                } elseif ( $gateway_label == 'Pay by WooCommerce' ) {
                    $gateway = new \MEC_gateway_woocommerce();
                } elseif ( $gateway_label == 'Stripe Connect' ) {
                    $gateway = new \MEC_gateway_stripe_connect();
                }
                $final_pie_data[$gateway_label]['count'] =  $count;
                $final_pie_data[$gateway_label]['color'] =  $gateway->color();
            }

            $numItemss = count($final_pie_data);

            foreach ($final_pie_data as $pie_labels => $pie_data) {

                if(++$ii === $numItemss) {
                    $labelss .= $pie_labels;
                    $data .= ((int) $pie_data['count']);
                    $bg_colors .= $pie_data['color'];
                } else {
                    $labelss .= $pie_labels.',';
                    $data .= ((int) $pie_data['count']).',';
                    $bg_colors .= $pie_data['color'].',';
                }
            }

            $all_books = $fes_class->db->select("SELECT `ID` FROM `#__posts` WHERE `post_type`='mec-books'", 'loadColumn');
            $countt = count($all_books);

        } else {
            $past_week = strtotime('-7 days', current_time('timestamp', 0));
            $dates = $render->dates($event_id, NULL, 15, date('Y-m-d', $past_week));
            $current_user_books = $fes_class->db->select("SELECT `ID` FROM `#__posts` WHERE `post_type`='mec-books'", 'loadColumn');
            $all_books_ids_info = array();
            $ids_text_field = '';
            $total_price = $countt = 0;
            $countt_ticket = 0;
            $stats = '';
            $labels = '';
            $book_ids_info = array();


            if(is_array($current_user_books) and count($current_user_books)):
                foreach($current_user_books as $current_user_book_id => $current_user_book):

                    $event_id_book = get_post_meta($current_user_book, 'mec_event_id', true);

                    if($event_id_book == $event_id){
                        $countt_ticket++;
                    }

                    $books_meta_info = $fes_class->db->select("SELECT `post_id`, `meta_key`, `meta_value` FROM `#__postmeta` WHERE `post_id`={$current_user_book}", 'loadAssocList');

                    if(is_array($books_meta_info) and count($books_meta_info))
                    {
                        $books_data = array();
                        foreach($books_meta_info as $book_meta_info)
                        {
                            $books_data = array_merge($books_data, array(trim($book_meta_info['meta_key']) => $book_meta_info['meta_value']));
                        }
                        $book_ids_info[$current_user_book_id]['id'] = $current_user_book;
                        $book_ids_info[$current_user_book_id]['info'] = $books_data;

                        if($event_id == $book_ids_info['info']['mec_event_id']) $ids_text_field .= $book_ids_info['id'] . ',';
                    }
                endforeach;
            endif;

            foreach($dates as $date):
                if(isset($date['start']['date']) and isset($date['end']['date'])):

                    $attendees_count = 0;
                    $certain_date_ids = "";
                    $render_date = $date['start']['timestamp'].':'.$date['end']['timestamp'];
                    if ( !empty($book_ids_info) ) :

                        foreach($book_ids_info as $book_info  )
                        {
                            if((isset($book_info['info']['mec_date']) and trim($book_info['info']['mec_date']) == $render_date) and (isset($book_info['info']['mec_event_id']) and trim($book_info['info']['mec_event_id']) == $event_id))
                            {
                                if(isset($book_info['info']['mec_attendees']))
                                {

                                    $attendees_info = unserialize($book_info['info']['mec_attendees']);

                                    $certain_date_ids .= $book_info['id'] . ',';
                                    foreach($attendees_info as $attendees_info)
                                    {
                                        $attendees_count += $attendees_info['count'];
                                    }
                                }
                                if(isset($book_info['info']['mec_price']))
                                {

                                    $total_price += $book_info['info']['mec_price'];
                                }
                            }


                        }
                    endif;
                    $countt += $attendees_count;
                endif;
            endforeach;

            $args = array(
                'post_type' => 'mec-books',
                'post_status' => 'any',
                'meta_query' => array(
                'relation' => 'AND',
                    array(
                        'key' => 'mec_book_date_submit',
                        'compare' => 'BETWEEN',
                        'value' => array(date('YmdHis',strtotime($start)) , date('YmdHis',strtotime($end))),
                    ),
                    array(
                        'key' => 'mec_event_id',
                        'compare' => '=',
                        'value' => $event_id,
                    ),
                )
            );
            $book_posts = get_posts($args);

            foreach($periods as $period)
            {
                $information[$period['label']] = 0;
            }

            foreach ($book_posts as $keyy => $valuee)
            {
                foreach ($information as $key => $value)
                {

                    if ( $type == 'monthly')
                    {
                        if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))) . ' ' . date_i18n('F', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                    if ( $type == 'daily')
                    {
                        if ( $key == date_i18n($date_format, strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                    if ( $type == 'yearly')
                    {
                        if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                        {
                            $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                            $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                            $information[$key] += intval($total_sells);
                        }
                    }

                }
            }

            $numItems = count($information);
            $i = 0;
            foreach ($information as $array_label => $array_data)
            {
                if(++$i === $numItems) {
                    $labels .= $array_label.'';
                    $stats .= $array_data.'';
                } else {
                    $labels .= $array_label.',';
                    $stats .= $array_data.',';
                }
            }

            // Gateway Report
            $labelss = '';
            $data = '';
            $bg_colors = '';
            $ii = 0;
            $ud_pie_data = array_count_values($ud_gateway_labels);
            $final_pie_data = array();
            foreach ($ud_pie_data as $gateway_label => $count) {
                if(!$gateway_label) {
                    continue;
                }
                if( $gateway_label == 'Pay Locally' ) {
                    $gateway = new \MEC_gateway_pay_locally();
                } elseif ( $gateway_label == 'Stripe' ) {
                    $gateway = new \MEC_gateway_stripe();
                } elseif ( $gateway_label == 'PayPal Express' ) {
                    $gateway = new \MEC_gateway_paypal_express();
                } elseif ( $gateway_label == 'PayPal Credit Card' ) {
                    $gateway = new \MEC_gateway_paypal_credit_card();
                } elseif ( $gateway_label == 'Pay by WooCommerce' ) {
                    $gateway = new \MEC_gateway_woocommerce();
                } elseif ( $gateway_label == 'Stripe Connect' ) {
                    $gateway = new \MEC_gateway_stripe_connect();
                } elseif ($gateway_label == 'Stripe Connect') {
                    $gateway = new \MEC_gateway_stripe_connect();
                } else {
                    continue;
                }

                $final_pie_data[$gateway_label]['count'] =  $count;
                $final_pie_data[$gateway_label]['color'] =  $gateway->color();
            }

            $numItemss = count($final_pie_data);

            foreach ($final_pie_data as $pie_labels => $pie_data) {

                if(++$ii === $numItemss) {
                    $labelss .= $pie_labels;
                    $data .= ((int) $pie_data['count']);
                    $bg_colors .= $pie_data['color'];
                } else {
                    $labelss .= $pie_labels.',';
                    $data .= ((int) $pie_data['count']).',';
                    $bg_colors .= $pie_data['color'].',';
                }
            }

            $countt = $countt_ticket;

        }

        $info = array($countt, $total_price, $labels , $stats, $labelss , $data , $bg_colors);

        echo json_encode($info);

        die();
    }


    /**
     * Get total booking for charts
     *
     * @since     1.0.0
     */
    public function chart_data_filter_button()
    {
        $date_format = static::$mec_settings['dashboard_date_format1'] ?? 'Y-m-d';
        $main = new \MEC_main();
        $event_id = sanitize_text_field($_POST['event_id']);
        $start_placeholder = sanitize_text_field($_POST['start']);
        $end_placeholder =sanitize_text_field($_POST['end']);
        $start = sanitize_text_field($_POST['start']) . ' 00:00:00';
        $end = sanitize_text_field($_POST['end']) . ' 23:59:59';
        $type = sanitize_text_field($_POST['type']);
        $periods = $main->get_date_periods($start_placeholder, $end_placeholder, $type);
        $stats = '';
        $labels = '';
        $ud_gateway_labels = array();

        $args = array(
            'post_type' => 'mec-books',
            'numberposts' => -1,
            'post_status' => 'any',
            'meta_query' => array(
            'relation' => 'AND',
                array(
                    'key' => 'mec_book_date_submit',
                    'compare' => 'BETWEEN',
                    'value' => array(date('YmdHis',strtotime($start)) , date('YmdHis',strtotime($end))),
                ),
            )
        );
        $book_posts = get_posts($args);

        foreach($periods as $period)
        {
            $information[$period['label']] = 0;
        }

        foreach ($book_posts as $keyy => $valuee)
        {
            foreach ($information as $key => $value)
            {

                if ( $type == 'monthly')
                {
                    if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))) . ' ' . date_i18n('F', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                    {
                        $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                        $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                        $information[$key] += intval($total_sells);
                    }
                }

                if ( $type == 'daily')
                {
                    if ( $key == date_i18n($date_format, strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                    {
                        $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                        $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                        $information[$key] += intval($total_sells);
                    }
                }

                if ( $type == 'yearly')
                {
                    if ( $key == date_i18n('Y', strtotime(get_post_meta($valuee->ID, 'mec_book_date_submit', true))))
                    {
                        $total_sells = get_post_meta( $valuee->ID, 'mec_price', true );
                        $ud_gateway_labels[] = get_post_meta( $valuee->ID, 'mec_gateway_label', true );
                        $information[$key] += intval($total_sells);
                    }
                }

            }
        }

        $numItems = count($information);
        $i = 0;
        foreach ($information as $array_label => $array_data)
        {
            if(++$i === $numItems) {
                $labels .= $array_label.'';
                $stats .= $array_data.'';
            } else {
                $labels .= $array_label.',';
                $stats .= $array_data.',';
            }
        }


        // Gateway Report
        $labelss = '';
        $data = '';
        $bg_colors = '';
        $ii = 0;
        $ud_pie_data = array_count_values($ud_gateway_labels);
        $final_pie_data = array();
        foreach ($ud_pie_data as $gateway_label => $count) {
            if( $gateway_label == 'Pay Locally' ) {
                $gateway = new \MEC_gateway_pay_locally();
            } elseif ( $gateway_label == 'Stripe' ) {
                $gateway = new \MEC_gateway_stripe();
            } elseif ( $gateway_label == 'PayPal Express' ) {
                $gateway = new \MEC_gateway_paypal_express();
            } elseif ( $gateway_label == 'PayPal Credit Card' ) {
                $gateway = new \MEC_gateway_paypal_credit_card();
            } elseif ( $gateway_label == 'Pay by WooCommerce' ) {
                $gateway = new \MEC_gateway_woocommerce();
            } elseif ( $gateway_label == 'Stripe Connect' ) {
                $gateway = new \MEC_gateway_stripe_connect();
            } else {
                continue;
            }
            $final_pie_data[$gateway_label]['count'] =  $count;
            $final_pie_data[$gateway_label]['color'] =  $gateway->color();
        }

        $numItemss = count($final_pie_data);

        foreach ($final_pie_data as $pie_labels => $pie_data) {

            if(++$ii === $numItemss) {
                $labelss .= $pie_labels;
                $data .= ((int) $pie_data['count']);
                $bg_colors .= $pie_data['color'];
            } else {
                $labelss .= $pie_labels.',';
                $data .= ((int) $pie_data['count']).',';
                $bg_colors .= $pie_data['color'].',';
            }
        }

        $info = array($labels, $stats, $labelss, $data, $bg_colors);

        echo json_encode($info);

        die();
    }


    /**
     * Change Frontend Submission link
     *
     * @since     1.0.0
     */
    public function change_fes_list_link()
    {
        self::prepare_ud();

        $url = isset(self::$mec_settings['user_dashboard_page']) && !empty(self::$mec_settings['user_dashboard_page']) ? get_permalink(self::$mec_settings['user_dashboard_page']) : '' ;
        ?>
        <a class="mec-fes-form-to-dashboard" href="<?php echo esc_html($url); ?>"><?php echo __('Go to Dashboard', 'mec-ud'); ?></a>
        <?php
    }

    /**
     * Organizer fields
     *
     * @since     1.0.0
     */
    public static function UD_content_organizer()
    {
        $organizerId = MecUserMeta::user_is_organizer(self::$userId);
        $term = get_term( $organizerId, 'mec_organizer' );

        // Get term main data
        $organizer_name = !empty( $term->name ) ? $term->name : esc_html__('Name' , 'mec-ud');
        $organizer_slug = !empty( $term->slug ) ? $term->slug : esc_html__('Slug' , 'mec-ud');
        $organizer_description = !empty( $term->description ) ? $term->description : esc_html__('Description' , 'mec-ud');

        //Get term extra fields
        $org_tel = get_term_meta($term->term_id, 'tel', true);
        $org_email = get_term_meta($term->term_id, 'email', true);
        $org_url = get_term_meta($term->term_id, 'url', true);
        $organizer_main_facebook = get_term_meta($term->term_id, 'facebook', true);
        $organizer_main_instagram = get_term_meta($term->term_id, 'instagram', true);
        $organizer_main_linkedin = get_term_meta($term->term_id, 'linkedin', true);
        $organizer_main_twitter = get_term_meta($term->term_id, 'twitter', true);
        $org_thumbnail = get_term_meta($term->term_id, 'thumbnail', true);

        $organizer_tel = !empty( $org_tel ) ? $org_tel : esc_html__('Phone' , 'mec-ud');
        $organizer_email = !empty( $org_email ) ? $org_email : esc_html__('E-mail' , 'mec-ud');
        $organizer_url = !empty( $org_url ) ? $org_url : esc_html__('Page' , 'mec-ud');
        $organizer_facebook = !empty( $organizer_main_facebook ) ? $organizer_main_facebook : esc_html__('Facebook Page' , 'mec-ud');
        $organizer_instagram = !empty( $organizer_main_instagram ) ? $organizer_main_instagram : esc_html__('Instagram Page' , 'mec-ud');
        $organizer_linkedin = !empty( $organizer_main_linkedin ) ? $organizer_main_linkedin : esc_html__('Linkedin Page' , 'mec-ud');
        $organizer_twitter = !empty( $organizer_main_twitter ) ? $organizer_main_twitter : esc_html__('Twitter Page' , 'mec-ud');
        $organizer_thumbnail = !empty( $org_thumbnail ) ? $org_thumbnail : '';
        $thumbnailId = !empty( $organizer_thumbnail ) ? attachment_url_to_postid( $organizer_thumbnail ) : '' ;

        if ( !empty($thumbnailId) ) {
            $avatar = '<img src="'.$organizer_thumbnail.'" />';
        } else {
            $avatar = '';
        }

        $output = '
            <div id="mec-ud-organizer" class="mec-ud-organizer mec-ud-content" data-menu="organizer">
                <form method="post" action="" class="mec-organizer-form">
                    <div class="row">
                        <div class="col-md-12 mec-ud-form mec-ud-form-p">
                            <label>'.esc_html__('Organizer Name', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16">
                                        <path id="notebook" d="M12,16H2.105c-.019,0-.034-.009-.053-.011S2.019,16,2,16a.666.666,0,0,1-.667-.667V12.667H.667a.667.667,0,0,1,0-1.333h.667V8.667H.667a.667.667,0,0,1,0-1.333h.667V4.667H.667a.667.667,0,1,1,0-1.333h.667V.667A.666.666,0,0,1,2,0c.019,0,.035.009.053.011S2.087,0,2.105,0H12a2,2,0,0,1,2,2V14A2,2,0,0,1,12,16ZM2.667,3.333a.667.667,0,0,1,0,1.333V7.333a.667.667,0,0,1,0,1.333v2.667a.667.667,0,0,1,0,1.333v2H10V1.333H2.667ZM12.667,2A.667.667,0,0,0,12,1.333h-.667V14.667H12A.667.667,0,0,0,12.667,14Z" fill="#c1c5c9" fill-rule="evenodd"/>
                                    </svg>
                                </span>
                                <input type="text" name="mec_organizer_name" id="mec_organizer_name" value="" />
                                <input type="hidden" name="mec_organizer_name_hidden" id="mec_organizer_name_hidden" value="'.$term->name.'" />
                            </span>
                            <p>'.esc_html__('The name is how it appears on your site.' , 'mec-ud').'</p>
                        </div>
                        <div class="col-md-12 mec-ud-form mec-ud-form-p mec-ud-form-textarea">
                            <label>'.esc_html__('Organizer Description', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1040">
                                        <path d="M952 2L529 116q-4 1-10 1.5t-12.5.5-12.5-.5-10-1.5L72 2q-28-8-50 9T0 56v778q0 24 16 44.5T55 906l412 114q17 5 40 5 9 0 19.5-1t19.5-4l423-115q23-6 39-26.5t16-44.5V56q0-28-22-45t-50-9zM480 957L71 844q-2-1-4.5-4t-2.5-6V66l403 112q3 0 6 1t7 1v777zm480-123q0 2-3 5.5t-5 4.5L544 954V178h2L960 66v768zM642 366q5 0 9-1l224-63q12-4 18.5-15.5T897 263q-3-9-9-15t-14-8-17 0l-224 63q-12 4-18.5 15.5T611 343q8 22 31 23zm0 192q5 0 9-1l224-63q12-4 18.5-15.5t3-24-15-19T857 432l-224 63q-12 4-18.5 15.5T611 535q8 22 31 23zm0 192h4.5l4.5-1 224-63q12-4 18.5-15.5t3-24-15-19T857 624l-224 63q-12 4-18.5 15.5T611 727q8 22 31 23zM395 303l-224-63q-7-1-13 0t-11.5 3.5-9.5 7.5-6 12q-3 12 3.5 23.5T153 302l224 63q2 1 4.5 1h4.5q7 0 13.5-2.5t11-8T417 343q6-23-14-36-5-2-8-4zm0 192l-224-63q-9-2-17 0t-14 8-9 15q-1 5-1 10t2 9.5 5 8.5 7 7 9 4l224 63q4 1 9 1 11 0 19.5-6.5T417 535q6-23-14-36-5-2-8-4zm0 192l-224-63q-13-3-24.5 3.5T131 647q-1 5-1 10t2 9.5 5 8.5 7 7 9 4l224 63q5 1 9 1 11 0 19.5-6.5T417 727q7-24-15-36-4-2-7-4z" fill="#c1c5c9"/>
                                    </svg>
                                </span>
                                <textarea name="mec_organizer_desc" id="mec_organizer_desc">'. $organizer_description .'</textarea>
                                <input type="hidden" name="mec_organizer_desc_hidden" id="mec_organizer_desc_hidden" value="'.$term->description.'" />
                            </span>
                            <p>'.esc_html__('The description is not prominent by default; however, some themes may show it.' , 'mec-ud').'</p>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('Phone', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1056 1056"><path d="M1016 788q-4-4-25-18t-49-32.5l-56-37-50-33-28-17.5q-4-3-9.5-5t-11-3-11.5-1q-4 0-7 .5t-6.5 1-7.5 1.5-7.5 2-7 2.5-7.5 3-7 3.5q-19 10-91 51-61-43-152-134-90-90-133-151 41-73 51-91 26-50 5-83-11-17-70.5-107T268 39q-17-24-52-24-9 0-17.5 2t-17 5.5T165 31q-5 4-16.5 13t-37 30.5-45.5 42-36 45T15 204q1 42 15 88.5T68 385t53.5 91 66.5 90 71 82.5 72 75.5q59 59 118 109.5t128.5 99 141 77.5 134.5 31h1q17 0 41-16t44.5-36.5 42-45T1012 907l12-16q31-44 9-84-7-12-17-19zm-44 65q-30 42-67 79.5T851 977q-90-5-212.5-81.5T376.5 679 160 416.5 79 205q6-17 43.5-54T202 84q2-2 4-3t4.5-1.5 5.5-.5q1 0 2 1 60 86 132 199 0 8-6 21-2 3-5 9t-7.5 14-10.5 18-12.5 22-14.5 26l-20 35 23 33q47 67 141 161t160 140l33 24 36-20q29-17 54-31.5t35-18.5q11-7 20-7h1q81 51 200 133 1 7-5 15zM660 393q7 6 16 6h13l229 1q6 0 11.5-3.5t9-9T942 376v-17q-1-11-9-17.5t-18-6.5H764l262-262q9-9 9-22t-9.5-22.5T1003 19t-23 9L718 291l1-155q0-10-7-17t-16-7h-17q-6 0-11.5 2.5t-9 7T655 133v231h1l-2 12q1 11 6 17z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_tel" id="mec_organizer_tel" value="" />
                                <input type="hidden" name="mec_organizer_tel_hidden" id="mec_organizer_tel_hidden" value="'.$org_tel.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('Email', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M1023 473q0-4-1-8t-2.5-8-3.5-7.5-5-6.5l-1-1q-2-3-5-6l-6-6L582 27Q555 0 514 0t-68 27L29 427q-6 6-12 13T5.5 458.5 0 481v479q0 27 19 45.5t45 18.5h896q17 0 32-8.5t23.5-23.5 8.5-32V478l-1-5zM270 726L64 916V545zm66 27l6-6 1-1 141-130q11-9 25-9t24 8l384 345H110zm421-22l203-180v362zM104 443L491 72q10-9 23-9t23 9l361 345h-1l55 55-242 215-136-121q-18-15-41-20t-47 0-43 21L317 683 75 469l27-26h2z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_email" id="mec_organizer_email" value="" />
                                <input type="hidden" name="mec_organizer_email_hidden" id="mec_organizer_email_hidden" value="'.$org_email.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form mec-ud-form-p">
                            <label>'.esc_html__('Page', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 864 1024"><path d="M850 414q0-36-5.5-71t-16-68.5T803 210t-35-60-44-55-52.5-48.5T612 5q-8-5-16.5-5t-16 4.5T568 16q-7 12-3.5 24.5T579 60q97 57 152 151t55 203q0 90-31.5 168t-87 133-133 86.5T367 833q-13 0-26.5-1t-27-2.5-26.5-4-25.5-6T236 812t-25-9-24.5 0-17.5 17 .5 24.5T187 862q86 35 180 35h1v63h-93q-14 0-24 9t-10 22.5 10 23 24 9.5h253q14 0 23.5-9.5t9.5-23-9.5-22.5-23.5-9h-97v-67q186-22 302.5-154T850 414zm-131 3q0-57-17.5-111t-50-97.5-76-76T478 82 367 64q-72 0-137 28t-112.5 75.5-75 113T15 417q0 96 47 177t128 128 177 47q72 0 137-28t112.5-75 75-112T719 417zm-641 0q0-78 39-144.5T222.5 167 367 128q119 0 203.5 85T655 417q0 59-22.5 112T571 620.5 479 682t-112 23q-119 0-204-84.5T78 417z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_url" id="mec_organizer_url" value="" />
                                <input type="hidden" name="mec_organizer_url_hidden" id="mec_organizer_url_hidden" value="'.$org_url.'" />
                            </span>
                            <p>'.esc_html__('User this field to link organizer to other user profile pages.' , 'mec-ud').'</p>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('Facebook', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 528 992"><path d="M342 64l6 1h83v96h-83q-7 0-13.5 1t-10.5 3.5t-7.5 5.5t-6 6t-4 6.5t-2 6l-1 5l-.5 3.5v154h162l-23 96H303v480h-96V448H79v-96h128V203q0-31 8-55.5t21.5-38.5T264 85t31-14t27-5.5t20-1.5zm89 1zM342 0q-62 0-111 30q-88 53-88 173v85H79q-26 0-45 19t-19 45v96q0 26 19 45t45 19h64v415q0 27 18.5 45.5T207 991h96q26 0 45-18.5t19-45.5V512h75q22 0 39-13t23-33l22-96q9-31-10-56.5T465 288h-98v-63h64q26 0 45-19t19-45V65q0-27-18.5-45.5T432 1h-82q-4-1-8-1z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_facebook" id="mec_organizer_facebook" value="" />
                                <input type="hidden" name="mec_organizer_facebook_hidden" id="mec_organizer_facebook_hidden" value="'.$organizer_main_facebook.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('Instagram', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="14" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M511 4q128 0 209 3q69 3 123 24q52 20 90 58t58 90q21 54 24 123q3 81 3 209t-3 209q-3 69-24 123q-20 52-58 90t-90 58q-54 21-123 24q-81 3-209 3t-209-3q-69-3-123-24q-52-20-90-58t-58-90Q10 789 7 720q-3-81-3-209t3-209q3-69 24-123q20-52 58-90t90-58q54-21 123-24q81-3 209-3zm0 66q-133 0-217 3q-54 2-100 19q-72 30-102 102q-17 46-19 100q-3 84-3 217t3 217q2 54 19 100q30 72 102 102q46 17 100 19q84 3 217 3t217-3q54-2 100-19q72-30 102-102q17-46 19-100q3-84 3-217t-3-217q-2-54-19-100q-30-72-102-102q-46-17-100-19q-84-3-217-3zm0 644q84 0 143.5-59.5T714 511t-59.5-143.5T511 308t-143.5 59.5T308 511t59.5 143.5T511 714zm0-463q108 0 184 76t76 184t-76 184t-184 76t-184-76t-76-184t76-184t184-76zm332-10q0 25-18 42.5T781 301q-25 0-42.5-17.5T721 241q0-26 17.5-44t42.5-18t43.5 18.5T843 241z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_instagram" id="mec_organizer_instagram" value="" />
                                <input type="hidden" name="mec_organizer_instagram_hidden" id="mec_organizer_instagram_hidden" value="'.$organizer_main_instagram.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('Linkedin', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="14" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M511 4q128 0 209 3q69 3 123 24q52 20 90 58t58 90q21 54 24 123q3 81 3 209t-3 209q-3 69-24 123q-20 52-58 90t-90 58q-54 21-123 24q-81 3-209 3t-209-3q-69-3-123-24q-52-20-90-58t-58-90Q10 789 7 720q-3-81-3-209t3-209q3-69 24-123q20-52 58-90t90-58q54-21 123-24q81-3 209-3zm0 66q-133 0-217 3q-54 2-100 19q-72 30-102 102q-17 46-19 100q-3 84-3 217t3 217q2 54 19 100q30 72 102 102q46 17 100 19q84 3 217 3t217-3q54-2 100-19q72-30 102-102q17-46 19-100q3-84 3-217t-3-217q-2-54-19-100q-30-72-102-102q-46-17-100-19q-84-3-217-3zm0 644q84 0 143.5-59.5T714 511t-59.5-143.5T511 308t-143.5 59.5T308 511t59.5 143.5T511 714zm0-463q108 0 184 76t76 184t-76 184t-184 76t-184-76t-76-184t76-184t184-76zm332-10q0 25-18 42.5T781 301q-25 0-42.5-17.5T721 241q0-26 17.5-44t42.5-18t43.5 18.5T843 241z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_organizer_linkedin" id="mec_organizer_linkedin" value="" />
                                <input type="hidden" name="mec_organizer_linkedin_hidden" id="mec_organizer_linkedin_hidden" value="'.$organizer_main_linkedin.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                            <label>'.esc_html__('X (Twitter)', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 512 462.799" style="width: 14px;height: 14px;"><path fill-rule="nonzero" d="M403.229 0h78.506L310.219 196.04 512 462.799H354.002L230.261 301.007 88.669 462.799h-78.56l183.455-209.683L0 0h161.999l111.856 147.88L403.229 0zm-27.556 415.805h43.505L138.363 44.527h-46.68l283.99 371.278z" fill="#c1c5c9"></path></svg>
                                </span>
                                <input type="text" name="mec_organizer_twitter" id="mec_organizer_twitter" value="" />
                                <input type="hidden" name="mec_organizer_twitter_hidden" id="mec_organizer_twitter_hidden" value="'.$organizer_main_twitter.'" />
                            </span>
                        </div>
                    </div>
                    <div class="row mec-ud-image">
                        <div class="col-md-7">
                            <label>Personal Picture</label>
                            <div class="mec-ud-image-upload">
                                <div class="mec-ud-image-box">
                                    <input type="number" name="mec_ud_attachment_id" class="mec-ud-attachment-id" value="'. $thumbnailId.'" />
                                    <div class="mec-ud-attachment-image">'.$avatar.'</div>
                                    <div class="mec-avatar-preview"></div>
                                </div>
                                <div class="mec-ud-image-url">
                                    <p><input type="file" id="orgfile" name="async-upload" class="image-file" accept="image/*" required>
                                    <label for="orgfile" />'.esc_html__('Add File', 'mec-ud').'</label></p>
                                    <input type="hidden" name="image_id" value="'.$thumbnailId.'">
                                    <input type="hidden" name="mec_ud_orgID" value="'.$organizerId.'">
                                    <input type="hidden" name="action" value="image_submission">
                                    <p class="image-notice">'.esc_html__('No File Choosen', 'mec-ud').'</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-12"><button class="mec-ud-submit-form mec-ud-submit-organizer"><span>'.esc_html__('Save Changes' ,'mec-ud').'</span></button></div>
                    </div>
                </form>
            </div>
        ';

        return $output;
    }

    /**
     * Speaker fields
     *
     * @since     1.0.0
     */
    public static function UD_content_speaker()
    {
        $speakerId =  MecUserMeta::user_is_speaker(self::$userId);
        $term = get_term( $speakerId, 'mec_speaker' );

        // Get term main data
        $speaker_name = !empty( $term->name ) ? $term->name : esc_html__('Name' , 'mec-ud');
        $speaker_slug = !empty( $term->slug ) ? $term->slug : esc_html__('Slug' , 'mec-ud');
        $speaker_description = !empty( $term->description ) ? $term->description : esc_html__('Description' , 'mec-ud');

        //Get term extra fields
        $speaker_main_job_title = get_term_meta($term->term_id, 'job_title', true);
        $speaker_main_tel = get_term_meta($term->term_id, 'tel', true);
        $speaker_main_email = get_term_meta($term->term_id, 'email', true);
        $speaker_main_facebook = get_term_meta($term->term_id, 'facebook', true);
        $speaker_main_instagram = get_term_meta($term->term_id, 'instagram', true);
        $speaker_main_linkedin = get_term_meta($term->term_id, 'linkedin', true);
        $speaker_main_twitter = get_term_meta($term->term_id, 'twitter', true);
        $speaker_main_thumbnail = get_term_meta($term->term_id, 'thumbnail', true);

        $speaker_job_title = !empty( $speaker_main_job_title ) ? $speaker_main_job_title : esc_html__('Job Title' , 'mec-ud');
        $speaker_tel = !empty( $speaker_main_tel ) ? $speaker_main_tel : esc_html__('Phone' , 'mec-ud');
        $speaker_email = !empty( $speaker_main_email ) ? $speaker_main_email : esc_html__('E-mail' , 'mec-ud');
        $speaker_facebook = !empty( $speaker_main_facebook ) ? $speaker_main_facebook : esc_html__('Facebook Page' , 'mec-ud');
        $speaker_instagram = !empty( $speaker_main_instagram ) ? $speaker_main_instagram : esc_html__('Instagram Page' , 'mec-ud');
        $speaker_linkedin = !empty( $speaker_main_linkedin ) ? $speaker_main_linkedin : esc_html__('Linkedin Page' , 'mec-ud');
        $speaker_twitter = !empty( $speaker_main_twitter ) ? $speaker_main_twitter : esc_html__('Twitter Page' , 'mec-ud');
        $speaker_thumbnail = !empty( $speaker_main_thumbnail ) ? $speaker_main_thumbnail : '';
        $thumbnailId = !empty( $speaker_thumbnail ) ? attachment_url_to_postid( $speaker_thumbnail ) : '' ;

        if ( !empty($thumbnailId) ) {
            $avatar = '<img src="'.$speaker_thumbnail.'" />';
        } else {
            $avatar = '';
        }

        $output = '
            <div id="mec-ud-speaker" class="mec-ud-speaker mec-ud-content" data-menu="speaker">
                <form method="post" action="" class="mec-speaker-form">
                    <div class="row">
                        <div class="col-md-12 mec-ud-form mec-ud-form-p">
                        <label>'.esc_html__('Speaker Name', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16">
                                        <path id="notebook" d="M12,16H2.105c-.019,0-.034-.009-.053-.011S2.019,16,2,16a.666.666,0,0,1-.667-.667V12.667H.667a.667.667,0,0,1,0-1.333h.667V8.667H.667a.667.667,0,0,1,0-1.333h.667V4.667H.667a.667.667,0,1,1,0-1.333h.667V.667A.666.666,0,0,1,2,0c.019,0,.035.009.053.011S2.087,0,2.105,0H12a2,2,0,0,1,2,2V14A2,2,0,0,1,12,16ZM2.667,3.333a.667.667,0,0,1,0,1.333V7.333a.667.667,0,0,1,0,1.333v2.667a.667.667,0,0,1,0,1.333v2H10V1.333H2.667ZM12.667,2A.667.667,0,0,0,12,1.333h-.667V14.667H12A.667.667,0,0,0,12.667,14Z" fill="#c1c5c9" fill-rule="evenodd"/>
                                    </svg>
                                </span>
                                <input type="text" name="mec_speaker_name" id="mec_speaker_name" value="" />
                                <input type="hidden" name="mec_speaker_name_hidden" id="mec_speaker_name_hidden" value="'.$term->name.'" />
                            </span>
                            <p>'.esc_html__('The name is how it appears on your site.' , 'mec-ud').'</p>
                        </div>
                        <div class="col-md-12 mec-ud-form mec-ud-form-p mec-ud-form-textarea">
                            <label>'.esc_html__('Speaker Description', 'mec-ud').'</label>
                                <span class="mec-field-wrapper">
                                    <span class="mec-field-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1040"><path d="M952 2L529 116q-4 1-10 1.5t-12.5.5-12.5-.5-10-1.5L72 2q-28-8-50 9T0 56v778q0 24 16 44.5T55 906l412 114q17 5 40 5 9 0 19.5-1t19.5-4l423-115q23-6 39-26.5t16-44.5V56q0-28-22-45t-50-9zM480 957L71 844q-2-1-4.5-4t-2.5-6V66l403 112q3 0 6 1t7 1v777zm480-123q0 2-3 5.5t-5 4.5L544 954V178h2L960 66v768zM642 366q5 0 9-1l224-63q12-4 18.5-15.5T897 263q-3-9-9-15t-14-8-17 0l-224 63q-12 4-18.5 15.5T611 343q8 22 31 23zm0 192q5 0 9-1l224-63q12-4 18.5-15.5t3-24-15-19T857 432l-224 63q-12 4-18.5 15.5T611 535q8 22 31 23zm0 192h4.5l4.5-1 224-63q12-4 18.5-15.5t3-24-15-19T857 624l-224 63q-12 4-18.5 15.5T611 727q8 22 31 23zM395 303l-224-63q-7-1-13 0t-11.5 3.5-9.5 7.5-6 12q-3 12 3.5 23.5T153 302l224 63q2 1 4.5 1h4.5q7 0 13.5-2.5t11-8T417 343q6-23-14-36-5-2-8-4zm0 192l-224-63q-9-2-17 0t-14 8-9 15q-1 5-1 10t2 9.5 5 8.5 7 7 9 4l224 63q4 1 9 1 11 0 19.5-6.5T417 535q6-23-14-36-5-2-8-4zm0 192l-224-63q-13-3-24.5 3.5T131 647q-1 5-1 10t2 9.5 5 8.5 7 7 9 4l224 63q5 1 9 1 11 0 19.5-6.5T417 727q7-24-15-36-4-2-7-4z" fill="#c1c5c9"/></svg>
                                    </span>
                                <textarea name="mec_speaker_desc" id="mec_speaker_desc">'. $speaker_description .'</textarea>
                                <input type="hidden" name="mec_speaker_desc_hidden" id="mec_speaker_desc_hidden" value="'.$term->description.'" />
                            </span>
                            <p>'.esc_html__('The description is not prominent by default; however, some themes may show it.' , 'mec-ud').'</p>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Job Title', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 960"><path d="M960 159H704V97q0-26-12.5-48t-35-35T608 1H416q-40 0-68 28.5T320 97v62H64q-26 0-45 19T0 223v672q0 26 19 45t45 19h896q26 0 45-19t19-45V223q0-17-8.5-31.5T992 168t-32-9zM384 97q0-13 9.5-22.5T416 65h192q14 0 23 9.5t9 22.5v62H384V97zM64 223h896v225H608v-33q0-17-9-32t-23.5-23.5T544 351h-64q-27 0-45.5 19T416 415v33H64V223zm480 353h-64V415h64v161zM64 895V512h352v64q0 27 18.5 45.5T480 640h64q17 0 31.5-8.5T599 608t9-32v-64h352v383H64z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_speaker_job_title" id="mec_speaker_job_title" value="" />
                                <input type="hidden" name="mec_speaker_job_title_hidden" id="mec_speaker_job_title_hidden" value="'.$speaker_main_job_title.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Phone', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1056 1056"><path d="M1016 788q-4-4-25-18t-49-32.5l-56-37-50-33-28-17.5q-4-3-9.5-5t-11-3-11.5-1q-4 0-7 .5t-6.5 1-7.5 1.5-7.5 2-7 2.5-7.5 3-7 3.5q-19 10-91 51-61-43-152-134-90-90-133-151 41-73 51-91 26-50 5-83-11-17-70.5-107T268 39q-17-24-52-24-9 0-17.5 2t-17 5.5T165 31q-5 4-16.5 13t-37 30.5-45.5 42-36 45T15 204q1 42 15 88.5T68 385t53.5 91 66.5 90 71 82.5 72 75.5q59 59 118 109.5t128.5 99 141 77.5 134.5 31h1q17 0 41-16t44.5-36.5 42-45T1012 907l12-16q31-44 9-84-7-12-17-19zm-44 65q-30 42-67 79.5T851 977q-90-5-212.5-81.5T376.5 679 160 416.5 79 205q6-17 43.5-54T202 84q2-2 4-3t4.5-1.5 5.5-.5q1 0 2 1 60 86 132 199 0 8-6 21-2 3-5 9t-7.5 14-10.5 18-12.5 22-14.5 26l-20 35 23 33q47 67 141 161t160 140l33 24 36-20q29-17 54-31.5t35-18.5q11-7 20-7h1q81 51 200 133 1 7-5 15zM660 393q7 6 16 6h13l229 1q6 0 11.5-3.5t9-9T942 376v-17q-1-11-9-17.5t-18-6.5H764l262-262q9-9 9-22t-9.5-22.5T1003 19t-23 9L718 291l1-155q0-10-7-17t-16-7h-17q-6 0-11.5 2.5t-9 7T655 133v231h1l-2 12q1 11 6 17z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_speaker_tel" id="mec_speaker_tel" value="" />
                                <input type="hidden" name="mec_speaker_tel_hidden" id="mec_speaker_tel_hidden" value="'.$speaker_main_tel.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Email', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M1023 473q0-4-1-8t-2.5-8-3.5-7.5-5-6.5l-1-1q-2-3-5-6l-6-6L582 27Q555 0 514 0t-68 27L29 427q-6 6-12 13T5.5 458.5 0 481v479q0 27 19 45.5t45 18.5h896q17 0 32-8.5t23.5-23.5 8.5-32V478l-1-5zM270 726L64 916V545zm66 27l6-6 1-1 141-130q11-9 25-9t24 8l384 345H110zm421-22l203-180v362zM104 443L491 72q10-9 23-9t23 9l361 345h-1l55 55-242 215-136-121q-18-15-41-20t-47 0-43 21L317 683 75 469l27-26h2z" fill="#c1c5c9"/></svg>
                                </span>
                            <input type="text" name="mec_speaker_email" id="mec_speaker_email" value="" />
                            <input type="hidden" name="mec_speaker_email_hidden" id="mec_speaker_email_hidden" value="'.$speaker_main_email.'" />
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Facebook', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="16" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 528 992"><path d="M342 64l6 1h83v96h-83q-7 0-13.5 1t-10.5 3.5t-7.5 5.5t-6 6t-4 6.5t-2 6l-1 5l-.5 3.5v154h162l-23 96H303v480h-96V448H79v-96h128V203q0-31 8-55.5t21.5-38.5T264 85t31-14t27-5.5t20-1.5zm89 1zM342 0q-62 0-111 30q-88 53-88 173v85H79q-26 0-45 19t-19 45v96q0 26 19 45t45 19h64v415q0 27 18.5 45.5T207 991h96q26 0 45-18.5t19-45.5V512h75q22 0 39-13t23-33l22-96q9-31-10-56.5T465 288h-98v-63h64q26 0 45-19t19-45V65q0-27-18.5-45.5T432 1h-82q-4-1-8-1z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_speaker_facebook" id="mec_speaker_facebook" value="" />
                                <input type="hidden" name="mec_speaker_facebook_hidden" id="mec_speaker_facebook_hidden" value="'.$speaker_main_facebook.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Instagram', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="14" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M511 4q128 0 209 3q69 3 123 24q52 20 90 58t58 90q21 54 24 123q3 81 3 209t-3 209q-3 69-24 123q-20 52-58 90t-90 58q-54 21-123 24q-81 3-209 3t-209-3q-69-3-123-24q-52-20-90-58t-58-90Q10 789 7 720q-3-81-3-209t3-209q3-69 24-123q20-52 58-90t90-58q54-21 123-24q81-3 209-3zm0 66q-133 0-217 3q-54 2-100 19q-72 30-102 102q-17 46-19 100q-3 84-3 217t3 217q2 54 19 100q30 72 102 102q46 17 100 19q84 3 217 3t217-3q54-2 100-19q72-30 102-102q17-46 19-100q3-84 3-217t-3-217q-2-54-19-100q-30-72-102-102q-46-17-100-19q-84-3-217-3zm0 644q84 0 143.5-59.5T714 511t-59.5-143.5T511 308t-143.5 59.5T308 511t59.5 143.5T511 714zm0-463q108 0 184 76t76 184t-76 184t-184 76t-184-76t-76-184t76-184t184-76zm332-10q0 25-18 42.5T781 301q-25 0-42.5-17.5T721 241q0-26 17.5-44t42.5-18t43.5 18.5T843 241z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_speaker_instagram" id="mec_speaker_instagram" value="" />
                                <input type="hidden" name="mec_speaker_instagram_hidden" id="mec_speaker_instagram_hidden" value="'.$speaker_main_instagram.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('Lindedin', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="14" height="14" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M511 4q128 0 209 3q69 3 123 24q52 20 90 58t58 90q21 54 24 123q3 81 3 209t-3 209q-3 69-24 123q-20 52-58 90t-90 58q-54 21-123 24q-81 3-209 3t-209-3q-69-3-123-24q-52-20-90-58t-58-90Q10 789 7 720q-3-81-3-209t3-209q3-69 24-123q20-52 58-90t90-58q54-21 123-24q81-3 209-3zm0 66q-133 0-217 3q-54 2-100 19q-72 30-102 102q-17 46-19 100q-3 84-3 217t3 217q2 54 19 100q30 72 102 102q46 17 100 19q84 3 217 3t217-3q54-2 100-19q72-30 102-102q17-46 19-100q3-84 3-217t-3-217q-2-54-19-100q-30-72-102-102q-46-17-100-19q-84-3-217-3zm0 644q84 0 143.5-59.5T714 511t-59.5-143.5T511 308t-143.5 59.5T308 511t59.5 143.5T511 714zm0-463q108 0 184 76t76 184t-76 184t-184 76t-184-76t-76-184t76-184t184-76zm332-10q0 25-18 42.5T781 301q-25 0-42.5-17.5T721 241q0-26 17.5-44t42.5-18t43.5 18.5T843 241z" fill="#c1c5c9"/></svg>
                                </span>
                                <input type="text" name="mec_speaker_linkedin" id="mec_speaker_linkedin" value="" />
                                <input type="hidden" name="mec_speaker_linkedin_hidden" id="mec_speaker_linkedin_hidden" value="'.$speaker_main_linkedin.'" />
                            </span>
                        </div>
                        <div class="col-md-12 mec-ud-form">
                        <label>'.esc_html__('X (Twitter)', 'mec-ud').'</label>
                            <span class="mec-field-wrapper">
                                <span class="mec-field-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 512 462.799" style="width: 14px;height: 14px;"><path fill-rule="nonzero" d="M403.229 0h78.506L310.219 196.04 512 462.799H354.002L230.261 301.007 88.669 462.799h-78.56l183.455-209.683L0 0h161.999l111.856 147.88L403.229 0zm-27.556 415.805h43.505L138.363 44.527h-46.68l283.99 371.278z" fill="#c1c5c9"></path></svg>
                                </span>
                                <input type="text" name="mec_speaker_twitter" id="mec_speaker_twitter" value="" />
                                <input type="hidden" name="mec_speaker_twitter_hidden" id="mec_speaker_twitter_hidden" value="'.$speaker_main_twitter.'" />
                            </span>
                        </div>
                    </div>
                    <div class="row mec-ud-image">
                        <div class="col-md-7">
                            <label>'.esc_html__('Personal Picture', 'mec-ud').'</label>
                            <div class="mec-ud-image-upload">
                                <div class="mec-ud-image-box">
                                    <input type="number" name="mec_ud_attachment_id" class="mec-ud-attachment-id" value="'. $thumbnailId.'" />
                                    <div class="mec-ud-attachment-image">'.$avatar.'</div>
                                    <div class="mec-avatar-preview"></div>
                                </div>
                                <div class="mec-ud-image-url">
                                    <p><input type="file" id="speakerfile" name="async-upload" class="image-file" accept="image/*" required>
                                    <label for="speakerfile" />'.esc_html__('Add File', 'mec-ud').'</label></p>
                                    <input type="hidden" name="image_id" value="'.$thumbnailId.'">
                                    <input type="hidden" name="mec_ud_speakerID" value="'.$speakerId.'">
                                    <input type="hidden" name="action" value="image_submission">
                                    <p class="image-notice">'.esc_html__('No File Choosen', 'mec-ud').'</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-12"><button class="mec-ud-submit-form mec-ud-submit-speaker"><span>'.esc_html__('Save Changes' ,'mec-ud').'</span></button></div>
                    </div>
                </form>
            </div>
        ';

        return $output;
    }

    /**
     * Save speaker data
     *
     * @since     1.0.0
     */
    public function mec_ud_update_speaker_data()
    {
        $speakerid = sanitize_text_field($_POST['mec_ud_speakerID']);

        $name = isset($_POST['mec_ud_speaker_name']) ? sanitize_text_field($_POST['mec_ud_speaker_name']) : '';
        $desc = isset($_POST['mec_ud_speaker_desc']) ? sanitize_text_field($_POST['mec_ud_speaker_desc']) : '';
        $tel = isset($_POST['mec_ud_speaker_tel']) ? sanitize_text_field($_POST['mec_ud_speaker_tel']) : '';
        $email = isset($_POST['mec_ud_speaker_email']) ? sanitize_text_field($_POST['mec_ud_speaker_email']) : '';
        $facebook = (isset($_POST['mec_ud_speaker_facebook']) and trim($_POST['mec_ud_speaker_facebook'])) ? (strpos($_POST['mec_ud_speaker_facebook'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_speaker_facebook']) : sanitize_text_field($_POST['mec_ud_speaker_facebook'])) : '';
        $instagram = (isset($_POST['mec_ud_speaker_instagram']) and trim($_POST['mec_ud_speaker_instagram'])) ? (strpos($_POST['mec_ud_speaker_instagram'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_speaker_instagram']) : sanitize_text_field($_POST['mec_ud_speaker_instagram'])) : '';
        $linkedin = (isset($_POST['mec_ud_speaker_linkedin']) and trim($_POST['mec_ud_speaker_linkedin'])) ? (strpos($_POST['mec_ud_speaker_linkedin'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_speaker_linkedin']) : sanitize_text_field($_POST['mec_ud_speaker_linkedin'])) : '';
        $twitter = (isset($_POST['mec_ud_speaker_twitter']) and trim($_POST['mec_ud_speaker_twitter'])) ? (strpos($_POST['mec_ud_speaker_twitter'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_speaker_twitter']) : sanitize_text_field($_POST['mec_ud_speaker_twitter'])) : '';
        $imgid = sanitize_text_field($_POST['mec_ud_speakerImgID']);
        $imgurl = wp_get_attachment_url( $imgid, 'thumbnail' );

        wp_update_term($speakerid, 'mec_speaker', array(
            'name' => $name,
            'description' => $desc,
        ));

        update_term_meta($speakerid, 'tel', $tel);
        update_term_meta($speakerid, 'email', $email);
        update_term_meta($speakerid, 'facebook', $facebook);
        update_term_meta($speakerid, 'instagram', $instagram);
        update_term_meta($speakerid, 'linkedin', $linkedin);
        update_term_meta($speakerid, 'twitter', $twitter);
        update_term_meta($speakerid, 'thumbnail', $imgurl);

        return true;
        die();
    }

    /**
     * save organizer data
     *
     * @since     1.0.0
     */
    public function mec_ud_update_organizer_data()
    {
        $orgid = sanitize_text_field($_POST['mec_ud_orgID']);

        $name = isset($_POST['mec_ud_org_name']) ? sanitize_text_field($_POST['mec_ud_org_name']) : '';
        $desc = isset($_POST['mec_ud_org_desc']) ? sanitize_textarea_field($_POST['mec_ud_org_desc']) : '';

        $tel = isset($_POST['mec_ud_org_tel']) ? sanitize_text_field($_POST['mec_ud_org_tel']) : '';
        $email = isset($_POST['mec_ud_org_email']) ? sanitize_text_field($_POST['mec_ud_org_email']) : '';
        $url = (isset($_POST['mec_ud_org_url']) and trim($_POST['mec_ud_org_url'])) ? (strpos($_POST['mec_ud_org_url'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_org_url']) : sanitize_text_field($_POST['mec_ud_org_url'])) : '';
        $facebook = (isset($_POST['mec_ud_org_facebook']) and trim($_POST['mec_ud_org_facebook'])) ? (strpos($_POST['mec_ud_org_facebook'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_org_facebook']) : sanitize_text_field($_POST['mec_ud_org_facebook'])) : '';
        $instagram = (isset($_POST['mec_ud_org_instagram']) and trim($_POST['mec_ud_org_instagram'])) ? (strpos($_POST['mec_ud_org_instagram'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_org_instagram']) : sanitize_text_field($_POST['mec_ud_org_instagram'])) : '';
        $linkedin = (isset($_POST['mec_ud_org_linkedin']) and trim($_POST['mec_ud_org_linkedin'])) ? (strpos($_POST['mec_ud_org_linkedin'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_org_linkedin']) : sanitize_text_field($_POST['mec_ud_org_linkedin'])) : '';
        $twitter = (isset($_POST['mec_ud_org_twitter']) and trim($_POST['mec_ud_org_twitter'])) ? (strpos($_POST['mec_ud_org_twitter'], 'http') === false ? 'http://'.sanitize_text_field($_POST['mec_ud_org_twitter']) : sanitize_text_field($_POST['mec_ud_org_twitter'])) : '';
        $imgid = sanitize_text_field($_POST['mec_ud_orgImgID']);
        $imgurl = wp_get_attachment_url( $imgid, 'thumbnail' );

        wp_update_term($orgid, 'mec_organizer', array(
            'name' => $name,
            'description' => $desc,
        ));

        update_term_meta($orgid, 'tel', $tel);
        update_term_meta($orgid, 'email', $email);
        update_term_meta($orgid, 'url', $url);
        update_term_meta($orgid, 'facebook', $facebook);
        update_term_meta($orgid, 'instagram', $instagram);
        update_term_meta($orgid, 'linkedin', $linkedin);
        update_term_meta($orgid, 'twitter', $twitter);
        update_term_meta($orgid, 'thumbnail', $imgurl);

        return true;
        die();
    }

    /**
     * Set organizer thumbnail
     *
     * @since     1.0.0
     */
    public function mec_ud_update_organizer_thumbnail()
    {

        $orgid = sanitize_text_field($_POST['mec_ud_orgID']);
        $imgid = sanitize_text_field($_POST['mec_ud_orgImgID']);
        $imgurl = wp_get_attachment_url( $imgid, 'thumbnail' );

        update_term_meta($orgid, 'thumbnail', $imgurl);

        echo $imgurl;
        die();
    }

    /**
     * Set speaker thumbnail
     *
     * @since     1.0.0
     */
    public function mec_ud_update_speaker_thumbnail()
    {
        $speakerid = sanitize_text_field($_POST['mec_ud_speakerID']);
        $imgid = sanitize_text_field($_POST['mec_ud_speakerImgID']);
        $imgurl = wp_get_attachment_url( $imgid, 'thumbnail' );

        update_term_meta($speakerid, 'thumbnail', $imgurl);

        echo $imgurl;
        die();
    }

    /**
     * Download CSV file
     *
     * @since     1.0.0
     */
    public function generate_orders_csv()
    {
        $event_id = $_POST['ID'];
        $title = get_the_title($event_id);
        $filename = 'attendees-'.$title;
        $generatedDate = $generatedDate = date('d-m-Y His');

        /**
         * output header so that file is downloaded
         * instead of open for reading.
         */
        header("Pragma: public");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private", false);
        header('Content-Type: text/csv; charset=utf-8');
        // header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"" . $filename . "-" . $generatedDate . ".csv\";" );
        // header('Content-Disposition: attachment; filename=lunchbox_orders.csv');
        header("Content-Transfer-Encoding: binary");

        /**
         * create a file pointer connected to the output stream
         * @var [type]
         */
        $output = '';
        $output = fopen('php://output', 'w');

        $queryy = self::get_events_query();
        /**
         * output the column headings
         */
        fputcsv( $output, array('Name', 'Email'));
        $sda = get_post_meta($event_id,'mec_date',true);
        $date = $sda['start']['date'];
        $asd = new \MEC_main();
        $bookings = $asd->get_bookings($event_id, $date, '1000');
        $attendees = array();
        $export = array();
        foreach($bookings as $booking)
        {
            if(!isset($attendees[$booking->post_author])) $attendees[$booking->post_author] = 1;
            else $attendees[$booking->post_author]++;
        }
        foreach($attendees as $attendee_id=>$tickets):
            $user = get_userdata($attendee_id);
            $name = trim($user->first_name.' '.$user->last_name);
            if(!$name) $name = $user->display_name;
            $export = array($name,$user->user_email);
            fputcsv($output, $export);
        endforeach;
        die();
    }

    /**
     * Set user information
     *
     * @since     1.0.0
     */
    public function mec_ud_update_custom_user_profile_details_frontend()
    {
        $userid = $_POST['mec_ud_userID'];

        $first = sanitize_text_field($_POST['mec_user_fname']);
        $last = sanitize_text_field($_POST['mec_user_lname']);
        $email = sanitize_text_field($_POST['mec_user_email']);
        $website = sanitize_text_field($_POST['mec_user_url']);
        $dash_color = sanitize_text_field($_POST['mec_user_dash_color']);

        if( !current_user_can('edit_user', (int) $userid) ) return false;

        wp_update_user( array(
            'ID'            => $userid,
            'first_name'    => $first,
            'last_name'     => $last,
            'user_email'    => $email,
            'user_url'      => $website,
        ) );
        update_user_meta( $userid, 'dash_color', $dash_color );

        return true;
        die();
    }

    /**
     * Set user meta
     *
     * @since     1.0.0
     */
    public function mec_ud_update_custom_user_profile_frontend()
    {
        $userid = $_POST['mec_ud_userID'];
        $imgid = $_POST['mec_ud_imgID'];
        $imgurl = wp_get_attachment_image( $imgid, 'thumbnail' );

        if( !current_user_can('edit_user', (int)$userid) ) return false;

        delete_user_meta( (int)$userid, 'mec_ud_attachment_id') ; //delete meta

        if(
            isset($imgid)
            && is_numeric($imgid)
            && $imgid > 0
        ) {
            add_user_meta( (int)$userid, 'mec_ud_attachment_id', (int)$imgid ); //add user meta
        } else {
            return false;
        }

        echo $imgurl;
        die();
    }

    /**
     * Get avatar URL
     *
     * @since     1.0.0
     */
    public static function mec_ud_get_attachment_url($attachment_id = 0, $size = 'thumbnail')
    {
        $image = wp_get_attachment_image_src((int)$attachment_id, $size);
        if ( !empty($image)) return $image[0];
    }

    /**
     * Set avatar
     *
     * @since     1.0.0
     */
    public function mec_ud_get_new_avatar( $avatar, $id_or_email )
    {
        $user_id = 0;
        if (isset($id_or_email) && !empty($id_or_email)):
            if ( is_numeric($id_or_email) ) {
                $user_id = (int)$id_or_email;
            } else if ( is_string($id_or_email) ) {
                $user = get_user_by( 'email', $id_or_email );
                $user_id = isset($user->ID) & !empty($user->ID) ? $user->ID : '';
            } else if ( is_object($id_or_email) ) {
                $user_id = $id_or_email->user_id;
            }

            if ( $user_id == 0 ) return $avatar;

            $mec_ud_attachment_id = (int)get_user_meta( (int)$user_id, 'mec_ud_attachment_id', true );
            if ( $mec_ud_attachment_id != 0 ) :
                $image = self::mec_ud_get_attachment_url((int)$mec_ud_attachment_id, 'thumbnail');
                if( empty($image) ) $avatar = '';

                $avatar = preg_replace('/src=("|\').*?("|\')/i', 'src="'.$image.'"', $avatar);
                $avatar = preg_replace('/srcset=("|\').*?("|\')/i', 'srcset="'.$image.'"', $avatar);
            endif;

            return $avatar;
        endif;
        return;
    }

    public static function filter_profile_datetime_format( $datetime_format ){

        $date_format = static::$mec_settings['dashboard_date_format1'] ?? get_option('date_format');
        $time_format = static::$mec_settings['dashboard_time_format1'] ?? get_option('time_format');

        $datetime_format = $date_format . ' ' . $time_format;

        return $datetime_format;
    }

    public static function filter_wc_async_upload_access($prevent_access){

        $script_file = basename( sanitize_text_field( wp_unslash( $_SERVER['SCRIPT_FILENAME'] ) ) );
        if( 'async-upload.php' === $script_file ) {

            return false;
        }

        return $prevent_access;
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
