<?php

namespace MEC_User_Dashboard\Core\shortcodesMetabox;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecUserDashboard.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecShortcodeMetabox
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_User_Dashboard
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action('add_meta_boxes', [$This, 'add_shortcode_metabox'], 1);
        add_action('mec_shortcode_filters_save', [$This, 'mec_ud_shortcode_save_meta'], 99 , 2);

        // Display skins for loggedin users
        add_action('mec_skin_output_html', [$This, 'display_shortcode_for_loggedin_users'], 999 , 2);
    }

    /**
     * register metabox
     *
     * @since   1.0.0
     */
    public function add_shortcode_metabox()
    {
        add_meta_box('mec_calendar_user_dashboard', __('Login to view', 'mec-ud'), [$this, 'mec_ud_shortcode_metabox'], 'mec_calendars', 'side');
    }

    /**
     * Show metabox
     *
     * @since   1.0.0
     */
    public function mec_ud_shortcode_metabox()
    {
        global $post;
        $ud_shortcode_login_status = get_post_meta($post->ID, 'ud_shortcode_login_status', true);
        ?>
        <div class="mec-form-row mec-switcher">
            <div class="mec-col-8">
                <label><?php echo esc_html__('Status' , 'mec-ud'); ?></label>
            </div>
            <div class="mec-col-4">
                <input type="hidden" name="mec[ud_shortcode_login_status]" value="0" />
                <input type="checkbox" name="mec[ud_shortcode_login_status]" id="mec_ud_shortcode_login_status" value="1" <?php if(isset( $ud_shortcode_login_status ) && $ud_shortcode_login_status == 1) echo 'checked="checked"'; ?> />
                <label for="mec_ud_shortcode_login_status"></label>
            </div>
        </div>
        <?php
    }

    /**
     * Save metabox
     *
     * @since   1.0.0
     */
    public function mec_ud_shortcode_save_meta($post_id , $terms)
    {
        $status = $_POST['mec']['ud_shortcode_login_status'] ?? '0';
        update_post_meta($post_id, 'ud_shortcode_login_status', $status);
    }

    public function display_shortcode_for_loggedin_users( $output, $skin ){

        $postid = $skin->id;
        $ud_shortcode_login_status = get_post_meta($postid, 'ud_shortcode_login_status', true);
        if( $ud_shortcode_login_status == '1'  and !is_user_logged_in() ){

            return do_shortcode('[MEC_login]');
        }

        return $output;
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_User_Dashboard\Autoloader')) {
            return;
        }
    }
} //MecUserDashboard
