<?php
/**
* Plugin Name: MEC User Dashboard
* Plugin URI: http://webnus.net/modern-events-calendar/
* Description: Create exclusive pages for users. These pages can contain ticket purchase information, information about registered events. Users can now log in to purchase tickets.
* Author: Webnus
* Version: 1.6.0
* Text Domain: mec-ud
* Domain Path: /languages
* Author URI: http://webnus.net
**/
namespace MEC_User_Dashboard;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author    author
 * @package   package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_User_Dashboard
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_User_Dashboard_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECUSERDASHBOARDVERSION' , '1.6.0');
		define('MECUSERDASHBOARDDIR' , plugin_dir_path(__FILE__));
		define('MECUSERDASHBOARDURL' , plugin_dir_url(__FILE__));
		define('MECUSERDASHBOARDDASSETS' , MECUSERDASHBOARDURL . 'assets/' );
		define('MECUSERDASHBOARDNAME' , 'User Dashboard');
		define('MECUSERDASHBOARDSLUG' , 'mec-user-dashboard');
		define('MECUSERDASHBOARDOPTIONS' , 'mec_user_dashboard_options');
		define('MECUSERDASHBOARDTEXTDOMAIN' , 'mec-ud');
		define('MECUSERDASHBOARD_MAINFILEPATH' ,__FILE__);
		define('MECUSERDASHBOARD_PABSPATH', dirname(__FILE__));

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
		add_action( 'plugins_loaded', [$This,'addon_load_text_domain'] );
		add_filter( 'mec_get_organizer_id_by_email', array( __CLASS__, 'filter_default_organizer_id' ), 10, 3 );

	}

	/**
	 * Load plugin textdomain.
	 */
	function addon_load_text_domain() {
		load_plugin_textdomain( 'mec-ud', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {

		if ( self::checkPlugins() ) {

			include_once MECUSERDASHBOARDDIR . DS . 'core' . DS . 'autoloader.php';
		}
	}

	public static function checkPlugins(){

		include_once MECUSERDASHBOARDDIR . DS . 'core' . DS . 'CoreChecker.php';

        return CoreChecker::CheckPlugins();
    }

	public static function filter_default_organizer_id ( $organizer_id, $current_user, $email ) {

		$user_id = get_current_user_id();
		$user_organizer_id = $user_id ? get_user_meta( (int)$user_id, 'mec_user_is_organizer', true ) : false;

		if( $user_organizer_id ) {
			$organizer_id = $user_organizer_id;
		}

		return $organizer_id;
	}

} //Base

Base::instance();
