<?php

namespace Elementor;

/** No direct access */
defined('MECEXEC') or die();

use MEC\BookingForm\DisplayFields;
/**
 * Webnus MEC elementor addon shortcode class
 *
 * @author Webnus <info@webnus.biz>
 */
class MEC_addon_elementor_form_builder extends \Elementor\Widget_Base
{

	/**
	 * Retrieve MEC widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'MEC-form';
	}

	/**
	 * Retrieve MEC widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('MEC Form Builder', 'mec-form-builder');
	}

	/**
	 * Retrieve MEC widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	/**
	 * Set widget category.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget category.
	 */
	public function get_categories()
	{
		return array('mec');
	}

	/**
	 * Set widget style.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget style.
	 */
	public function get_style_depends()
	{
		return ['form-builder'];
	}

	/**
	 * Register MEC widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls(){

		$this->mec_form_fields( 'reg' );
		$this->mec_form_fields( 'bfixed' );

		$this->register_form_controls();
	}

	public function get_wp_user_fields(){

		return \MEC\Base::get_main()->get_wp_user_fields();
	}

	public function get_form_fields( $form_type, $event_id = 0 ){

		$e_id = get_the_ID();
		$fields = get_post_meta($e_id, 'mec_'.$form_type.'_fields', true);

		if( !is_array($fields) || empty($fields) ){

			switch( $form_type ){
				case 'reg':

					$fields = \MEC\Base::get_main()->get_reg_fields( $event_id );
					break;
				case 'bfixed':

					$fields = \MEC\Base::get_main()->get_bfixed_fields( $event_id );
					break;
			}
		}

		$fields = is_array( $fields ) ? $fields : [];

		if( 'reg' === $form_type ){

			$mec_email = false;
			$mec_name = false;

			foreach ( $fields as $k => $field ) {
				if ( isset( $field['type'] ) ) {

					if ( 'name' === $field['type'] ) {
						$mec_name = true;
					}

					if ( 'mec_email' === $field['type'] ) {
						$mec_email = true;
					}
				} else {
					break;
				}
			}

			if ( !$mec_name ) {
				array_unshift(
					$fields,
					array(
						'mandatory' => '0',
						'type'      => 'name',
						'label'     => esc_html__( 'Name', 'mec' ),
						'placeholder' => '',
					)
				);
			}

			if ( !$mec_email ) {
				array_unshift(
					$fields,
					array(
						'mandatory' => '0',
						'type'      => 'mec_email',
						'label'     => esc_html__( 'Email', 'mec' ),
						'placeholder' => '',
					)
				);
			}
		}

		return $fields;
	}

	public function get_field_types( $form_type ){

		$field_types = [];

		$fields = 'reg' === $form_type ? [
			'name' => [
				'required' => true,
				'type'     => 'name',
				'text'     => __('MEC Name', 'mec-form-builder'),
			]
		] : [];


		switch( $form_type ){

			case 'reg':
			case 'bfixed':

				$fields = array_merge_recursive(
					$fields,
					\MEC\Forms\SettingsForm::getInstance()->get_element_fields( $form_type )
				);

			break;
		}

		unset($fields['first_name']);
		unset($fields['last_name']);

		if( is_array( $fields ) && !empty( $fields ) ){

			foreach( $fields as $key => $fixed_field ){

				$text = isset($fixed_field['text']) ? $fixed_field['text'] : false;
				if( !$text ){

					continue;
				}

				$field_types[ $key ] = $text;
			}
		}

		return $field_types;
	}

	public function prepare_form_fields_data_for_elementor( $form_fields ){

		foreach( $form_fields as $k => $field ){

			if( isset( $field['options'] ) && is_array( $field['options'] ) ){

				$form_fields[ $k ]['options'] = implode(',', array_column( $field['options'], 'label' ) );
			}
		}

		return $form_fields;
	}

	public function mec_form_fields( $form_type ){

		$field_types = $this->get_field_types( $form_type );
		$form_fields = $this->prepare_form_fields_data_for_elementor(
			$this->get_form_fields( $form_type )
		);

		$meta_key_fields = array_merge(
			array('none' => __('None', 'mec-form-builder')),
			(array)$this->get_wp_user_fields()
		);


		switch( $form_type ){
			case 'reg':

				$options_key = 'display_options';
				$form_title_option_key = 'form_title';
				$label = __('Attendee Form Options', 'mec-form-builder');
				$default_form_title = __('Attendees Form', 'mec-form-builder');
				break;
			case 'bfixed':

				$options_key = 'fixed_form_options';
				$form_title_option_key = '';
				$label = __('Fixed Form Options', 'mec-form-builder');
				$default_form_title = '';
				break;
		}

		if( is_array( $form_fields ) && 'hide' === current($form_fields) ){

		    $key = key( $form_fields );
		    $form_fields[ $key ] = [];
		}


		$condition = array();

		$this->start_controls_section(
			$options_key,
			array(
				'label' => $label,
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		if( !empty( $form_title_option_key ) ){

			$this->add_control(
				$form_title_option_key,
				[
					'label'       => __('Form Title', 'mec-form-builder'),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => $default_form_title,
					'label_block' => true,
				]
			);
		}else{

			$this->add_control(
				'hide_fixed_fields',
				[
					'type' => Controls_Manager::SWITCHER,
					'label' => __('Hide fixed fields','mec-form-builder'),
					'label_on' => __('Hide', 'mec-form-fields'),
					'label_off' => __('Show', 'mec-form-fields'),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$condition = array(
				'hide_fixed_fields!' => 'yes'
			);
		}


		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'type',
			[
				'label'       => __('Field Type', 'mec-form-builder'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => $field_types,
				'default'     => __('text', 'mec-form-builder'),
				'label_block' => true,
			]
		);


		$repeater->add_control(
			'mapping',
			[
				'label'       => __('Field Map', 'mec-form-builder'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => $meta_key_fields,
				'default'     => 'none',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'mandatory',
			[
				'label'        => __('Required Field', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Show', 'mec-form-builder'),
				'label_off'    => __('Hide', 'mec-form-builder'),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'type!' => [
						'name',
						'mec_email',
						'p'
					],
				],
			]
		);

		$repeater->add_control(
			'ignore',
			[
				'label'        => __(' Consider the first item as a placeholder', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Yes', 'mec-form-builder'),
				'label_off'    => __('No', 'mec-form-builder'),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'type' => [
						'select',
					],
				],
			]
		);

		$repeater->add_control(
			'label',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Insert a label for this field', 'mec-form-builder'),
				'default' => __('Label', 'mec-form-builder'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'paragraph',
			[
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Insert a label for this field', 'mec-form-builder'),
				'default' => __('Descriptions...', 'mec-form-builder'),
				'label_block' => true,
				'condition'   => [
					'type' => [
						'p',
					],
				],
			]
		);
		$repeater->add_control(
			'placeholder',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Insert a placeholder for this field', 'mec-form-builder'),
				'label_block' => true,
				'condition'   => [
					'type' => [
						'name',
						'mec_email',
						'text',
						'email',
						'tel',
						'textarea',
					],
				],
			]
		);
		$repeater->add_control(
			'agreement_desc',
			[
				'type'        => \Elementor\Controls_Manager::RAW_HTML,
				'raw'         => __('Instead of %s, the page title with a link will be show.', 'mec-form-builder'),
				'label_block' => true,
				'condition'   => [
					'type' => [
						'agreement',
					],
				],
			]
		);
		$repeater->add_control(
			'options',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'title'       => __('Options', 'mec-form-builder'),
				'placeholder' => __('first item,second item, third item', 'mec-form-builder'),
				'description' => __('Please separate with "," for example:<br> first item,second item,third item', 'mec-form-builder'),
				'label_block' => true,
				'default'	=> 'Option1, Option2',
				'condition'   => [
					'type' => [
						'checkbox',
						'radio',
						'select',
					],
				],
			]
		);
		$pages          = get_posts('post_type="page"&numberposts=-1');
		$argument_pages = array();

		foreach ($pages as $page) {
			$argument_pages[$page->ID] = $page->post_title;
		}

		$repeater->add_control(
			'page',
			[
				'label'       => __('Agreement Page', 'mec-form-builder'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => $argument_pages,
				'label_block' => true,
				'condition'   => [
					'type' => [
						'agreement',
					],
				],
			]
		);
		$repeater->add_control(
			'status',
			[
				'label'       => __('Status', 'mec-form-builder'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'checked',
				'options'     => [
					'checked'   => __('Checked by default', 'mec-form-builder'),
					'unchecked' => __('Unchecked by default', 'mec-form-builder'),
				],
				'label_block' => true,
				'condition'   => [
					'type' => [
						'agreement',
					],
				],
			]
		);

		$repeater->add_control(
			'inline',
			[
				'label'        => __('Half-Width', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'return_value' => 'enable',
				'default'      => 'disable',
				'description'  => __('This option enables your form to have 2 columns and the fields will be placed in pairs next to one another.', 'mec-form-builder'),
				'condition' => [
					'inline_third!' => 'enable'
				]
			]
		);
		$repeater->add_control(
			'inline_third',
			[
				'label'        => __('Third-Width', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'return_value' => 'enable',
				'default'      => 'disable',
				'description'  => __('This option enables your form to have 3 columns and the fields will be placed in pairs next to one another.', 'mec-form-builder'),
				'condition' => [
					'inline!' => 'enable'
				]
			]
		);
		$repeater->add_control(
			'single_row',
			[
				'label'        => __('Single-Line', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'return_value' => 'enable',
				'default'      => 'disable',
				'description'  => __('This option enables your form to have controls in single row.', 'mec-form-builder'),
			]
		);

		$repeater->add_control(
			'full_width',
			[
				'label'        => __('Full-Width', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'condition'    => array(
					'single_row' => 'enable',
					'inline_third' => 'enable'
				),
				'return_value' => 'enable',
				'default'      => 'disable',
			]
		);

		unset($form_fields['form_style_url']);

		$this->add_control(
			$form_type . '_fields',
			[
				'label'         => __('Elements List', 'mec-form-builder'),
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'description'   => __('MEC Name and MEC Email are necessary and your form must contain both of them.', 'mec-form-builder'),
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ type }}}: {{{ label }}}',
				'default'       => $form_fields,
				'prevent_empty' => true,
				'condition' 	=> $condition
			]
		);

		$this->end_controls_section();
	}

	public function mec_update_form_fields(){

		$actions = stripslashes($_POST['actions']);
		if (false === strpos($actions, '"action":"render_widget"')) {

			return;
		}

		$settings = $this->get_settings_for_display();

		$form_types = [
			'reg',
			'bfixed',
		];
		$object_id = get_the_ID(); // elementor

		$actions = wp_unslash($_POST['actions']);
		$actions = json_decode($actions, true);
		$actions = current($actions);


		foreach( $form_types as $form_type ){

			$form_title_option_key = 'form_title';
			$meta_key_form_title = 'mec-booking-attendees-title';
			if( 'reg' !== $form_type ){

				$form_title_option_key = $form_type.'_form_title';
				$meta_key_form_title = 'mec_'.$form_type.'_form_title';
			}

			$form_title = self::search_in_array( $form_title_option_key, $actions );
			update_post_meta( $object_id, $meta_key_form_title, $form_title);

			$form_fields = self::search_in_array( $form_type . '_fields', $actions );

			$i = 0;
			if ($form_fields) {
				$args = [];
				$j = 0;
				foreach ($form_fields as $field) {
					// args
					if (isset($settings['inline']) && $settings['inline'] == 'enable') {
						$inline = 'enable';
					} else {
						$inline = isset($field['inline']) ? $field['inline'] : '';
					}
					if (isset($settings['inline_third']) && $settings['inline_third'] == 'enable') {
						$inline_third = 'enable';
					} else {
						$inline_third = isset($field['inline_third']) ? $field['inline_third'] : '';
					}
					if (isset($settings['single_row']) && $settings['single_row'] == 'enable') {
						$single_row = 'enable';
					} else {
						$single_row = isset($field['single_row']) ? $field['single_row'] : '';
					}


					$paragraph = isset($field['paragraph']) ? $field['paragraph'] : '';
					$label = isset($field['label']) ? $field['label'] : '';
					$args[$i] = array(
						'mandatory' => $field['mandatory'] == 'yes' ? '1' : '0',
						'ignore' => isset( $field['ignore'] ) && $field['ignore'] == 'yes' ? '1' : '0',
						'type'      => isset($field['type']) ? $field['type'] : '',
						'mapping'      => isset($field['mapping']) && 'none' !== $field['mapping'] ? $field['mapping'] : '',
						'label'     => $label,
						'paragraph'     => $paragraph,
						'inline'    => $inline,
						'inline_third'    => $inline_third,
						'single_row'    => $single_row,
						'full_width'    => isset($field['full_width']) ? $field['full_width'] : '',
						'placeholder'    => isset($field['placeholder']) ? $field['placeholder'] : '',
					);

					// checkbox
					if (isset($field['options']) && $field['options']) {
						$options = !is_array( $field['options'] ) ? explode(',', $field['options'] ) : $field['options'];
						foreach ($options as $option) {

							$option = is_array( $option ) ? $option['label'] : $option;//TODO: remove next version
							$opts[$j]['label'] = is_array( $option ) ? $option['label'] : $option;
							$j++;
						}
						$args[$i]['options'] = $opts;
						unset($opts);
					}

					// argument page
					if (isset($field['page']) && $field['page']) {
						$args[$i]['page'] = $field['page'];
					}

					// argument status
					if (isset($field['status']) && $field['status']) {
						$args[$i]['status'] = $field['status'];
					}
					$i++;
				}

				$form_fields = $args;

				if( 'bfixed' === $form_type && 'yes' === $settings['hide_fixed_fields']){
					$form_fields = array('hide');
					update_post_meta( $object_id, 'mec_'.$form_type.'_fields', 'no' );
				}

				if( 'reg' === $form_type ){

					$mec_email = false;
					$mec_name = false;

					foreach ( $form_fields as $k => $field ) {
						if ( isset( $field['type'] ) ) {

							if ( 'name' === $field['type'] ) {
								$mec_name = true;
							}

							if ( 'mec_email' === $field['type'] ) {
								$mec_email = true;
							}
						} else {
							break;
						}
					}

					if ( !$mec_name ) {
						array_unshift(
							$form_fields,
							array(
								'mandatory' => '0',
								'type'      => 'name',
								'label'     => esc_html__( 'Name', 'mec' ),
								'placeholder' => '',
							)
						);
					}

					if ( !$mec_email ) {
						array_unshift(
							$form_fields,
							array(
								'mandatory' => '0',
								'type'      => 'mec_email',
								'label'     => esc_html__( 'Email', 'mec' ),
								'placeholder' => '',
							)
						);
					}
				}

				$mec_options            = get_option('mec_options');
				$mec_options['form_style_url'] = site_url('wp-content/uploads/elementor/css/post-' . $object_id . '.css');
				$mec_options[ $form_type . '_fields' ] = $form_fields;
				update_post_meta( $object_id, 'mec_'.$form_type.'_fields', $form_fields );
				update_post_meta( $object_id, 'mec_options', $mec_options );

			}

		}
	}

	public function register_form_controls(){

		$base_selector = 'body .mec-booking-form-container';

		$this->start_controls_section(
			'field_options',
			array(
				'label' => __('Form', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'inline',
			[
				'label'        => __('Half-Width', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'return_value' => 'enable',
				'default'      => 'disable',
				'description'  => __('This option enables your form to have 2 columns and the fields will be placed in pairs next to one another.', 'mec-form-builder'),
				'condition' => [
					'inline_third!' => 'enable'
				]
			]
		);
		$this->add_control(
			'inline_third',
			[
				'label'        => __('Third-Width', 'mec-form-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Enable', 'mec-form-builder'),
				'label_off'    => __('Disable', 'mec-form-builder'),
				'return_value' => 'enable',
				'default'      => 'disable',
				'description'  => __('This option enables your form to have 3 columns and the fields will be placed in pairs next to one another.', 'mec-form-builder'),
				'condition' => [
					'inline!' => 'enable',
				]
			]
		);

		$this->end_controls_section();

		// Wrap
		$this->start_controls_section(
			'wrap_options_form',
			array(
				'label' => __('Container', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'wrap_typography',
				'label'    => __('Typography', 'mec-form-builder'),
				'selector' => $base_selector,
			]
		);
		$this->add_control(
			'wrap_color',
			[
				'label'     => __('Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.',body .mec-single-event .mec-event-ticket-name,body .mec-single-event .mec-event-ticket-description,body .mec-single-event .mec-event-ticket-available,'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,'.$base_selector.' label' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'wrap_bg',
			[
				'label'     => __('Background Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					$base_selector => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_responsive_control(
			'wrap_padding',
			[
				'label'      => __('Padding', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'wrap_margin',
			[
				'label'      => __('Margin', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'wrap_border',
				'label'    => __('Border', 'mec-form-builder'),
				'selector' => $base_selector,
			]
		);
		$this->add_responsive_control(
			'wrap_width',
			[
				'label'      => __('Width', 'mec-form-builder'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					$base_selector => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'wrap_border_radius',
			[
				'label'      => __('Border Radius', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'wrap_box_shadow',
				'label'    => __('Box Shadow', 'mec-form-builder'),
				'selectors' => [
					$base_selector => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}} {{box_shadow_position.VALUE}} !important;'
				]
			]
		);

		$this->end_controls_section();

		// H4 - Title
		$this->start_controls_section(
			'h4_options_form',
			array(
				'label' => __('Title', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'h4_typography',
				'label'    => __('Typography', 'mec-form-builder'),
				'selector' => $base_selector.' > h4',
			]
		);
		$this->add_control(
			'h4_color',
			[
				'label'     => __('Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' > h4' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'h4_underline_color',
			[
				'label'     => __('Underline Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' > h4:before' => 'border-color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'h4_bg',
			[
				'label'     => __('Background Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					$base_selector.' > h4' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_responsive_control(
			'h4_padding',
			[
				'label'      => __('Padding', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' > h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_responsive_control(
			'h4_margin',
			[
				'label'      => __('Margin', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' > h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'h4_border',
				'label'    => __('Border', 'mec-form-builder'),
				'selector' => $base_selector.' > h4',
			]
		);
		$this->add_responsive_control(
			'h4_width',
			[
				'label'      => __('Width', 'mec-form-builder'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					$base_selector.' > h4' => 'width: {{SIZE}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_responsive_control(
			'h4_border_radius',
			[
				'label'      => __('Border Radius', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' > h4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'h4_box_shadow',
				'label'    => __('Box Shadow', 'mec-form-builder'),
				'selector' => '.mec-events-meta-group-booking form > h4',
				'selectors' => [
					$base_selector.' > h4' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}} !important;'
				]
			]
		);

		$this->end_controls_section();

		// H4 - Ticket Title
		$this->start_controls_section(
			'ticket_h4_options_form',
			array(
				'label' => __('Ticket Name', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'ticket_h4_typography',
				'label'    => __('Typography', 'mec-form-builder'),
				'selector' => "{$base_selector} .mec-ticket-detail, {$base_selector} .mec-ticket-detail .mec-ticket-name, {$base_selector} .mec-ticket-detail .mec-ticket-price-wrapper .mec-ticket-price-label, {$base_selector} .mec-ticket-detail .mec-ticket-price-wrapper .mec-ticket-price",
			]
		);
		$this->add_control(
			'ticket_h4_color',
			[
				'label'     => __('Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					"{$base_selector} .mec-ticket-detail, {$base_selector} .mec-ticket-detail .mec-ticket-name, {$base_selector} .mec-ticket-detail .mec-ticket-price-wrapper .mec-ticket-price-label, {$base_selector} .mec-ticket-detail .mec-ticket-price-wrapper .mec-ticket-price"  => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'ticket_h4_bg',
			[
				'label'     => __('Background Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					$base_selector.' .mec-ticket-detail' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_responsive_control(
			'ticket_h4_padding',
			[
				'label'      => __('Padding', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' .mec-ticket-detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_responsive_control(
			'ticket_h4_margin',
			[
				'label'      => __('Margin', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' .mec-ticket-detail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'ticket_h4_border',
				'label'    => __('Border', 'mec-form-builder'),
				'selector' => $base_selector.' .mec-ticket-detail',
			]
		);
		$this->add_responsive_control(
			'ticket_h4_width',
			[
				'label'      => __('Width', 'mec-form-builder'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					$base_selector.' .mec-ticket-detail' => 'width: {{SIZE}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_responsive_control(
			'ticket_h4_border_radius',
			[
				'label'      => __('Border Radius', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' .mec-ticket-detail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}  !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'ticket_h4_box_shadow',
				'label'    => __('Box Shadow', 'mec-form-builder'),
				'selector' => $base_selector.' .mec-ticket-detail',
				'selectors' => [
					$base_selector.' .mec-ticket-detail' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}} {{box_shadow_position.VALUE}} !important;'
				]
			]
		);

		$this->end_controls_section();

		// Styling Options
		$this->start_controls_section(
			'label_options',
			array(
				'label' => __('Labels', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'label_typography',
				'label'    => __('Typography', 'mec-form-builder'),
				'selector' => $base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container .mec-form-fields label,' . $base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,' . $base_selector . ' label,body .mec-single-event .mec-booking label,'.$base_selector.' .mec-ticket-variation-name',
			]
		);
		$this->add_control(
			'label_color',
			[
				'label'     => __('Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,'.$base_selector.' label,body .mec-single-event .mec-booking label,'.$base_selector.' .mec-ticket-variation-name' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'label_bg',
			[
				'label'     => __('Background Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,'.$base_selector.' label,body .mec-single-event .mec-booking label,'.$base_selector.' .mec-ticket-variation-name' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'label_padding',
			[
				'label'      => __('Padding', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,'.$base_selector.' label,body .mec-single-event .mec-booking label,'.$base_selector.' .mec-ticket-variation-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'label_margin',
			[
				'label'      => __('Margin', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container label,'.$base_selector.' label,body .mec-single-event .mec-booking label,'.$base_selector.' .mec-ticket-variation-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'checkbox_radiobutton_hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'checkbox_radiobutton_typography',
				'label'    => __('Checkbox & Radio Button Typography', 'mec-form-builder'),
				'selector' => $base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-checkbox label:not(:first-child),'.$base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-radio label:not(:first-child)',
			]
		);
		$this->add_control(
			'checkbox_radiobutton_color',
			[
				'label'     => __('Checkbox & Radio Button Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-checkbox label:not(:first-child),'.$base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-radio label:not(:first-child)' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'agreement_hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'agreement_typography',
				'label'    => __('Agreement', 'mec-form-builder'),
				'selector' => $base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-agreement label',
			]
		);
		$this->add_control(
			'paragraph_hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'paragraph_typography',
				'label'    => __('Paragraph', 'mec-form-builder'),
				'selector' => $base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-p p',
			]
		);
		$this->add_control(
			'paragraph_color',
			[
				'label'     => __('Paragraph Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' ul.mec-book-tickets-container li .mec-book-reg-field-p p' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'field_options_form',
			array(
				'label' => __('Fields', 'mec-form-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$inputs_box_selector = $base_selector;
		$inputs_selectors =
		$inputs_box_selector.' input[type=date],'
		.$inputs_box_selector.' input[type=email],'
		.$inputs_box_selector.' input[type=number],'
		.$inputs_box_selector.' input[type=password],'
		.$inputs_box_selector.' input[type=tel],'
		.$inputs_box_selector.' input[type=text],'
		.$inputs_box_selector.' select,'
		.$inputs_box_selector.' textarea,'
			.$inputs_box_selector.' textarea,'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input,'
			.$inputs_box_selector.' ul.mec-book-tickets-container li span.mec-field-wrapper,'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=date],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=email],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=number],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=password],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=tel],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > input[type=text],'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > textarea,'
			.$inputs_box_selector.' ul.mec-book-tickets-container li > select';
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'field_typography',
				'label'    => __('Typography', 'mec-form-builder'),
				'selector' => $inputs_selectors,
			]
		);
		$this->add_control(
			'field_color',
			[
				'label'     => __('Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$inputs_selectors => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field_placeholder_color',
			[
				'label'     => __('PlaceHolder Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#424242',
				'selectors' => [
					$base_selector.' input::placeholder,'.$base_selector.' textarea::placeholder' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field_bg',
			[
				'label'     => __('Background Color', 'mec-form-builder'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					$inputs_selectors => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'field_padding',
			[
				'label'      => __('Padding', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$inputs_selectors => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'field_margin',
			[
				'label'      => __('Margin', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$inputs_selectors => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'field_border',
				'label'    => __('Border', 'mec-form-builder'),
				'selector' => $inputs_selectors,
			]
		);
		$inputs_selectors = ' .mec-booking-form-container input, {{WRAPPER}} .mec-booking-form-container textarea';
		$this->add_responsive_control(
			'width',
			[
				'label'      => __('Width', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					$inputs_selectors => 'width: var(--custom-input-width, {{SIZE}}{{UNIT}}) !important;',
				],
			]
		);

		$this->add_responsive_control(
			'wrap_max_height',
			[
				'label'      => __('Maximum height for input', 'mec-form-builder'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min'  => 10,
						'max'  => 80,
						'step' => 4,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 46,
				],
				'selectors'  => [
					'body .mec-single-event li.mec-book-ticket-container input, body .mec-single-event li.mec-book-ticket-container select' => 'max-height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'field_border_radius',
			[
				'label'      => __('Border Radius', 'mec-form-builder'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					$inputs_selectors => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'field_box_shadow',
				'label'    => __('Box Shadow', 'mec-form-builder'),
				'selector' => $base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="date"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="text"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="file"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="email"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="tel"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="text"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container textarea',
				'selectors' => [
				$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="date"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="text"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="file"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="email"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="tel"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container input[type="text"],
				'.$base_selector.' ul.mec-book-tickets-container li.mec-book-ticket-container textarea' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}} {{box_shadow_position.VALUE}} !important;'
				]
			]
		);

		$this->end_controls_section();
	}

	public static function search_in_array($key, $array, $l = 40)
	{
		foreach ($array as $k => $val) {
			if ($key === $k) {
				return $val;
			} else if (is_array($val)) {
				$d = static::search_in_array($key, $val, $l - 1);
				if ($d) {
					return $d;
				}
			}
		}
		if ($l === 0) {
			return false;
		}
	}

	/**
	 * Render MEC widget output on the frontend.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		// Requirements
		$settings        = $this->get_settings_for_display();
		$e_id       	 = get_the_ID();
		$args            = $opts = array();
		$i               = $j = 1;
		$mec_email_count = $mec_name_count  = 0;
		$me              = $mn = false;

		$is_demo = \Elementor\Plugin::$instance->editor->is_edit_mode();
		if ( get_post_type() == 'mec_form' ) {

			$event_id = get_posts( 'post_type=mec-events&numberposts=1' )[0]->ID;
		} else {

			$event_id = get_the_ID() ? get_the_ID() : ( $_POST['event_id'] ?? 0 );
		}

		// Update options
		if (isset( $_POST['action'] ) && 'elementor_ajax' === $_POST['action'] ) {

			$this->mec_update_form_fields();
		}

		if( $is_demo ){

			$reg_fields = $this->get_form_fields( 'reg' );

			if (count($reg_fields)) :
				$mec_email = false;
				$mec_name  = false;

				foreach ($reg_fields as $reg_field_id => $reg_field) :
					if (isset($reg_field['type'])) {
						if ($reg_field['type'] == 'mec_email') {
							$mec_email = true;
						}
						if ($reg_field['type'] == 'name') {
							$mec_name = true;
						}
					}
				endforeach;

				if (!$mec_email) {
					echo '<h4 style="color:red">' . esc_html__('Please add MEC Email field in your form.', 'mec-form-builder') . '</h3>';
				}

				if (!$mec_name) {
					echo '<h4 style="color:red">' . esc_html__('Please add MEC Name field in your form.', 'mec-form-builder') . '</h3>';
				}

				if ($mec_email_count > 1) {
					echo '<h4 style="color:red">' . esc_html__('Duplicate Error! Please add just one MEC Email field in your form.', 'mec-form-builder') . '</h3>';
				}

				if ($mec_name_count > 1) {
					echo '<h4 style="color:red">' . esc_html__('Duplicate Error! Please add just one MEC Name field in your form.', 'mec-form-builder') . '</h3>';
				}
			endif;

			if (!is_array($reg_fields) || !is_array( current( $reg_fields ) )) {
				$reg_fields = array();
			}

			foreach ($reg_fields as $k => $field) {

				if (empty($field) || !isset($field['type'])) {
					continue;
				}

				if ($me) {
					if ($field['type'] == 'mec_email') {
						$mec_email_count++;
						continue;
					}
				}

				if ($mn) {
					if ($field['type'] == 'name') {
						$mec_name_count++;
						continue;
					}
				}

				if ($field['type'] == 'mec_email') {
					$reg_fields[ $k ]['has_icon'] = false;
					$me = true;
					$mec_email_count++;
				}

				if ($field['type'] == 'name') {
					$reg_fields[ $k ]['has_icon'] = false;
					$mn = true;
					$mec_name_count++;
				}

				$i++;
			}

			$bfixed_fields = $this->get_form_fields( 'bfixed' );
		}else{

			$reg_fields = $this->get_form_fields( 'reg', $event_id );
			$bfixed_fields = $this->get_form_fields( 'bfixed', $event_id );
		}


		global $mec_fb_form_args;

		$tickets = $mec_fb_form_args['tickets'] ?? array(0=>1);
		$uniqueid = $mec_fb_form_args['uniqueid'] ?? '';
		$date = $mec_fb_form_args['date'] ?? '';
		$event = $mec_fb_form_args['event'] ?? $event_id;
		$args = array(
			'form_title' => $settings['form_title'],
		);

		if( $is_demo ):
		?>
		<div class="mec-wrap">
			<div class="mec-single-event">
				<div class="mec-events-meta-group-booking">
					<?php

					\MEC\BookingForm\Attendees::output( $event, $date, $tickets, $reg_fields, $bfixed_fields, $uniqueid, array(), $args );
					?>
				</div>
			</div>
		<?php
		else:
			\MEC\BookingForm\Attendees::output( $event, $date, $tickets, $reg_fields, $bfixed_fields, $uniqueid, array(), $args );
		endif;
	}
}
